
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <NDS.h>

#include "_console.h"
#include "_const.h"

#include "inifile.h"
#include "strtool.h"
#include "memtool.h"

TGlobalINI GlobalINI;

void InitINI(void)
{
  {
    TiniSystem *System=&GlobalINI.System;
    System->UseCheckDisk=true;
    System->OverrideLanguageID=(u32)-1;
    System->StartButtonFunction=ESSBF_SoftReset;
    System->FileSelectVertical=true;
    System->GlobalMP3Folder[0]=0;
  }
  
  {
    TiniKeyRepeat *KeyRepeat=&GlobalINI.KeyRepeat;
    KeyRepeat->DelayCount=15;
    KeyRepeat->RateCount=1;
  }
  
  {
    TiniCustomConfig *CustomConfig=&GlobalINI.CustomConfig;
    CustomConfig->SwitchModeEffect=true;
    CustomConfig->ViewMode_DoubleScreenCompulsorily=true;
    CustomConfig->ViewMode_CornerIconTimeoutSec=3;
  }
  
  {
    TiniAdapterConfig *AdapterConfig=&GlobalINI.AdapterConfig;
    AdapterConfig->EnabledWrite=true;
    AdapterConfig->SC_EnabledDRAM=false;
    AdapterConfig->EZ4_PSRAMSizeMByte=8;
  }
  
}

static char section[128];
static u32 readline;

static void readsection(char *str)
{
  str++;
  
  u32 ofs;
  
  ofs=0;
  while(*str!=']'){
    if((128<=ofs)||(*str==0)){
      _consolePrintf("line%d error.\nThe section name doesn't end correctly.\n",readline);
      ShowLogHalt();
    }
    section[ofs]=*str;
    str++;
    ofs++;
  }
  section[ofs]=0;
}

static void readkey(char *str)
{
  if(section[0]==0){
    _consolePrintf("line%d error.\nThere is a key ahead of the section name.\n",readline);
//    ShowLogHalt();
    return;
  }
  
  char key[128],value[128];
  
  u32 ofs;
  
  ofs=0;
  while(*str!='='){
    if((128<=ofs)||(*str==0)){
      _consolePrintf("line%d error.\nThe key name doesn't end correctly.\n",readline);
      ShowLogHalt();
    }
    key[ofs]=*str;
    str++;
    ofs++;
  }
  key[ofs]=0;
  
  str++;
  
  ofs=0;
  while(*str!=0){
    if(128<=ofs){
      _consolePrintf("line%d error.\nThe value doesn't end correctly.\n",readline);
      ShowLogHalt();
    }
    value[ofs]=*str;
    str++;
    ofs++;
  }
  value[ofs]=0;
  
  s32 ivalue=atoi(value);
  bool bvalue;
  
  if(ivalue==0){
    bvalue=false;
    }else{
    bvalue=true;
  }
  
  if(strcmp(section,"System")==0){
    TiniSystem *System=&GlobalINI.System;
    
    if(strcmp(key,"UseCheckDisk")==0){
      System->UseCheckDisk=bvalue;
      return;
    }
    if(strcmp(key,"OverrideLanguageID")==0){
      System->OverrideLanguageID=ivalue;
      return;
    }
    if(strcmp(key,"StartButtonFunction")==0){
      System->StartButtonFunction=(EiniSystemStartButtonFunction)ivalue;
      return;
    }
    if(strcmp(key,"FileSelectVertical")==0){
      System->FileSelectVertical=bvalue;
      return;
    }
    if(strcmp(key,"GlobalMP3Folder")==0){
      StrCopy(value,System->GlobalMP3Folder);
      return;
    }
    
  }
  
  if(strcmp(section,"KeyRepeat")==0){
    TiniKeyRepeat *KeyRepeat=&GlobalINI.KeyRepeat;
    
    if(strcmp(key,"DelayCount")==0){
      if(ivalue!=0) KeyRepeat->DelayCount=ivalue;
      return;
    }
    if(strcmp(key,"RateCount")==0){
      if(ivalue!=0) KeyRepeat->RateCount=ivalue;
      return;
    }
    
  }
  
  if(strcmp(section,"CustomConfig")==0){
    TiniCustomConfig *CustomConfig=&GlobalINI.CustomConfig;
    
    if(strcmp(key,"SwitchModeEffect")==0){
      CustomConfig->SwitchModeEffect=bvalue;
      return;
    }
    if(strcmp(key,"ViewMode_DoubleScreenCompulsorily")==0){
      CustomConfig->ViewMode_DoubleScreenCompulsorily=bvalue;
      return;
    }
    if(strcmp(key,"ViewMode_CornerIconTimeoutSec")==0){
      CustomConfig->ViewMode_CornerIconTimeoutSec=ivalue;
      return;
    }
    
  }
  
  if(strcmp(section,"AdapterConfig")==0){
    TiniAdapterConfig *AdapterConfig=&GlobalINI.AdapterConfig;
    
    if(strcmp(key,"EnabledWrite")==0){
      AdapterConfig->EnabledWrite=bvalue;
      return;
    }
    if(strcmp(key,"SC_EnabledDRAM")==0){
      AdapterConfig->SC_EnabledDRAM=bvalue;
      return;
    }
    if(strcmp(key,"EZ4_PSRAMSizeMByte")==0){
      AdapterConfig->EZ4_PSRAMSizeMByte=ivalue;
      return;
    }
    
  }
  _consolePrintf("line%d error.\ncurrent section [%s] unknown key=%s value=%s\n",readline,section,key,value);
//  ShowLogHalt();
}

static void internal_LoadGlobalINI(char *pini,u32 inisize)
{
  section[0]=0;
  readline=0;
  
  u32 iniofs=0;
  
  while(iniofs<inisize){
    
    readline++;
    
    u32 linelen=0;
    
    // Calc Line Length
    {
      char *s=&pini[iniofs];
      
      while(0x20<=*s){
        linelen++;
        s++;
        if(inisize<=(iniofs+linelen)) break;
      }
      *s=0;
    }
    
    if(linelen!=0){
      char c=pini[iniofs];
      if((c==';')||(c=='/')||(c=='!')){
        // comment line
        }else{
        if(c=='['){
          readsection(&pini[iniofs]);
          }else{
          readkey(&pini[iniofs]);
        }
      }
    }
    
    iniofs+=linelen;
    
    // skip NULL,CR,LF
    {
      char *s=&pini[iniofs];
      
      while(*s<0x20){
        iniofs++;
        s++;
        if(inisize<=iniofs) break;
      }
    }
    
  }
}

void LoadINI(char *pINIFileBuf,u32 INIFileSize)
{
  internal_LoadGlobalINI(pINIFileBuf,INIFileSize);
}

