
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#include <NDS.h>

#include "glib.h"
#include "glmemtool.h"

#include "glCP15.h"

#define CACHE_LINE_SIZE (32)
#define prcdiv (0x40)

static s32 glMemAllocCount;
s32 glMemAllocCountMirror;

static void glDC_FlushRangeOverrun(void *v,u32 size)
{
  static void (*lp_DC_FlushRange)(void *base, u32 size)=DC_FlushRange;
  static void (*lp_DC_InvalidateRange)(void *base, u32 size)=DC_InvalidateRange;
  
  size&=~(CACHE_LINE_SIZE-1);
  size+=CACHE_LINE_SIZE;
  
  if(size==0) return;
  
  lp_DC_FlushRange(v,size);
  lp_DC_InvalidateRange(v,size);
}

void glMemCopy8CPU(void *src,void *dst,u32 len)
{
  if((len&1)==0){
    if( (((u32)src&1)==0) && (((u32)dst&1)==0) ){
      glMemCopy16CPU(src,dst,len);
      return;
    }
  }
  
  len>>=0;
  if(len==0) return;
  
  u8 *_src=(u8*)src;
  u8 *_dst=(u8*)dst;
  
  for(u32 idx=0;idx<len;idx++){
    _dst[idx]=_src[idx];
  }
}

void glMemCopy16CPU(void *src,void *dst,u32 len)
{
  if((len&3)==0){
    if( (((u32)src&3)==0) && (((u32)dst&3)==0) ){
      glMemCopy32CPU(src,dst,len);
      return;
    }
  }
  
  len>>=1;
  if(len==0) return;
  
  u16 *_src=(u16*)src;
  u16 *_dst=(u16*)dst;
  
  for(u32 idx=0;idx<len;idx++){
    _dst[idx]=_src[idx];
  }
  return;
}

void __attribute__((noinline)) glMemCopy32CPU(void *src,void *dst,u32 len)
{
  asm volatile(
    "movs %2,%2,lsr #2 \n"
    "beq MemCopy32CPU_32bitEnd \n"
    
    "ands r3,%2,#3 \n"
    "beq MemCopy32CPU_4x32bitLoop \n"
    
    "MemCopy32CPU_32bitLoop: \n"
    "ldr r4,[%0],#4 \n"
    "str r4,[%1],#4 \n"
    "sub %2,#1 \n"
    "subs r3,#1 \n"
    "bne MemCopy32CPU_32bitLoop \n"
    
    "cmps %2,#0 \n"
    "beq MemCopy32CPU_32bitEnd \n"
    
    "MemCopy32CPU_4x32bitLoop: \n"
    "ldmia %0!,{r3,r4,r5,r6} \n"
    "stmia %1!,{r3,r4,r5,r6} \n"
    "subs %2,#4 \n"
    "bne MemCopy32CPU_4x32bitLoop \n"
    
    "MemCopy32CPU_32bitEnd: \n"
    
    : "+r"(src), "+r"(dst), "+r"(len) :
    : "r3","r4","r5","r6"
  );
}

void glMemSet16CPU(vu16 v,void *dst,u32 len)
{
  if(len<2) return;
  
  u16 *_dst=(u16*)dst;
  
  len/=2;
  for(u32 cnt=0;cnt<len;cnt++){
    _dst[cnt]=v;
  }
}

void glMemSet32CPU(u32 v,void *dst,u32 len)
{
  if(len<4) return;
  
  u32 *_dst=(u32*)dst;
  
  len/=4;
  for(u32 cnt=0;cnt<len;cnt++){
    _dst[cnt]=v;
  }
}

void glMemSet8CPU(u8 v,void *dst,u32 len)
{
  if(len<1) return;
  
  u8 *_dst=(u8*)dst;
  
  for(u32 cnt=0;cnt<len;cnt++){
    _dst[cnt]=v;
  }
}

void glMemCopy32swi256bit(void *src,void *dst,u32 len)
{
  swiFastCopy(src,dst,COPY_MODE_COPY | (len/4));
}

extern void ShowLogHalt(void);

void glsafemalloc_halt(void)
{
  ShowLogHalt();
}

extern bool (*safemalloc_RequestFreeArea)(void);

void *glsafemalloc(int size)
{
// glDebugPrintf("malloc(%d); ",size);
//  return(malloc(size));
  
  if(size<=0) return(NULL);
  
  size=(size+3)&(~3);
  
  void *ptr;
  u32 adr;
  
  while(1){
    ptr=malloc(size+(32*1024)); // 32kb͕Kc
    if(ptr!=NULL) break;
    if(safemalloc_RequestFreeArea==NULL){
      glDebugPrintf("glib:malloc(%dbyte) fail. safemalloc_RequestFreeArea==NULL\n",size);
      glsafemalloc_halt();
    }
    if(safemalloc_RequestFreeArea()==false){
      glDebugPrintf("glib:malloc(%dbyte) fail. safemalloc_RequestFreeArea result is false.\n",size);
      glsafemalloc_halt();
    }
  }
  
  adr=(u32)ptr;
  
  if((adr&3)!=0){ // 4byteACgĂȂ
    glDebugPrintf("glib:malloc(%d) fail not 4bytealian\n",size);
    glsafemalloc_halt();
    return(NULL);
  }
  
  if(adr<0x02000000){ // 擪AhXCO
    glDebugPrintf("glib:malloc(%d) fail adr<MemArea\n",size);
    glsafemalloc_halt();
    return(NULL);
  }
  
  if((0x02000000+(4*1024*1024))<=(adr+size)){ // I[AhXCゾ
    glDebugPrintf("glib:malloc(%d) fail MemArea<adr+size\n",size);
    glsafemalloc_halt();
    return(NULL);
  }
  
  // ]mۂ蒼
  
  void *checkedptr=ptr;
  
  free(ptr);
  ptr=malloc(size);
//  ptr=realloc(checkedptr,size);
  
  adr=(u32)ptr;
  
/*
  if(checkedptr!=ptr){ // `FbNς݂̎擾|C^ƈ
    glDebugPrintf("glib:malloc(%d) fail reallocerror.%x!=%x\n",size,(u32)checkedptr,(u32)ptr);
    glsafemalloc_halt();
    return(NULL);
  }
*/
  
  if((adr&3)!=0){ // 4byteACgĂȂ
    glDebugPrintf("glib:malloc(%d) fail reallocerror.%x!=%x\n",size,(u32)checkedptr,(u32)ptr);
    glsafemalloc_halt();
    return(NULL);
  }
  
  if(adr<0x02000000){ // 擪AhXCO
    glDebugPrintf("glib:malloc(%d) fail reallocerror.%x!=%x\n",size,(u32)checkedptr,(u32)ptr);
    glsafemalloc_halt();
    return(NULL);
  }
  
  if((0x02000000+(4*1024*1024))<=(adr+size)){ // I[AhXCゾ
    glDebugPrintf("glib:malloc(%d) fail reallocerror.%x!=%x\n",size,(u32)checkedptr,(u32)ptr);
    glsafemalloc_halt();
    return(NULL);
  }
  
/*
  {
    u8 *pbuf=(u8*)ptr;
    for(s32 cnt=0;cnt<size;cnt++){
      pbuf[cnt]=0;
    }
  }
*/
  
  glMemAllocCount++;
  glMemAllocCountMirror++;
//  glDebugPrintf("[%x]",ptr);
  
  return(ptr);
}

void glsafefree(void *ptr)
{
  if(ptr==NULL){
    glDebugPrintf("glib:safefree Request NullPointer.\n");
    return;
  }
  
  glMemAllocCount--;
  glMemAllocCountMirror--;
//  glDebugPrintf("(%x)",ptr);
  
  free(ptr);
}

void glMemLeak_Init(void)
{
  glMemAllocCount=0;
  glMemAllocCountMirror=0;
}

void glMemLeak_CheckAndHalt(void)
{
  if(glMemAllocCount!=0){
    glDebugPrintf("glib:Memory leak found. MemAllocCount=%d\n",glMemAllocCount);
    ShowLogHalt();
  }
  if(glMemAllocCount!=glMemAllocCountMirror){
    glDebugPrintf("glib:Memory leak check error. broken memory? %d!=%d\n",glMemAllocCount,glMemAllocCountMirror);
    ShowLogHalt();
  }
}

