
#include <stdlib.h>
#include <NDS.h>

#include "glib.h"
#include "glmemtool.h"
#include "cglscreen.h"

#define VRAMBuf ((u16*)&SPRITE_GFX_SUB[0])

#define objcnt (8+16)

#ifdef WriteBMPFunction

typedef struct {
  bool show;
  u32 srcx,srcy;
  s32 posx,posy;
  s32 sizex,sizey;
} TSpriteSetting;

static TSpriteSetting SpriteSetting[objcnt];

#endif

//a global copy of sprite attribute memory
static SpriteEntry sprites_sub[128];

//rotation attributes overlap so assign then to the same location
static pSpriteRotation spriteRotations_SUB = (pSpriteRotation)sprites_sub;

//turn off all the sprites
static inline void initSprites(bool isVertical)
{
  glMemSet16CPU(0, sprites_sub, 128 * sizeof(SpriteEntry));
  
  u32 i;
  for(i = 0; i < 128; i++)
  {
     sprites_sub[i].attribute[0] = ATTR0_DISABLED | 0;
     sprites_sub[i].attribute[1] = 0 | 0;
     sprites_sub[i].attribute[2] = 0;
     sprites_sub[i].attribute[3] = 0;
  }
  
  if(isVertical==true){
    for(i=0;i<32;i++){
      spriteRotations_SUB[i].hdx=0*0x100;
      spriteRotations_SUB[i].hdy=1*0x100;
      spriteRotations_SUB[i].vdx=-1*0x100;
      spriteRotations_SUB[i].vdy=0*0x100;
    }
    }else{
    for(i=0;i<32;i++){
      spriteRotations_SUB[i].hdx=1*0x100;
      spriteRotations_SUB[i].hdy=0*0x100;
      spriteRotations_SUB[i].vdx=0*0x100;
      spriteRotations_SUB[i].vdy=1*0x100;
    }
  }
}

//copy our sprite to object attribute memory
static inline void updateOAM(u32 Index,u32 Count)
{
  DC_FlushAll();
  u16 *psrc=(u16*)&sprites_sub[0];
  u16 *pdst=OAM_SUB;
  if(Index!=0){
    psrc+=Index * sizeof(SpriteEntry)/2;
    pdst+=Index * sizeof(SpriteEntry)/2;
  }
  glMemCopy16CPU(psrc,pdst, Count * sizeof(SpriteEntry));
}

static inline void SetPosSprite(u32 objno,s32 x,s32 y,bool EnabledBlend,u16 ATTR1_SIZE,bool DoubleSize)
{
  u32 sx=x;
  u32 sy=y;
  
  if(x<0) sx=x+512;
  if(y<0) sy=y+256;
  
  sx&=512-1;
  sy&=256-1;
  
  sx=x & (512-1);
  sy=y & (256-1);
  
  u16 attr0=0;
  u16 attr1=0;
  
  attr0|=ATTR0_NORMAL | ATTR0_BMP | ATTR0_SQUARE | sy | ATTR0_ROTSCALE;
  
  if(DoubleSize==true) attr0|=ATTR0_ROTSCALE_DOUBLE;
  
  if(EnabledBlend==false){
    attr0|=ATTR0_TYPE_NORMAL;
    }else{
    attr0|=ATTR0_TYPE_BLENDED;
  }
  
  attr1|=ATTR1_ROTDATA(0) | ATTR1_SIZE | sx;
  
  sprites_sub[objno].attribute[0] = attr0;
  sprites_sub[objno].attribute[1] = attr1;
}

static inline void HiddenSprite(u32 objno)
{
  sprites_sub[objno].attribute[0] = ATTR0_DISABLED;
}

static inline void SetSprite(u32 objno,u32 Priority,u32 num,u16 alpha)
{
  sprites_sub[objno].attribute[2] = ATTR2_PRIORITY(Priority) | ATTR2_ALPHA(alpha) | num;
}

CglScreenSub64::CglScreenSub64(void)
{
  pCanvas=new CglCanvas(VRAMBuf,LineBufferWidth,ScreenHeight,pf15bit);
  pCanvas->SetColor(RGB15(0,0,0));
  pCanvas->FillAll();
}

CglScreenSub64::~CglScreenSub64(void)
{
  delete pCanvas; pCanvas=NULL;
}

#ifdef WriteBMPFunction
static bool used=false;
#endif

void CglScreenSub64::Init(bool _isVertical)
{
#ifdef WriteBMPFunction
  used=true;
#endif
  
  isVertical=_isVertical;
  
  SUB_BLEND_CR=BLEND_ALPHA | BLEND_DST_BG2 | BLEND_SRC_SPRITE;
  SUB_BLEND_AB=16;
  
  initSprites(isVertical);
  updateOAM(0,128);
  
  for(u32 idx=0;idx<objcnt;idx++){
    HiddenSprite(idx);
#ifdef WriteBMPFunction
    SpriteSetting[idx].show=false;
#endif
  }
  UpdateOAM();
  
  MouseInfo.Initialized=false;
}

void CglScreenSub64::End(void)
{
#ifdef WriteBMPFunction
  used=false;
#endif

  for(u32 idx=0;idx<objcnt;idx++){
    HiddenSprite(idx);
#ifdef WriteBMPFunction
    SpriteSetting[idx].show=false;
#endif
  }
  UpdateOAM();
  
  MouseInfo.Initialized=false;
}

u16* CglScreenSub64::GetVRAMBuf(void) const
{
  return(VRAMBuf);
}

void CglScreenSub64::SetSpritePos64(u32 idx,u32 srcx,u32 srcy,s32 ofsx,s32 ofsy,u32 blend) const
{
#ifdef WriteBMPFunction
  TSpriteSetting *psp=&SpriteSetting[idx];
  if(blend==0){
    psp->show=false;
    }else{
    psp->show=true;
    psp->srcx=srcx; psp->srcy=srcy;
    psp->posx=ofsx; psp->posy=ofsy;
    psp->sizex=64; psp->sizey=64;
  }
#endif
  
  if(blend==0){
    HiddenSprite(idx);
    return;
  }
  
  u32 bl=blend;
  if(bl==16) bl=15;
  SetSprite(idx,2,((256/8)*(srcy/8))+(srcx/8),bl);
  
  s32 px=ofsx;
  s32 py=ofsy;
  
  if(isVertical==true){
    s32 tmp=py;
    py=px;
    px=256-tmp;
    px-=64;
  }
  
  bool bb=true;
  if(blend==16) bb=false;
  SetPosSprite(idx,px-1,py,bb,ATTR1_SIZE_64,false);
}

void CglScreenSub64::SetSpritePos16(u32 idx,u32 srcx,u32 srcy,s32 ofsx,s32 ofsy,u32 blend) const
{
#ifdef WriteBMPFunction
  TSpriteSetting *psp=&SpriteSetting[idx];
  if(blend==0){
    psp->show=false;
    }else{
    psp->show=true;
    psp->srcx=srcx; psp->srcy=srcy;
    psp->posx=ofsx; psp->posy=ofsy;
    psp->sizex=16; psp->sizey=16;
  }
#endif

  if(blend==0){
    HiddenSprite(idx);
    return;
  }
  
  u32 bl=blend;
  if(bl==16) bl=15;
  SetSprite(idx,1,((256/8)*(srcy/8))+(srcx/8),bl);
  
  s32 px=ofsx;
  s32 py=ofsy;
  if(isVertical==true){
    s32 tmp=py;
    py=px;
    px=256-tmp;
    px-=16;
  }
  
  bool bb=true;
  if(blend==16) bb=false;
  SetPosSprite(idx,px-1,py,bb,ATTR1_SIZE_16,false);
}

void CglScreenSub64::UpdateOAM(void) const
{
  updateOAM(0,objcnt);
}

void CglScreenSub64::Mouse_Init(u32 srcx,u32 srcy,CglCanvas *pMouseCanvas)
{
  TMouseInfo *pmi=&MouseInfo;
  
  pmi->Initialized=true;
  pmi->pMouseCanvas=pMouseCanvas;
  pmi->objnum=32;
  pmi->srcx=srcx;
  pmi->srcy=srcy;
  pmi->srcw=pMouseCanvas->GetWidth();
  pmi->srch=pMouseCanvas->GetHeight();
  pmi->show=false;
  pmi->posx=0;
  pmi->posy=0;
  
  pmi->pMouseCanvas->BitBlt(pCanvas,pmi->srcx,pmi->srcy,pmi->srcw,pmi->srch,0,0,false);
  
  HiddenSprite(pmi->objnum);
  updateOAM(pmi->objnum,1);
}

void CglScreenSub64::Mouse_Show(bool show)
{
  TMouseInfo *pmi=&MouseInfo;
  if(pmi->Initialized==false) return;
  
  pmi->show=show;
  
  if(pmi->show==false){
    HiddenSprite(pmi->objnum);
    }else{
    s32 px=pmi->posx;
    s32 py=pmi->posy;
    
    if(isVertical==true){
      s32 tmp=py;
      py=px;
      px=256-tmp;
      px-=16;
    }
    
    SetSprite(pmi->objnum,0,((256/8)*(pmi->srcy/8))+(pmi->srcx/8),15);
    SetPosSprite(pmi->objnum,px-8-1,py-8,false,ATTR1_SIZE_16,true);
  }
  updateOAM(pmi->objnum,1);
}

void CglScreenSub64::Mouse_SetPos(s32 x,s32 y)
{
  TMouseInfo *pmi=&MouseInfo;
  if(pmi->Initialized==false) return;
  
  pmi->posx=x;
  pmi->posy=y;
  
  Mouse_Show(pmi->show);
}

u8* CglScreenSub64::CreateBMPImage(u32 *psize) const
{
#ifdef WriteBMPFunction
  if(used==false) return(NULL);
  CglCanvas *pDstCanvas=new CglCanvas(NULL,256,256,pf15bit);
  pDstCanvas->SetColor(RGB15(31,31,31)|BIT15);
  pDstCanvas->FillAll();
  
  for(s32 idx=objcnt-1;idx>=0;idx--){
    TSpriteSetting *psp=&SpriteSetting[idx];
    if(psp->show==true){
      pCanvas->BitBlt(pDstCanvas,psp->posx,psp->posy,psp->sizex,psp->sizey,psp->srcx,psp->srcy,true);
    }
  }
  
  u8 *pbuf=pDstCanvas->CreateBMPImage(psize);
  delete pDstCanvas; pDstCanvas=NULL;
  return(pbuf);
#endif
  return(NULL);
}

