
#include <stdlib.h>
#include <NDS.h>

#include "glib.h"
#include "glmemtool.h"
#include "cglscreen.h"

#define VRAMBuf ((u16*)&SPRITE_GFX[0])

//a global copy of sprite attribute memory
static SpriteEntry sprites[128];

//rotation attributes overlap so assign then to the same location
static pSpriteRotation spriteRotations = (pSpriteRotation)sprites;

//turn off all the sprites
static inline void initSprites(void)
{
  glMemSet16CPU(0, sprites, 128 * sizeof(SpriteEntry));
  
  u32 i;
  for(i = 0; i < 128; i++)
  {
     sprites[i].attribute[0] = ATTR0_DISABLED | 0;
     sprites[i].attribute[1] = 0 | 0;
     sprites[i].attribute[2] = 0;
     sprites[i].attribute[3] = 0;
  }
  
  for(i=0;i<32;i++){
/*
// horizonal
    spriteRotations[i].hdx=1*0x100;
    spriteRotations[i].hdy=0*0x100;
    spriteRotations[i].vdx=0*0x100;
    spriteRotations[i].vdy=1*0x100;
*/
// vertical
    spriteRotations[i].hdx=0*0x100;
    spriteRotations[i].hdy=1*0x100;
    spriteRotations[i].vdx=-1*0x100;
    spriteRotations[i].vdy=0*0x100;
  }

}

//copy our sprite to object attribute memory
static inline void updateOAM(u32 Count)
{
  glMemCopy16CPU(sprites, OAM, Count * sizeof(SpriteEntry));
}

static inline void SetPosSprite(u32 objno,bool Visible,s32 x,s32 y,bool EnabledBlend)
{
  u32 sx=x;
  u32 sy=y;
  
  if(x<0) sx=x+512;
  if(y<0) sy=y+256;
  
  sx&=512-1;
  sy&=256-1;
  
  sx=x & (512-1);
  sy=y & (256-1);
  
  u16 attr0=ATTR0_BMP | ATTR0_SQUARE | sy | ATTR0_ROTSCALE | ATTR0_ROTSCALE_DOUBLE;
  
  if(Visible==false){
    attr0|=ATTR0_DISABLED;
    }else{
    attr0|=ATTR0_NORMAL;
  }
  
  if(EnabledBlend==false){
    attr0|=ATTR0_TYPE_NORMAL;
    }else{
    attr0|=ATTR0_TYPE_BLENDED;
  }
  sprites[objno].attribute[0] = attr0;
  sprites[objno].attribute[1] = ATTR1_ROTDATA(0) | ATTR1_SIZE_64 | sx;
}

static inline void HiddenSprite(u32 objno)
{
  sprites[objno].attribute[0] = ATTR0_DISABLED;
}

static inline void SetSprite(u32 objno,u32 Priority,u32 num,u16 alpha)
{
  sprites[objno].attribute[2] = ATTR2_PRIORITY(Priority) | ATTR2_ALPHA(alpha) | num;
}

static void MainDisplay_Init(bool Visible)
{
  initSprites();
  updateOAM(128);
  
  s32 spx[16]={0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3};
  s32 spy[16]={0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3};
  
  for(u32 idx=0;idx<16;idx++){
    SetSprite(idx,0,(8*spx[idx])+((8*8*4)*spy[idx]),16);
    
    s32 px=spx[idx]*64;
    s32 py=spy[idx]*64;
    
// vertical
    s32 tmp=py;
    py=px;
    px=tmp;
    px=192-px;
    
    SetPosSprite(idx,Visible,px-32-1,py-32,false);
  }
  
  updateOAM(16);
}

CglScreenMainOverlay::CglScreenMainOverlay(void)
{
  pCanvas=new CglCanvas(VRAMBuf,LineBufferWidth,ScreenHeight,pf15bit);
  pCanvas->SetColor(RGB15(0,0,0));
  pCanvas->FillAll();
  
  MainDisplay_Init(true);
}

CglScreenMainOverlay::~CglScreenMainOverlay(void)
{
  delete pCanvas; pCanvas=NULL;
}

u16* CglScreenMainOverlay::GetVRAMBuf(void) const
{
  return(VRAMBuf);
}

void CglScreenMainOverlay::SetVisible(bool Visible)
{
  MainDisplay_Init(Visible);
}

