
#include <stdlib.h>
#include <NDS.h>

#include "glib.h"
#include "glmemtool.h"
#include "cglscreen.h"

#define VRAMBuf ((u16*)(0x06000000))

#define BG2_CR_BASE (BG_BMP16_256x256 | BG_BMP_BASE(0) | BG_WRAP_ON)

CglScreenMain::CglScreenMain(void)
{
  BG2_CR = BG2_CR_BASE | BG_PRIORITY_1;
  pCanvas=NULL;
  Init(true);
}

CglScreenMain::~CglScreenMain(void)
{
  delete pCanvas; pCanvas=NULL;
}

void CglScreenMain::Init(bool _isVertical)
{
  End();
  
  isVertical=_isVertical;
  
  if(isVertical==true){
    BG2_XDX = 0 << 8;
    BG2_XDY = 1 << 8;
    BG2_YDX = -1 << 8;
    BG2_YDY = 0 << 8;
    BG2_CX = 0<<8;
    BG2_CY = (256-1)<<8;
    }else{
    BG2_XDX = 1 << 8;
    BG2_XDY = 0 << 8;
    BG2_YDX = 0 << 8;
    BG2_YDY = 1 << 8;
    BG2_CX = 0<<8;
    BG2_CY = 0<<8;
  }
  
  pCanvas=new CglCanvas(VRAMBuf,LineBufferWidth,ScreenHeight,pf15bit);
  pCanvas->SetColor(RGB15(31,31,31)|BIT15);
  pCanvas->FillAll();
}

void CglScreenMain::End(void)
{
  if(pCanvas!=NULL){
    delete pCanvas; pCanvas=NULL;
  }
}

u16* CglScreenMain::GetVRAMBuf(void) const
{
  return(VRAMBuf);
}

void CglScreenMain::SetWhiteOut(u32 v)
{
  BLEND_CR=BLEND_FADE_WHITE | BLEND_SRC_BG2;
  BLEND_Y=v;
}

void CglScreenMain::SetOffsetY(s32 y)
{
  BG2_CY = (u16)(y<<8);
}

void CglScreenMain::SetOffsetPos(s32 x,s32 y)
{
  if(isVertical==true){
    BG2_CX = (u16)(x<<8);
    BG2_CY = (u16)((256-1+y)<<8);
    }else{
    BG2_CX = (u16)(x<<8);
    BG2_CY = (u16)(y<<8);
  }
}

u8* CglScreenMain::CreateBMPImage(u32 *psize) const
{
  CglCanvas *pDstCanvas=new CglCanvas(NULL,256,256,pf15bit);
  pDstCanvas->SetColor(RGB15(31,31,31)|BIT15);
  pDstCanvas->FillAll();
  
  pCanvas->BitBlt(pDstCanvas,0,0,256,256,0,0,true);
  
  u8 *pbuf=pDstCanvas->CreateBMPImage(psize);
  delete pDstCanvas; pDstCanvas=NULL;
  return(pbuf);
}

