
#ifndef cglscreen_h
#define cglscreen_h

#include <stdlib.h>
#include <NDS.h>

#include "cglcanvas.h"

class CglScreenMain
{
  CglScreenMain(const CglScreenMain&);
  CglScreenMain& operator=(const CglScreenMain&);
  bool isVertical;
public:
  CglCanvas *pCanvas;
  CglScreenMain(void);
  ~CglScreenMain(void);
  void Init(bool _isVertical);
  void End(void);
  u16* GetVRAMBuf(void) const;
  void SetWhiteOut(u32 v);
  void SetOffsetY(s32 y);
  void SetOffsetPos(s32 x,s32 y);
  u8* CreateBMPImage(u32 *psize) const;
};

class CglScreenMainOverlay
{
  CglScreenMainOverlay(const CglScreenMainOverlay&);
  CglScreenMainOverlay& operator=(const CglScreenMainOverlay&);
public:
  CglCanvas *pCanvas;
  CglScreenMainOverlay(void);
  ~CglScreenMainOverlay(void);
  u16* GetVRAMBuf(void) const;
  void SetVisible(bool Visible);
};

typedef struct {
  bool Initialized;
  CglCanvas *pMouseCanvas;
  u32 objnum;
  u32 srcx,srcy,srcw,srch;
  bool show;
  s32 posx,posy;
} TMouseInfo;

class CglScreenSub64
{
  CglScreenSub64(const CglScreenSub64&);
  CglScreenSub64& operator=(const CglScreenSub64&);
  bool isVertical;
  TMouseInfo MouseInfo;
public:
  CglCanvas *pCanvas;
  CglScreenSub64(void);
  ~CglScreenSub64(void);
  void Init(bool _isVertical);
  void End(void);
  u16* GetVRAMBuf(void) const;
  void SetSpritePos64(u32 idx,u32 srcx,u32 srcy,s32 ofsx,s32 ofsy,u32 blend) const;
  void SetSpritePos16(u32 idx,u32 srcx,u32 srcy,s32 ofsx,s32 ofsy,u32 blend) const;
  void UpdateOAM(void) const;
  void Mouse_Init(u32 srcx,u32 srcy,CglCanvas *pMouseCanvas);
  void Mouse_Show(bool show);
  void Mouse_SetPos(s32 x,s32 y);
  u8* CreateBMPImage(u32 *psize) const;
};

class CglScreenSubBM
{
  CglScreenSubBM(const CglScreenSubBM&);
  CglScreenSubBM& operator=(const CglScreenSubBM&);
  bool isVertical;
  TMouseInfo MouseInfo;
  s32 OffsetY;
public:
  CglCanvas *pCanvas;
  CglScreenSubBM(void);
  ~CglScreenSubBM(void);
  void Init(bool _isVertical);
  void End(void);
  u16* GetVRAMBuf(void) const;
  void SetSpritePos64(u32 idx,u32 srcx,u32 srcy,s32 ofsx,s32 ofsy,u32 blend) const;
  void SetSpritePos16(u32 idx,u32 srcx,u32 srcy,s32 ofsx,s32 ofsy,u32 blend) const;
  void SetSpriteHidden(u32 idx) const;
  void SetAlpha(u32 blend);
  void SetOffsetY(s32 y);
  void UpdateOAM(void) const;
  void Mouse_Init(u32 srcx,u32 srcy,CglCanvas *pMouseCanvas);
  void Mouse_Show(bool show);
  void Mouse_SetPos(s32 x,s32 y);
  void Mouse_SetAlpha(u32 alpha);
  u8* CreateBMPImage(u32 *psize) const;
};

#endif

