
#ifndef cglcanvas_h
#define cglcanvas_h

#include <stdlib.h>
#include <NDS.h>

#include "tglunicode.h"

enum EPixelFormat {pf15bit};

class CglCanvas
{
  u16 *VRAMBuf;
  bool VRAMBufInsideAllocatedFlag;
  int Width;
  int Height;
  EPixelFormat PixelFormat;
  u16 **ScanLine;
  u16 Color;
  int LastX,LastY;
  void *pCglFont;
  CglCanvas(const CglCanvas&);
  CglCanvas& operator=(const CglCanvas&);
  bool isInsidePosition(const int x,const int y) const;
  void BitBltBeta(CglCanvas *pDestCanvas,const int nDestLeft,const int nDestTop,const int nWidth,const int nHeight,const int nSrcLeft,const int nSrcTop) const;
  void BitBltTrans(CglCanvas *pDestCanvas,const int nDestLeft,const int nDestTop,const int nWidth,const int nHeight,const int nSrcLeft,const int nSrcTop) const;
public:
  CglCanvas(u16 *_VRAMBuf,const int _Width,const int _Height,const EPixelFormat _PixelFormat);
  ~CglCanvas(void);
  u16* GetVRAMBuf(void) const;
  void SetVRAMBuf(u16 *_VRAMBuf,const int _Width,const int _Height,const EPixelFormat _PixelFormat);
  int GetWidth(void) const;
  int GetHeight(void) const;
  u16* GetScanLine(const int y) const;
  void SetPixel(const int x,const int y,const u16 rgb);
  void SetPixelHalf(const int x,const int y,const u16 rgb);
  void SetPixelAlpha(const int x,const int y,const u16 rgb,const int Alpha);
  void SetPixelAlphaAdd(const int x,const int y,const u16 rgb,const int Alpha);
  u16 GetPixel(const int x,const int y) const;
  void SetColor(const u16 _Color);
  void DrawLine(const int x1,const int y1,const int x2,const int y2);
  void DrawTickLine(const int x1,const int y1,const int x2,const int y2);
  void MoveTo(const int x,const int y);
  void LineTo(const int x,const int y);
  void FillAll(void);
  void FillFull(const u16 _Color);
  void FillFast(const int x,const int y,const int w,const int h);
  void FillBox(const int x,const int y,const int w,const int h);
  void FillBox12(const int x,const int y,const int w,const int h);
  void FillBox25(const int x,const int y,const int w,const int h);
  void FillBox50(const int x,const int y,const int w,const int h);
  void FillBox75(const int x,const int y,const int w,const int h);
  void DrawBox(const int x,const int y,const int w,const int h);
  void SetFontBGColor(const u16 Color);
  void SetFontTextColor(const u16 Color);
  void TextOutA(const int x,const int y,const char *str) const;
  void TextOutW(const int x,const int y,const TglUnicode *str) const;
  void TextOutUTF8(const int x,const int y,const char *str) const;
  int GetTextWidthA(const char *str) const;
  int GetTextWidthW(const TglUnicode *str) const;
  int GetTextWidthUTF8(const char *str) const;
  int GetTextHeight(void) const;
  void SetCglFont(void *_pCglFont);
  void BitBlt(CglCanvas *pDestCanvas,const int nDestLeft,const int nDestTop,const int nWidth,const int nHeight,const int nSrcLeft,const int nSrcTop,const bool TransFlag) const;
  u8* CreateBMPImage(u32 *size) const;
};

#endif

