
#include <stdlib.h>
#include <NDS.h>

#include "glib.h"
#include "glmemtool.h"
#include "cglcanvas.h"

#include "cp0_glf_bin.h"

static CglFont *pCglFontDefault=NULL;

CglCanvas::CglCanvas(u16 *_VRAMBuf,const int _Width,const int _Height,const EPixelFormat _PixelFormat)
{
  VRAMBuf=NULL;
  VRAMBufInsideAllocatedFlag=false;
  Width=0;
  Height=0;
  ScanLine=NULL;
  Color=0;
  LastX=0;
  LastY=0;
  
  if(pCglFontDefault==NULL){
    pCglFontDefault=new CglFont((u8*)cp0_glf_bin,cp0_glf_bin_size);
  }
  pCglFont=pCglFontDefault;
  
  
  SetVRAMBuf(_VRAMBuf,_Width,_Height,_PixelFormat);
}

CglCanvas::~CglCanvas(void)
{
  if(VRAMBufInsideAllocatedFlag==true){
    VRAMBufInsideAllocatedFlag=false;
    glsafefree(VRAMBuf); VRAMBuf=NULL;
  }
  if(ScanLine!=NULL){
    glsafefree(ScanLine); ScanLine=NULL;
  }
}

u16* CglCanvas::GetVRAMBuf(void) const
{
  return(VRAMBuf);
}

void CglCanvas::SetVRAMBuf(u16 *_VRAMBuf,const int _Width,const int _Height,const EPixelFormat _PixelFormat)
{
  if(VRAMBufInsideAllocatedFlag==true){
    VRAMBufInsideAllocatedFlag=false;
    glsafefree(VRAMBuf); VRAMBuf=NULL;
  }
  
  Width=_Width;
  
  if(Height!=_Height){
    Height=_Height;
    if(ScanLine!=NULL){
      glsafefree(ScanLine); ScanLine=NULL;
    }
    ScanLine=(u16**)glsafemalloc(Height*sizeof(u16*));
  }
  
  PixelFormat=_PixelFormat;
  
  if(_VRAMBuf==NULL){
    VRAMBufInsideAllocatedFlag=true;
    VRAMBuf=(u16*)glsafemalloc(Width*Height*sizeof(u16));
    }else{
    VRAMBufInsideAllocatedFlag=false;
    VRAMBuf=_VRAMBuf;
  }
  
  for(int y=0;y<Height;y++){
    ScanLine[y]=&VRAMBuf[y*Width];
  }
}

int CglCanvas::GetWidth(void) const
{
  return(Width);
}

int CglCanvas::GetHeight(void) const
{
  return(Height);
}

u16* CglCanvas::GetScanLine(const int y) const
{
  if((y<0)||(Height<=y)) return(NULL);
  
  return(ScanLine[y]);
}

bool CglCanvas::isInsidePosition(const int x,const int y) const
{
  if((x<0)||(Width<=x)) return(false);
  if((y<0)||(Height<=y)) return(false);
  
  return(true);
}

void CglCanvas::SetPixel(const int x,const int y,const u16 rgb)
{
//  if(isInsidePosition(x,y)==false) return;
  
  ScanLine[y][x]=rgb;
}

void CglCanvas::SetPixelHalf(const int x,const int y,const u16 rgb)
{
//  if(isInsidePosition(x,y)==false) return;
  
  ScanLine[y][x]=ColorMargeHalf(ScanLine[y][x],rgb);
}

void CglCanvas::SetPixelAlpha(const int x,const int y,const u16 rgb,const int Alpha)
{
//  if(isInsidePosition(x,y)==false) return;
  
  ScanLine[y][x]=ColorMargeAlpha(ScanLine[y][x],rgb,Alpha);
}

void CglCanvas::SetPixelAlphaAdd(const int x,const int y,const u16 rgb,const int Alpha)
{
//  if(isInsidePosition(x,y)==false) return;
  
  ScanLine[y][x]=ColorMargeAlphaAdd(ScanLine[y][x],rgb,Alpha);
}

u16 CglCanvas::GetPixel(const int x,const int y) const
{
//  if(isInsidePosition(x,y)==false) return(0);
  
  return(ScanLine[y][x]);
}

void CglCanvas::SetColor(const u16 _Color)
{
  Color=_Color;
}

void CglCanvas::DrawLine(const int x1,const int y1,const int x2,const int y2)
{
  if((x1==x2)&&(y1==y2)) return;
  
  if(x1==x2){
    int ys,ye;
    if(y1<y2){
      ys=y1;
      ye=y2-1;
      }else{
      ys=y2+1;
      ye=y1;
    }
    for(int py=ys;py<=ye;py++){
      SetPixel(x1+0,py+0,Color);
    }
    return;
  }
  
  if(y1==y2){
    int xs,xe;
    if(x1<x2){
      xs=x1;
      xe=x2-1;
      }else{
      xs=x2+1;
      xe=x1;
    }
    for(int px=xs;px<=xe;px++){
      SetPixel(px+0,y1+0,Color);
    }
    return;
  }
  
  if(abs(x2-x1)>abs(y2-y1)){
    int px=0;
    int pyf8=0;
    int xe=x2-x1;
    int yef8=(y2-y1)<<8;
    int xv;
    int yvf8;
    
    if(0<xe){
      xv=1;
      }else{
      xv=-1;
    }
    yvf8=yef8/abs(xe);
    
    while(px!=xe){
      u32 dx=x1+px;
      u32 dy=y1+(int)(pyf8>>8);
      SetPixel(dx+0,dy+0,Color);
      px+=xv;
      pyf8+=yvf8;
    }
    return;
    
    }else{
    int pxf8=0;
    int py=0;
    int xef8=(x2-x1)<<8;
    int ye=y2-y1;
    int xvf8;
    int yv;
    
    xvf8=xef8/abs(ye);
    if(0<ye){
      yv=1;
      }else{
      yv=-1;
    }
    
    while(py!=ye){
      u32 dx=x1+(int)(pxf8>>8);
      u32 dy=y1+py;
      SetPixel(dx+0,dy+0,Color);
      pxf8+=xvf8;
      py+=yv;
    }
    return;
  }
}

void CglCanvas::DrawTickLine(const int x1,const int y1,const int x2,const int y2)
{
  if((x1==x2)&&(y1==y2)) return;
  
  if(x1==x2){
    int ys,ye;
    if(y1<y2){
      ys=y1;
      ye=y2-1;
      }else{
      ys=y2+1;
      ye=y1;
    }
    for(int py=ys;py<=ye;py++){
      SetPixelHalf(x1-1,py+0,Color);
      SetPixel(x1+0,py+0,Color);
      SetPixelHalf(x1+1,py+0,Color);
    }
    return;
  }
  
  if(y1==y2){
    int xs,xe;
    if(x1<x2){
      xs=x1;
      xe=x2-1;
      }else{
      xs=x2+1;
      xe=x1;
    }
    for(int px=xs;px<=xe;px++){
      SetPixelHalf(px+0,y1-1,Color);
      SetPixel(px+0,y1+0,Color);
      SetPixelHalf(px+0,y1+1,Color);
    }
    return;
  }
  
  if(abs(x2-x1)>abs(y2-y1)){
    int px=0;
    int pyf8=0;
    int xe=x2-x1;
    int yef8=(y2-y1)<<8;
    int xv;
    int yvf8;
    
    if(0<xe){
      xv=1;
      }else{
      xv=-1;
    }
    yvf8=yef8/abs(xe);
    
    while(px!=xe){
      u32 dx=x1+px;
      u32 dy=y1+(int)(pyf8>>8);
      SetPixelHalf(dx+0,dy-1,Color);
      SetPixel(dx+0,dy+0,Color);
      SetPixelHalf(dx+0,dy+1,Color);
      px+=xv;
      pyf8+=yvf8;
    }
    return;
    
    }else{
    int pxf8=0;
    int py=0;
    int xef8=(x2-x1)<<8;
    int ye=y2-y1;
    int xvf8;
    int yv;
    
    xvf8=xef8/abs(ye);
    if(0<ye){
      yv=1;
      }else{
      yv=-1;
    }
    
    while(py!=ye){
      u32 dx=x1+(int)(pxf8>>8);
      u32 dy=y1+py;
      SetPixelHalf(dx-1,dy+0,Color);
      SetPixel(dx+0,dy+0,Color);
      SetPixelHalf(dx+1,dy+0,Color);
      pxf8+=xvf8;
      py+=yv;
    }
    return;
  }
}

void CglCanvas::MoveTo(const int x,const int y)
{
  LastX=x;
  LastY=y;
}

void CglCanvas::LineTo(const int x,const int y)
{
  DrawLine(LastX,LastY,x,y);
  
  LastX=x;
  LastY=y;
}


void CglCanvas::FillAll(void)
{
  vu16 *pbuf=VRAMBuf;
  vu32 bufsize=Width*Height;
  vu32 c=Color | (Color<<16);
  
  if((pbuf==NULL)||(bufsize==0)) return;
  
  asm volatile(
    "mov r0,%2 \n"
    "mov r1,%2 \n"
    "mov r2,%2 \n"
    "mov r3,%2 \n"
    "mov r4,%2 \n"
    "mov r5,%2 \n"
    "mov r6,%2 \n"
    "mov r7,%2 \n"
    
    "fillall_16pix: \n"
    "cmps %1,#16 \n"
    "blo fillall_2pix \n"
    "sub %1,#16 \n"
    "stmia %0!,{r0,r1,r2,r3,r4,r5,r6,r7} \n"
    "b fillall_16pix \n"
    
    "fillall_2pix: \n"
    "cmps %1,#2 \n"
    "blo fillall_1pix \n"
    "sub %1,#2 \n"
    "str r0,[%0],#4 \n"
    "b fillall_2pix \n"
    
    "fillall_1pix: \n"
    "cmps %1,#1 \n"
    "blo fillall_end \n"
    "sub %1,#1 \n"
    "strh r0,[%0],#2 \n"
    "b fillall_1pix \n"
    
    "fillall_end: \n"
    
    : "+r"(pbuf) : "r"(bufsize), "r"(c)
    : "r0","r1","r2","r3","r4","r5","r6","r7"
  );
}

void CglCanvas::FillFull(const u16 _Color)
{
  u16 *pbuf=VRAMBuf;
  u32 size=Width*Height;
  
  if((size&1)!=0){
    pbuf[size-1]=_Color;
  }
  
  u32 *pbuf32=(u32*)pbuf;
  u32 size32=size/2;
  u32 col32=_Color | (_Color<<16);
  
  for(u32 idx=0;idx<size32;idx++){
    *pbuf32++=col32;
  }
}

void CglCanvas::FillFast(const int x,const int y,const int w,const int h)
{
  // FLoXTCY2pixelPʁAx,w2pixelP
  
  vu32 c=Color | (Color<<16);
  
  for(int py=y;py<(y+h);py++){
    vu16 *pbuf=GetScanLine(py);
    pbuf+=x;
    vs32 count=w;
    
    asm volatile(
      "fillbox_2pix: \n"
      "str %2,[%0],#4 \n"
      "subs %1,#2 \n"
      "bne fillbox_2pix \n"
      
      : "+r"(pbuf), "+r"(count) : "r"(c)
      :
    );
  }
}

void CglCanvas::FillBox(const int x,const int y,const int w,const int h)
{
  for(int py=y;py<(y+h);py++){
    u16 *pbuf=GetScanLine(py);
    if(pbuf!=NULL){
      glMemSet16CPU(Color,&pbuf[x],w*2);
    }
  }
}

static inline void getrgb(u32 col,u32 *r,u32 *g,u32 *b)
{
  *r=(col>>0)&0x1f;
  *g=(col>>5)&0x1f;
  *b=(col>>10)&0x1f;
}

void CglCanvas::FillBox12(const int x,const int y,const int w,const int h)
{
  s32 xe=x+w;
  s32 ye=y+h;
  
  for(int py=y;py<ye;py++){
    u16 *pbuf=GetScanLine(py);
    if(pbuf!=NULL){
      for(int px=x;px<xe;px++){
        u32 r,g,b;
        getrgb(pbuf[px],&r,&g,&b);
        pbuf[px]=RGB15(r>>3,g>>3,b>>3)|BIT15;
      }
    }
  }
}

void CglCanvas::FillBox25(const int x,const int y,const int w,const int h)
{
  s32 xe=x+w;
  s32 ye=y+h;
  
  for(int py=y;py<ye;py++){
    u16 *pbuf=GetScanLine(py);
    if(pbuf!=NULL){
      for(int px=x;px<xe;px++){
        u32 r,g,b;
        getrgb(pbuf[px],&r,&g,&b);
        pbuf[px]=RGB15(r>>2,g>>2,b>>2)|BIT15;
      }
    }
  }
}

void CglCanvas::FillBox50(const int x,const int y,const int w,const int h)
{
  s32 xe=x+w;
  s32 ye=y+h;
  
  for(int py=y;py<ye;py++){
    u16 *pbuf=GetScanLine(py);
    if(pbuf!=NULL){
      for(int px=x;px<xe;px++){
        u32 r,g,b;
        getrgb(pbuf[px],&r,&g,&b);
        pbuf[px]=RGB15(r>>1,g>>1,b>>1)|BIT15;
      }
    }
  }
}

void CglCanvas::FillBox75(const int x,const int y,const int w,const int h)
{
  s32 xe=x+w;
  s32 ye=y+h;
  
  for(int py=y;py<ye;py++){
    u16 *pbuf=GetScanLine(py);
    if(pbuf!=NULL){
      for(int px=x;px<xe;px++){
        u32 r,g,b;
        getrgb(pbuf[px],&r,&g,&b);
        pbuf[px]=RGB15(r*3/4,g*3/4,b*3/4)|BIT15;
      }
    }
  }
}

void CglCanvas::DrawBox(const int x,const int y,const int w,const int h)
{
  if((w==0)||(h==0)) return;
  
  if((w==1)&&(h==1)){
    SetPixel(x,y,Color);
    return;
  }
  
  if(w==1){
    DrawLine(x,y,x,y+h);
    return;
  }
  
  if(h==1){
    DrawLine(x,y,x+w,y);
    return;
  }
  
  const int x1=x,y1=y,x2=x+w-1,y2=y+h-1;
  
  DrawLine(x1,y1,x2,y1);
  DrawLine(x2,y1,x2,y2);
  DrawLine(x2,y2,x1,y2);
  DrawLine(x1,y2,x1,y1);
}

void CglCanvas::SetFontBGColor(const u16 Color)
{
  CglFont *pFont=(CglFont*)pCglFont;
  
  pFont->SetBGColor(Color);
}

void CglCanvas::SetFontTextColor(const u16 Color)
{
  CglFont *pFont=(CglFont*)pCglFont;
  
  pFont->SetTextColor(Color);
}

void CglCanvas::TextOutA(const int x,const int y,const char *str) const
{
  int dx=x;
  int dy=y;
  s32 dw=Width;
  
  CglFont *pFont=(CglFont*)pCglFont;
  
  while(*str!=0){
    TglUnicode uidx=(TglUnicode)*str++;
    u32 endx=dx+pFont->GetFontWidth(uidx)+1;
    if(dw<endx) return;
    pFont->DrawFont((CglCanvas*)this,dx,dy,uidx);
    dx=endx;
  }
}

void CglCanvas::TextOutW(const int x,const int y,const TglUnicode *str) const
{
  int dx=x;
  int dy=y;
  s32 dw=Width;
  
  CglFont *pFont=(CglFont*)pCglFont;
  
  while(*str!=0){
    TglUnicode uidx=*str++;
    u32 endx=dx+pFont->GetFontWidth(uidx)+1;
    if(dw<endx) return;
    pFont->DrawFont((CglCanvas*)this,dx,dy,uidx);
    dx=endx;
  }
}

static void StrConvert_UTF82Unicode(const char *srcstr,TglUnicode *dststr)
{
  while(*srcstr!=0){
    u16 b0=(byte)srcstr[0],b1=(byte)srcstr[1],b2=(byte)srcstr[2];
    u16 uc;
    
    if(b0<0x80){
      uc=b0;
      srcstr++;
      }else{
      if((b0&0xe0)==0xc0){ // 0b 110. ....
        uc=((b0&~0xe0)<<6)+((b1&~0xc0)<<0);
        srcstr+=2;
        }else{
        if((b0&0xf0)==0xe0){ // 0b 1110 ....
          uc=((b0&~0xf0)<<12)+((b1&~0xc0)<<6)+((b2&~0xc0)<<0);
          srcstr+=3;
          }else{
          uc=(u16)'?';
          srcstr+=4;
        }
      }
    }
    
    *dststr=uc;
    dststr++;
  }
  
  *dststr=(TglUnicode)0;
}

void CglCanvas::TextOutUTF8(const int x,const int y,const char *str) const
{
  if(str==NULL) return;
  if(*str==0) return;
  
  u32 strlen=0;
  while(str[strlen]!=0) strlen++;
  
  TglUnicode *unistr=(TglUnicode*)glsafemalloc((strlen+1)*2);
  
  StrConvert_UTF82Unicode(str,unistr);
  
  TextOutW(x,y,unistr);
  
  glsafefree(unistr); unistr=NULL;
}

int CglCanvas::GetTextWidthA(const char *str) const
{
  int w=0;
  
  CglFont *pFont=(CglFont*)pCglFont;
  
  while(*str!=0){
    TglUnicode uidx=(TglUnicode)*str++;
    w+=pFont->GetFontWidth(uidx)+1;
  }
  
  return(w);
}

int CglCanvas::GetTextWidthW(const TglUnicode *str) const
{
  int w=0;
  
  CglFont *pFont=(CglFont*)pCglFont;
  
  while(*str!=0){
    w+=pFont->GetFontWidth(*str)+1;
    str++;
  }
  
  return(w);
}

int CglCanvas::GetTextWidthUTF8(const char *str) const
{
  if(str==NULL) return(0);
  if(*str==0) return(0);
  
  u32 strlen=0;
  while(str[strlen]!=0) strlen++;
  
  TglUnicode *unistr=(TglUnicode*)glsafemalloc((strlen+1)*2);
  
  StrConvert_UTF82Unicode(str,unistr);
  
  u32 w=GetTextWidthW(unistr);
  
  glsafefree(unistr); unistr=NULL;
  
  return(w);
}

int CglCanvas::GetTextHeight(void) const
{
  CglFont *pFont=(CglFont*)pCglFont;
  return(pFont->GetFontHeight());
}

void CglCanvas::SetCglFont(void *_pCglFont)
{
  if(_pCglFont==NULL){
    pCglFont=pCglFontDefault;
    }else{
    pCglFont=_pCglFont;
  }
}

void CglCanvas::BitBlt(CglCanvas *pDestCanvas,const int nDestLeft,const int nDestTop,const int nWidth,const int nHeight,const int nSrcLeft,const int nSrcTop,const bool TransFlag) const
{
  if(TransFlag==false){
    BitBltBeta(pDestCanvas,nDestLeft,nDestTop,nWidth,nHeight,nSrcLeft,nSrcTop);
    }else{
    BitBltTrans(pDestCanvas,nDestLeft,nDestTop,nWidth,nHeight,nSrcLeft,nSrcTop);
  }
}

void CglCanvas::BitBltBeta(CglCanvas *pDestCanvas,const int nDestLeft,const int nDestTop,const int nWidth,const int nHeight,const int nSrcLeft,const int nSrcTop) const
{
  int dx=nDestLeft;
  int dy=nDestTop;
  int sx=nSrcLeft;
  int sy=nSrcTop;
  int w=nWidth;
  int h=nHeight;
  
  if(dx<0){
    dx=-dx;
    w-=dx;
    sx+=dx;
    dx=0;
  }
  if(dy<0){
    dy=-dy;
    h-=dy;
    sy+=dy;
    dy=0;
  }
  
  if((w<0)||(h<0)) return;
  
  if(Width<=sx) return;
  if(Height<=sy) return;
  
  if(Width<(sx+w)) w=Width-sx;
  if(Height<(sy+h)) h=Height-sy;
  
  u16 *psrcbuf=GetScanLine(sy)+sx;
  u32 srcw=Width;
  u16 *pdstbuf=pDestCanvas->GetScanLine(dy)+dx;
  u32 dstw=pDestCanvas->GetWidth();
  
  for(u32 y=0;y<(u32)h;y++){
    glMemCopy16CPU(psrcbuf,pdstbuf,w*2);
    psrcbuf+=srcw;
    pdstbuf+=dstw;
  }
}

void CglCanvas::BitBltTrans(CglCanvas *pDestCanvas,const int nDestLeft,const int nDestTop,const int nWidth,const int nHeight,const int nSrcLeft,const int nSrcTop) const
{
  int dx=nDestLeft;
  int dy=nDestTop;
  int sx=nSrcLeft;
  int sy=nSrcTop;
  int w=nWidth;
  int h=nHeight;
  
  if(dx<0){
    dx=-dx;
    w-=dx;
    sx+=dx;
    dx=0;
  }
  if(dy<0){
    dy=-dy;
    h-=dy;
    sy+=dy;
    dy=0;
  }
  
  if((w<0)||(h<0)) return;
  
  if(Width<=sx) return;
  if(Height<=sy) return;
  
  if(Width<(sx+w)) w=Width-sx;
  if(Height<(sy+h)) h=Height-sy;
  
  u16 *psrcdata=&VRAMBuf[sx+(sy*Width)];
  u32 srcdataw=Width;
  u16 *pdstdata=pDestCanvas->GetScanLine(dy)+dx;
  u32 dstdataw=pDestCanvas->GetWidth();
  
  for(int y=0;y<h;y++){
    for(int x=0;x<w;x++){
      u16 data=psrcdata[x];
      if(data!=0){
        pdstdata[x]=data;
      }
    }
    psrcdata+=srcdataw;
    pdstdata+=dstdataw;
  }
}

#define add8(d) { pbuf[ofs]=d; ofs++; }
#define add16(d) { pbuf[ofs+0]=(u8)((d>>0)&0xff); pbuf[ofs+1]=(u8)((d>>8)&0xff); ofs+=2; }
#define add32(d) { pbuf[ofs+0]=(u8)((d>>0)&0xff); pbuf[ofs+1]=(u8)((d>>8)&0xff); pbuf[ofs+2]=(u8)((d>>16)&0xff); pbuf[ofs+3]=(u8)((d>>24)&0xff); ofs+=4; }

u8* CglCanvas::CreateBMPImage(u32 *size) const
{
  u32 linelen;
  
  linelen=Width*3;
  linelen=(linelen+3)&(~3);
  
  u32 bufsize=14+40+(Height*linelen);
  u8 *pbuf=(u8*)malloc(bufsize);
  if(pbuf==NULL){
    glDebugPrintf("memory overflow!! CreateBMPImage. safemalloc(%d)=NULL;\n",bufsize);
    *size=0;
    return(NULL);
  }
  
  u32 ofs=0;
  
  // BITMAPFILEHEADER
  
  // bfType 2 byte t@C^Cv 'BM' - OS/2, Windows Bitmap
  add8((u8)'B');
  add8((u8)'M');
  // bfSize 4 byte t@CTCY (byte)
  add32(bufsize);
  // bfReserved1 2 byte \̈  0
  add16(0);
  // bfReserved2 2 byte \̈  0
  add16(0);
  // bfOffBits 4 byte t@C擪摜f[^܂ł̃ItZbg (byte)
  add32(14+40);
  
  // BITMAPINFOHEADER
  
  // biSize 4 byte wb_̃TCY (byte) 40
  add32(40);
  // biWidth 4 byte 摜̕ (sNZ)
  add32(Width);
  // biHeight 4 byte 摜̍ (sNZ) biHeight ̒lȂC摜f[^͉
  add32(Height);
  // biPlanes 2 byte v[  1
  add16(1);
  // biBitCount 2 byte 1 f̃f[^TCY (bit)
  add16(24);
  // biCopmression 4 byte k` 0 - BI_RGB (k)
  add32(0);
  // biSizeImage 4 byte 摜f[^̃TCY (byte) 96dpi Ȃ3780
  add32(0);
  // biXPixPerMeter 4 byte 𑜓x (1m̉f) 96dpi Ȃ3780
  add32(0);
  // biYPixPerMeter 4 byte c𑜓x (1m̉f) 96dpi Ȃ3780
  add32(0);
  // biClrUsed 4 byte i[Ăpbg (gpF) 0 ̏ꍇ
  add32(0);
  // biCirImportant 4 byte dvȃpbg̃CfbNX 0 ̏ꍇ
  add32(0);
  
  for(int y=Height-1;0<=y;y--){
    u16 *psrcbm=&VRAMBuf[y*Width];
    for(int x=0;x<Width;x++){
      u16 col=*psrcbm++;
      u8 b=(col>>10)&0x1f;
      u8 g=(col>>5)&0x1f;
      u8 r=(col>>0)&0x1f;
      add8(b<<3);
      add8(g<<3);
      add8(r<<3);
    }
    for(u32 x=0;x<(linelen-(Width*3));x++){
      add8(0);
    }
  }
  
  *size=bufsize;
  return(pbuf);
}

#undef add8
#undef add16
#undef add32

