
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <NDS.h>

#include "_const.h"
#include "_console.h"

#include "memtool.h"
#include "inifile.h"

#include "directdisk.h"

#include "gba_nds_fat.h"
#include "disc_io.h"
#include "mediatype.h"

extern LPIO_INTERFACE active_interface;

typedef struct {
  u32 Sector,SectorMirror;
} TFileInfo;

static TFileInfo FileInfo;

static bool CanWrite;

static u8 tmpbuf[DD_SectorSize];

static bool DD_InitFile_FAT(TFileInfo *pfi,FAT_FILE *fp,u8 *pfbuf0,u8 *pfbuf1)
{
  if((active_interface->ul_Features & FEATURE_MEDIUM_CANWRITE)==0){
    _consolePrintf("\nnot support disk write function.\nAdapter = %s\n",DIMediaName);
    return(false);
  }
  
  u32 clus=fp->curClus;
  u32 Sector=FAT_ClustToSect_extern(clus);
  _consolePrintf("Cluster=0x%08x\n",clus);
  _consolePrintf("Sector=0x%08x\n",Sector);
  
  if(Sector==0){
    _consolePrintf("\nSector is null.\n");
    return(false);
  }
  
  FAT_fseek(fp,0,SEEK_END);
  u32 fsize=FAT_ftell(fp);
  FAT_fseek(fp,0,SEEK_SET);
  
  if(fsize<DD_SectorSize){
    _consolePrintf("\nfile size is not %dbyte.\n",DD_SectorSize);
    return(false);
  }
  
  {
    _consolePrintf("Test: direct disk reading.");
    
    // read source
    active_interface->fn_ReadSectors(Sector,1,pfbuf0);
    FAT_fread(pfbuf1,1,DD_SectorSize,fp);
    
    // verify
    for(u32 idx=0;idx<DD_SectorSize;idx++){
      if(pfbuf0[idx]!=pfbuf1[idx]){
        _consolePrintf(" failed.\nposition = (%d,0x%02x!=0x%02x)\n",idx,pfbuf0[idx],pfbuf1[idx]);
        return(false);
      }
    }
    _consolePrintf("\n");
  }
  
  {
    _consolePrintf("Test: direct disk writing.");
    
    // write dummy
    for(u32 idx=0;idx<DD_SectorSize;idx++){
      pfbuf0[idx]=(idx-126)&0xff;
    }
    active_interface->fn_WriteSectors(Sector,1,pfbuf0);
    
    // read dummy
    for(u32 idx=0;idx<DD_SectorSize;idx++){
      pfbuf0[idx]=0xa5;
    }
    active_interface->fn_ReadSectors(Sector,1,pfbuf0);
    
    // restore
    active_interface->fn_WriteSectors(Sector,1,pfbuf1);
    
    // verify
    for(u32 idx=0;idx<DD_SectorSize;idx++){
      if(pfbuf0[idx]!=((idx-126)&0xff)){
        _consolePrintf(" failed.\nposition = (%d,0x%02x!=0x%02x)\n",idx,pfbuf0[idx],(idx-126)&0xff);
        return(false);
      }
    }
    
    _consolePrintf("\n");
  }
  
  _consolePrintf("can write.\n");
  
  pfi->Sector=Sector;
  pfi->SectorMirror=Sector;
  
  return(true);
}

void DD_InitFile(const char *pAliasFullFilename)
{
  vu16 ime=REG_IME;
  REG_IME=0;
  
  MemSet8CPU(0,tmpbuf,DD_SectorSize);
  
  CanWrite=false;
  
  if(GlobalINI.AdapterConfig.EnabledWrite==true){
    TFileInfo *pfi=&FileInfo;
    
    pfi->Sector=0;
    pfi->SectorMirror=0;
    
    FAT_FILE *fp=FAT_fopen(pAliasFullFilename,"r");
    if(fp==NULL){
      _consolePrintf("\nfile not found. [%s]\n",pAliasFullFilename);
      return;
    }
    
    u8 *pfbuf0=(u8*)safemalloc(DD_SectorSize);
    u8 *pfbuf1=(u8*)safemalloc(DD_SectorSize);
    
    CanWrite=DD_InitFile_FAT(pfi,fp,pfbuf0,pfbuf1);
    
    FAT_fclose(fp);
    
    safefree(pfbuf0);
    safefree(pfbuf1);
  }
  
  REG_IME=ime;
  
  return;
}

// --------------------

static void fatinfochk(void)
{
  TFileInfo *pfi=&FileInfo;
  
  if((pfi->Sector==0)||(pfi->Sector!=pfi->SectorMirror)){
    _consolePrintf("Sector(%d)!=SectorMirror(%d)\n",pfi->Sector,pfi->SectorMirror);
    _consolePrintf("Critical error!! CPU HALT for safety.\n");
    ShowLogHalt();
    while(1);
  }
}

static void FAT_ReadSector(void *pbuf,u32 bufsize)
{
  fatinfochk();
//  for(vu32 idx=0;idx<0x10000;idx++);
  active_interface->fn_ReadSectors(FileInfo.Sector,1,pbuf);
//  for(vu32 idx=0;idx<0x10000;idx++);
}

static void FAT_WriteSector(void *pbuf,u32 bufsize)
{
  fatinfochk();
//  for(vu32 idx=0;idx<0x10000;idx++);
  active_interface->fn_WriteSectors(FileInfo.Sector,1,pbuf);
//  for(vu32 idx=0;idx<0x10000;idx++);
}

// --------------------

void DD_ReadFile(void *pbuf,u32 bufsize)
{
  if(pbuf==NULL){
    _consolePrintf("DD_xSector(0x%x,%d); pbuf=NULL.\n",pbuf,bufsize);
    ShowLogHalt();
    while(1);
  }
  
  if(bufsize!=DD_SectorSize){
    _consolePrintf("DD_xSector(0x%x,%d); Illigal bufsize error.\n",pbuf,bufsize);
    ShowLogHalt();
    while(1);
  }
  
  if(CanWrite==false){
    MemCopy8CPU(tmpbuf,pbuf,DD_SectorSize);
    }else{
    vu16 ime=REG_IME;
    REG_IME=0;
    FAT_ReadSector(pbuf,DD_SectorSize);
    REG_IME=ime;
  }
}

void DD_WriteFile(void *pbuf,u32 bufsize)
{
  if(pbuf==NULL){
    _consolePrintf("DD_xSector(0x%x,%d); pbuf=NULL.\n",pbuf,bufsize);
    ShowLogHalt();
    while(1);
  }
  
  if(bufsize!=DD_SectorSize){
    _consolePrintf("DD_xSector(0x%x,%d); Illigal bufsize error.\n",pbuf,bufsize);
    ShowLogHalt();
    while(1);
  }
  
  if(CanWrite==false){
    MemCopy8CPU(pbuf,tmpbuf,DD_SectorSize);
    }else{
    u32 RetryCount=16;
    while(RetryCount!=0){
      {
        swiWaitForVBlank();
        vu16 ime=REG_IME;
        REG_IME=0;
        FAT_WriteSector(pbuf,DD_SectorSize);
        REG_IME=ime;
      }
      static u32 TestBuf[DD_SectorSize/4];
      {
        swiWaitForVBlank();
        vu16 ime=REG_IME;
        REG_IME=0;
        FAT_ReadSector(TestBuf,DD_SectorSize);
        REG_IME=ime;
      }
      bool flag=true;
      u32 *psrcbuf=(u32*)pbuf;
      for(u32 idx=0;idx<DD_SectorSize/4;idx++){
        if(psrcbuf[idx]!=TestBuf[idx]){
          flag=false;
          _consolePrintf("[%d,%08x,%08x] ",idx*4,psrcbuf[idx],TestBuf[idx]);
        }
      }
      if(flag==true) return;
      RetryCount--;
    }
    _consolePrintf("\n\nDD_xSector(0x%x,%d);\nFatal error!!\n\n",pbuf,bufsize);
    ShowLogHalt();
  }
}

