
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <NDS.h>

#include "_console.h"
#include "_consolewritelog.h"
#include "_const.h"
#include "memtool.h"

#include "glib/glib.h"
#include "shell.h"
#include "maindef.h"

#include "corner.h"

typedef struct {
  EIconType IconType;
  const char *Filename;
  CglB15 *pB15;
} TIconBM;

#define IconBMCount (EITCount)
static TIconBM IconBMs[IconBMCount];

void Corner_Init(void)
{
  u8 b15buf[1024];
  
  for(u32 idx=0;idx<IconBMCount;idx++){
    TIconBM *pibm=&IconBMs[idx];
    pibm->IconType=(EIconType)idx;
    switch(pibm->IconType){
      case EIT_Mouse: pibm->Filename="icon_mouse.b15"; break;
      case EIT_BlueBox: pibm->Filename="icon_bluebox.b15"; break;
      case EIT_Lite: pibm->Filename="icon_lite.b15"; break;
      case EIT_Up: pibm->Filename="icon_up.b15"; break;
      case EIT_Left: pibm->Filename="icon_left.b15"; break;
      case EIT_Right: pibm->Filename="icon_right.b15"; break;
      case EIT_SpeakerOn: pibm->Filename="icon_speakeron.b15"; break;
      case EIT_SpeakerOff: pibm->Filename="icon_speakeroff.b15"; break;
      case EIT_SlideBtn: pibm->Filename="icon_slidebtn.b15"; break;
      case EIT_ToggleDisplay: pibm->Filename="icon_toggledisplay.b15"; break;
      case EIT_ReduceDown: pibm->Filename="icon_reduce_down.b15"; break;
      case EIT_ReduceUp: pibm->Filename="icon_reduce_up.b15"; break;
      case EIT_DblScr_Vertical: pibm->Filename="icon_dblscr_vertical.b15"; break;
      case EIT_DblScr_Horizontal: pibm->Filename="icon_dblscr_horizontal.b15"; break;
      case EITCount: default: {
        _consolePrintf("Unknown EIconType value. %d\n",pibm->IconType);
        ShowLogHalt();
      } break;
    }
    {
      u8 *pb15;
      int b15size;
      if(Shell_ReadFileAlloc(pibm->Filename,(void**)&pb15,&b15size)==false){
        _consolePrintf("File not found.\n");
        ShowLogHalt();
      }
      MemCopy8CPU(pb15,b15buf,b15size);
      safefree(pb15); pb15=NULL;
      pibm->pB15=new CglB15(b15buf,b15size);
    }
  }
}

void Corner_Free(void)
{
  for(u32 idx=0;idx<IconBMCount;idx++){
    TIconBM *pibm=&IconBMs[idx];
    delete pibm->pB15; pibm->pB15=NULL;
  }
}

CglB15* Corner_GetIcon(EIconType IconType)
{
  TIconBM *pibm=&IconBMs[(u32)IconType];
  return(pibm->pB15);
}

ECornerItem GetInsideCornerItem(s32 x,s32 y)
{
  const s32 s=CornerIconSize;
  
  if((x<s)&&(y<s)) return(ECI_LeftUp);
  if(((Global_ScreenWidth-s)<=x)&&(y<s)) return(ECI_RightUp);
  if((x<s)&&((Global_ScreenHeight-s)<=y)) return(ECI_LeftDown);
  if(((Global_ScreenWidth-s)<=x)&&((Global_ScreenHeight-s)<=y)) return(ECI_RightDown);
  
  if(y<s){
    s32 xc=Global_ScreenWidth/2;
    s32 xcl=xc-16-s;
    s32 xcc=xc-(s/2);
    s32 xcr=xc+16;
    if((xcl<=x)&&(x<(xcl+s))) return(ECI_CenterTop_Left);
    if((xcc<=x)&&(x<(xcc+s))) return(ECI_CenterTop_Center);
    if((xcr<=x)&&(x<(xcr+s))) return(ECI_CenterTop_Right);
  }
  
  if((Global_ScreenHeight-s)<=y){
    s32 xc=Global_ScreenWidth/2;
    s32 xcl=xc-16-s;
    s32 xcc=xc-(s/2);
    s32 xcr=xc+16;
    if((xcl<=x)&&(x<(xcl+s))) return(ECI_CenterDown_Left);
    if((xcc<=x)&&(x<(xcc+s))) return(ECI_CenterDown_Center);
    if((xcr<=x)&&(x<(xcr+s))) return(ECI_CenterDown_Right);
  }
  
  return(ECI_None);
}

TPoint Corner_GetPoint(u32 IconIndex)
{
  TPoint p;
  
  if(Global_isVertical==true){
    // Ec
    p.x=256-CornerIconSize;
    p.y=CornerIconSize*IconIndex;
    }else{
    // E
    p.x=256-CornerIconSize-(CornerIconSize*IconIndex);
    p.y=256-CornerIconSize;
  }
  
  return(p);
}

