
#ifndef component_h
#define component_h

#include <NDS.h>

#include "glib/glib.h"

#include "rect.h"

enum ECompIconType {ECIT_Ok,ECIT_Cancel,ECIT_BoxMin,ECIT_BoxPlus,ECIT_CheckOff,ECIT_CheckOn,ECIT_RadioOff,ECIT_RadioOn,ECITCount};

extern void Component_Init(void);
extern void Component_Free(void);
extern CglB15* Component_GetIcon(ECompIconType CompIconType);

typedef struct {
  void (*CallBack_ItemDraw)(u32 Index,CglCanvas *pCanvas,TRect r);
  CglCanvas *pCanvas;
  const char *pTitleUTF8_eng,*pTitleUTF8_jpn;
  u32 ItemCount;
  s32 ItemHeight;
  s32 TextOfsX,TextOfsY;
  TRect Rect;
  u16 FrameColor,FillColor;
  u32 FillAlpha; // 0/12/25/50/75/100 only. 0=Filled FillColor.
} TComponentFrame;

extern void ComponentFrame_Init(TComponentFrame *pComponentFrame,CglCanvas *pCanvas);
extern void ComponentFrame_Draw(TComponentFrame *pComponentFrame);
extern s32 ComponentFrame_GetIndexFromPos(TComponentFrame *pComponentFrame,s32 mx,s32 my);

typedef struct {
  void (*CallBack_Click)(void *pComponentLabel);
  CglCanvas *pCanvas;
  TRect Rect;
  CglFont *pFont;
  u16 BGColor,TextColor;
  bool Center;
  const char *pMsgUTF8_eng,*pMsgUTF8_jpn;
} TComponentLabel;

extern void ComponentLabel_Init(TComponentLabel *pComponentLabel,CglCanvas *pCanvas);
extern void ComponentLabel_Draw(TComponentLabel *pComponentLabel);
extern s32 ComponentLabel_GetIndexFromPos(TComponentLabel *pComponentLabel,s32 mx,s32 my);
extern bool ComponentLabel_MouseUp(TComponentLabel *pComponentLabel,s32 mx,s32 my);

typedef struct {
  void (*CallBack_Click)(void *pComponentCheck);
  CglCanvas *pCanvas;
  CglCanvas *pOnCanvas,*pOffCanvas;
  bool Checked;
  TRect Rect;
  CglFont *pFont;
  u16 BGColor,TextColor;
  const char *pMsgUTF8_eng,*pMsgUTF8_jpn;
} TComponentCheck;

extern void ComponentCheck_Init(TComponentCheck *pComponentCheck,CglCanvas *pCanvas);
extern void ComponentCheck_Draw(TComponentCheck *pComponentCheck);
extern s32 ComponentCheck_GetIndexFromPos(TComponentCheck *pComponentCheck,s32 mx,s32 my);
extern bool ComponentCheck_MouseUp(TComponentCheck *pComponentCheck,s32 mx,s32 my);

typedef struct {
  CglCanvas *pCanvas;
  CglCanvas *pIconCanvas;
  bool Pressing;
  TRect Rect;
  CglFont *pFont;
  u16 BGColor,BGPressColor,TextColor;
  const char *pMsgUTF8_eng,*pMsgUTF8_jpn;
  void (*CallBack_Click)(void *pComponentButton);
} TComponentButton;

extern void ComponentButton_Init(TComponentButton *pComponentButton,CglCanvas *pCanvas);
extern void ComponentButton_Draw(TComponentButton *pComponentButton);
extern s32 ComponentButton_GetIndexFromPos(TComponentButton *pComponentButton,s32 mx,s32 my);
extern bool ComponentButton_MouseUp(TComponentButton *pComponentButton,s32 mx,s32 my);

#endif

