
#include <NDS.h>

#include "_const.h"
#include "_console.h"

#include "maindef.h"
#include "memtool.h"
#include "shell.h"
#include "lang.h"

#include "component.h"

typedef struct {
  ECompIconType CompIconType;
  const char *Filename;
  CglB15 *pB15;
} TCompIconBM;

#define CompIconBMCount (ECITCount)
static TCompIconBM CompIconBMs[CompIconBMCount];

void Component_Init(void)
{
  u8 b15buf[1024];
  
  for(u32 idx=0;idx<CompIconBMCount;idx++){
    TCompIconBM *pcibm=&CompIconBMs[idx];
    pcibm->CompIconType=(ECompIconType)idx;
    switch(pcibm->CompIconType){
      case ECIT_Ok: pcibm->Filename="comp_ok.b15"; break;
      case ECIT_Cancel: pcibm->Filename="comp_cancel.b15"; break;
      case ECIT_BoxMin: pcibm->Filename="comp_boxmin.b15"; break;
      case ECIT_BoxPlus: pcibm->Filename="comp_boxplus.b15"; break;
      case ECIT_CheckOff: pcibm->Filename="comp_chkoff.b15"; break;
      case ECIT_CheckOn: pcibm->Filename="comp_chkon.b15"; break;
      case ECIT_RadioOff: pcibm->Filename="comp_radiooff.b15"; break;
      case ECIT_RadioOn: pcibm->Filename="comp_radioon.b15"; break;
      case ECITCount: default: {
        _consolePrintf("Unknown EIconType value. %d\n",pcibm->CompIconType);
        ShowLogHalt();
      } break;
    }
    {
      u8 *pb15;
      int b15size;
      if(Shell_ReadFileAlloc(pcibm->Filename,(void**)&pb15,&b15size)==false){
        _consolePrintf("File not found.\n");
        ShowLogHalt();
      }
      MemCopy8CPU(pb15,b15buf,b15size);
      safefree(pb15); pb15=NULL;
      pcibm->pB15=new CglB15(b15buf,b15size);
    }
  }
}

void Component_Free(void)
{
  for(u32 idx=0;idx<CompIconBMCount;idx++){
    TCompIconBM *pcibm=&CompIconBMs[idx];
    delete pcibm->pB15; pcibm->pB15=NULL;
  }
}

CglB15* Component_GetIcon(ECompIconType CompIconType)
{
  TCompIconBM *pcibm=&CompIconBMs[(u32)CompIconType];
  return(pcibm->pB15);
}

// -----------------------

void ComponentFrame_Init(TComponentFrame *pComponentFrame,CglCanvas *pCanvas)
{
  TComponentFrame *pcf=pComponentFrame;
  
  pcf->pCanvas=pCanvas;
  pcf->pTitleUTF8_eng=NULL;
  pcf->pTitleUTF8_jpn=NULL;
  pcf->ItemCount=0;
  pcf->ItemHeight=0;
  pcf->TextOfsX=0;
  pcf->TextOfsY=0;
  pcf->Rect=CreateRect(0,0,0,0);
  pcf->FrameColor=(u16)(GlobalTextColor15<<1) | BIT15; // Kɂقǂ
  pcf->FillAlpha=0;
  pcf->FillColor=RGB15(0,0,0)|BIT15;
  pcf->CallBack_ItemDraw=NULL;
}

void ComponentFrame_Draw(TComponentFrame *pComponentFrame)
{
  TComponentFrame *pcf=pComponentFrame;
  TRect r=pcf->Rect;
  
  if(21<pcf->Rect.y){
    const char *pTitleUTF8=Lang_GetTextUTF8(pcf->pTitleUTF8_eng,pcf->pTitleUTF8_jpn);
    
    if(pTitleUTF8!=NULL){
      TRect r=pcf->Rect;
      r.h=20;
      r.y-=r.h;
      pcf->pCanvas->SetColor(GlobalTextColor15);
      pcf->pCanvas->DrawBox(r.x-1,r.y-1,r.w+2,r.h+1);
      pcf->pCanvas->SetColor(GlobalBGColor15);
      pcf->pCanvas->FillBox(r.x,r.y,r.w,r.h);
      
      pcf->pCanvas->SetCglFont(pCglFont_Large14);
      pcf->pCanvas->SetFontBGColor(GlobalBGColor15);
      pcf->pCanvas->SetFontTextColor(GlobalTextColor15);
      
      u32 TextHeight=pcf->pCanvas->GetTextHeight();
      pcf->pCanvas->TextOutUTF8(r.x+2,r.y+((r.h-TextHeight)/2),pTitleUTF8);
    }
  }
  
  pcf->pCanvas->SetColor(pcf->FrameColor);
  pcf->pCanvas->DrawBox(r.x-1,r.y-1,r.w+2,r.h+2);
  
  switch(pcf->FillAlpha){
    case 0: {
      pcf->pCanvas->SetColor(pcf->FillColor|BIT15);
      pcf->pCanvas->FillBox(r.x-1,r.y-1,r.w+2,r.h+2);
    } break;
    case 12: pcf->pCanvas->FillBox12(r.x,r.y,r.w,r.h); break;
    case 25: pcf->pCanvas->FillBox25(r.x,r.y,r.w,r.h); break;
    case 50: pcf->pCanvas->FillBox50(r.x,r.y,r.w,r.h); break;
    case 75: pcf->pCanvas->FillBox75(r.x,r.y,r.w,r.h); break;
    case 100: break;
    default: {
      _consolePrintf("Not support fill alpha. FillAlpha=%d\n",pcf->FillAlpha);
      ShowLogHalt();
    }
  }
  
  pcf->pCanvas->SetCglFont(pCglFont_Large14);
  pcf->pCanvas->SetFontBGColor(GlobalTextColor15);
  pcf->pCanvas->SetFontTextColor(GlobalBGColor15);
  
  for(u32 idx=0;idx<(u32)pcf->ItemCount;idx++){
    TRect r=pcf->Rect;
    
    r.x=r.x+pcf->TextOfsX;
    r.y=r.y+(pcf->ItemHeight*idx)+pcf->TextOfsY;
    r.w=r.w-(pcf->TextOfsX*2);
    r.h=pcf->ItemHeight-(pcf->TextOfsY*2);
    
    if(pcf->CallBack_ItemDraw!=NULL) pcf->CallBack_ItemDraw(idx,pcf->pCanvas,r);
  }
}

s32 ComponentFrame_GetIndexFromPos(TComponentFrame *pComponentFrame,s32 mx,s32 my)
{
  TComponentFrame *pcf=pComponentFrame;
  TRect r=pcf->Rect;
  
  mx-=r.x;
  my-=r.y;
  
  if((0<=mx)&&(mx<r.w)){
    if((0<=my)&&(my<r.h)){
      s32 idx=my/pcf->ItemHeight;
      if((0<=idx)&&(idx<(s32)pcf->ItemCount)) return(idx);
    }
  }
  
  return(-1);
}

// ---------------------

void ComponentLabel_Init(TComponentLabel *pComponentLabel,CglCanvas *pCanvas)
{
  TComponentLabel *pcl=pComponentLabel;
  
  pcl->CallBack_Click=NULL;
  pcl->pCanvas=pCanvas;
  pcl->Rect=CreateRect(0,0,0,0);
  pcl->pFont=pCglFont_Large14;
  pcl->BGColor=GlobalBGColor15;
  pcl->TextColor=GlobalTextColor15;
  pcl->Center=false;
  pcl->pMsgUTF8_eng="";
  pcl->pMsgUTF8_jpn="";
}

void ComponentLabel_Draw(TComponentLabel *pComponentLabel)
{
  TComponentLabel *pcl=pComponentLabel;
  
  pcl->pCanvas->SetCglFont(pcl->pFont);
  pcl->pCanvas->SetFontBGColor(pcl->BGColor);
  pcl->pCanvas->SetFontTextColor(pcl->TextColor);
  
  const char *pmsgUTF8=Lang_GetTextUTF8(pcl->pMsgUTF8_eng,pcl->pMsgUTF8_jpn);
  
  u32 TextWidth=pcl->pCanvas->GetTextWidthUTF8(pmsgUTF8);
  u32 TextHeight=pcl->pCanvas->GetTextHeight();
  
  if(pcl->Rect.w==0) pcl->Rect.w=TextWidth;
  if(pcl->Rect.h==0) pcl->Rect.h=TextHeight;
  
  TRect r=pcl->Rect;
  
  pcl->pCanvas->SetColor(pcl->BGColor);
  pcl->pCanvas->FillBox(r.x,r.y,r.w,r.h);
  
  if(pcl->Center==false){
    pcl->pCanvas->TextOutUTF8(r.x,r.y,pmsgUTF8);
    }else{
    pcl->pCanvas->TextOutUTF8(r.x+((r.w-TextWidth)/2),r.y,pmsgUTF8);
  }
}

s32 ComponentLabel_GetIndexFromPos(TComponentLabel *pComponentLabel,s32 mx,s32 my)
{
  TComponentLabel *pcl=pComponentLabel;
  TRect r=pcl->Rect;
  
  mx-=r.x;
  my-=r.y;
  
  if((0<=mx)&&(mx<r.w)){
    if((0<=my)&&(my<r.h)){
      return(0);
    }
  }
  
  return(-1);
}

bool ComponentLabel_MouseUp(TComponentLabel *pComponentLabel,s32 mx,s32 my)
{
  TComponentLabel *pcl=pComponentLabel;
  
  if(ComponentLabel_GetIndexFromPos(pcl,mx,my)==-1) return(false);
  
  if(pcl->CallBack_Click!=NULL) pcl->CallBack_Click(pcl);
  
  return(true);
}

// ------------------

void ComponentCheck_Init(TComponentCheck *pComponentCheck,CglCanvas *pCanvas)
{
  TComponentCheck *pcc=pComponentCheck;
  
  pcc->CallBack_Click=NULL;
  pcc->pCanvas=pCanvas;
  pcc->pOnCanvas=NULL;
  pcc->pOffCanvas=NULL;
  pcc->Checked=false;
  pcc->Rect=CreateRect(0,0,0,0);
  pcc->pFont=pCglFont_Large14;
  pcc->BGColor=GlobalBGColor15;
  pcc->TextColor=GlobalTextColor15;
  pcc->pMsgUTF8_eng="";
  pcc->pMsgUTF8_jpn="";
}

void ComponentCheck_Draw(TComponentCheck *pComponentCheck)
{
  TComponentCheck *pcc=pComponentCheck;
  
  if(pcc->Rect.w==0) pcc->Rect.w=pcc->pOnCanvas->GetWidth();
  if(pcc->Rect.h==0) pcc->Rect.h=pcc->pOnCanvas->GetHeight();
  
  TRect r=pcc->Rect;
  
  CglCanvas *pSrcCanvas=NULL;
  if(pcc->Checked==true){
    pSrcCanvas=pcc->pOnCanvas;
    }else{
    pSrcCanvas=pcc->pOffCanvas;
  }
  if(pSrcCanvas!=NULL){
    s32 x=r.x;
    s32 y=r.y;
    s32 w=pSrcCanvas->GetWidth();
    s32 h=pSrcCanvas->GetHeight();
    x+=(r.w-w)/2;
    y+=(r.h-h)/2;
    pSrcCanvas->BitBlt(pcc->pCanvas,x,y,w,h,0,0,true);
  }
  
  pcc->pCanvas->SetCglFont(pcc->pFont);
  pcc->pCanvas->SetFontBGColor(pcc->BGColor);
  pcc->pCanvas->SetFontTextColor(pcc->TextColor);
  
  const char *pmsgUTF8=Lang_GetTextUTF8(pcc->pMsgUTF8_eng,pcc->pMsgUTF8_jpn);
  
  u32 TextX=r.x+r.w+2;
  u32 TextY=r.y;
  u32 TextWidth=pcc->pCanvas->GetTextWidthUTF8(pmsgUTF8);
  u32 TextHeight=pcc->pCanvas->GetTextHeight();
  
  pcc->pCanvas->SetColor(pcc->BGColor);
  pcc->pCanvas->FillBox(TextX,TextY,TextWidth,TextHeight);
  
  pcc->pCanvas->TextOutUTF8(TextX,TextY,pmsgUTF8);
}

s32 ComponentCheck_GetIndexFromPos(TComponentCheck *pComponentCheck,s32 mx,s32 my)
{
  TComponentCheck *pcc=pComponentCheck;
  TRect r=pcc->Rect;
  
  pcc->pCanvas->SetCglFont(pcc->pFont);
  const char *pmsgUTF8=Lang_GetTextUTF8(pcc->pMsgUTF8_eng,pcc->pMsgUTF8_jpn);
  s32 TextWidth=r.w+2+pcc->pCanvas->GetTextWidthUTF8(pmsgUTF8);
  
  mx-=r.x;
  my-=r.y;
  
  if((0<=mx)&&(mx<TextWidth)){
    if((0<=my)&&(my<r.h)){
      return(0);
    }
  }
  
  return(-1);
}

bool ComponentCheck_MouseUp(TComponentCheck *pComponentCheck,s32 mx,s32 my)
{
  TComponentCheck *pcc=pComponentCheck;
  
  if(ComponentCheck_GetIndexFromPos(pcc,mx,my)==-1) return(false);
  
  if(pcc->CallBack_Click!=NULL) pcc->CallBack_Click(pcc);
  
  return(true);
}

// ------------------

void ComponentButton_Init(TComponentButton *pComponentButton,CglCanvas *pCanvas)
{
  TComponentButton *pcb=pComponentButton;
  
  pcb->CallBack_Click=NULL;
  pcb->pCanvas=pCanvas;
  pcb->pIconCanvas=NULL;
  pcb->Pressing=false;
  pcb->Rect=CreateRect(0,0,0,0);
  pcb->pFont=pCglFont_Large14;
  pcb->BGColor=GlobalBGColor15;
  pcb->BGPressColor=pcb->BGColor-RGB15(3,4,4);
  pcb->TextColor=GlobalTextColor15;
  pcb->pMsgUTF8_eng="";
  pcb->pMsgUTF8_jpn="";
}

void ComponentButton_Draw(TComponentButton *pComponentButton)
{
  TComponentButton *pcb=pComponentButton;
  
  u16 BGColor;
  
  if(pcb->Pressing==false){
    BGColor=pcb->BGColor;
    TRect r=pcb->Rect;
    pcb->pCanvas->SetColor(RGB15(29,27,28)|BIT15);
    pcb->pCanvas->DrawBox(r.x-1,r.y-1,r.w+2,r.h+2);
    pcb->pCanvas->SetColor(RGB15(20,12,14)|BIT15);
    pcb->pCanvas->DrawBox(r.x,r.y,r.w+1,r.h+1);
    pcb->pCanvas->SetColor(BGColor);
    pcb->pCanvas->FillBox(r.x,r.y,r.w,r.h);
    }else{
    BGColor=pcb->BGPressColor;
    TRect r=pcb->Rect;
    pcb->pCanvas->SetColor(RGB15(19,11,13)|BIT15);
    pcb->pCanvas->DrawBox(r.x-1,r.y-1,r.w+2,r.h+2);
    pcb->pCanvas->SetColor(BGColor);
    pcb->pCanvas->FillBox(r.x,r.y,r.w,r.h);
  }
  
  pcb->pCanvas->SetCglFont(pcb->pFont);
  pcb->pCanvas->SetFontBGColor(BGColor);
  pcb->pCanvas->SetFontTextColor(pcb->TextColor);
  
  const char *pmsgUTF8=Lang_GetTextUTF8(pcb->pMsgUTF8_eng,pcb->pMsgUTF8_jpn);
  
  TRect r=pcb->Rect;
  
  s32 IconWidth;
  s32 IconHeight;
  if(pcb->pIconCanvas==NULL){
    IconWidth=0;
    IconHeight=0;
    }else{
    IconWidth=pcb->pIconCanvas->GetWidth();
    IconHeight=pcb->pIconCanvas->GetHeight();
  }
  
  s32 TextWidth=pcb->pCanvas->GetTextWidthUTF8(pmsgUTF8);
  s32 TextHeight=pcb->pCanvas->GetTextHeight();
  
  s32 BodyWidth=IconWidth+2+TextWidth;
  s32 BodyHeight=IconHeight;
  if(IconHeight<TextHeight) BodyHeight=TextHeight;
  s32 BodyX=r.x+((r.w-BodyWidth)/2);
  s32 BodyY=r.y+((r.h-BodyHeight)/2);
  
  if(pcb->pIconCanvas!=NULL){
    s32 x=BodyX;
    s32 y=BodyY+((BodyHeight-IconHeight)/2);
    pcb->pIconCanvas->BitBlt(pcb->pCanvas,x,y,IconWidth,IconHeight,0,0,true);
  }
  
  pcb->pCanvas->TextOutUTF8(BodyX+2+IconWidth,BodyY,pmsgUTF8);
}

s32 ComponentButton_GetIndexFromPos(TComponentButton *pComponentButton,s32 mx,s32 my)
{
  TComponentButton *pcb=pComponentButton;
  TRect r=pcb->Rect;
  
  mx-=r.x;
  my-=r.y;
  
  if((0<=mx)&&(mx<r.w)){
    if((0<=my)&&(my<r.h)){
      return(0);
    }
  }
  
  return(-1);
}

bool ComponentButton_MouseUp(TComponentButton *pComponentButton,s32 mx,s32 my)
{
  TComponentButton *pcb=pComponentButton;
  
  if(ComponentButton_GetIndexFromPos(pcb,mx,my)==-1) return(false);
  
  if(pcb->CallBack_Click!=NULL) pcb->CallBack_Click(pcb);
  
  return(true);
}

