
#ifndef cipk_h
#define cipk_h

#include "unicode.h"

#include "cstream.h"

#define IPKID_Size (16)
#define IPKID_Data "PackedImages01\0x00\0x00"
#define IPKStateVersion_Size (4)
#define IPKStateBulk_Size (512-IPKID_Size-IPKStateVersion_Size)

#define IPKMCUWidth (64)
#define IPKMCUHeight (64)
#define IPKMCUSize (IPKMCUWidth*IPKMCUHeight)

enum EFileInfoExt {EFIE_None=0,EFIE_Exif=1};

enum EIPKThumbnailID {EIPKTHID_4864=0,EIPKTHID_6448=1,EIPKTHID_192256=2,EIPKTHID_256192=3,EIPKTHID_SKIP=4};
enum EIPKBodyFormat {EIPKBF_Beta15bit=0,EIPKBF_CustomJpegYUV111=1,EIPKBF_CustomJpegYUV411=2};

typedef struct {
  u32 Width,Height;
  u32 Ratio; // fixed fraction 16.16
  u16 *pBuf;
} TIPKThumbnail;

typedef struct {
  u32 Width,Height;
  u16 MCUXCount;
  u16 dummy;
  u16 MCUYCount;
  EIPKBodyFormat BodyFormat;
  s32 QuantizeTable[64];
} TIPKImageInfo;

class CIPK
{
  CIPK(const CIPK&);
  CIPK& operator=(const CIPK&);
protected:
  CStream *prfs;
  u32 FilesCount;
  u32 *pBodyOffsets;
  u32 OffsetEXT0;
public:
  char *pFileInfoExtExif_Description;
  char *pFileInfoExtExif_DateTime;
  CIPK(CStream *_pCStreamRead);
  ~CIPK(void);
  
  u32 GetFilesCount(void);
  bool GetCoverImage(TIPKThumbnail *pth);
  u32 GetBodyOffset(u32 FileIndex);
  
  void GetFilename(u32 FileIndex,UnicodeChar *pstr);
  bool GetFileInfoExtExif(u32 FileIndex);
  void GetThumbnail(u32 FileIndex,EIPKThumbnailID thID,TIPKThumbnail *pth);
  void GetImageInfo(u32 FileIndex,TIPKImageInfo *pimginfo);
  void GetMCUOffsets(u32 FileIndex,u32 *pMCUOffsets);
  void GetMCUData(TIPKImageInfo *pimginfo,u32 MCUOffset,u16 *pDstBuf,u32 DstSize);
};

#endif

