/*---------------------------------------------------------------------------------
	$Id: template.c,v 1.2 2005/09/07 20:06:06 wntrmute Exp $

	Simple ARM7 stub (sends RTC, TSC, and X/Y data to the ARM 9)

	$Log: template.c,v $
	Revision 1.2  2005/09/07 20:06:06  wntrmute
	updated for latest libnds changes
	
	Revision 1.8  2005/08/03 05:13:16  wntrmute
	corrected sound code


---------------------------------------------------------------------------------*/
#include <nds.h>

#include <nds/bios.h>
#include <nds/arm7/touch.h>
#include <nds/arm7/clock.h>

#include "memtoolARM7.h"

#include "../../ipcex.h"

extern void ex_touchReadXY_Init(void);
extern s32 ex_touchReadX(void);
extern s32 ex_touchReadY(void);

//////////////////////////////////////////////////////////////////////

static u32 strpcmCursorFlag=0;

static u32 strpcmSamples,strpcmChannels;
static u32 strpcmFormat;
static s16 *strpcmLBuf=NULL,*strpcmRBuf=NULL;

//static s16 *strpcmL0=NULL,*strpcmL1=NULL,*strpcmR0=NULL,*strpcmR1=NULL;

#define fix_strpcmSamples (1152*1)
#define fix_Multiple (4)
static s16 strpcmL0[fix_strpcmSamples*fix_Multiple],strpcmL1[fix_strpcmSamples*fix_Multiple],strpcmR0[fix_strpcmSamples*fix_Multiple],strpcmR1[fix_strpcmSamples*fix_Multiple];

#undef SOUND_FREQ
#define SOUND_FREQ(n)	(0x10000 - (16756000 / (n)))

static inline void strpcmPlay()
{
  IPCEX->IPCREQ=IPCREQ_NULL;
  
  strpcmCursorFlag=0;
  
  strpcmFormat=IPCEX->strpcmFormat;
  
  strpcmLBuf=IPCEX->strpcmLBuf;
  strpcmRBuf=IPCEX->strpcmRBuf;
  
  int Multiple=0;
  
  switch(strpcmFormat){
    case strpcmFormat_PCMx1: Multiple=1; break;
    case strpcmFormat_PCMx2: Multiple=2; break;
    case strpcmFormat_PCMx4: Multiple=4; break;
  }
  
  strpcmSamples=IPCEX->strpcmSamples;
  strpcmChannels=IPCEX->strpcmChannels;
  
  if(fix_strpcmSamples!=strpcmSamples) while(1);
  if(fix_Multiple!=Multiple) while(1);
  
/*
  strpcmL0=(s16*)safemalloc(strpcmSamples*Multiple*2);
  strpcmL1=(s16*)safemalloc(strpcmSamples*Multiple*2);
  strpcmR0=(s16*)safemalloc(strpcmSamples*Multiple*2);
  strpcmR1=(s16*)safemalloc(strpcmSamples*Multiple*2);
*/
  
//  powerON(POWER_SOUND);
//  SOUND_CR = SOUND_ENABLE | SOUND_VOL(0x7F);
  SCHANNEL_CR(0) = 0;
  SCHANNEL_CR(1) = 0;
  SCHANNEL_CR(2) = 0;
  SCHANNEL_CR(3) = 0;
  
  int f=IPCEX->strpcmFreq*Multiple;
  
  TIMER0_DATA = SOUND_FREQ(f);
  TIMER0_CR = TIMER_DIV_1 | TIMER_ENABLE;
  
  TIMER1_DATA = 0x10000 - (strpcmSamples*Multiple*2);
  TIMER1_CR = TIMER_CASCADE | TIMER_IRQ_REQ | TIMER_ENABLE;
  
  u32 ch;
  for(ch=0;ch<4;ch++){
    SCHANNEL_CR(ch) = 0;
    SCHANNEL_TIMER(ch) = SOUND_FREQ(f);
    SCHANNEL_LENGTH(ch) = (strpcmSamples*Multiple*2) >> 2;
    SCHANNEL_REPEAT_POINT(ch) = 0;
  }
  
  IPCEX->strpcmWriteRequest=0;
}

__attribute__((noinline)) static void strpcmStop()
{
//  powerOFF(POWER_SOUND);
//  SOUND_CR = 0;
  TIMER0_CR = 0;
  TIMER1_CR = 0;
  
  u32 ch;
  for(ch=0;ch<4;ch++){
    SCHANNEL_CR(ch) = 0;
  }
  
/*
  safefree(strpcmL0); strpcmL0=NULL;
  safefree(strpcmL1); strpcmL1=NULL;
  safefree(strpcmR0); strpcmR0=NULL;
  safefree(strpcmR1); strpcmR1=NULL;
*/
  
  IPCEX->IPCREQ=IPCREQ_NULL;
}

//////////////////////////////////////////////////////////////////////

#define MAX( x, y ) ( ( x > y ) ? x : y )
#define MIN( x, y ) ( ( x < y ) ? x : y )

__attribute__((noinline)) static void InterruptHandler_Timer1_SetSwapChannel(void)
{
  s16 *lbuf,*rbuf;
  
  if(strpcmCursorFlag==0){
    lbuf=strpcmL0;
    rbuf=strpcmR0;
    }else{
    lbuf=strpcmL1;
    rbuf=strpcmR1;
  }
  
  u32 channel=strpcmCursorFlag;
  
  // Left channel
  SCHANNEL_CR(channel) = 0;
  SCHANNEL_SOURCE(channel) = (uint32)lbuf;
  SCHANNEL_CR(channel) = SCHANNEL_ENABLE | SOUND_ONE_SHOT | SOUND_VOL(0x7F) | SOUND_PAN(0) | SOUND_16BIT;
  
  channel+=2;
  
  // Right channel
  SCHANNEL_CR(channel) = 0;
  SCHANNEL_SOURCE(channel) = (uint32)rbuf;
  SCHANNEL_CR(channel) = SCHANNEL_ENABLE | SOUND_ONE_SHOT | SOUND_VOL(0x7F) | SOUND_PAN(0x7F) | SOUND_16BIT;
  
  strpcmCursorFlag=1-strpcmCursorFlag;
  
  static s32 lastvol=-1;
  s32 vol=(s32)IPCEX->strpcmVolume16;
  
  if(lastvol!=vol){
    lastvol=vol;
    if(vol<16){
      SOUND_CR = SOUND_ENABLE | SOUND_VOL(vol*0x08);
      }else{
      SOUND_CR = SOUND_ENABLE | SOUND_VOL(0x7f);
    }
  }
}

__attribute__((noinline)) static void InterruptHandler_Timer1_ApplyVolume(s16 *lbuf,s16 *rbuf,u32 count)
{
  s32 vol=(s32)IPCEX->strpcmVolume16;
  if(vol<=16) return;
  
  if((lbuf==NULL)||(rbuf==NULL)) return;
  
  u32 cnt;
  for(cnt=count;cnt!=0;cnt--){
    s32 SrcSample;
    s32 Sample;
    
    SrcSample=(s32)*lbuf;
    Sample=MAX(MIN(32767,(SrcSample*vol)/16),-32768);
    *lbuf++=(s16)Sample;
    
    SrcSample=(s32)*rbuf;
    Sample=MAX(MIN(32767,(SrcSample*vol)/16),-32768);
    *rbuf++=(s16)Sample;
  }
}

__attribute__((noinline)) static void InterruptHandler_Timer1_OverSampling(u32 Multiple,s16 *lbuf,s16 *rbuf,u32 Samples)
{
  static s16 slastl=0,slastr=0;
  
  switch(Multiple){
    case 1: {
    } break;
    case 2: {
      s16 *lsrc=&lbuf[Samples*1],*rsrc=&rbuf[Samples*1];
      s16 *ldst=lbuf,*rdst=rbuf;
      s16 lastl=slastl,lastr=slastr;
      u32 cnt;
      for(cnt=Samples;cnt!=0;cnt--){
        s16 sample;
        
        sample=*lsrc++;
        *ldst++=lastl;
        *ldst++=(lastl+sample)/2;
        lastl=sample;
        
        sample=*rsrc++;
        *rdst++=lastr;
        *rdst++=(lastr+sample)/2;
        lastr=sample;
      }
      slastl=lastl; slastr=lastr;
    } break;
    case 4: {
      s16 *lsrc=&lbuf[Samples*3],*rsrc=&rbuf[Samples*3];
      s16 *ldst=lbuf,*rdst=rbuf;
      s16 lastl=slastl,lastr=slastr;
      u32 cnt;
      for(cnt=Samples;cnt!=0;cnt--){
        s16 sample,half;
        
        sample=*lsrc++;
        half=(lastl+sample)/2;
        *ldst++=lastl;
        *ldst++=(lastl+half)/2;
        *ldst++=half;
        *ldst++=(half+sample)/2;
        lastl=sample;
        
        sample=*rsrc++;
        half=(lastr+sample)/2;
        *rdst++=lastr;
        *rdst++=(lastr+half)/2;
        *rdst++=half;
        *rdst++=(half+sample)/2;
        lastr=sample;
      }
      slastl=lastl; slastr=lastr;
    } break;
    default: {
    }
  }
}

static void InterruptHandler_Timer1_Null(void)
{
}

static void InterruptHandler_Timer1_PCM(void)
{
  InterruptHandler_Timer1_SetSwapChannel();
  
  s16 *lbuf,*rbuf;
  
  if(strpcmCursorFlag==0){
    lbuf=strpcmL0;
    rbuf=strpcmR0;
    }else{
    lbuf=strpcmL1;
    rbuf=strpcmR1;
  }
  
  s16 *lsrc=strpcmLBuf;
  s16 *rsrc=strpcmRBuf;
  
  u32 Samples=strpcmSamples;
  
  u32 Multiple=0;
  
  switch(strpcmFormat){
    case strpcmFormat_PCMx1: Multiple=1; break;
    case strpcmFormat_PCMx2: Multiple=2; break;
    case strpcmFormat_PCMx4: Multiple=4; break;
    default: Multiple=0; break;
  }
  
  if(IPCEX->strpcmWriteRequest!=0){
    MemSet16CPU(0,lbuf,Samples*2);
    MemSet16CPU(0,rbuf,Samples*2);
    }else{
    s16 *ldst,*rdst;
    
    ldst=&lbuf[Samples*(Multiple-1)];
    rdst=&rbuf[Samples*(Multiple-1)];
    
    if(strpcmChannels==2){
      MemCopy16CPU(lsrc,ldst,Samples*2);
      MemCopy16CPU(rsrc,rdst,Samples*2);
      }else{
      MemCopy16CPU(lsrc,ldst,Samples*2);
      MemCopy16CPU(lsrc,rdst,Samples*2);
    }
    
    IPCEX->IPCREQ=IPCREQ_NextSoundData;
    REG_IPC_SYNC|=IPC_SYNC_IRQ_REQUEST;
    IPCEX->strpcmWriteRequest=1;
    
    InterruptHandler_Timer1_ApplyVolume(ldst,rdst,Samples);
    
    InterruptHandler_Timer1_OverSampling(Multiple,lbuf,rbuf,Samples);
  }
}

// -----------------------------------

static void VblankHandler_MainThread(void) {
	uint16 but=0, x=0, y=0, z1=0, z2=0, batt=0, aux=0;
	int t1=0, t2=0;
	uint32 temp=0;
	uint8 ct[8];
	
	s32 xpx=0,ypx=0;

	// Read the touch screen
	but = REG_KEYXY;

  bool press=false;
  
  if((but & (1<<6))==0){
    press=true;
    xpx = ex_touchReadX();
    ypx = ex_touchReadY();
  }
  
  {
    bool ignore=false;
    static u32 ignorecount;
    static u32 tbufidx;
    static s32 tbufx[2],tbufy[2];
    static u32 tbufrep;
    static s32 tlastx,tlasty;
    if(press==true){
      if(ignorecount!=0){
        ignorecount--;
        ignore=true;
        }else{
        if(tbufidx<1){
          tbufx[tbufidx]=xpx;
          tbufy[tbufidx]=ypx;
          tbufidx++;
          ignore=true;
          }else{
          {
            s32 x=xpx,y=ypx;
            xpx=tbufx[0]; ypx=tbufy[0];
            tbufx[0]=tbufx[1]; tbufy[0]=tbufy[1];
            tbufx[1]=x; tbufy[1]=y;
          }
          if((xpx<2)||((256-2)<xpx)) ignore=true;
          if((ypx<2)||((192-2)<ypx)) ignore=true;
          if(ignore==false){
            if((tlastx!=0)&&(tlasty!=0)){
              s32 gx=abs(xpx-tlastx);
              s32 gy=abs(ypx-tlasty);
              if((gx<2)&&(gy<2)){
                if(tbufrep!=0) tbufrep--;
                ignore=true;
                }else{
                if(tbufrep<3) tbufrep++;
                s32 gap=16*tbufrep;
                if((gap<gx)||(gap<gy)) ignore=true;
              }
            }
            if(ignore==false){
              tlastx=xpx;
              tlasty=ypx;
            }
          }
        }
      }
      }else{
      if(ignorecount!=0) ignore=true;
      ignorecount=1;
      tbufidx=0;
      tbufrep=0;
      tlastx=0;
      tlasty=0;
    }
    
    if(ignore==false){
      TIPCEXTouchPad *pTouchPad=(TIPCEXTouchPad*)&IPCEX->IPCEXTouchPad;
      u32 wpos=pTouchPad->WritePos;
      pTouchPad->Press[wpos]=(u8)press;
      pTouchPad->X[wpos]=(u16)xpx;
      pTouchPad->Y[wpos]=(u16)ypx;
      pTouchPad->WritePos=(wpos+1)&IPCEXTouchPadMaxMask;
    }
  }

//	z1 = touchRead(TSC_MEASURE_Z1);
//	z2 = touchRead(TSC_MEASURE_Z2);

	
//	batt = touchRead(TSC_MEASURE_BATTERY);
//	aux  = touchRead(TSC_MEASURE_AUX);

	// Read the temperature
//	temp = touchReadTemperature(&t1, &t2);

	// Update the IPC struct
	IPC->buttons		= but;
//	IPC->touchX			= x;
//	IPC->touchY			= y;
//	IPC->touchXpx		= xpx;
//	IPC->touchYpx		= ypx;
//	IPC->touchZ1		= z1;
//	IPC->touchZ2		= z2;
//	IPC->battery		= batt;
//	IPC->aux			= aux;

	// Read the time
	if(IPCEX->RequestCurTime==true){
	  rtcGetTime((uint8 *)ct);
	  BCDToInteger((uint8 *)&(ct[1]), 7);
	  u32 i;
	  for(i=0; i<8; i++) {
	    IPCEX->curtime[i] = ct[i];
	  }
	  IPCEX->RequestCurTime=false;
	}

//	IPC->temperature = temp;
//	IPC->tdiode1 = t1;
//	IPC->tdiode2 = t2;
}

static bool VBlankApply;

//---------------------------------------------------------------------------------
static void VblankHandler(void) {
//---------------------------------------------------------------------------------
  VBlankApply=true;
  
  IPCEX->heartbeat++;
//  IPCEX->IPCREQ=IPCREQ_vsync;
//  REG_IPC_SYNC|=IPC_SYNC_IRQ_REQUEST;
}

// read firmware.
// reference hbfirmware.zip/firmware/arm7/source/settings.c

//typedef void(*call0)(void);
typedef void(*call3)(u32,void*,u32);

//size must be a multiple of 4
static inline void read_nvram(u32 src, void *dst, u32 size) {
	((call3)0x2437)(src,dst,size);
}

//read firmware settings
static inline void load_PersonalData() {
	u32 src, count0, count1;

	read_nvram(0x20, &src, 4);		//find settings area
	src=(src&0xffff)*8;

	read_nvram(src+0x70, &count0, 4);	//pick recent copy
	read_nvram(src+0x170, &count1, 4);
	if((u16)count0<(u16)count1){
		src+=0x100;
	}
	
	read_nvram(src, PersonalData, 0x80);
	if(swiCRC16(0xffff,PersonalData,0x70) != ((u16*)PersonalData)[0x72/2]){ 	//invalid / corrupt?
		read_nvram(src^0x100, PersonalData, 0x80);	//try the older copy
	}
}

#include "a7sleep.h"

#define PM_NDSLITE_ADR (4)
#define PM_NDSLITE_ISLITE BIT(6)
#define PM_NDSLITE_BRIGHTNESS(x) ((x & 0x03)<<0)
#define PM_NDSLITE_BRIGHTNESS_MASK (PM_NDSLITE_BRIGHTNESS(3))

static inline void main_InitNDSL(void)
{
  IPCEX->isNDSLite = ( (PM_GetRegister(PM_NDSLITE_ADR) & PM_NDSLITE_ISLITE) != 0) ? true : false;
  if(IPCEX->isNDSLite==false){
    IPCEX->DefaultBrightness=0;
    }else{
    u8 data;
    data=PM_GetRegister(PM_NDSLITE_ADR);
    data&=PM_NDSLITE_BRIGHTNESS_MASK;
    IPCEX->DefaultBrightness=data;
  }
  IPCEX->Brightness=0xff;
}

static inline void main_InitSoundDevice(void)
{
  powerON(POWER_SOUND);
  SOUND_CR = SOUND_ENABLE | SOUND_VOL(0x7F);
  
  swiChangeSoundBias(1,0x400);
  a7SetSoundAmplifier(true);
  
  IPC->soundData = 0;
}

__attribute__((noinline)) static void main_InitAll(void)
{
  REG_IME=0;
  REG_IE=0;
  REG_IF=REG_IF;
  
  // Clear DMA
  u32 i;
  for(i=0;i<0x30/4;i++){
    *((vu32*)(0x40000B0+i))=0;
  }
  
  rtcReset();
  
  IPCEX->RESET=RESET_NULL;
  
  a7lcd_select(PM_BACKLIGHT_TOP | PM_BACKLIGHT_BOTTOM);
  
  IPCEX->heartbeat=0;
  
  IPCEX->IPCEXTouchPad.ReadPos=0;
  IPCEX->IPCEXTouchPad.WritePos=0;
  
  IPCEX->strpcmControl=strpcmControl_NOP;
  
  IPCEX->IPCREQ=IPCREQ_NULL;
  
  IPCEX->RequestCurTime=false;
  
  IPCEX->PanelClosed=false;
  
  ex_touchReadXY_Init();
  
  // ݒ肪Ɠǂݍ߂Ă邩ēxmF邱ƁIcς_łB
  REG_SPICNT = SPI_ENABLE|SPI_CONTINUOUS|SPI_DEVICE_NVRAM;
  load_PersonalData();
  REG_SPICNT = 0;
  IPCEX->UserLanguage=PersonalData->_user_data.language;
  
  main_InitNDSL();
  
  main_InitSoundDevice();
  
  ex_touchReadXY_Init();
  
  irqInit();
  irqSet(IRQ_TIMER1,InterruptHandler_Timer1_Null);
  irqSet(IRQ_VBLANK, VblankHandler);
  irqEnable(IRQ_VBLANK);
  
  VBlankApply=false;
}

// -------------------------------------

#include "main_boot_gbarom.h"

__attribute__((noinline)) static void main_Proc_Reset(ERESET RESET)
{
  switch(RESET){
    case RESET_NULL: return; break;
    case RESET_MainMemory: boot_GBAROM(0); break;
  }
  
  while(1);
}

__attribute__((noinline)) static void main_Proc_Brightness(void)
{
  u8 data;
  
  data=PM_GetRegister(PM_NDSLITE_ADR);
  data&=~PM_NDSLITE_BRIGHTNESS_MASK;
  data|=PM_NDSLITE_BRIGHTNESS(IPCEX->Brightness);
  
  PM_SetRegister(PM_NDSLITE_ADR,data);
  
  IPCEX->Brightness=0xff;
}

__attribute__((noinline)) static void main_Proc_PanelClose(bool CurrentCloseFlag)
{
  if(CurrentCloseFlag==true){
    a7led(1);
    a7lcd_select(0);
    }else{
    a7led(0);
    a7lcd_select(PM_BACKLIGHT_BOTTOM | PM_BACKLIGHT_TOP);
  }
}

__attribute__((noinline)) static void main_Proc_strpcmControl(void)
{
  switch(IPCEX->strpcmControl){
    case strpcmControl_NOP: {
    } break;
    case strpcmControl_Play: {
      strpcmPlay();
      switch(strpcmFormat){
        case strpcmFormat_PCMx1: case strpcmFormat_PCMx2: case strpcmFormat_PCMx4: {
          irqSet(IRQ_TIMER1,InterruptHandler_Timer1_PCM);
        } break;
        default: irqSet(IRQ_TIMER1,InterruptHandler_Timer1_Null); break;
      }
    } break;
    case strpcmControl_Stop: {
      strpcmStop();
      irqSet(IRQ_TIMER1,InterruptHandler_Timer1_Null);
    }
    default: {
      strpcmStop();
      irqSet(IRQ_TIMER1,InterruptHandler_Timer1_Null);
    }
  }
  IPCEX->strpcmControl=strpcmControl_NOP;
}

//---------------------------------------------------------------------------------
int main(int argc, char ** argv) {
//---------------------------------------------------------------------------------
  
  main_InitAll();
  
  bool LastCloseFlag=false;
  
  while (1){
    if(VBlankApply==false){
      while(1){
        swiIntrWait(1,IRQ_VBLANK); // vblank
        if(VBlankApply==true) break;
      }
    }
    VBlankApply=false;
    VblankHandler_MainThread();
    
    if(IPCEX->Brightness!=0xff) main_Proc_Brightness();
    
    bool CurrentCloseFlag=(REG_KEYXY==0x00FF);
    
    if(LastCloseFlag!=CurrentCloseFlag){
      IPCEX->PanelClosed=CurrentCloseFlag;
      LastCloseFlag=CurrentCloseFlag;
      main_Proc_PanelClose(CurrentCloseFlag);
    }
    
    if(IPCEX->RESET!=RESET_NULL){
      main_Proc_Reset(IPCEX->RESET);
      while(1);
    }
    
    if(IPCEX->strpcmControl!=strpcmControl_NOP){
      REG_IME=0;
      main_Proc_strpcmControl();
      REG_IME=1;
    }
    
  }
}


