unit _def;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, INIFiles, GLDPNG, _PicTools;

var
  StartPath,ThemePath,BasePath:string;
  BGBM,FrameColBM,FrameAlphaBM:TBitmap;
  CoverBM:TBitmap;

type TThemeItem=record
  Filename,Title:string;
end;

var
  ThemeItemsCount:integer;
  ThemeItems:array of TThemeItem;

type TPos=record
  x,y:integer;
end;

type TCoverDataItem=record
  Title,Caption:TStringList;
  Pos:TPos;
  TitleFont,CaptionFont:TFont;
  TitleFontColor,CaptionFontColor:dword;
end;

type TCoverData=record
  ScrWidth,ScrHeight:integer;
  Name:string;
  isVertical:boolean;
  FrameColor:dword;
  ItemCount:integer;
  Item:array[0..8-1] of TCoverDataItem;
end;

var
  CoverData:TCoverData;

procedure InitCoverData;
procedure LoadTheme(fn:string);
procedure LoadCoverData;
procedure SaveTheme(fn:string);
function SaveCoverData:string;

function ExistsCoverData:boolean;

implementation

uses MainWin;

procedure InitCoverData;
var
  idx:integer;
  Font:TFont;
begin
  with CoverData do begin
    ScrWidth:=192;
    ScrHeight:=256;
    Name:='default';
    isVertical:=True;
    FrameColor:=$f0f0ff;
    ItemCount:=0;
    for idx:=0 to 8-1 do begin
      with Item[idx] do begin
        if Assigned(Title)=True then Title.Free;
        Title:=TStringList.Create;
        Title.Text:='^Cg'+inttostr(idx)+':';
        if Assigned(Caption)=True then Caption.Free;
        Caption:=TStringList.Create;
        Caption.Text:='Lv'+inttostr(idx);
        Font:=TFont.Create;
        TitleFont:=Font;
        TitleFont.Name:='Meiryo';
        TitleFont.Size:=11;
        TitleFontColor:=$000000;
        Font:=TFont.Create;
        CaptionFont:=Font;
        CaptionFont.Name:='Meiryo';
        CaptionFont.Size:=11;
        CaptionFontColor:=$000000;
      end;
    end;
  end;
end;

procedure LoadTheme(fn:string);
var
  inifn,pngfn:string;
  fini:TINIFile;
  Section:string;
  ItemName:string;
  idx:integer;
  png:TGLDPNG;
  w,h:integer;
begin
  fn:=ThemePath+ChangeFileExt(fn,'');
  inifn:=fn+'.ini';
  pngfn:=fn+'.png';

  if FileExists(inifn)=False then exit;
  if FileExists(pngfn)=False then exit;

  fini:=TINIFile.Create(inifn);

  with CoverData do begin
    Section:='Theme';
    Name:=fini.ReadString(Section,'Name',Name);
    isVertical:=fini.ReadBool(Section,'isVertical',isVertical);

    if isVertical=True then begin
      ScrWidth:=192;
      ScrHeight:=256;
      end else begin
      ScrWidth:=256;
      ScrHeight:=192;
    end;

    Section:='Item';
    ItemCount:=fini.ReadInteger(Section,'Count',ItemCount);
    for idx:=0 to 8-1 do begin
      ItemName:='Item'+inttostr(idx)+'_';
      with Item[idx].Pos do begin
        x:=fini.ReadInteger(Section,ItemName+'X',x);
        y:=fini.ReadInteger(Section,ItemName+'Y',y);
      end;
    end;
  end;

  fini.Free;

  w:=CoverData.ScrWidth;
  h:=CoverData.ScrHeight;

  MakeBlankBM(FrameColBM,w,h,pf24bit);
  MakeBlankBM(FrameAlphaBM,w,h,pf8bit);

  png:=TGLDPNG.Create;
  png.Image:=FrameColBM;
  png.LoadFromFile(pngfn);
  if png.AlphaBitmapAssignTo(FrameAlphaBM)=False then ShowMessage('can not found alpha channel.');
  png.Free;
  FrameColBM.PixelFormat:=pf24bit;
  FrameAlphaBM.PixelFormat:=pf8bit;
end;

procedure SaveTheme(fn:string);
var
  inifn,pngfn:string;
  fini:TINIFile;
  Section:string;
  ItemName:string;
  idx:integer;
  png:TGLDPNG;
begin
  fn:=ThemePath+ChangeFileExt(fn,'');
  inifn:=fn+'.ini';
  pngfn:=fn+'.png';

  fini:=TINIFile.Create(inifn);

  with CoverData do begin
    Section:='Theme';
    fini.WriteString(Section,'Name',Name);
    fini.WriteBool(Section,'isVertical',isVertical);

    Section:='Item';
    fini.WriteInteger(Section,'Count',ItemCount);
    for idx:=0 to ItemCount-1 do begin
      ItemName:='Item'+inttostr(idx)+'_';
      with Item[idx].Pos do begin
        fini.WriteInteger(Section,ItemName+'X',x);
        fini.WriteInteger(Section,ItemName+'Y',y);
      end;
    end;
  end;

  fini.Free;

  png:=TGLDPNG.Create;
  png.Image:=FrameColBM;
  png.AlphaChannel:=True;
  png.AlphaBitmap:=FrameAlphaBM;
  png.CompressLevel:=9;
  png.FilterType:=gpfJust;
  png.SaveToFile(pngfn);
  png.Free;
end;

procedure LoadCoverData;
var
  fn,inifn,bmpfn,bgpngfn,framepngfn:string;
  fini:TINIFile;
  Section:string;
  ItemName:string;
  idx:integer;
  tidx:integer;
  png:TGLDPNG;
begin
  fn:=BasePath+'_imgview_cover';
  inifn:=fn+'.ini';
  bgpngfn:=fn+'_bg.png';
  framepngfn:=fn+'_frame.png';

  fini:=TINIFile.Create(inifn);

  with CoverData do begin
    Section:='Theme';
    Name:=fini.ReadString(Section,'Name',Name);
    isVertical:=fini.ReadBool(Section,'isVertical',isVertical);

    if isVertical=True then begin
      ScrWidth:=192;
      ScrHeight:=256;
      end else begin
      ScrWidth:=256;
      ScrHeight:=192;
    end;
    
    Section:='Setting';
    Main.TextAlignLst.ItemIndex:=fini.ReadInteger(Section,'TextAlign',Main.TextAlignLst.ItemIndex);
    Main.FrameEnabledChk.Checked:=fini.ReadBool(Section,'FrameEnabled',Main.FrameEnabledChk.Checked);
    Main.FrameAlphaBar.Position:=fini.ReadInteger(Section,'FrameAlpha',Main.FrameAlphaBar.Position);
    FrameColor:=fini.ReadInteger(Section,'FrameColor',FrameColor);

    Section:='Item';
    ItemCount:=fini.ReadInteger(Section,'Count',ItemCount);
    for idx:=0 to ItemCount-1 do begin
      ItemName:='Item'+inttostr(idx)+'_';
      with Item[idx] do begin
        Title.Clear;
        for tidx:=0 to fini.ReadInteger(Section,ItemName+'TitleLineCount',0)-1 do begin
          Title.Add(fini.ReadString(Section,ItemName+'TitleLine'+inttostr(tidx),''));
        end;
        Caption.Clear;
        for tidx:=0 to fini.ReadInteger(Section,ItemName+'CaptionLineCount',0)-1 do begin
          Caption.Add(fini.ReadString(Section,ItemName+'CaptionLine'+inttostr(tidx),''));
        end;
        Pos.x:=fini.ReadInteger(Section,ItemName+'X',Pos.x);
        Pos.y:=fini.ReadInteger(Section,ItemName+'Y',Pos.y);
        TitleFont.Name:=fini.ReadString(Section,ItemName+'TitleFontName',TitleFont.Name);
        TitleFont.Size:=fini.ReadInteger(Section,ItemName+'TitleFontSize',TitleFont.Size);
        if fini.ReadBool(Section,ItemName+'TitleFontBold',False)=False then begin
          TitleFont.Style:=[];
          end else begin
          TitleFont.Style:=[fsBold];
        end;
        TitleFontColor:=fini.ReadInteger(Section,ItemName+'TitleFontColor',TitleFontColor);
        CaptionFont.Name:=fini.ReadString(Section,ItemName+'CaptionFontName',CaptionFont.Name);
        CaptionFont.Size:=fini.ReadInteger(Section,ItemName+'CaptionFontSize',CaptionFont.Size);
        if fini.ReadBool(Section,ItemName+'CaptionFontBold',False)=False then begin
          CaptionFont.Style:=[];
          end else begin
          CaptionFont.Style:=[fsBold];
        end;
        CaptionFontColor:=fini.ReadInteger(Section,ItemName+'CaptionFontColor',CaptionFontColor);
      end;
    end;
  end;

  fini.Free;

  png:=TGLDPNG.Create;
  png.Image:=BGBM;
  png.LoadFromFile(bgpngfn);
  png.Free;

  png:=TGLDPNG.Create;
  png.Image:=FrameColBM;
  png.AlphaBitmap:=FrameAlphaBM;
  png.LoadFromFile(framepngfn);
  png.Free;
end;

function SaveCoverData:string;
var
  fn,inifn,bmpfn,bgpngfn,framepngfn:string;
  fini:TINIFile;
  Section:string;
  ItemName:string;
  idx:integer;
  tidx:integer;
  png:TGLDPNG;
begin
  fn:=BasePath+'_imgview_cover';
  inifn:=fn+'.ini';
  bmpfn:=fn+'.bmp';
  bgpngfn:=fn+'_bg.png';
  framepngfn:=fn+'_frame.png';

  Result:=bmpfn;

  fini:=TINIFile.Create(inifn);

  with CoverData do begin
    Section:='Theme';
    fini.WriteString(Section,'Name',Name);
    fini.WriteBool(Section,'isVertical',isVertical);

    Section:='Setting';
    fini.WriteInteger(Section,'TextAlign',Main.TextAlignLst.ItemIndex);
    fini.WriteBool(Section,'FrameEnabled',Main.FrameEnabledChk.Checked);
    fini.WriteInteger(Section,'FrameAlpha',Main.FrameAlphaBar.Position);
    fini.WriteInteger(Section,'FrameColor',FrameColor);

    Section:='Item';
    fini.WriteInteger(Section,'Count',ItemCount);
    for idx:=0 to ItemCount-1 do begin
      ItemName:='Item'+inttostr(idx)+'_';
      with Item[idx] do begin
        fini.WriteInteger(Section,ItemName+'TitleLineCount',Title.Count);
        for tidx:=0 to Title.Count-1 do begin
          fini.WriteString(Section,ItemName+'TitleLine'+inttostr(tidx),Title[tidx]);
        end;
        fini.WriteInteger(Section,ItemName+'CaptionLineCount',Caption.Count);
        for tidx:=0 to Caption.Count-1 do begin
          fini.WriteString(Section,ItemName+'CaptionLine'+inttostr(tidx),Caption[tidx]);
        end;
        fini.WriteInteger(Section,ItemName+'X',Pos.x);
        fini.WriteInteger(Section,ItemName+'Y',Pos.y);
        fini.WriteString(Section,ItemName+'TitleFontName',TitleFont.Name);
        fini.WriteInteger(Section,ItemName+'TitleFontSize',TitleFont.Size);
        if fsBold in TitleFont.Style then begin
          fini.WriteBool(Section,ItemName+'TitleFontBold',True);
          end else begin
          fini.WriteBool(Section,ItemName+'TitleFontBold',False);
        end;
        fini.WriteInteger(Section,ItemName+'TitleFontColor',TitleFontColor);
        fini.WriteString(Section,ItemName+'CaptionFontName',CaptionFont.Name);
        fini.WriteInteger(Section,ItemName+'CaptionFontSize',CaptionFont.Size);
        if fsBold in CaptionFont.Style then begin
          fini.WriteBool(Section,ItemName+'CaptionFontBold',True);
          end else begin
          fini.WriteBool(Section,ItemName+'CaptionFontBold',False);
        end;
        fini.WriteInteger(Section,ItemName+'CaptionFontColor',CaptionFontColor);
      end;
    end;
  end;

  fini.Free;

  CoverBM.SaveToFile(bmpfn);
  
  png:=TGLDPNG.Create;
  png.Image:=BGBM;
  png.AlphaChannel:=False;
  png.CompressLevel:=9;
  png.FilterType:=gpfJust;
  png.SaveToFile(bgpngfn);
  png.Free;

  png:=TGLDPNG.Create;
  png.Image:=FrameColBM;
  png.AlphaChannel:=True;
  png.AlphaBitmap:=FrameAlphaBM;
  png.CompressLevel:=9;
  png.FilterType:=gpfJust;
  png.SaveToFile(framepngfn);
  png.Free;
end;

function ExistsCoverData:boolean;
var
  fn,inifn,framepngfn:string;
begin
  fn:=BasePath+'_imgview_cover';
  inifn:=fn+'.ini';
  framepngfn:=fn+'_frame.png';

  Result:=True;
  if FileExists(inifn)=False then Result:=False;
  if FileExists(framepngfn)=False then Result:=False;
end;

end.
