unit TextWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons;

type
  TTextEdit = class(TForm)
    Memo1: TMemo;
    Memo2: TMemo;
    Memo3: TMemo;
    Memo4: TMemo;
    Memo5: TMemo;
    Memo6: TMemo;
    Memo7: TMemo;
    Memo8: TMemo;
    BitBtn1: TBitBtn;
    procedure BitBtn1Click(Sender: TObject);
    procedure Memo1Change(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
    procedure ReloadText;
  end;

var
  TextEdit: TTextEdit;

implementation

{$R *.dfm}

uses _def, MainWin;

var
  MemoLst:array[0..4-1,0..2-1] of TMemo;

var
  ApplyFlag:boolean;

procedure TTextEdit.BitBtn1Click(Sender: TObject);
begin
  TextEdit.Close;
end;

procedure TTextEdit.ReloadText;
var
  idx:integer;
begin
  ApplyFlag:=False;

  MemoLst[0,0]:=Memo1;
  MemoLst[0,1]:=Memo2;
  MemoLst[1,0]:=Memo3;
  MemoLst[1,1]:=Memo4;
  MemoLst[2,0]:=Memo5;
  MemoLst[2,1]:=Memo6;
  MemoLst[3,0]:=Memo7;
  MemoLst[3,1]:=Memo8;

  for idx:=0 to 4-1 do begin
    MemoLst[idx,0].Tag:=(idx*2)+0;
    MemoLst[idx,0].Lines:=CoverData.Item[idx].Title;
    MemoLst[idx,1].Tag:=(idx*2)+1;
    MemoLst[idx,1].Lines:=CoverData.Item[idx].Caption;
  end;

  ApplyFlag:=True;
end;

procedure TTextEdit.Memo1Change(Sender: TObject);
var
  idx,num:integer;
begin
  if ApplyFlag=False then exit;

  idx:=(Sender as TMemo).Tag;
  num:=idx and 1;
  idx:=idx div 2;

  if num=0 then begin
    CoverData.Item[idx].Title.Text:=(Sender as TMemo).Lines.Text;
    end else begin
    CoverData.Item[idx].Caption.Text:=(Sender as TMemo).Lines.Text;
  end;

  Main.RefreshPreview;
end;

end.
