unit MainWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtDlgs, ExtCtrls, ComCtrls, inifiles, Menus,
  FileCtrl;

type
  TMain = class(TForm)
    OpenDlg: TOpenPictureDialog;
    Timer1: TTimer;
    PrevImg: TImage;
    GroupBox1: TGroupBox;
    FrameAlphaBar: TTrackBar;
    FrameColorImg: TImage;
    FontDlg: TFontDialog;
    GroupBox2: TGroupBox;
    TextTitleFontBtn: TButton;
    Label2: TLabel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    TextPosLbl: TLabel;
    TextTitleColorImg: TImage;
    MainMenu1: TMainMenu;
    MenuFile: TMenuItem;
    MenuLoadBG: TMenuItem;
    Label1: TLabel;
    ThemeLst: TComboBox;
    ThemeFileLst: TFileListBox;
    MenuAbout: TMenuItem;
    MenuFileExit: TMenuItem;
    SelTextLst: TComboBox;
    Label3: TLabel;
    TextCaptionColorImg: TImage;
    TextCaptionFontBtn: TButton;
    Label4: TLabel;
    MenuText: TMenuItem;
    MenuFrame: TMenuItem;
    OpenPngDlg: TOpenPictureDialog;
    MenuFrameLoad: TMenuItem;
    TextAlignLst: TComboBox;
    FrameEnabledChk: TCheckBox;
    MenuFileThemeSave: TMenuItem;
    N1: TMenuItem;
    MenuFileCoverSave: TMenuItem;
    N2: TMenuItem;
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FrameAlphaBarChange(Sender: TObject);
    procedure FrameColorImgClick(Sender: TObject);
    procedure TextFontBtnClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure TextColorImgClick(Sender: TObject);
    procedure MenuLoadBGClick(Sender: TObject);
    procedure ThemeLstChange(Sender: TObject);
    procedure MenuAboutClick(Sender: TObject);
    procedure MenuFileExitClick(Sender: TObject);
    procedure MenuTextClick(Sender: TObject);
    procedure CaptionFontBtnClick(Sender: TObject);
    procedure SelTextLstChange(Sender: TObject);
    procedure MenuFrameLoadClick(Sender: TObject);
    procedure TextAlignLstChange(Sender: TObject);
    procedure FrameEnabledChkClick(Sender: TObject);
    procedure MenuFileThemeSaveClick(Sender: TObject);
    procedure MenuFileCoverSaveClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private 錾 }
  public
    { Public 錾 }
    procedure RefreshParam;
    procedure RefreshPreview;
  end;

var
  Main: TMain;

implementation

uses LoadBMWin, GLDPNG,_PicTools, ColorPickWin, AboutWin, TextWin,_def;

{$R *.dfm}

const CRLF:string=char($0d)+char($0a);

procedure InitThemeLst;
var
  idx:integer;
  fini:TINIFile;
  fn:string;
  Section:string;
  Title:string;
  Name:string;
  isVertical:boolean;
begin
  Main.ThemeLst.Clear;
  
  Main.ThemeFileLst.Update;
  
  ThemeItemsCount:=Main.ThemeFileLst.Count;
  setlength(ThemeItems,ThemeItemsCount);

  for idx:=0 to ThemeItemsCount-1 do begin
    fn:=Main.ThemeFileLst.Items[idx];

    fini:=TINIFile.Create(ThemePath+fn);
    Section:='Theme';
    Name:=fini.ReadString(Section,'Name','Ήe[}');
    isVertical:=fini.ReadBool(Section,'isVertical',False);
    fini.Free;

    if isVertical=True then begin
      Title:=Name+' ()';
      end else begin
      Title:=Name+' ()';
    end;

    ThemeItems[idx].Filename:=fn;
    ThemeItems[idx].Title:=Title;
    Main.ThemeLst.Items.Add(Title);
  end;
end;

procedure TMain.FormCreate(Sender: TObject);
  procedure bm(var bm:TBitmap);
  begin
    MakeBlankBM(bm,256,256,pf24bit);
    bm.Canvas.Brush.Color:=$ffffff;
    bm.Canvas.Brush.Style:=bsSolid;
    bm.Canvas.FillRect(Rect(0,0,256,256));
  end;
begin
  Application.Title:='CoverMaker';
  Main.Caption:=Application.Title;

  StartPath:=ExtractFilePath(Application.ExeName);
  ThemePath:=StartPath;

  BGBM:=TBitmap.Create;
  bm(BGBM);
  FrameColBM:=TBitmap.Create;
  bm(FrameColBM);
  FrameAlphaBM:=TBitmap.Create;
  bm(FrameAlphaBM);
  CoverBM:=TBitmap.Create;
  bm(CoverBM);

  InitThemeLst;

  InitCoverData;
end;

procedure TMain.Timer1Timer(Sender: TObject);
var
  w,h:integer;
begin
  Timer1.Enabled:=False;

  if ParamCount=0 then begin
    ShowMessage('CoverMaker.exe͒P̂ŋNł܂B'+CRLF+CRLF+'CoverMaker.exe cannot be booted in the single.');
    Application.Terminate;
    exit;
    if OpenDlg.Execute=False then begin
      Application.Terminate;
      exit;
    end;
    BasePath:=ExtractFilePath(OpenDlg.FileName);
    end else begin
    BasePath:=ParamStr(1);
  end;

  if copy(BasePath,length(BasePath),1)<>'\' then BasePath:=BasePath+'\';

  if DirectoryExists(BasePath)=False then begin
    ShowMessage('݂ȂtH_łB');
    Application.Terminate;
    exit;
  end;

  ColorPick.Caption:=Application.Title+' FI';
  TextEdit.Caption:=Application.Title+' eLXgҏW';
  LoadBM.Caption:=Application.Title+' wi摜ǂݍ';

  Application.Title:=Application.Title+' '+BasePath;
  Main.Caption:=Application.Title;
  About.TagLbl.Caption:='ΏۃtH_F'+BasePath;

  if ExistsCoverData=True then begin
    LoadCoverData();
    end else begin
    LoadTheme('Theme_Simple_V.ini');
  end;

  TextEdit.ReloadText;

  w:=CoverData.ScrWidth;
  h:=CoverData.ScrHeight;

  MakeBlankBM(CoverBM,w,h,pf24bit);

  with PrevImg do begin
    Width:=w;
    Height:=h;
    MakeBlankImg(PrevImg,pf24bit);
    Main.ClientWidth:=Left+Width+8;
    Main.ClientHeight:=Top+256+8;
  end;

  RefreshParam;

  MenuTextClick(Sender);
  Application.ProcessMessages;
  Main.SetFocus;
end;

procedure TMain.RefreshParam;
var
  w,h:integer;
  idx:integer;
  procedure SetColor(var img:TImage;col:dword);
  begin
    w:=img.Width;
    h:=img.Height;
    with img.Canvas do begin
      Brush.Color:=$000000;
      Brush.Style:=bsSolid;
      FillRect(Rect(0,0,w,h));
      Brush.Color:=col;
      Brush.Style:=bsSolid;
      FillRect(Rect(1,1,w-1,h-1));
    end;
    img.Refresh;
  end;
begin
  idx:=SelTextLst.ItemIndex;
  
  SetColor(TextTitleColorImg,CoverData.Item[idx].TitleFontColor);
  SetColor(TextCaptionColorImg,CoverData.Item[idx].CaptionFontColor);
  SetColor(FrameColorImg,CoverData.FrameColor);

  TextPosLbl.Caption:=Format('(%d,%d)',[CoverData.Item[idx].Pos.x,CoverData.Item[idx].Pos.y]);
  RefreshPreview;
end;

procedure TMain.RefreshPreview;
var
  w,h:integer;
  procedure DrawFrame;
  var
    FrameAlpha:dword;
    x,y:integer;
    srcpb,dstpb,alphapb:PByteArray;
    alpha,ialpha:dword;
    fcr,fcg,fcb,fr,fg,fb:dword;
    r,g,b:dword;
  begin
    FrameAlpha:=FrameAlphaBar.Position;
    fcr:=(CoverData.FrameColor shr 0) and $ff;
    fcg:=(CoverData.FrameColor shr 8) and $ff;
    fcb:=(CoverData.FrameColor shr 16) and $ff;
    for y:=0 to h-1 do begin
      srcpb:=FrameColBM.ScanLine[y];
      dstpb:=CoverBM.ScanLine[y];
      alphapb:=FrameAlphaBM.ScanLine[y];
      for x:=0 to w-1 do begin
        alpha:=(($ff-dword(alphapb[x*1+0]))*FrameAlpha div $100);
        ialpha:=$ff-alpha;
        fb:=(srcpb[x*3+0]*fcb) div $100;
        fg:=(srcpb[x*3+1]*fcg) div $100;
        fr:=(srcpb[x*3+2]*fcr) div $100;
        b:=dstpb[x*3+0];
        g:=dstpb[x*3+1];
        r:=dstpb[x*3+2];
        dstpb[x*3+0]:=((fb*alpha) div $100)+((b*ialpha) div $100);
        dstpb[x*3+1]:=((fg*alpha) div $100)+((g*ialpha) div $100);
        dstpb[x*3+2]:=((fr*alpha) div $100)+((r*ialpha) div $100);
      end;
    end;
  end;
  procedure DrawText;
  var
    idx:integer;
    Pos:TPos;
    line:integer;
    liney:integer;
    TitleWidth:integer;
    ItemWidth:integer;
    str:string;
  begin
    TitleWidth:=0;
    for idx:=0 to CoverData.ItemCount-1 do begin
      CoverBM.Canvas.Font:=CoverData.Item[idx].TitleFont;
      CoverBM.Canvas.Font.Charset:=DEFAULT_CHARSET;
      CoverBM.Canvas.Font.Color:=CoverData.Item[idx].TitleFontColor;
      CoverBM.Canvas.Brush.Style:=bsClear;
      for line:=0 to CoverData.Item[idx].Title.Count-1 do begin
        str:=CoverData.Item[idx].Title[line];
        if TitleWidth<CoverBM.Canvas.TextWidth(str) then TitleWidth:=CoverBM.Canvas.TextWidth(str);
      end;
    end;
    for idx:=0 to CoverData.ItemCount-1 do begin
      Pos:=CoverData.Item[idx].Pos;

      CoverBM.Canvas.Font:=CoverData.Item[idx].TitleFont;
      CoverBM.Canvas.Font.Charset:=DEFAULT_CHARSET;
      CoverBM.Canvas.Font.Color:=CoverData.Item[idx].TitleFontColor;
      CoverBM.Canvas.Brush.Style:=bsClear;

      ItemWidth:=0;
      for line:=0 to CoverData.Item[idx].Title.Count-1 do begin
        str:=CoverData.Item[idx].Title[line];
        if ItemWidth<CoverBM.Canvas.TextWidth(str) then ItemWidth:=CoverBM.Canvas.TextWidth(str);
      end;

      if ItemWidth<>0 then begin
        liney:=Pos.y;
        for line:=0 to CoverData.Item[idx].Title.Count-1 do begin
          str:=CoverData.Item[idx].Title[line];
          if TextAlignLst.ItemIndex<>1 then begin
            CoverBM.Canvas.TextOut(Pos.x,liney,str);
            end else begin
            CoverBM.Canvas.TextOut(Pos.x+TitleWidth-CoverBM.Canvas.TextWidth(str),liney,str);
          end;
          inc(liney,CoverBM.Canvas.TextHeight(str));
        end;
      end;

      if TextAlignLst.ItemIndex=2 then begin
        inc(Pos.x,ItemWidth+4);
        end else begin
        inc(Pos.x,TitleWidth+4);
      end;

      CoverBM.Canvas.Font:=CoverData.Item[idx].CaptionFont;
      CoverBM.Canvas.Font.Charset:=DEFAULT_CHARSET;
      CoverBM.Canvas.Font.Color:=CoverData.Item[idx].CaptionFontColor;
      CoverBM.Canvas.Brush.Style:=bsClear;
      liney:=Pos.y;
      for line:=0 to CoverData.Item[idx].Caption.Count-1 do begin
        str:=CoverData.Item[idx].Caption[line];
        CoverBM.Canvas.TextOut(Pos.x,liney,str);
        inc(liney,CoverBM.Canvas.TextHeight(str));
      end;
    end;
  end;
begin
  w:=CoverData.ScrWidth;
  h:=CoverData.ScrHeight;

  MakeBlankBM(CoverBM,w,h,pf24bit);

  with BGBM do begin
    BitBlt(CoverBM.Canvas.Handle,0,0,w,h,Canvas.Handle,0,0,SRCCOPY);
  end;

  if FrameEnabledChk.Checked=True then DrawFrame;

  DrawText;

  BitBlt(PrevImg.Canvas.Handle,0,0,w,h,CoverBM.Canvas.Handle,0,0,SRCCOPY);
  PrevImg.Refresh;
end;

procedure TMain.FrameAlphaBarChange(Sender: TObject);
begin
  RefreshPreview;
end;

procedure TMain.FrameColorImgClick(Sender: TObject);
begin
  ColorPick.StartPick(CoverData.FrameColor);
  if ColorPick.ShowModal=mrOk then begin
    CoverData.FrameColor:=ColorPick.PickColor;
    RefreshParam;
  end;
end;

procedure TMain.TextColorImgClick(Sender: TObject);
var
  c:dword;
begin
  if (Sender as TImage).Tag=0 then begin
    c:=CoverData.Item[SelTextLst.ItemIndex].TitleFontColor;
    end else begin
    c:=CoverData.Item[SelTextLst.ItemIndex].CaptionFontColor;
  end;

  ColorPick.StartPick(c);
  if ColorPick.ShowModal=mrOk then begin
    c:=ColorPick.PickColor;
    if (Sender as TImage).Tag=0 then begin
      CoverData.Item[SelTextLst.ItemIndex].TitleFontColor:=c;
      end else begin
      CoverData.Item[SelTextLst.ItemIndex].CaptionFontColor:=c;
    end;
    RefreshParam;
  end;
end;

procedure TMain.TextFontBtnClick(Sender: TObject);
var
  srcf:TFont;
begin
  if (Sender as TButton).Tag=0 then begin
    srcf:=CoverData.Item[SelTextLst.ItemIndex].TitleFont;
    end else begin
    srcf:=CoverData.Item[SelTextLst.ItemIndex].CaptionFont;
  end;

  FontDlg.Font.Name:=srcf.Name;
  FontDlg.Font.Size:=srcf.Size;
  FontDlg.Font.Style:=srcf.Style;
  FontDlg.Font.Charset:=DEFAULT_CHARSET;

  if FontDlg.Execute=True then begin
    srcf.Name:=FontDlg.Font.Name;
    srcf.Size:=FontDlg.Font.Size;
    if fsBold in FontDlg.Font.Style then begin
      srcf.Style:=[fsBold];
      end else begin
      srcf.Style:=[];
    end;
    RefreshPreview;
  end;
end;

procedure TMain.CaptionFontBtnClick(Sender: TObject);
begin
  FontDlg.Font:=CoverData.Item[SelTextLst.ItemIndex].CaptionFont;
  FontDlg.Font.Charset:=DEFAULT_CHARSET;

  if FontDlg.Execute=True then begin
    FontDlg.Font.Charset:=DEFAULT_CHARSET;
    if FontDlg.Font.Style<>[fsBold] then begin
      FontDlg.Font.Style:=[];
    end;
    CoverData.Item[SelTextLst.ItemIndex].CaptionFont:=FontDlg.Font;
    RefreshPreview;
  end;
end;

procedure TMain.Button1Click(Sender: TObject);
begin
  dec(CoverData.Item[SelTextLst.ItemIndex].Pos.y);
  RefreshParam;
end;

procedure TMain.Button2Click(Sender: TObject);
begin
  inc(CoverData.Item[SelTextLst.ItemIndex].Pos.y);
  RefreshParam;
end;

procedure TMain.Button3Click(Sender: TObject);
begin
  dec(CoverData.Item[SelTextLst.ItemIndex].Pos.x);
  RefreshParam;
end;

procedure TMain.Button4Click(Sender: TObject);
begin
  inc(CoverData.Item[SelTextLst.ItemIndex].Pos.x);
  RefreshParam;
end;

procedure TMain.MenuLoadBGClick(Sender: TObject);
begin
  OpenDlg.Title:='wi摜t@C̓ǂݍ...';
  OpenDlg.InitialDir:=BasePath;

  if OpenDlg.Execute=True then begin
    LoadBM.Startup(OpenDlg.FileName,CoverData.ScrWidth,CoverData.ScrHeight);
    if LoadBM.ShowModal=mrOk then begin
      BitBlt(BGBM.Canvas.Handle,0,0,LoadBM.dstbm.Width,LoadBM.dstbm.Height,LoadBM.dstbm.Canvas.Handle,0,0,SRCCOPY);
      RefreshPreview;
    end;
  end;
end;

procedure TMain.ThemeLstChange(Sender: TObject);
var
  w,h:integer;
begin
  LoadTheme(ThemeItems[ThemeLst.ItemIndex].Filename);

  w:=CoverData.ScrWidth;
  h:=CoverData.ScrHeight;

  MakeBlankBM(CoverBM,w,h,pf24bit);

  with PrevImg do begin
    Width:=w;
    Height:=h;
    MakeBlankImg(PrevImg,pf24bit);
    Main.ClientWidth:=Left+Width+8;
    Main.ClientHeight:=Top+256+8;
  end;

  RefreshParam;
end;

procedure TMain.MenuAboutClick(Sender: TObject);
begin
  About.ShowModal;
end;

procedure TMain.MenuFileExitClick(Sender: TObject);
begin
  Main.Close;
end;

procedure TMain.MenuTextClick(Sender: TObject);
begin
  TextEdit.Hide;
  with Main do begin
    TextEdit.Top:=Top+Height;
    TextEdit.Left:=Left;
  end;
  TextEdit.Show;
end;

procedure TMain.SelTextLstChange(Sender: TObject);
begin
  RefreshParam;
end;

procedure TMain.MenuFrameLoadClick(Sender: TObject);
var
  png:TGLDPNG;
  bm:TBitmap;
begin
  OpenPngDlg.Title:=format('32bitAt@`lt(%dx%d)sNZPNGt@Ĉݗp\łB',[CoverData.ScrWidth,CoverData.ScrHeight]);
  OpenPngDlg.InitialDir:=BasePath;

  if OpenPngDlg.Execute=True then begin
    bm:=TBitmap.Create;
    png:=TGLDPNG.Create;
    png.Image:=bm;
    png.LoadFromFile(OpenPngDlg.FileName);
    if png.AlphaChannel=False then begin
      ShowMessage('At@`l܂B');
      end else begin
      if (png.Image.Width<>CoverData.ScrWidth) or (png.Image.Height<>CoverData.ScrHeight) then begin
        ShowMessage('TCYႢ܂B');
        end else begin
        BitBlt(FrameColBM.Canvas.Handle,0,0,bm.Width,bm.Height,bm.Canvas.Handle,0,0,SRCCOPY);
        if png.AlphaBitmapAssignTo(FrameAlphaBM)=False then ShowMessage('At@`ltH[}bgُłB');
      end;
    end;
    png.Free;
    bm.Free;
    FrameColBM.PixelFormat:=pf24bit;
    FrameAlphaBM.PixelFormat:=pf8bit;
    RefreshPreview;
  end;
end;

procedure TMain.TextAlignLstChange(Sender: TObject);
begin
  RefreshPreview;
end;

procedure TMain.FrameEnabledChkClick(Sender: TObject);
begin
  RefreshPreview;
end;

procedure TMain.MenuFileThemeSaveClick(Sender: TObject);
var
  str:string;
  idx:integer;
  pos:integer;
  name:string;
  inifn:string;
begin
  str:='';
  if InputQuery('e[}ۑ','ۑe[}͂ĉB',str)=False then exit;
  if str='' then exit;

  for idx:=0 to ThemeLst.Items.Count-1 do begin
    name:=ThemeLst.Items[idx];
    pos:=ansipos(' (',name);
    if pos<>0 then begin
      name:=copy(name,1,pos-1);
      if str=name then begin
        ShowMessage('e[}݂̂ŃLZ܂B');
        exit;
      end;
    end;
  end;

  CoverData.Name:=str;
  inifn:='Theme_'+str+'.ini';
  SaveTheme(inifn);

  InitThemeLst;

  for idx:=0 to ThemeLst.Items.Count-1 do begin
    name:=ThemeLst.Items[idx];
    pos:=ansipos(' (',name);
    if pos<>0 then begin
      name:=copy(name,1,pos-1);
      if str=name then ThemeLst.ItemIndex:=idx;
    end;
  end;

  ShowMessage('[U[`e[}ۑ܂B'+CRLF+CRLF+'e[}F'+str+CRLF+'t@CF'+inifn+'/.png');
end;

procedure TMain.MenuFileCoverSaveClick(Sender: TObject);
var
  fn:string;
begin
  fn:=SaveCoverData;
  ShowMessage('Jo[摜['+fn+']ۑ܂B'+CRLF+CRLF+'TCYł΁A摜ҏW\tgȂǂŎRɕςĂč\܂B');
end;

procedure TMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if MessageDlg('IOɃJo[摜ۑ܂H',mtConfirmation,[mbYes,mbNo],0)=mrYes then MenuFileCoverSaveClick(nil);
end;

end.
