unit LoadBMWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, ComCtrls, StdCtrls, ExtCtrls,_PicTools;

type
  TLoadBM = class(TForm)
    PrvImg: TImage;
    ZoomGrp: TGroupBox;
    ZoomWidthBtn: TButton;
    ZoomHeightBtn: TButton;
    Zoom100Btn: TButton;
    ZoomManBtn: TButton;
    GroupBox2: TGroupBox;
    PosLbl: TLabel;
    Zoom50Btn: TButton;
    OkBtn: TBitBtn;
    BitBtn3: TBitBtn;
    PosInitBtn: TButton;
    ReduceTimer: TTimer;
    TileModeChk: TCheckBox;
    PosUpBtn: TButton;
    PosRightBtn: TButton;
    PosLeftBtn: TButton;
    PosDownBtn: TButton;
    Zoom200Btn: TButton;
    Zoom150Btn: TButton;
    AlphaBar: TTrackBar;
    BGColorImg: TImage;
    procedure FormCreate(Sender: TObject);
    procedure ZoomWidthBtnClick(Sender: TObject);
    procedure ZoomHeightBtnClick(Sender: TObject);
    procedure Zoom100BtnClick(Sender: TObject);
    procedure Zoom50BtnClick(Sender: TObject);
    procedure PosInitBtnClick(Sender: TObject);
    procedure PrvImgMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure PrvImgMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure PrvImgMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ZoomManBtnClick(Sender: TObject);
    procedure OkBtnClick(Sender: TObject);
    procedure TileModeChkClick(Sender: TObject);
    procedure PosUpBtnClick(Sender: TObject);
    procedure PosDownBtnClick(Sender: TObject);
    procedure PosLeftBtnClick(Sender: TObject);
    procedure PosRightBtnClick(Sender: TObject);
    procedure Zoom200BtnClick(Sender: TObject);
    procedure Zoom150BtnClick(Sender: TObject);
    procedure BGColorImgClick(Sender: TObject);
    procedure AlphaBarChange(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
    srcbm,dstbm:TBitmap;
    ZoomSize:double;
    PosX,PosY:integer;
    BGColor:dword;
    procedure Startup(Filename:string;w,h:integer);
    procedure RefreshParam;
    procedure RefreshBM;
  end;

var
  LoadBM: TLoadBM;

implementation

{$R *.dfm}

uses _loadimage, ColorPickWin;

procedure TLoadBM.FormCreate(Sender: TObject);
begin
  ZoomSize:=1;
  PosX:=0;
  PosY:=0;

  srcbm:=TBitmap.Create;
  dstbm:=TBitmap.Create;

  BGColor:=$ffffff;

  MakeBlankImg(BGColorImg,pf24bit);
end;

procedure TLoadBM.Startup(Filename:string;w,h:integer);
begin
  PrvImg.Width:=w;
  PrvImg.Height:=h;
  MakeBlankImg(PrvImg,pf24bit);

  LoadImage_LoadFromFile(srcbm,Filename,False);

  MakeBlankBM(dstbm,w,h,pf24bit);

  RefreshParam;
end;

procedure TLoadBM.RefreshParam;
var
  w,h:integer;
begin
  ZoomGrp.Caption:=format('gk (g嗦 %7.3f%%)',[ZoomSize*100]);
  PosLbl.Caption:=format('ړ=(%d,%d)',[PosX,PosY]);

  w:=BGColorImg.Width;
  h:=BGColorImg.Height;
  with BGColorImg.Canvas do begin
    Brush.Color:=$000000;
    Brush.Style:=bsSolid;
    FillRect(Rect(0,0,w,h));
    Brush.Color:=BGColor;
    Brush.Style:=bsSolid;
    FillRect(Rect(1,1,w-1,h-1));
  end;
  BGColorImg.Refresh;

  RefreshBM;
end;

procedure TLoadBM.RefreshBM;
var
  sx,sy:integer;
  dx,dy:integer;
  px,py:integer;
  tsx,tsy,tex,tey:integer;
  tx,ty:integer;
  w,h:integer;
  tmpbm:TBitmap;
  procedure ProcAlpha;
  var
    pb:PByteArray;
    x,y:integer;
    a,ia:dword;
    r,g,b:dword;
    ir,ig,ib:dword;
  begin
    a:=AlphaBar.Position;
    ia:=$ff-a;
    ib:=(BGColor shr 16) and $ff;
    ig:=(BGColor shr 8) and $ff;
    ir:=(BGColor shr 0) and $ff;
    for y:=0 to tmpbm.Height-1 do begin
      pb:=tmpbm.ScanLine[y];
      for x:=0 to tmpbm.Width-1 do begin
        b:=pb[x*3+0];
        g:=pb[x*3+1];
        r:=pb[x*3+2];
        b:=((b*a) div $100)+((ib*ia) div $100);
        g:=((g*a) div $100)+((ig*ia) div $100);
        r:=((r*a) div $100)+((ir*ia) div $100);
        pb[x*3+0]:=b;
        pb[x*3+1]:=g;
        pb[x*3+2]:=r;
      end;
    end;
  end;
begin
  w:=dstbm.Width;
  h:=dstbm.Height;

  sx:=srcbm.Width;
  sy:=srcbm.Height;
  dx:=trunc(sx*ZoomSize);
  dy:=trunc(sy*ZoomSize);
  px:=PosX mod dx;
  py:=PosY mod dy;

  if dx<=0 then dx:=1;
  if dy<=0 then dy:=1;

  if TileModeChk.Checked=False then begin
    tsx:=0;
    tex:=1;
    tsy:=0;
    tey:=1;
    end else begin
    if px<=0 then begin
      tsx:=0;
      end else begin
      tsx:=-(trunc(px/dx)+1);
    end;
    if py<=0 then begin
      tsy:=0;
      end else begin
      tsy:=-(trunc(py/dy)+1);
    end;
    tex:=trunc((-px+w)/dx)+1;
    tey:=trunc((-py+h)/dy)+1;
  end;

  tmpbm:=TBitmap.Create;
  MakeBlankBM(tmpbm,w,h,pf24bit);

  tmpbm.Canvas.Brush.Color:=$000000;
  tmpbm.Canvas.FillRect(Rect(0,0,w,h));

  SetStretchBltMode(srcbm.Canvas.Handle,HALFTONE);
  SetStretchBltMode(tmpbm.Canvas.Handle,HALFTONE);
  for ty:=tsy to tey-1 do begin
    for tx:=tsx to tex-1 do begin
      StretchBlt(tmpbm.Canvas.Handle,px+(dx*tx),py+(dy*ty),dx,dy,srcbm.Canvas.Handle,0,0,sx,sy,SRCCOPY);
    end;
  end;

  ProcAlpha;

  MakeBlankBM(dstbm,w,h,pf24bit);
  BitBlt(dstbm.Canvas.Handle,0,0,w,h,tmpbm.Canvas.Handle,0,0,SRCCOPY);

  tmpbm.Free;

  PrvImg.Picture.Bitmap.Assign(dstbm);
  PrvImg.Refresh;

  ReduceTimer.Enabled:=True;
end;

procedure TLoadBM.ZoomWidthBtnClick(Sender: TObject);
begin
  ZoomSize:=dstbm.Width/srcbm.Width;
  RefreshParam;
end;

procedure TLoadBM.ZoomHeightBtnClick(Sender: TObject);
begin
  ZoomSize:=dstbm.Height/srcbm.Height;
  RefreshParam;
end;

procedure TLoadBM.Zoom50BtnClick(Sender: TObject);
begin
  ZoomSize:=0.5;
  RefreshParam;
end;

procedure TLoadBM.Zoom100BtnClick(Sender: TObject);
begin
  ZoomSize:=1;
  RefreshParam;
end;

procedure TLoadBM.Zoom150BtnClick(Sender: TObject);
begin
  ZoomSize:=1.5;
  RefreshParam;
end;

procedure TLoadBM.Zoom200BtnClick(Sender: TObject);
begin
  ZoomSize:=2;
  RefreshParam;
end;

procedure TLoadBM.ZoomManBtnClick(Sender: TObject);
var
  str:string;
begin
  str:=format('%3.10f',[ZoomSize*100]);

  str:=InputBox('g嗦͂ĂB','',str);

  ZoomSize:=strtofloatdef(str,ZoomSize*100)/100;
  RefreshParam;
end;

procedure TLoadBM.PosInitBtnClick(Sender: TObject);
begin
  PosX:=0;
  PosY:=0;
  RefreshParam;
end;

var
  mf:boolean;
  mx,my:integer;

procedure TLoadBM.PrvImgMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if Button=mbLeft then mf:=True;

  mx:=X;
  my:=Y;
end;

procedure TLoadBM.PrvImgMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if mf=True then begin
    PosX:=PosX+(X-mx);
    PosY:=PosY+(Y-my);
    RefreshParam;
  end;

  mx:=X;
  my:=Y;
end;

procedure TLoadBM.PrvImgMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  mf:=False;
end;

procedure TLoadBM.OkBtnClick(Sender: TObject);
begin
  RefreshBM;
end;

procedure TLoadBM.TileModeChkClick(Sender: TObject);
begin
  RefreshBM;
end;

procedure TLoadBM.PosUpBtnClick(Sender: TObject);
begin
  PosY:=PosY-1;
  RefreshParam;
end;

procedure TLoadBM.PosDownBtnClick(Sender: TObject);
begin
  PosY:=PosY+1;
  RefreshParam;
end;

procedure TLoadBM.PosLeftBtnClick(Sender: TObject);
begin
  PosX:=PosX-1;
  RefreshParam;
end;

procedure TLoadBM.PosRightBtnClick(Sender: TObject);
begin
  PosX:=PosX+1;
  RefreshParam;
end;

procedure TLoadBM.BGColorImgClick(Sender: TObject);
begin
  ColorPick.StartPick(BGColor);
  if ColorPick.ShowModal=mrOk then begin
    BGColor:=ColorPick.PickColor;
    RefreshParam;
  end;
end;

procedure TLoadBM.AlphaBarChange(Sender: TObject);
begin
  RefreshBM;
end;

end.
