
static const char *pSysMsg;
static u32 SysMsg_Timeout;

static void SysMsg_Init(void)
{
  pSysMsg=NULL;
  SysMsg_Timeout=0;
}

void SysMsg_Set(const char *pstr)
{
  pSysMsg=pstr;
  SysMsg_Timeout=3*60;
  RequestRedrawMainFlag=true;
  _consolePrintf("SysMsg_Set: [%s]\n",pstr);
}

static void SysMsg_Clear(void)
{
  pSysMsg=NULL;
  SysMsg_Timeout=0;
  RequestRedrawMainFlag=true;
}

static void SysMsg_VSyncUpdate(void)
{
  if(SysMsg_Timeout==0) return;
  SysMsg_Timeout--;
  if(SysMsg_Timeout!=0) return;
  
  SysMsg_Clear();
}

static bool SysMsg_Draw(CglCanvas *pcan)
{
  const char *pstr=pSysMsg;
  if(pstr==NULL) return(false);
  
  u32 y=0;
  
  pcan->SetColor(RGB15(31,31,31)|BIT15);
  pcan->FillBox(0,y,ScreenWidth,glCanvasTextHeight+2);
  
  pcan->SetFontTextColor(RGB15(0,0,0)|BIT15);
  pcan->TextOutA(2,1+y,pstr);
  y+=glCanvasTextHeight+2;
  
  pcan->SetColor(RGB15(0,0,0)|BIT15);
  pcan->DrawLine(0,y,ScreenWidth,y);
  y++;
  
  return(true);
}

