
typedef struct {
  u32 DicIndex;
  u8 DicItem_Flags;
  u8 Dummy;
  s16 Rate;
  u32 DstStrOffset;
  const u8 *pOkuriBinStr;
} TFindResult;

static u32 FindResultsCount;
static const u32 FindResultsMaxCount=4*1024;
static TFindResult *pFindResults;
static const UnicodeChar *pFindResultNumStr;

typedef struct {
  u32 TopIndex;
  u32 SelectIndex;
  u32 ItemsCountX,ItemsCountY;
} TResultsWindow;

static TResultsWindow ResultsWindow;

static void DicResults_Init(void)
{
  FindResultsCount=0;
  pFindResults=NULL;
  pFindResultNumStr=NULL;
  
  TResultsWindow *prw=&ResultsWindow;
  prw->TopIndex=0;
  prw->SelectIndex=(u32)-1;
  prw->ItemsCountX=5;
  prw->ItemsCountY=4;
}

static void DicResults_Free(void)
{
  if(pFindResults!=NULL){
    for(u32 idx=0;idx<FindResultsCount;idx++){
      TFindResult *pfr=&pFindResults[idx];
      if(pfr->pOkuriBinStr!=NULL){
        safefree(&MM_SKKDic,pfr->pOkuriBinStr); pfr->pOkuriBinStr=NULL;
      }
    }
    safefree(&MM_SKKDic,pFindResults); pFindResults=NULL;
  }
  FindResultsCount=0;
  
  DicResults_Init();
}

static void DicResults_Add(
  const u32 DicIndex,const u8 DicItem_Flags,const s32 Rate,
  const u32 DstStrOffset,
  const u8 *pOkuriBinStr,const u32 OkuriBinStrLen
)
{
//  _consolePrintf("Match(%d): DI=%d, Rate=%d.\n",FindResultsCount,DicIndex,Rate);
  
  if(FindResultsMaxCount<=FindResultsCount) return;
  
  TFindResult *pfr=&pFindResults[FindResultsCount];
  pfr->DicIndex=DicIndex;
  pfr->DicItem_Flags=DicItem_Flags;
  pfr->Dummy=0;
  pfr->Rate=Rate;
  pfr->DstStrOffset=DstStrOffset;
  if((pOkuriBinStr==NULL)||(pOkuriBinStr[0]==0)||(OkuriBinStrLen==0)){
    pfr->pOkuriBinStr=NULL;
    }else{
    u8 *ptmp=(u8*)safemalloc(&MM_SKKDic,OkuriBinStrLen+1);
    for(u32 idx=0;idx<OkuriBinStrLen;idx++){
      ptmp[idx]=pOkuriBinStr[idx];
    }
    ptmp[OkuriBinStrLen]=0;
    pfr->pOkuriBinStr=ptmp;
  }
  FindResultsCount++;
}

static void DicResults_SetWindowParams(void)
{
  TResultsWindow *prw=&ResultsWindow;
  prw->TopIndex=0;
  prw->SelectIndex=(u32)-1;
  prw->ItemsCountX=5;
  prw->ItemsCountY=4;
  
  if((4*4)<=FindResultsCount){
    prw->ItemsCountX=5;
    }else{
    if((4*3)<=FindResultsCount){
      prw->ItemsCountX=4;
      }else{
      if((4*2)<=FindResultsCount){
        prw->ItemsCountX=3;
        }else{
        if((4*1)<=FindResultsCount){
          prw->ItemsCountX=2;
          }else{
          prw->ItemsCountX=1;
        }
      }
    }
  }
  
}
