
static const UnicodeChar* DicResults_GetDstStr(u32 ResultIndex)
{
  TFindResult *pfr=&pFindResults[ResultIndex];
  
  static UnicodeChar res[FindMaxLen+1];
  UnicodeChar *pres=res;
  
  Unicode_Copy(pres,pFindResultNumStr);
  pres+=Unicode_GetLength(pres);
  
  u32 DstLen=pfr->DicItem_Flags&DicItem_Flags_DstLenMask;
  Unicode_Copy(pres,DicSystem_GetDstStr(pfr->DstStrOffset,DstLen));
  pres+=DstLen;
  
  const u8 *pobs=pfr->pOkuriBinStr;
  if(pobs!=NULL){
    while(1){
      u8 bc=*pobs++;
      if(bc==0) break;
      *pres++=WideToBinTable[bc];
    }
  }
  *pres=0;
  
  return(res);
}

static bool DicResults_isSelected(void)
{
  TResultsWindow *prw=&ResultsWindow;
  
  if(FindResultsCount==0) return(false);
  if(prw->SelectIndex==(u32)-1) return(false);
  
  return(true);
}

static const UnicodeChar* DicResults_GetSelectedText(void)
{
  if(DicResults_isSelected()==false) return(DicFind_InputStr);
  
  TResultsWindow *prw=&ResultsWindow;
  
  return(DicResults_GetDstStr(prw->SelectIndex));
}

static void DicResults_Draw(CglCanvas *pcan)
{
  if(DicFind_InputStr[0]==0) return;
  if(FindResultsCount==0) return;
  
  TResultsWindow *prw=&ResultsWindow;
  
  if((prw->ItemsCountX==0)||(prw->ItemsCountY==0)) StopFatalError(0,"Illigal window size. (%d,%d)",prw->ItemsCountX,prw->ItemsCountY);
  
  const u32 th=glCanvasTextHeight;
  const u32 pw=ScreenWidth/prw->ItemsCountX;
  const u32 ph=th+2;
  
  u16 InfoTextColor=RGB15(16,16,16)|BIT15;
  u16 FrameOutColor=RGB15(16,16,16)|BIT15;
  u16 FrameInColor=RGB15(24,24,24)|BIT15;
  u16 BGColor=RGB15(29,29,30)|BIT15;
  u16 SelectBGColor=RGB15(0,0,16)|BIT15;
  u16 TextColor=RGB15(0,0,0)|BIT15;
  u16 TextHighColor=RGB15(31,31,31)|BIT15;
  
  u32 WindowTop=ScreenHeight-(ph*4)-1-ph-1;
  
  {
    char str[64];
    if(prw->SelectIndex==(u32)-1){
      snprintf(str,64,"--- / %d",FindResultsCount);
      }else{
      snprintf(str,64,"%d / %d",1+prw->SelectIndex,FindResultsCount);
    }
    const u32 tw=pcan->GetTextWidthA(str)+2+2;
    const u32 tx=ScreenWidth-tw;
    pcan->SetColor(BGColor);
    pcan->FillBox(tx,WindowTop,ScreenWidth-tx,th+2);
    pcan->SetColor(FrameOutColor);
    pcan->DrawBox(tx,WindowTop,ScreenWidth-tx,th+2);
    WindowTop++;
    pcan->SetFontTextColor(InfoTextColor);
    pcan->TextOutA(tx+2,WindowTop+1,str);
    WindowTop+=th;
  }
  
  pcan->SetColor(FrameOutColor);
  pcan->DrawLine(0,WindowTop,ScreenWidth,WindowTop);
  WindowTop++;
  
  pcan->SetColor(BGColor);
  pcan->FillBox(0,WindowTop,ScreenWidth,ScreenHeight-WindowTop);
  pSkinResultBG->BitBlt(pcan,0,WindowTop,ScreenWidth,ScreenHeight-WindowTop,0,0,false);
  
  pcan->SetColor(FrameInColor);
  for(u32 x=0;x<prw->ItemsCountX-1;x++){
    const u32 px=pw*(x+1);
    pcan->DrawLine(px-1,WindowTop,px-1,ScreenHeight);
  }
  for(u32 y=0;y<prw->ItemsCountY-1;y++){
    const u32 py=WindowTop+(ph*(y+1));
    pcan->DrawLine(0,py-1,ScreenWidth,py-1);
  }
  
  UnicodeChar DstStr_TanKanjiBuf[6]={0,/* */ 0x20,/*(*/ 0x28,/*P*/ 0x5358,/*)*/ 0x29,0};
  
  for(u32 idx=0;idx<prw->ItemsCountY*prw->ItemsCountX;idx++){
    u32 ridx=prw->TopIndex+idx;
    if(ridx<FindResultsCount){
      const UnicodeChar *pDstStr=DicResults_GetDstStr(ridx);
      TFindResult *pfr=&pFindResults[ridx];
      if((pfr->DicItem_Flags&DicItem_Flags_isTanKanji)!=0){
        DstStr_TanKanjiBuf[0]=pDstStr[0];
        pDstStr=DstStr_TanKanjiBuf;
      }
      const u32 tw=pcan->GetTextWidthW(pDstStr);
      const u32 px=pw*(idx/prw->ItemsCountY);
      const u32 py=WindowTop+ph*(idx%prw->ItemsCountY);
      if(prw->SelectIndex==ridx){
        OnSkin_FillBox50per(pcan,px,py,pw,ph,SelectBGColor);
        pcan->SetFontTextColor(TextHighColor);
        }else{
        pcan->SetFontTextColor(TextColor);
      }
      pcan->TextOutW(px+2,py+1,pDstStr);
    }
  }
}

static bool DicResults_Fix(bool UseDicFindBackup)
{
  if(DicFind_InputStr[0]==0) return(false);
  if(FindResultsCount==0) return(false);
  
  TResultsWindow *prw=&ResultsWindow;
  if(prw->SelectIndex==(u32)-1) return(false);
  
  if(DicResults_isSelected()==true){
    TResultsWindow *prw=&ResultsWindow;
    TFindResult *pfr=&pFindResults[prw->SelectIndex];
    DicUser_RegistSelectedItem(pfr->DicIndex,pfr->pOkuriBinStr);
  }
  
  const UnicodeChar *pstr=DicResults_GetSelectedText();
  if(UseDicFindBackup==true) DicFind_Backup_Set(Unicode_GetLength(pstr));
  TextEdit_Add(pstr);
  
  DicFind_Clear();
  
  DicResults_Free();
  
  return(true);
}

static bool DicResults_MoveCursor(u32 keys)
{
  if(FindResultsCount==0) return(false);
  
  TResultsWindow *prw=&ResultsWindow;
  
  s32 icx=prw->ItemsCountX;
  s32 icy=prw->ItemsCountY;
  s32 ix=prw->SelectIndex/icy;
  s32 iy=prw->SelectIndex%icy;
  
  if(prw->SelectIndex==(u32)-1){
    if((keys&(KEY_DOWN|KEY_RIGHT))!=0){
      ix=0;
      iy=0;
    }
    if((keys&KEY_UP)!=0){
      ix=0;
      iy=icy-1;
    }
    }else{
    if((keys&KEY_UP)!=0){
      if(iy==0){
        ix--;
        iy=icy-1;
        }else{
        iy--;
      }
    }
    if((keys&KEY_DOWN)!=0){
      if(iy==(icy-1)){
        ix++;
        iy=0;
        }else{
        iy++;
      }
    }
    if((keys&KEY_LEFT)!=0) ix--;
    if((keys&KEY_RIGHT)!=0) ix++;
  }
  
  s32 idx=ix*icy+iy;
  
  if(idx<0){
    prw->SelectIndex=(u32)-1;
    }else{
    if((FindResultsCount-1)<idx) idx=FindResultsCount-1;
    prw->SelectIndex=idx;
  }
  
  if(prw->SelectIndex==(u32)-1){
    PlaySE_Long();
    prw->TopIndex=0;
    }else{
    PlaySE_Short();
    s32 tix=prw->TopIndex/icy;
    s32 x=prw->SelectIndex/icy;
    if(x<tix) tix=x;
    if((tix+icx-1)<x) tix=x-icx+1;
    prw->TopIndex=tix*icy;
  }
  
  return(true);
}

static bool DicResults_Space(void)
{
  return(false);
}
