
#include <nds.h>

#include "_const.h"
#include "maindef.h"
#include "_console.h"
#include "_consoleWriteLog.h"

#include "memtool.h"
#undef safemalloc
#define safemalloc safemalloc_chkmem
#include "strtool.h"
#include "unicode.h"
#include "cwl.h"
#include "fat2.h"
#include "datetime.h"
#include "shell.h"

#include "extlink.h"

static TExtLinkBody ExtLinkBody;

const TExtLinkBody* GetFileBody_From_MoonShell2_ExtLink(void)
{
  const char *pfn="/MOONSHL2/EXTLINK.DAT"; // This full path file name is fixation. It is never moved.
  
  FAT_FILE *pf=FAT2_fopen_AliasForRead(pfn);
  if(pf==NULL) StopFatalError(0,"Extend link data file not found. [%s]\n",pfn);
  
  u32 ReadSize=FAT2_fread(&ExtLinkBody,sizeof(TExtLinkBody),1,pf);
  
  FAT2_fclose(pf); pf=NULL;
  
  if((ReadSize<4)||(ExtLinkBody.ID==0)) StopFatalError(0,"Please call this application from MoonShell2 by way of the extend link. [%s]\n",pfn);
  if(ExtLinkBody.ID!=ExtLinkBody_ID) StopFatalError(0,"Extend link ID error. (0x%08x!=0x%08x)\n",ExtLinkBody_ID,ExtLinkBody_ID);
  
  return(&ExtLinkBody);
}


