
#define SelectEncode_BGColor (RGB15(8,8,8)|BIT15)

static u32 SelectEncode_ItemsCount;
static const char *SelectEncode_pItems[3]={
  "UTF-8",
  "UTF-16",
  "S-JIS (JPN)",
};
static u32 SelectEncode_ItemIndex;

static void SelectEncode_DrawScreen_DrawText(CglCanvas *pcan,u32 x,u32 y,u16 col,const char *pstr)
{
  pcan->SetFontTextColor(RGB15(0,0,0)|BIT15);
  pcan->TextOutA(x+1,y+1,pstr);
  pcan->SetFontTextColor(col);
  pcan->TextOutA(x+0,y+0,pstr);
}

static void SelectEncode_DrawScreen(CglCanvas *pcan)
{
  pcan->FillFull(SelectEncode_BGColor);
  
  const u16 TextColor=RGB15(24,24,24)|BIT15;
  const u16 TextHighColor=RGB15(31,31,31)|BIT15;
  
  u32 tx=16;
  u32 ty=16;
  const u32 th=glCanvasTextHeight+2;
  
  ty+=th;
  
  SelectEncode_DrawScreen_DrawText(pcan,tx,ty,TextColor,"Text encode select menu.");
  ty+=th*2;
  
  for(u32 idx=0;idx<SelectEncode_ItemsCount;idx++){
    const char *pstr=SelectEncode_pItems[idx];
    if(idx==SelectEncode_ItemIndex){
      SelectEncode_DrawScreen_DrawText(pcan,tx+0,ty,TextHighColor,">");
      SelectEncode_DrawScreen_DrawText(pcan,tx+8,ty,TextHighColor,pstr);
      }else{
      SelectEncode_DrawScreen_DrawText(pcan,tx+8,ty,TextColor,pstr);
    }
    ty+=th;
  }
  
}

static bool SelectEncode_KeyPress(u16 keys)
{
  if((keys&(KEY_UP|KEY_DOWN|KEY_LEFT|KEY_RIGHT))!=0){
    PlaySE_Short();
    if((keys&KEY_UP)!=0){
      if(0<SelectEncode_ItemIndex) SelectEncode_ItemIndex--;
    }
    if((keys&KEY_DOWN)!=0){
      if(SelectEncode_ItemIndex<(SelectEncode_ItemsCount-1)) SelectEncode_ItemIndex++;
    }
    if((keys&KEY_LEFT)!=0){
      SelectEncode_ItemIndex=0;
    }
    if((keys&KEY_RIGHT)!=0){
      SelectEncode_ItemIndex=SelectEncode_ItemsCount-1;
    }
    return(false);
  }
  
  if((keys&(KEY_START|KEY_SELECT|KEY_A))!=0){
    return(true);
  }
  
  return(false);
}

#include "_GlobalTool_DirectPenRead.h"

static bool SelectEncode_Execute(void)
{
  pScreenMain->pBackCanvas->FillFull(SelectEncode_BGColor);
  pScreenMain->Flip(true);
  
  if(Shell_isJPNmode()==false){
    SelectEncode_ItemsCount=2;
    }else{
    SelectEncode_ItemsCount=3;
  }
  
  SelectEncode_ItemIndex=0;
  
  switch(TextEncode){
    case ETE_UTF8: SelectEncode_ItemIndex=0; break;
    case ETE_UTF16: SelectEncode_ItemIndex=1; break;
    case ETE_SJIS: {
      if(Shell_isJPNmode()==true) SelectEncode_ItemIndex=2;
    } break;
  }
  
  SelectEncode_DrawScreen(pScreenSub->pCanvas);
  
  while(1){
    u16 keys=GetKeyInputWithXY();
    if(keys==0) break;
    swiWaitForVBlank();
  }
  
  while(1){
    u16 keys;
    while(1){
      keys=GetKeyInputWithXY();
      if(keys!=0) break;
      swiWaitForVBlank();
    }
    bool execute=false;
    bool cancel=false;
    if((keys&KEY_B)!=0){
      cancel=true;
      }else{
      if(SelectEncode_KeyPress(keys)==true) execute=true;
    }
    SelectEncode_DrawScreen(pScreenSub->pCanvas);
    while(1){
      keys=GetKeyInputWithXY();
      if(keys==0) break;
      swiWaitForVBlank();
    }
    if(cancel==true){
      PlaySE_Long();
      return(false);
    }
    if(execute==true){
      switch(SelectEncode_ItemIndex){
        case 0: TextEncode=ETE_UTF8; break;
        case 1: TextEncode=ETE_UTF16; break;
        case 2: TextEncode=ETE_SJIS; break;
      }
      PlaySE_Long();
      return(false);
    }
  }
  
  return(false);
}
