#pragma once

#define FontWidthMargin (1)

#include "unidef.h"

#define WindowRectWidth (ScreenWidth-2)

typedef struct {
  u32 TopIndex;
  u32 Length;
  UnicodeChar *pstr;
} TLineState_TLine;

typedef struct {
  u32 TotalLength;
  u32 LinesCount;
  TLineState_TLine *pLines;
} TLineState;

class CTextEditLine
{
protected:
  UnicodeChar *pstr;
  TLineState LineState;
  void ExpandBuffer(u32 addlen);
  void LineState_Init(void);
  void LineState_Free(void);
  void LineState_Create(void);
public:
  CTextEditLine(void);
  CTextEditLine(const UnicodeChar *psrcstr,const u32 srcstrlen);
  ~CTextEditLine(void);
  u32 GetLength(void);
  const UnicodeChar* GetPlaneStringBuffer(void) const;
  void AddNewLine(void);
  void AddNewLineWithSet(const UnicodeChar *psrcstr,const u32 srcstrlen);
  void AddStr(u32 Index,const UnicodeChar *psrcstr);
  void Split(u32 Index);
  void ApplyReduce(void);
  CTextEditLine *pBack,*pNext;
  const TLineState* GetLineState(void);
  void DeleteOne(u32 pos);
  void LineState_Clear(void);
};

