
typedef struct {
  char *pAliasFilename;
  UnicodeChar *pUnicodeFilename;
  TOSK_GlobalInfo GlobalInfo;
} TKeyMap;

static u32 KeyMapsCount;
static const u32 KeyMapsMaxCount=8;
static TKeyMap KeyMaps[KeyMapsMaxCount];

static u32 KeyMapsCurrentIndex;

static void OSK_KeyMaps_Init(void)
{
  if(FAT2_chdir_Alias(DefaultKeyMapsPath)==false) StopFatalError(17004,"Can not change path. [%s]\n",DefaultKeyMapsPath);
  
  KeyMapsCount=0;
  
  {
    const char *pafn;
    u32 FAT_FileType=FAT2_FindFirstFile(&pafn);
    
    while(FAT_FileType!=FT_NONE){
      switch(FAT_FileType){
        case FT_NONE: break;
        case FT_DIR: break;
        case FT_FILE: {
          u32 Ext32=0;
          {
            const char *ptmp=pafn;
            while(*ptmp!=0){
              u32 ch=*ptmp++;
              if(ch==(u32)'.'){
                Ext32=0;
                }else{
                if((0x61<=ch)&&(ch<=0x7a)) ch-=0x20;
                Ext32=(Ext32<<8)|ch;
              }
            }
          }
          
#define MakeExt32(c0,c1,c2,c3) ( ((u32)(c0)<<24) | ((u32)(c1)<<16) | ((u32)(c2)<<8) | ((u32)(c3)<<0) )
          
          if(Ext32==MakeExt32(0,'I','N','I')){
            const UnicodeChar *pufn=FAT2_GetLongFilenameUnicode();
            char afn[64];
            for(u32 idx=0;idx<64;idx++){
              afn[idx]=char(pufn[idx]);
            }
            OSK_KeyMap_Load(afn,true);
            bool f=false;
            if(OSK_GlobalInfo.TargetCodePage==0) f=true;
            if(Shell_isJPNmode()==true){
              if(OSK_GlobalInfo.TargetCodePage==932) f=true;
            }
            u32 CPNum=atoi(Shell_GetCodePageStr());
            if(OSK_GlobalInfo.TargetCodePage==CPNum) f=true;
            if((OSK_GlobalInfo.TargetCodePage<200)&&(CPNum<200)) f=true;
            if(f==true){
              TKeyMap *pkm=&KeyMaps[KeyMapsCount];
              pkm->pAliasFilename=str_AllocateCopy(&MM_SKKOSK,afn);
              pkm->pUnicodeFilename=Unicode_AllocateCopy(&MM_SKKOSK,FAT2_GetLongFilenameUnicode());
              pkm->GlobalInfo.pTitle=Unicode_AllocateCopy(&MM_SKKOSK,OSK_GlobalInfo.pTitle);
              pkm->GlobalInfo.pMaker=Unicode_AllocateCopy(&MM_SKKOSK,OSK_GlobalInfo.pMaker);
              pkm->GlobalInfo.TargetCodePage=OSK_GlobalInfo.TargetCodePage;
              pkm->GlobalInfo.pIME=str_AllocateCopy(&MM_SKKOSK,OSK_GlobalInfo.pIME);
              pkm->GlobalInfo.pOSK=str_AllocateCopy(&MM_SKKOSK,OSK_GlobalInfo.pOSK);
              KeyMapsCount++;
            }
            OSK_KeyMap_Free();
          }
        } break;
      }
      
      if(KeyMapsCount==KeyMapsMaxCount) break;
      
      FAT_FileType=FAT2_FindNextFile(&pafn);
    }
  }
  
  if(KeyMapsCount==0) StopFatalError(0,"Not found KeyMap setting file.");
  
  KeyMapsCurrentIndex=(u32)-1;
}

static void OSK_KeyMaps_Free(void)
{
  OSK_KeyMap_Free();
  
  for(u32 idx=0;idx<KeyMapsCount;idx++){
    TKeyMap *pkm=&KeyMaps[idx];
    if(pkm->pAliasFilename!=NULL){
      safefree(&MM_SKKOSK,pkm->pAliasFilename); pkm->pAliasFilename=NULL;
    }
    if(pkm->pUnicodeFilename!=NULL){
      safefree(&MM_SKKOSK,pkm->pUnicodeFilename); pkm->pUnicodeFilename=NULL;
    }
    if(pkm->GlobalInfo.pTitle!=NULL){
      safefree(&MM_SKKOSK,pkm->GlobalInfo.pTitle); pkm->GlobalInfo.pTitle=NULL;
    }
    if(pkm->GlobalInfo.pMaker!=NULL){
      safefree(&MM_SKKOSK,pkm->GlobalInfo.pMaker); pkm->GlobalInfo.pMaker=NULL;
    }
    pkm->GlobalInfo.TargetCodePage=0;
    if(pkm->GlobalInfo.pIME!=NULL){
      safefree(&MM_SKKOSK,pkm->GlobalInfo.pIME); pkm->GlobalInfo.pIME=NULL;
    }
    if(pkm->GlobalInfo.pOSK!=NULL){
      safefree(&MM_SKKOSK,pkm->GlobalInfo.pOSK); pkm->GlobalInfo.pOSK=NULL;
    }
  }
  
  KeyMapsCount=0;
}

static u32 OSK_KeyMaps_GetKeyMapIndex(void)
{
  return(KeyMapsCurrentIndex);
}

static void OSK_KeyMaps_ChangeKeyMapIndex(u32 idx)
{
  if(KeyMapsCurrentIndex==idx) return;
  
  OSK_KeyMap_Free();
  
  KeyMapsCurrentIndex=idx;
  
  if(KeyMapsCurrentIndex!=(u32)-1) OSK_KeyMap_Load(KeyMaps[KeyMapsCurrentIndex].pAliasFilename,false);
}

static void OSK_KeyMaps_ChangeKeyMapFilename(const char *pfn)
{
  UnicodeChar fnw[128];
  StrConvert_Ank2Unicode(pfn,fnw);
  
  for(u32 idx=0;idx<KeyMapsCount;idx++){
    if(Unicode_isEqual_NoCaseSensitive(fnw,KeyMaps[idx].pUnicodeFilename)==true){
      OSK_KeyMaps_ChangeKeyMapIndex(idx);
      return;
    }
  }
  
  OSK_KeyMaps_ChangeKeyMapIndex(0);
}

