
typedef struct {
  double x,y;
  double NormalLen;
} TModelLinePoint;

typedef struct {
  double TotalLen;
  double fx,fy;
  u32 PointsCount;
  TModelLinePoint *pPoints;
} TModelLine;

typedef struct {
  UnicodeChar wc;
  u32 LinesCount;
  TModelLine *pLines;
} TModel;

static u32 ModelsCount;
static TModel *pModels=NULL;

static void Model_Draw(const TModel *pModel,CglCanvas *pcan,double ofsx,double ofsy,double ratio,u16 col);
static void Models_AddRefer(const TModel *pSrcModel,UnicodeChar wc);

// ---------------------------------------------------------------------------

static bool Model_isEnableChar(UnicodeChar wc)
{
  bool res=false;

#define ES(x) if(wc==UnicodeChar(x)) res=true;
#define ER(x,y) if((UnicodeChar(x)<=wc)&&(wc<=UnicodeChar(y))) res=true;
  
  if(OSKHW_CharMode_UseNumber==true) ER(0x0030,0x0039); /* 0 ` 9 */

  if(OSKHW_CharMode==OSKHW_CM_Symbol){
    ES(0x0021); /* ! */ ES(0x0022); /* " */ ES(0x0023); /* # */ ES(0x0024); /* $ */
    ES(0x0025); /* % */ ES(0x0026); /* & */ ES(0x0028); /* ( */
    ES(0x0029); /* ) */ ES(0x002A); /* * */ ES(0x002B); /* + */
    ES(0x002c); /* , */ ES(0x002D); /* - */ ES(0x002e); /* . */
    ES(0x002F); /* / */ ES(0x003A); /* : */ ES(0x003B); /* ; */
    ES(0x003C); /* < */ ES(0x003D); /* = */ ES(0x003E); /* > */ ES(0x003F); /* ? */
    ES(0x0040); /* @ */ ES(0x005B); /* [ */ ES(0x005C); /* \\ */ ES(0x005D); /* ] */ ES(0x005E); /* ^ */
    ES(0x007B); /* { */ ES(0x007D); /* } */
    ES(0xFF5E); /* ` */
  }

  if(OSKHW_CharMode==OSKHW_CM_ENG_Large) ER(0x0041,0x005A); /* A ` Z */
  if(OSKHW_CharMode==OSKHW_CM_ENG_Small) ER(0x0061,0x007A); /* a ` z */
  if((OSKHW_CharMode==OSKHW_CM_ENG_Large)||(OSKHW_CharMode==OSKHW_CM_ENG_Small)){
    ES(0x0021); /* ! */ ES(0x0022); /* " */ ES(0x0023); /* # */ ES(0x0024); /* $ */
    ES(0x0025); /* % */ ES(0x0026); /* & */
    ES(0x002A); /* * */ ES(0x002B); /* + */
    ES(0x002c); /* , */ ES(0x002D); /* - */ ES(0x002e); /* . */
    ES(0x003A); /* : */ ES(0x003B); /* ; */ ES(0x003C); /* < */
    ES(0x003D); /* = */ ES(0x003E); /* > */ ES(0x003F); /* ? */ ES(0x0040); /* @ */
    ES(0x005C); /* \\ */ ES(0x005E); /* ^ */ ES(0x007B); /* { */ ES(0x007D); /* } */
    ES(0xFF5E); /* ` */
  }

  if(OSKHW_CharMode==OSKHW_CM_JPN_Hiragana) ER(0x3042,0x3093); /*  `  */
  if(OSKHW_CharMode==OSKHW_CM_JPN_Katakana) ER(0x30A2,0x30F3); /* A `  */
  if((OSKHW_CharMode==OSKHW_CM_JPN_Hiragana)||(OSKHW_CharMode==OSKHW_CM_JPN_Katakana)){
    ES(0x0021); /* ! */ ES(0x0022); /* # */ ES(0x0024); /* $ */
    ES(0x0025); /* % */ ES(0x0026); /* & */
    ES(0x002A); /* * */
    ES(0x002c); /* , */ ES(0x002D); /* - */ ES(0x002e); /* . */
    ES(0x003A); /* : */ ES(0x003B); /* ; */ ES(0x003F); /* ? */ ES(0x0040); /* @ */
    ES(0x005C); /* \\ */
    ES(0x007B); /* { */ ES(0x007D); /* } */ ES(0x007E); /* ~ */ ES(0x30FC); /* [ */
    ES(0xFF5E); /* ` */ ES(0x3002); /* B */
  }
  
  return(res);
}

// ---------------------------------------------------------------------------

#include "OSKHW_Model_ModelLine.h"
#include "OSKHW_Model_ModelResults.h"
#include "OSKHW_Model_ModelsLoadSave.h"
#include "OSKHW_Model_UserModel.h"

// ---------------------------------------------------------------------------

static void Model_Free(TModel *pmdl)
{
  pmdl->wc=0;
  for(u32 lidx=0;lidx<pmdl->LinesCount;lidx++){
    TModelLine *pline=&pmdl->pLines[lidx];
    pline->TotalLen=0;
    pline->fx=0;
    pline->fy=0;
    for(u32 pidx=0;pidx<pline->PointsCount;pidx++){
      TModelLinePoint *ppoi=&pline->pPoints[pidx];
      ppoi->x=0;
      ppoi->y=0;
    }
    pline->PointsCount=0;
    if(pline->pPoints!=NULL){
      safefree(&MM_SKKOSKHW,pline->pPoints); pline->pPoints=NULL;
    }
  }
  pmdl->LinesCount=0;
  if(pmdl->pLines!=NULL){
    safefree(&MM_SKKOSKHW,pmdl->pLines); pmdl->pLines=NULL;
  }
}

static bool Model_Fit(const TModel *pSrcModel,TModel *pDstModel,bool *pKogakiFlag)
{
  double minx=10000,miny=10000;
  double maxx=-10000,maxy=-10000;

#define chk(x,y) { \
  if(x<minx) minx=x; \
  if(maxx<x) maxx=x; \
  if(y<miny) miny=y; \
  if(maxy<y) maxy=y; \
}

  for(u32 lidx=0;lidx<pSrcModel->LinesCount;lidx++){
    if(GetPenDown()==true) return(false);
    TModelLine *pline=&pSrcModel->pLines[lidx];
    double px=pline->fx,py=pline->fy;
    for(u32 pidx=0;pidx<pline->PointsCount;pidx++){
      TModelLinePoint *ppoi=&pline->pPoints[pidx];
      px+=ppoi->x;
      py+=ppoi->y;
      chk(px,py);
    }
  }
  
  *pKogakiFlag=false;
  _consolePrintf("%f,%f.\n",miny,maxy);
  if((80<=miny)&&(120<=maxy)) *pKogakiFlag=true;

  _consolePrintf("ModelFit: min=%f, %f, max=%f, %f.\n",minx,miny,maxx,maxy);
  double ratiox=1,ratioy=1;
  double ofsx,ofsy;
  {
    double w=maxx-minx;
    double h=maxy-miny;
    double ratioadd=0;
    if(w!=0) ratiox=256/w;
    if(h!=0) ratioy=256/h;
    if(ratiox!=ratioy){
      if(ratiox<ratioy){
        ratioadd=(ratioy-ratiox)/4;
        ratioy=ratiox+ratioadd;
        }else{
        ratioadd=(ratiox-ratioy)/4;
        ratiox=ratioy+ratioadd;
      }
    }
    ofsx=(256-(w*ratiox))/2;
    ofsy=(256-(h*ratioy))/2;
    if(5<ratiox) ratiox=5;
    if(5<ratioy) ratioy=5;
    _consolePrintf("ratio=%f,%f, radd=%f, ofs=%f, %f.\n",ratiox,ratioy,ratioadd,ofsx,ofsy);
  }

  pDstModel->wc=pSrcModel->wc;
  pDstModel->LinesCount=pSrcModel->LinesCount;
  pDstModel->pLines=(TModelLine*)safemalloc(&MM_SKKOSKHW,sizeof(TModelLine)*pDstModel->LinesCount);
  for(u32 lidx=0;lidx<pDstModel->LinesCount;lidx++){
    TModelLine *pdstline=&pDstModel->pLines[lidx];
    pdstline->PointsCount=0;
    pdstline->pPoints=NULL;
  }
  
  for(u32 lidx=0;lidx<pDstModel->LinesCount;lidx++){
    if(GetPenDown()==true) return(false);
    TModelLine *psrcline=&pSrcModel->pLines[lidx];
    TModelLine *pdstline=&pDstModel->pLines[lidx];
    pdstline->TotalLen=psrcline->TotalLen;
    pdstline->fx=(psrcline->fx-minx)*ratiox+ofsx;
    pdstline->fy=(psrcline->fy-miny)*ratioy+ofsy;
    pdstline->PointsCount=psrcline->PointsCount;
    pdstline->pPoints=(TModelLinePoint*)safemalloc(&MM_SKKOSKHW,sizeof(TModelLinePoint)*pdstline->PointsCount);
    for(u32 pidx=0;pidx<pdstline->PointsCount;pidx++){
      TModelLinePoint *psrcpoi=&psrcline->pPoints[pidx];
      TModelLinePoint *pdstpoi=&pdstline->pPoints[pidx];
      pdstpoi->x=psrcpoi->x*ratiox;
      pdstpoi->y=psrcpoi->y*ratioy;
      pdstpoi->NormalLen=psrcpoi->NormalLen;
    }
  }

  for(u32 lidx=0;lidx<pDstModel->LinesCount;lidx++){
    if(GetPenDown()==true) return(false);
    ModelLine_CreateLength(&pDstModel->pLines[lidx]);
  }
  
  return(true);
}

static void Model_Draw(const TModel *pModel,CglCanvas *pcan,double ofsx,double ofsy,double ratio,u16 col)
{
  for(u32 lidx=0;lidx<pModel->LinesCount;lidx++){
    TModelLine *pline=&pModel->pLines[lidx];
    double x=ofsx+(pline->fx*ratio);
    double y=ofsy+(pline->fy*ratio);
    double lx=x,ly=y;
    for(u32 pidx=0;pidx<pline->PointsCount;pidx++){
      TModelLinePoint *ppoi=&pline->pPoints[pidx];
      x+=ppoi->x*ratio;
      y+=ppoi->y*ratio;
      DrawLine(pcan,lx,ly,x,y,col);
      lx=x; ly=y;
    }
  }
}

static void Models_AddRefer(const TModel *pSrcModel,UnicodeChar wc)
{
  _consolePrintf("AddRefer $%04x to %d.\n",wc,ModelsCount);
  
  pModels=(TModel*)saferealloc(&MM_SKKOSKHW_Model,pModels,sizeof(TModel)*(ModelsCount+1));
  TModel *pmdl=&pModels[ModelsCount++];
  
  pmdl->wc=wc;
  pmdl->LinesCount=pSrcModel->LinesCount;
  pmdl->pLines=(TModelLine*)safemalloc(&MM_SKKOSKHW_Model,sizeof(TModelLine)*pmdl->LinesCount);
//  _consolePrintf("LinesCount: %d.\n",pmdl->LinesCount);
  for(u32 lidx=0;lidx<pmdl->LinesCount;lidx++){
    TModelLine *pline=&pmdl->pLines[lidx];
    pline->fx=pSrcModel->pLines[lidx].fx;
    pline->fy=pSrcModel->pLines[lidx].fy;
    pline->PointsCount=pSrcModel->pLines[lidx].PointsCount;
//    _consolePrintf("First= %f, %f, PointsCount:%d.\n",pline->fx,pline->fy,pline->PointsCount);
    pline->pPoints=(TModelLinePoint*)safemalloc(&MM_SKKOSKHW_Model,sizeof(TModelLinePoint)*pline->PointsCount);
    for(u32 pidx=0;pidx<pline->PointsCount;pidx++){
      TModelLinePoint *ppoi=&pline->pPoints[pidx];
      ppoi->x=pSrcModel->pLines[lidx].pPoints[pidx].x;
      ppoi->y=pSrcModel->pLines[lidx].pPoints[pidx].y;
//      _consolePrintf("Points %d: %f, %f.\n",pidx,ppoi->x,ppoi->y);
    }
    ModelLine_CreateLength(pline);
  }
  
  Models_SaveToBin();
}

// ---------------------------------------------------------------------------

static void Models_Free(void)
{
  if(pModels!=NULL){
    for(u32 midx=0;midx<ModelsCount;midx++){
      TModel *pmdl=&pModels[midx];
      for(u32 lidx=0;lidx<pmdl->LinesCount;lidx++){
        TModelLine *pline=&pmdl->pLines[lidx];
        pline->PointsCount=0;
        if(pline->pPoints!=NULL){
          safefree(&MM_SKKOSKHW_Model,pline->pPoints); pline->pPoints=NULL;
        }
      }
      pmdl->LinesCount=0;
      if(pmdl->pLines!=NULL){
        safefree(&MM_SKKOSKHW_Model,pmdl->pLines); pmdl->pLines=NULL;
      }
    }
    ModelsCount=0;
    safefree(&MM_SKKOSKHW_Model,pModels); pModels=NULL;
  }
}

// ---------------------------------------------------------------------------

