;/*---------------------------------------------------------------------------------
;	$Id: biosCalls.s,v 1.5 2006/03/15 12:37:14 wntrmute Exp $
;
;	Copyright (C) 2005
;		Michael Noland (joat)
;		Jason Rogers (dovoto)
;		Dave Murphy (WinterMute)
;
;	This software is provided 'as-is', without any express or implied
;	warranty.  In no event will the authors be held liable for any
;	damages arising from the use of this software.
;
;	Permission is granted to anyone to use this software for any
;	purpose, including commercial applications, and to alter it and
;	redistribute it freely, subject to the following restrictions:
;
;	1.	The origin of this software must not be misrepresented; you
;		must not claim that you wrote the original software. If you use
;		this software in a product, an acknowledgment in the product
;		documentation would be appreciated but is not required.
;	2.	Altered source versions must be plainly marked as such, and
;		must not be misrepresented as being the original software.
;	3.	This notice may not be removed or altered from any source
;		distribution.
;
;	$Log: biosCalls.s,v $
;	Revision 1.5  2006/03/15 12:37:14  wntrmute
;	reformatted for legibility
;	grouped arm7 and arm9 specific code
;	
;	Revision 1.4  2006/03/03 07:20:14  joatski
;	Fixed a couple of little bugs (e.g. swiSetHaltCR using r0 instead of r2 on ARM7)
;	Commented out ARM7 swis in ARM9 mode, and vis versa
;	
;	Revision 1.3  2006/01/17 00:13:36  dovoto
;	Fixed swi 08 so lable and global matched "swiChangeSoundBias"
;	
;	Revision 1.2  2005/09/03 13:47:13  wntrmute
;	added logging to header
;	reformatted for legibility
;	
;
;---------------------------------------------------------------------------------*/

    AREA     globals,CODE,READONLY
    THUMB

;@---------------------------------------------------------------------------------
	EXPORT swiSoftReset
;@---------------------------------------------------------------------------------
swiSoftReset
;@---------------------------------------------------------------------------------
	swi	0x00
	bx	lr


;@---------------------------------------------------------------------------------
	EXPORT swiDelay
;@---------------------------------------------------------------------------------
swiDelay
;@---------------------------------------------------------------------------------
	swi	0x03
	bx	lr

;@---------------------------------------------------------------------------------
	EXPORT swiIntrWait
;@---------------------------------------------------------------------------------
swiIntrWait
;@---------------------------------------------------------------------------------
	swi	0x04
	bx	lr


;@---------------------------------------------------------------------------------
	EXPORT swiWaitForVBlank
;@---------------------------------------------------------------------------------
swiWaitForVBlank
;@---------------------------------------------------------------------------------
	swi	0x05
	bx	lr

;@---------------------------------------------------------------------------------
	EXPORT swiSleep
;@---------------------------------------------------------------------------------
swiSleep
;@---------------------------------------------------------------------------------
	swi	0x07
	bx	lr

;@---------------------------------------------------------------------------------
	EXPORT swiChangeSoundBias
;@---------------------------------------------------------------------------------
swiChangeSoundBias
;@---------------------------------------------------------------------------------
	swi	0x08
	bx	lr

;@---------------------------------------------------------------------------------
	EXPORT swiDivide
;@---------------------------------------------------------------------------------
swiDivide
;@---------------------------------------------------------------------------------
	swi	0x09
	bx	lr

;@---------------------------------------------------------------------------------
	EXPORT swiRemainder
;@---------------------------------------------------------------------------------
swiRemainder
;@---------------------------------------------------------------------------------
	swi	0x09
	;mov	r0, r1
	push {r1}
	pop {r0}
	bx	lr

;@---------------------------------------------------------------------------------
	EXPORT swiDivMod
;@---------------------------------------------------------------------------------
swiDivMod
;@---------------------------------------------------------------------------------
	push	{r2, r3}
	swi	0x09
	pop	{r2, r3}
	str	r0, [r2]
	str	r1, [r3]
	bx	lr

;@---------------------------------------------------------------------------------
	EXPORT swiCopy
;@---------------------------------------------------------------------------------
swiCopy
;@---------------------------------------------------------------------------------
	swi	0x0B
	bx	lr

;@---------------------------------------------------------------------------------
	EXPORT swiFastCopy
;@---------------------------------------------------------------------------------
swiFastCopy
;@---------------------------------------------------------------------------------
	swi	0x0C
	bx	lr

;@---------------------------------------------------------------------------------
	EXPORT swiSqrt
;@---------------------------------------------------------------------------------
swiSqrt
;@---------------------------------------------------------------------------------
	swi	0x0D
	bx	lr

;@---------------------------------------------------------------------------------
	EXPORT swiCRC16
;@---------------------------------------------------------------------------------
swiCRC16
;@---------------------------------------------------------------------------------
	swi	0x0E
	bx	lr

;@---------------------------------------------------------------------------------
	EXPORT swiIsDebugger
;@---------------------------------------------------------------------------------
swiIsDebugger
;@---------------------------------------------------------------------------------
	swi	0x0F
	bx	lr

;@---------------------------------------------------------------------------------
	EXPORT swiUnpackBits
;@---------------------------------------------------------------------------------
swiUnpackBits
;@---------------------------------------------------------------------------------
	swi	0x10
	bx	lr

;@---------------------------------------------------------------------------------
	EXPORT swiDecompressLZSSWram
;@---------------------------------------------------------------------------------
swiDecompressLZSSWram
;@---------------------------------------------------------------------------------
	swi	0x11
	bx	lr

;@---------------------------------------------------------------------------------
	EXPORT swiDecompressLZSSVram
;@---------------------------------------------------------------------------------
swiDecompressLZSSVram
;@---------------------------------------------------------------------------------
	swi	0x12
	bx	lr

;@---------------------------------------------------------------------------------
	EXPORT swiDecompressHuffman
;@---------------------------------------------------------------------------------
swiDecompressHuffman
;@---------------------------------------------------------------------------------
	swi	0x13
	bx	lr

;@---------------------------------------------------------------------------------
	EXPORT swiDecompressRLEWram
;@---------------------------------------------------------------------------------
swiDecompressRLEWram
;@---------------------------------------------------------------------------------
	swi	0x14
	bx	lr

;@---------------------------------------------------------------------------------
	EXPORT swiDecompressRLEVram
;@---------------------------------------------------------------------------------
swiDecompressRLEVram
;@---------------------------------------------------------------------------------
	swi	0x15
	bx	lr

;@---------------------------------------------------------------------------------
;@ ARM7 only bios calls
;@---------------------------------------------------------------------------------
;#ifdef ARM7
;
;;@---------------------------------------------------------------------------------
;	EXPORT swiHalt
;;@---------------------------------------------------------------------------------
;swiHalt
;;@---------------------------------------------------------------------------------
;	swi	0x06
;	bx	lr
;
;;@---------------------------------------------------------------------------------
;	EXPORT swiGetSineTable
;;@---------------------------------------------------------------------------------
;swiGetSineTable
;;@---------------------------------------------------------------------------------
;	swi	0x1A
;	bx	lr
;
;;@---------------------------------------------------------------------------------
;	EXPORT swiGetPitchTable
;;@---------------------------------------------------------------------------------
;swiGetPitchTable
;;@---------------------------------------------------------------------------------
;	swi	0x1B
;	bx	lr
;
;;@---------------------------------------------------------------------------------
;	EXPORT swiGetVolumeTable
;;@---------------------------------------------------------------------------------
;swiGetVolumeTable
;;@---------------------------------------------------------------------------------
;	swi	0x1C
;	bx	lr
;
;
;;@ ARM7 function, but no real point in exposing it, at least not
;;@ without adding a way to get the 3 arguments back into C
;;@	EXPORT swiGetFptrs
;;@;@swiGetFptrs
;;@	swi	0x1D
;;@	bx	lr
;
;
;;@---------------------------------------------------------------------------------
;;	EXPORT	swiSwitchToGBAMode
;;@---------------------------------------------------------------------------------
;;swiSwitchToGBAMode
;;@---------------------------------------------------------------------------------
;;	mov	r0, #0x40
;;	swi	0x1F
;;@ does not return, of course
;
;;@---------------------------------------------------------------------------------
;;	EXPORT swiSetHaltCR
;;@---------------------------------------------------------------------------------
;;swiSetHaltCR
;;@---------------------------------------------------------------------------------
;;	mov	r2, r0
;;	swi	0x1F
;;	bx	lr
;
;#endif // ARM7

;@---------------------------------------------------------------------------------
;@ ARM9 only bios calls
;@---------------------------------------------------------------------------------
;#ifdef ARM9

;@---------------------------------------------------------------------------------
	EXPORT swiWaitForIRQ
;@---------------------------------------------------------------------------------
swiWaitForIRQ
;@---------------------------------------------------------------------------------
	swi	0x06
	bx	lr

;@---------------------------------------------------------------------------------
	EXPORT swiDecodeDelta8
;@---------------------------------------------------------------------------------
swiDecodeDelta8
;@---------------------------------------------------------------------------------
	swi	0x16
	bx	lr

;@---------------------------------------------------------------------------------
	EXPORT swiDecodeDelta16
;@---------------------------------------------------------------------------------
swiDecodeDelta16
;@---------------------------------------------------------------------------------
	swi	0x18
	bx	lr

;@---------------------------------------------------------------------------------
	EXPORT swiSetHaltCR
;@---------------------------------------------------------------------------------
swiSetHaltCR
;@---------------------------------------------------------------------------------
	swi	0x1F
	bx	lr

;#endif // ARM9

  END