#define LAMPE_VERSION "1.2" // "Variable" de la version

// On inclus les indispensables

#include <PA9.h>
#include <fat.h>
#include <string.h>

// On initialise les variables couleur et teuf

int couleur;
int teuf;

// On cre les tables couleurs et col_txt

float couleurs[8] = {PA_RGB8(255,255,255), PA_RGB8(255,0,0), PA_RGB8(0,255,0), PA_RGB8(0,0,255), PA_RGB8(255,127,39), PA_RGB8(255,255,0), PA_RGB8(0,255,255), PA_RGB8(128,255,0)};
char *col_txt[10] = {"Blanc", "Rouge", "Vert", "Bleu", "Orange", "Jaune", "Bleu Clair", "Vert Clair"};

int main (int argc, char **argv) // On dmarre le main
{

	// On initialise PAlib
	
    PA_Init();
    PA_InitVBL();
		// On initialise l'affichage 16bit et le texte sur les crans
	
	PA_Init16bitBg(0, 1);
	PA_Init16bitBg(1, 1);
	PA_InitText(1, 0);
	PA_InitText(0, 0);
	
	PA_SetDSLBrightness(3); // On met la luminosit max pour les DS Lite
	//Et on allume les crans (au cas ou...)
	PA_SetScreenLight(0, 1);
	PA_SetScreenLight(1, 1);
	
	fatInitDefault();	// On initialise la librairie Fat
	
	PA_OutputText(1, 1, 1, "Initalisiation du Wi-Fi...");
    PA_InitWifi();
	PA_OutputText(1, 1, 2, "OK !\nConnexion au Wi-Fi...\n");
    if (!PA_ConnectWifiWFC())
	{
		PA_OutputText(1, 1, 4, "erreur !");
	}
	else
	{
    PA_OutputText(1, 1, 4, "OK !\nLe Wi-Fi est maintenant pret !\n");
	
	PA_OutputText(1, 0, 6, "Recherche de la nouvelle version\n\n");
	
	char *buffer = malloc(256*256);
    PA_GetHTTP(buffer,"http://microlua.fr.nf/lampe.jpg"); // 
	PA_OutputText(1, 1, 8, "OK !");
	
	if(strncmp(buffer, LAMPE_VERSION, 3) == 0)
	{
	
	PA_OutputText(1, 0, 10, "Vous avez la dernire version de Lampe DS !\n\n");
	PA_OutputText(1, 0, 12, "Touchez l'cran tactile pour continuer !");
	
	}
	else
	{
	
	PA_OutputText(1, 0, 10, "Une nouvelle version de Lampe DS existe !\n\n");
	PA_OutputText(1, 0, 12, "http://microlua.xooit.fr/p6054.htm\n\n");
	PA_OutputText(1, 0, 14, "Touchez l'cran tactile pour continuer !");
	
	}
	
	PA_WaitFor(Stylus.Newpress);
	}

	FILE* ini = fopen("config_lampe.sav", "a+");  // On ouvre notre fichier de config
	
	
	fscanf(ini, "%d_%d", &couleur, &teuf); // On rcupres les donnes de ce fichier
	
	fclose(ini); // Et on le ferme


	if(&couleur == NULL) // Si il n'y a pas de couleur
	{

	couleur = 0; // Alors on la met  0

	}

	if(&teuf == NULL) // Si il n'y a pas de valeur de mode teuf
	{

	teuf = 0; // Alors on le met  0

	}
	else // Sinon
	{
	
	if(teuf == 1) // Si le mode teuf est activ
	{
	
	PA_VBLCounterStart(1); // On dmarre le compteur
	
	}
	
	}

	
    while (1) // Boucle
    {	
	
	if(Pad.Newpress.Start) // Si on appuie sur start
	{
	
	// On sauvegarde
	
	PA_OutputText(0, 3, 5, "Sauvegarde en cours...");
	FILE* ini = fopen("config_lampe.sav", "w+");
	fprintf(ini, "%d_%d", couleur, teuf);
	fclose(ini);
	PA_OutputText(0, 5, 5, "Termin !");
	PA_ClearTextBg(0);
	
	}
	
	if(Pad.Newpress.Select) // Si on appuie sur Select
	{
	
	if(teuf == 1) // Si le mode teuf est dj activ
	{
	
	teuf = 0; // On le dsactive
	PA_VBLCountersReset(); // Et on met le compteur   0
	
	}
	else // Sinon le mode teuf n'est pas activ
	{
	
	teuf = 1; // On l'active
	PA_VBLCounterStart(1); // Et on dmarre le compteur
	
	}
	
	}
	
	if(teuf == 1) // Si le mode teuf est activ
	{
	
	if(PA_VBLCounter[1]/60 >= 2) // Et que le compteur est  2 secondes
	{
	
	PA_VBLCountersReset();	// On rinitialise le compteur
	
	if(couleur < 7) // Si la couleur est infrieure  7
	{
	
	PA_ClearTextBg(1); // On efface l'cran
	couleur++; // Et on change de couleur
	
	}
	else // Sinon
	{
	
	PA_ClearTextBg(1); // On efface l'cran
	couleur = 0; // Et on remet  la premire couleur
	
	}
	
	PA_VBLCounterStart(1); // On redmarre le compteur
	
	}
	
	}
	
	if(((Pad.Newpress.Right) || (Pad.Newpress.R) || (Pad.Newpress.Up) || (Stylus.Newpress)) && (PA_StylusInZone(256/2, 0, 256, 192))) // Si on appuie sur la Flche Droite, Flche Haut,  Bouton R ou qu'on appuie sur le cot droit de l'cran tactile
	{
	
	if(couleur < 7) // Et que la couleur est infrieure  7
	{
	
	PA_ClearTextBg(1); // On efface l'cran
	couleur++; // On change de couleur
	
	}
	else // Sinon
	{
	
	PA_ClearTextBg(1); // On efface l'cran
	couleur = 0; // Et on met la couleur  0
	
	}
	
	}
	
	
	if(((Pad.Newpress.Left) || (Pad.Newpress.L) || (Pad.Newpress.Down) || (Stylus.Newpress)) && (PA_StylusInZone(0, 0, 256/2, 192))) // Si on appuie sur la Flche Gauche, Flche Bas, Bouton L ou qu'on appuie sur le ct gauche de l'cran tactile
	{
	
	if(couleur > 0) // Si la couleur est suprieure  0
	{
	
	PA_ClearTextBg(1); // On efface  l'cran
	couleur--; // Et on change la couleur
	
	}
	else // Sinon
	{
	
	PA_ClearTextBg(1); // On efface  l'cran
	couleur = 7; // On met la couleur  7
	
	}
	
	}
	
	PA_SetTextCol(1, 0, 0, 0); // On met la couleur du texte blanche
	
	
	PA_OutputText(1, 1, 1, "%s", col_txt[couleur]); // On affiche le nom de la couleur
	
	if((Pad.Held.A) || (Pad.Held.B) || (Pad.Held.X) || (Pad.Held.Y)) // Si on appuie sur A, B, X ou Y
	{
	
	PA_SetTextCol(0, 31, 0, 0); // On met la couleur du texte rouge
	
	// On affiche les crdits
	
	PA_OutputText(0, 10, 5, "Lampe DS v%s", LAMPE_VERSION);
	PA_OutputText(0, 4,8, "Par Aurel2108 avec PAlib");
	
	}
	else // Sinon
	{
	
	PA_ClearTextBg(0); // On efface l'cran
	
	}
	
	// On met les deux crans  la couleur
	
	PA_Draw16bitRect (0,0,0,256,192, couleurs[couleur]);
	PA_Draw16bitRect (1,0,0,256,192, couleurs[couleur]);

	
    PA_WaitForVBL(); // Indispensable
    
	} // Fin de la boucle
    
    return 0; // Indispensable
} // Fin du main
