#include <winsock2.h>
#include <stdio.h>

#define DEFAULT_PORT 21
#define DEFAULT_BUFFER_SIZE 4096

int main(int argc, char* argv[])
{
   if(argc < 2)
      return 0;

   printf("Preparing to send %s\n", argv[1]);

   char Buffer[DEFAULT_BUFFER_SIZE + 1];

    WSAData wsd;

    if(WSAStartup(MAKEWORD(2, 2), &wsd) != 0)
   {
        printf("Winsock not initialised!\n");
        return -1;
    }

    SOCKET ls = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if (ls == INVALID_SOCKET)
   {
        printf("Invalid socket!\n");
        return -1;
    }

    sockaddr_in service;
    memset(&service, 0, sizeof(service));
    service.sin_family = AF_INET;
    service.sin_addr.s_addr = INADDR_ANY;
   service.sin_port = htons(DEFAULT_PORT);

   if (bind(ls, (SOCKADDR*) &service, sizeof(service)) == SOCKET_ERROR)
   {
      printf("bind error!\n");
      return -1;
   }

   printf("Waiting for connection...\n");

   if (listen(ls, 1) == SOCKET_ERROR)
   {
      printf("listen() error!\n");
      return -1;
   }

   SOCKET as;

   while (1)
   {
      as = accept(ls, NULL, NULL);
      if (as == SOCKET_ERROR)
      {
         continue;
      }

      printf("Sending %s", argv[1]);

      int namelen = strlen(argv[1]) + 1;
      send(as, (char *)&namelen, 4, 0);
      send(as, argv[1], namelen, 0);

      FILE *inf;
      fopen_s(&inf, argv[1], "rb");

      fseek(inf, 0, SEEK_END);
      int totbytes = ftell(inf);
      send(as, (char *)&totbytes, 4, 0);
      fseek(inf, 0, SEEK_SET);

      int len, sent;
      char *pos;

      while(!feof(inf))
      {
         len = fread(Buffer, 1, DEFAULT_BUFFER_SIZE, inf);
         pos = Buffer;

         while(len)
         {
            sent = send(as, Buffer, len, 0);
            len -= sent;
            pos += sent;
         }
      }
      fclose(inf);
      break;
   }

   closesocket(as);
   closesocket(ls);
   WSACleanup();

   return 0;
} 