#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
//#include <sys/types.h>
//#include <fstream.h>
//#include <netdb.h>
//#include <fcntl.h>
//#include <sys/un.h>

#define PORT 21
#define DEFAULT_BUFFER_SIZE 4096

int main(int argc, char* argv[])
{
   if(argc < 2)
      return 0;

   printf("Preparing to send %s\n", argv[1]);

   char Buffer[DEFAULT_BUFFER_SIZE + 1];
  int sock;

  /* Create the socket.   */
  sock = socket (PF_INET, SOCK_STREAM, IPPROTO_TCP);
  if (sock < 0)
    {
      perror ("socket (client)");
      exit (EXIT_FAILURE);
    }

   printf("socket %d\n", sock);

// setsockopt stops error 98 ( EADDRINUSE), i.e. allows addr to be reused if still in use
  unsigned int opt = 1;
  if (setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, &opt, sizeof(opt))==-1) {
    perror("setsockopt(fd,SOL_SOCKET, SO_REUSEADDR,1)");
    exit(1);
  }
  printf("setsockopt ok\n");

// bind socket to address
 struct sockaddr_in server_address;

   memset(&server_address, 0, sizeof(server_address));

   server_address.sin_family      = AF_INET;
   server_address.sin_addr.s_addr = htonl(INADDR_ANY);
   server_address.sin_port        = htons(PORT);

   int status = bind(sock, (struct sockaddr*) &server_address, sizeof(server_address));

 if (status < 0)
   {
      printf("failed to bind status=%d errno=%d\n", status, errno);
      printf("error codes: %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d\n",EACCES,EADDRINUSE,EBADF,EINVAL,ENOTSOCK,EACCES,EADDRNOTAVAIL,EFAULT,EINVAL,ELOOP,ENAMETOOLONG,ENOENT,ENOMEM,ENOTDIR,EROFS);
      return errno;
   }
   printf("bind ok %d\n", status);

  if (listen (sock, 1) < 0)
    {
      perror ("listen");
      exit (EXIT_FAILURE);
    }

   printf("listen\n");

   int as;

   while (1)
   {
      printf("waiting for DS connection (b4 accept)\n");
      as = accept(sock, NULL, NULL);
      printf("aft accept\n");
      if (as < 0)
      {
	 printf("as accept error %d\n",as);
         continue;
      }

      printf("Sending %s", argv[1]);

      int namelen = strlen(argv[1]) + 1;
      send(as, (char *)&namelen, 4, 0);
      send(as, argv[1], namelen, 0);

      FILE *inf=fopen(argv[1], "rb");

      fseek(inf, 0, SEEK_END);
      int totbytes = ftell(inf);
      printf(" totbytes=%d\n",totbytes);
      send(as, (char *)&totbytes, 4, 0);
      fseek(inf, 0, SEEK_SET);

      int len, sent;
      char *pos;

      while(!feof(inf))
      {
         len = fread(Buffer, 1, DEFAULT_BUFFER_SIZE, inf);
         pos = Buffer;
// alt. progress indicator (one dot (.) per buffer (4096 bytes) sent)
//         printf(".");
//         fflush(stdout); // flush stdout so that the . (without \n) is shown while the buffer is sent in 4096 chunks

         while(len)
         {
            sent = send(as, Buffer, len, 0);
            len -= sent;
            pos += sent;
// alt. progress indicator (reducing bytes left to send)
            totbytes -=sent;
	    printf("%d\n",totbytes);
         }
      }
      fclose(inf);
      printf("\nComplete.\n");
      break;
   }

   close(sock);
   close(as);


   return 0;
} 
