dofile("standard.lua")
_VCLAVIER = 2.01
clavier = {}
coul = {}
coul.blanc = Color.new(31,31,31)
coul.noir = Color.new(0,0,0)
coul.bleu = Color.new(0,0,31)
coul.bleuf = Color.new(1,3,15)
coul.bleuv = Color.new(1,29,19)

clavier.new = function()
	local cla = {}
	local i,j
	for i= 1,6 do
		cla[i] = {}
		for j= 1,10 do
			cla[i][j] = {}
			-- cla[i][j][1] = {}
			--[[
			cla[i][j][1].t = ""          --Texte du panneau [x]
			cla[i][j][1].cc = coul.blanc --Couleur du cadre
			cla[i][j][1].cf = coul.bleu  --Couleur du fond
			cla[i][j][1].cs = coul.blanc --Couleur du fond selectionn
			cla[i][j][1].ct = coul.blanc --Couleur du texte
			cla[i][j][1].op = 0          --Activation du panneau x si > 0
			]]
		end
	end
	cla.ta = 1             --Panneau actif
	cla.rep = Timer.new()  --Timer de repetition
	cla.xscr = 1		   --Pos x de l'ecran
	cla.yscr = 1		   --Pos y de l'ecran
	cla.lon = 1			   --Longueur de l'ecran en case
	cla.ascr = false	   --Affichage de l'ecran
	cla.cc = coul.blanc	   --Couleur du cadre de l'ecran
	cla.cf = coul.noir	   --Couleur du fond de l'ecran
	cla.ct = coul.blanc	   --Couleur du texte de l'ecran
	cla.text = ""		   --Texte entrer au clavier
	cla.ycurs = 1		   --Pos y du curseur de l'ecran
	cla.ydep = 1		   --Pos de dpart du texte
	return cla
end

clavier.del = function(cla)
	if(cla == nil) then 
		clavier = nil
		coul = nil
		_VCLAVIER = nil
	else cla = nil end
end

clavier.addKey = function(cla,x,y,text,nbc,op,cc,cf,cs,ct)
	local key = {}
	if(type(text) == "number") then text = string.char(text) end
	key.t = text            --Texte du panneau [x]
	if(cc == nil) then key.cc = coul.blanc
	else key.cc = cc end    --Couleur du cadre
	if(cf == nil) then key.cf = coul.bleu
	else key.cf = cf end    --Couleur du fond
	if(cs == nil) then key.cs = coul.bleuv
	else key.cs = cs end    --Couleur du fond selectionn
	if(ct == nil) then key.ct = coul.blanc
	else key.ct = ct end    --Couleur du texte
	if(op == nil) then key.op = 0
	else key.op = op end    --Activation du panneau x si > 0
	if(nbc == nil) then key.nbc = 1
	else key.nbc = nbc end    --Nb de case recouverte par la touche
	key.app = false           --La touche n'est pas appuyer
	table.insert(cla[y][x],key)
end

clavier.nbPanel = function(cla)
	local i,j
	local nbp = 0
	for i = 1,6 do
		for j= 1,10 do
			if(#cla[i][j] > nbp) then nbp = #cla[i][j] end
		end
	end
	return nbp
end

clavier.modKey = function(cla,x,y,panneau,text,nbc,op,cc,cf,cs,ct)
	if(text ~= nil) then cla[y][x][panneau].t = text end --Texte du panneau [x]
	if(cc ~= nil) then cla[y][x][panneau].cc = cc end    --Couleur du cadre
	if(cf ~= nil) then cla[y][x][panneau].cf = cf end    --Couleur du fond
	if(cs ~= nil) then cla[y][x][panneau].cs = cs end    --Couleur du fond selectionn
	if(ct ~= nil) then cla[y][x][panneau].ct = ct end    --Couleur du texte
	if(op ~= nil) then cla[y][x][panneau].op = op end     --Activation du panneau x si > 0
	if(nbc ~= nil) then cla[y][x][panneau].nbc = nbc end   --Nb de case recouverte par la touche
end

clavier.delKey = function(cla,x,y,panneau)
	table.remove(cla[y][x],panneau)
end

clavier.modScreen = function(cla,x,y,lon,cc,cf,ct)
	cla.xscr = x
	cla.yscr = y
	cla.lon = lon
	if(cc ~= nil) then cla.cc = cc end    --Couleur du cadre
	if(cf ~= nil) then cla.cf = cf end    --Couleur du fond
	if(ct ~= nil) then cla.ct = ct end    --Couleur du texte
end

clavier.activeScreen = function(cla,active)
	if active then cla.ascr = true
	else cla.ascr = false end
end

clavier.setText = function(cla,text)
	cla.text = text
end

clavier.getText = function(cla)
	return cla.text
end

clavier.activePanel = function(cla,numPanel)
	local maxP = clavier.nbPanel(cla)
	if(numPanel > 0 and numPanel < maxP+1) then
		cla.ta = numPanel
	end
end

clavier.show = function(mat)
	local i,j,x,y,xx,yy,buff,lon
	local pan = mat.ta
	for i = 1,6 do
		y = ((i-1)*25)+42
		for j = 1,10 do
			-- Debug.print(i.."."..j.."."..pan) render()
			if(mat[i][j][pan] ~= nil) then
				if(mat[i][j][pan].t ~= "") then
					x = ((j-1)*25)+3
					lon = (mat[i][j][pan].nbc -1)*25
					if(mat[i][j][pan].app) then
						screen.drawFillRect(SCREEN_DOWN,x+1,y+1,x+23+lon,y+23,mat[i][j][pan].cs)
						if(mat.rep:time() >= 200) then
							mat.rep:reset()
							mat[i][j][pan].app = false
						end
					else
						screen.drawFillRect(SCREEN_DOWN,x+1,y+1,x+23+lon,y+23,mat[i][j][pan].cf)
					end
					screen.drawRect(SCREEN_DOWN,x,y,x+24+lon,y+24,mat[i][j][pan].cc)
					xx = 12-(string.len(mat[i][j][pan].t)*3)+x + math.floor(lon/2)
					yy = y +9
					-- if(type(mat[i][j][pan].t) == "string") then buff = mat[i][j][pan].t
					-- else buff = string.char(mat[i][j][pan].t) end
					buff = mat[i][j][pan].t
					screen.print(SCREEN_DOWN,xx,yy,buff,mat[i][j][pan].ct)
				end
			end
		end
	end
	if(mat.ascr) then
		y = ((mat.yscr -1)*25)+42
		x = ((mat.xscr -1)*25)+3
		lon = (mat.lon)*25
		screen.drawFillRect(SCREEN_DOWN,x+1,y+1,x+lon-2,y+23,mat.cf)
		screen.drawRect(SCREEN_DOWN,x,y,x+lon-1,y+24,mat.cc)
		lon = math.floor((lon-8)/6)
		buff = string.sub(mat.text,mat.ydep,lon)
		screen.print(SCREEN_DOWN,x+3,y+9,buff,mat.ct)
	end
end

clavier.held = function(mat,x,y)
	local i,j,xx,yy,lon
	local pan = mat.ta
	local kre
	local result = ""
	for i = 1,6 do
		yy = 42+((i-1)*25)
		for j = 1,10 do
			xx = 3+((j-1)*25)
			if(mat[i][j][pan] ~= nil) then
				if(mat[i][j][pan].t ~= "") then
					lon = (mat[i][j][pan].nbc)*25
					kre = square(xx,yy,xx+lon,yy+25)
					if(estDedans(x,y,kre)) then
						if(mat[i][j][pan].op == 0) then 
							result = mat[i][j][pan].t
							mat.text = mat.text..result
						elseif(mat[i][j][pan].op > 0) then mat.ta = mat[i][j][pan].op 
						else 
							if(mat[i][j][pan].op == -4) then 
								result =" "
								mat.text = mat.text..result
							elseif(mat[i][j][pan].op == -2) then 
								mat.text = string.sub(mat.text,1,-2) 
								result = mat[i][j][pan].t
							else result = mat[i][j][pan].t end
						end
						mat[i][j][pan].app = true
						mat.rep:start()
					end
				end
			end
		end
	end
	return result
end
