package org.pictods.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
//import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.pictods.Pictods;
import org.pictods.UserSettings;

public class UserSettingsUI extends Dialog {

	private Shell dialogShell;
	public UserSettings settings;
	private static final int WIDTH = 350;

	private Text scrollIncrement, zoomIncrement;
	public String title = "";
//	private String[] actionList = {
//			"Left", "Right", "Up", "Down", 
//			"Zoom In", "Zoom Out", "No Zoom", 
//			"Set Thumbnails Mode", "Set Overview Mode", "Set Dual Screen Mode", "Set Default Conf", 
//			"Change View Mode", "Change Mode", "Change Orientation", "Change Hand", "Change Reading", "Change Screen Space", "Change Light", 
//			"Right Page", "Left Page", "Up Page", "Down Page", "Left Thumbnails Page", "Right Thumbnails Page"};
//	private Label right, left, down, up, a, b, x, y, r, l, select;
//	RightHanded_Landscape_View
//	KEY_Right  = Action_ScrollRight;
//	KEY_Down   = Action_ScrollDown;
//	KEY_Up     = Action_ScrollUp;
//	KEY_Left   = Action_ScrollLeft;
//	KEY_A      = Action_ChangeViewMode;
//	KEY_B      = Action_SetModeThmbs;
//	KEY_X      = Action_RightPage;
//	KEY_Y      = Action_LeftPage;
//	KEY_R      = Action_Rotate;
//	KEY_L      = Action_ChangeMode;
//	KEY_Select = Action_ChangeLight;
	private Button 
		lefty, landscape, screenspace, scrollChange, iconLock, waitForKeyRelease, progressiveScroll, 
		transitionAnim, iconAnim, soundsEffect, startupSound, resizeFilter;

	public UserSettingsUI(Shell parent) {
		super(parent);
	}

	public void defaultPressed() {
		applySettingsToUI(new UserSettings());
		applyUIToSettings();
	}
	
	protected void okPressed() {
		applyUIToSettings();
		Pictods.SaveUserSettings(settings);
		super.okPressed();
	}
	
	protected void buttonPressed(int buttonId) {
		if (buttonId == IDialogConstants.BACK_ID) {
			defaultPressed();
		}
		else {
			super.buttonPressed(buttonId);
		}
	}
	
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, "Generate",
				true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
		createButton(parent, IDialogConstants.BACK_ID,
				"Default", false);
	}
	
	public void applyUIToSettings() {
		try {
			settings.soundsEffect = soundsEffect.getSelection()?1:0;
			settings.startupSound = startupSound.getSelection()?1:0;
			settings.resizeFilter = resizeFilter.getSelection()?1:0;
			settings.lefty = lefty.getSelection()?1:0;
			settings.scrollChange = scrollChange.getSelection()?1:0;
			settings.landscape = landscape.getSelection()?1:0;
			settings.screenspace = screenspace.getSelection()?1:0;
			settings.iconLock = iconLock.getSelection()?1:0;
			settings.waitForKeyRelease = waitForKeyRelease.getSelection()?1:0;
			settings.progressiveScroll = progressiveScroll.getSelection()?1:0;
			settings.transitionAnim = transitionAnim.getSelection()?1:0;
			settings.iconAnim = iconAnim.getSelection()?1:0;
			settings.scrollIncrement = Integer.parseInt(scrollIncrement.getText());
			settings.zoomIncrement = Integer.parseInt(zoomIncrement.getText());
		} catch (NumberFormatException e) {
			MessageDialog.openError(
					dialogShell, "Pictods error", "Bad value. Please, check fields.");
		}
	}

	public void applySettingsToUI(UserSettings set) {
		soundsEffect.setSelection(set.soundsEffect == 0?false:true);
		startupSound.setSelection(set.startupSound == 0?false:true);
		resizeFilter.setSelection(set.resizeFilter == 0?false:true);
		lefty.setSelection(set.lefty == 0?false:true);
		scrollChange.setSelection(set.scrollChange == 0?false:true);
		landscape.setSelection(set.landscape == 0?false:true);
		screenspace.setSelection(set.screenspace == 0?false:true);
		iconLock.setSelection(set.iconLock == 0?false:true);
		waitForKeyRelease.setSelection(set.waitForKeyRelease == 0?false:true);
		progressiveScroll.setSelection(set.progressiveScroll == 0?false:true);
		transitionAnim.setSelection(set.transitionAnim == 0?false:true);
		iconAnim.setSelection(set.iconAnim == 0?false:true);
		scrollIncrement.setText("" + set.scrollIncrement);
		zoomIncrement.setText("" + set.zoomIncrement);
	}

	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		dialogShell = newShell;
		dialogShell.setText("User Settings");
		dialogShell.setImage(new Image(Display.getCurrent(),
				"../resources/pictods.ico"));
		dialogShell.setLayout(new GridLayout(1, false));
		dialogShell.setMinimumSize(WIDTH, -1);
	}

	protected Control createDialogArea(Composite parent) {
		Composite composite = (Composite) super.createDialogArea(parent);
		((GridLayout) composite.getLayout()).numColumns = 1;
		
		Label titleLabel = new Label(composite, SWT.NONE);
		titleLabel.setText(title);

		Group panel = new Group(composite, SWT.NONE);
		panel.setLayout(new GridLayout(1, false));
		panel.setLayoutData(new GridData(GridData.FILL, GridData.FILL, true, true));

		TabFolder ndsFolder = new TabFolder(panel, SWT.NONE);
		ndsFolder.setLayoutData(new GridData(GridData.FILL, GridData.FILL,
				true, true));

		Group imageGroup = new Group(ndsFolder, SWT.NONE);
		imageGroup.setLayout(new GridLayout(2, false));
		imageGroup.setLayoutData(new GridData(GridData.FILL, GridData.FILL,
				true, true));
		
		Group userGroup = new Group(ndsFolder, SWT.NONE);
		userGroup.setLayout(new GridLayout(1, false));
		userGroup.setLayoutData(new GridData(GridData.FILL, GridData.FILL,
				true, true));
		lefty = new Button(userGroup, SWT.CHECK);
		lefty.setText("lefty");
		lefty.setToolTipText("lefty, right handed otherwise");
		landscape = new Button(userGroup, SWT.CHECK);
		landscape.setText("landscape");
		landscape.setToolTipText("landscape, portrait otherwise");
		soundsEffect = new Button(userGroup, SWT.CHECK);
		soundsEffect.setText("sounds effect");
		soundsEffect.setToolTipText("sound effects will be performed on user interaction");
		startupSound = new Button(userGroup, SWT.CHECK);
		startupSound.setText("startup sound");
		startupSound.setToolTipText("plays a welcome sound (\"welcome to comicbookds\") at application startup");
		resizeFilter = new Button(userGroup, SWT.CHECK);
		resizeFilter.setText("resize filter");
		resizeFilter.setToolTipText("use filters to resize the image (nicer but require a second image display)");
		screenspace = new Button(userGroup, SWT.CHECK);
		screenspace.setText("screen space");
		screenspace.setToolTipText("reflects the screen space between the top and bottom images");
		scrollChange = new Button(userGroup, SWT.CHECK);
		scrollChange.setText("scroll change");
		scrollChange.setToolTipText("a scroll action (with key presses) while viewing the last image part triggers a page change");
		iconLock = new Button(userGroup, SWT.CHECK);
		iconLock.setText("icon locked");
		iconLock.setToolTipText("locks the icons (they remain visible on screen)");
		transitionAnim = new Button(userGroup, SWT.CHECK);
		transitionAnim.setText("transition animated");
		transitionAnim.setToolTipText("animate the transitions");
		iconAnim = new Button(userGroup, SWT.CHECK);
		iconAnim.setText("icon animated");
		iconAnim.setToolTipText("animate the icons");
		waitForKeyRelease = new Button(userGroup, SWT.CHECK);
		waitForKeyRelease.setText("wait key release");
		waitForKeyRelease.setToolTipText("In thumbnails and library modes: Wait for the key to be released before switching to next element");
		progressiveScroll = new Button(userGroup, SWT.CHECK);
		progressiveScroll.setText("progressive scroll");
		progressiveScroll.setToolTipText("One pixel scroll at the begining, then quicker until the max value (scroll incr.)");
		Label scrollLabel = new Label(userGroup, SWT.NONE);
		scrollLabel.setText("scroll increment:");
		scrollIncrement = new Text(userGroup, SWT.BORDER);
		scrollIncrement.setLayoutData(new GridData(GridData.FILL, GridData.VERTICAL_ALIGN_CENTER, true, false));
		scrollIncrement.setToolTipText("defines the scroll increment in pixels");
		Label zoomLabel = new Label(userGroup, SWT.NONE);
		zoomLabel.setText("zoom increment:");
		zoomIncrement = new Text(userGroup, SWT.BORDER);
		zoomIncrement.setLayoutData(new GridData(GridData.FILL, GridData.VERTICAL_ALIGN_CENTER, true, false));
		zoomIncrement.setToolTipText("defines the zoom increment (the higher the value is, the quicker the zoom will be)");

		TabItem userItem = new TabItem(ndsFolder, SWT.NONE);
		userItem.setText("Preferences");
		userItem.setControl(userGroup);

//		Group buttonConfigGroup = new Group(ndsFolder, SWT.NONE);
//		buttonConfigGroup.setLayout(new GridLayout(2, false));
//		buttonConfigGroup.setLayoutData(new GridData(GridData.FILL, GridData.FILL,
//				true, true));
//		TabItem buttonConfigItem = new TabItem(ndsFolder, SWT.NONE);
//		buttonConfigItem.setText("Button Config");
//		buttonConfigItem.setControl(buttonConfigGroup);
//		
//		Label configLabel = new Label(buttonConfigGroup, SWT.NONE);
//		configLabel.setText("Config");
//		Combo configCombo = new Combo(buttonConfigGroup, SWT.READ_ONLY);
//		configCombo.setItems(new String[] {
//				"Right handed landscape view", "Right handed portrait view",
//				"Right handed landscape thumnails", "Right handed portrait thumnails",
//				"Left handed landscape view", "Left handed portrait view",
//				"Left handed landscape thumnails", "Left handed portrait thumnails",});
//		left = new Label(buttonConfigGroup, SWT.NONE);
//		left.setText("Left");
//		Combo leftCombo = new Combo(buttonConfigGroup, SWT.READ_ONLY);
//		leftCombo.setItems(actionList);
//		right = new Label(buttonConfigGroup, SWT.NONE);
//		right.setText("Right");
//		Combo rightCombo = new Combo(buttonConfigGroup, SWT.READ_ONLY);
//		rightCombo.setItems(actionList);
//		up = new Label(buttonConfigGroup, SWT.NONE);
//		up.setText("Up");
//		Combo upCombo = new Combo(buttonConfigGroup, SWT.READ_ONLY);
//		upCombo.setItems(actionList);
//		down = new Label(buttonConfigGroup, SWT.NONE);
//		down.setText("Down");
//		Combo downCombo = new Combo(buttonConfigGroup, SWT.READ_ONLY);
//		downCombo.setItems(actionList);
//		a = new Label(buttonConfigGroup, SWT.NONE);
//		a.setText("A");
//		Combo aCombo = new Combo(buttonConfigGroup, SWT.READ_ONLY);
//		aCombo.setItems(actionList);
//		b = new Label(buttonConfigGroup, SWT.NONE);
//		b.setText("B");
//		Combo bCombo = new Combo(buttonConfigGroup, SWT.READ_ONLY);
//		bCombo.setItems(actionList);
//		x = new Label(buttonConfigGroup, SWT.NONE);
//		x.setText("X");
//		Combo xCombo = new Combo(buttonConfigGroup, SWT.READ_ONLY);
//		xCombo.setItems(actionList);
//		y = new Label(buttonConfigGroup, SWT.NONE);
//		y.setText("Y");
//		Combo yCombo = new Combo(buttonConfigGroup, SWT.READ_ONLY);
//		yCombo.setItems(actionList);
//		l = new Label(buttonConfigGroup, SWT.NONE);
//		l.setText("L");
//		Combo lCombo = new Combo(buttonConfigGroup, SWT.READ_ONLY);
//		lCombo.setItems(actionList);
//		r = new Label(buttonConfigGroup, SWT.NONE);
//		r.setText("R");
//		Combo rCombo = new Combo(buttonConfigGroup, SWT.READ_ONLY);
//		rCombo.setItems(actionList);
//		select = new Label(buttonConfigGroup, SWT.NONE);
//		select.setText("Select");
//		Combo selectCombo = new Combo(buttonConfigGroup, SWT.READ_ONLY);
//		selectCombo.setItems(actionList);
		
		applySettingsToUI(settings);
		return composite;
	}

}
