package org.pictods.ui;


import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.pictods.IPictoDSJobListener;
import org.pictods.NDSSettings;
import org.pictods.Pictods;
import org.pictods.PictodsSettings;
import org.pictods.UserSettings;
import org.util.IProgressMonitor;
import org.util.Log;
import org.util.Maths;
import org.util.Status;

public class PictodsUI extends ApplicationWindow implements IPictoDSJobListener{
	
	private Shell dialogShell;
	private Group listGroup;
	private Group buttonGroup;
	private Table list;
	private Button addFolder, modify, delete, addFile, create;
	private FileDialog fd;
	private DirectoryDialog dd;

	private ProgressBar progressBar;

	private static Pictods biz;
	private int currentIndex;
	private static final int WIDTH = 400;
	private MyProgressMonitor pm;
	private final NDSSettings defaultNdsSettings = new NDSSettings();
	private final UserSettings defaultUserSettings = new UserSettings();
	private final PictodsSettings pictodsSettings = new PictodsSettings();
	private final static String CURRENT_DIR = "../";//System.getProperty("user.dir") + "/";
	private final static String NDS_CONFIG_FILE = "ComicBookDS_book.default.ini";
	private final static String USER_CONFIG_FILE = "ComicBookDS.default.ini";
	private final static String PICTODS_CONFIG_FILE = CURRENT_DIR + "pictods.properties";
	private final static int SRC_FILE_NAME = 0;
	private final static int DEST_FILE_NAME = 1;
	private final static int MANGA = 2;
	private final static int NAME = 3;
	private final static int AUTHOR = 4;
	private final static int PROVIDER = 5;
	private final static int STATUS = 6;
	private static final String[] COLUMN_NAMES = {
		"Input",
		"Output",
		"Manga",
		"Name",
		"Author",
		"Provider",
		"Status"
	};
	private int lastSortColumn= -1;

	/**
	 * Auto-generated main method to display this 
	 * org.eclipse.swt.widgets.Dialog inside a new Shell.
	 */
	public static void main(String[] args) {
		try {
			PictodsUI inst = new PictodsUI(args);
			inst.addStatusLine();
			inst.setBlockOnOpen(true);
			inst.open();
		}
		catch(Throwable th) {
			Log.debug(th);
		}
	}
	
	public int open() {
		return super.open();
	}

	public PictodsUI(String[] files) {
		super(null);
		biz = new Pictods(pictodsSettings);
		File configFile = new File(NDS_CONFIG_FILE);
		if (configFile.exists()) {
			biz.loadNdsSettings(NDS_CONFIG_FILE, defaultNdsSettings);
		}
		configFile = new File(USER_CONFIG_FILE);
		if (configFile.exists()) {
			biz.loadUserSettings(USER_CONFIG_FILE, defaultUserSettings);
		}
		configFile = new File(PICTODS_CONFIG_FILE);
		if (configFile.exists()) {
			biz.loadPictoDSSettings(PICTODS_CONFIG_FILE);
		}
		for (int i = 0; i < files.length; i++) {
			addFiles(files);
		}
	}

	public boolean close() {
		if (new ExitUI(getShell()).open() == Window.OK) {
			biz.clean();
			biz.saveNdsSettings(NDS_CONFIG_FILE, defaultNdsSettings);
			Pictods.SaveUserSettings(USER_CONFIG_FILE, defaultUserSettings);
			biz.savePictoDSSettings(PICTODS_CONFIG_FILE);
			System.exit(0);
		}
		return false;
	}

	/**
	 * @see Dialog#createDialogArea(Composite parent)
	 */
	protected Control createContents(Composite parent) {
		Composite composite = (Composite) super.createContents(parent);
		composite.setLayout(new GridLayout(1, false));

		Menu menuBar = new Menu(dialogShell, SWT.BAR);
		dialogShell.setMenuBar(menuBar);

		MenuItem fileItem = new MenuItem(menuBar, SWT.CASCADE);
		fileItem.setText("File");
		Menu fileMenu = new Menu(fileItem);
		fileItem.setMenu(fileMenu);
//		MenuItem testItem = new MenuItem(fileMenu, SWT.PUSH);
//		testItem.setText("Test NDS file");
//		testItem.addSelectionListener(new SelectionListener() {
//			public void widgetDefaultSelected(SelectionEvent arg0) {
//			}
//			public void widgetSelected(SelectionEvent arg0) {
//				FileDialog fd = new FileDialog(new Shell(Display.getDefault(), SWT.OPEN));
//				fd.setFilterExtensions(new String[] {"*.nds" ,"*.*"});
//				fd.setFilterPath(pictodsSettings.outputPath);
//				String file = fd.open();
//				if (file != null) {
//					try {
//						Runtime.getRuntime().exec("\"" + pictodsSettings.desmumePath + "\" \"" + file + "\"");
//					} catch (IOException e) {
//						Log.debug(e);
//					}
//				}
//			}
//		});
		MenuItem openOutputItem = new MenuItem(fileMenu, SWT.PUSH);
		openOutputItem.setText("Open Output directory");
		openOutputItem.addSelectionListener(new SelectionListener() {
			public void widgetDefaultSelected(SelectionEvent arg0) {
			}
			public void widgetSelected(SelectionEvent arg0) {
				if (!new File(pictodsSettings.outputPath).exists()) {
					MessageDialog.openError(
							getShell(),
							"Pictods error",
							pictodsSettings.outputPath + " not found.Please, check path in options.");
					return;
				}
				try {
					Runtime.getRuntime().exec(
							"\"" +  pictodsSettings.explorerPath + "\" \"" + 
							pictodsSettings.outputPath + "\"");
				} catch (IOException e) {
					Log.debug(e);
				}
			}
		});
		MenuItem loadItem = new MenuItem(fileMenu, SWT.PUSH);
		loadItem.setText("Load PictoDS Settings");
		loadItem.addSelectionListener(new SelectionListener() {
			public void widgetDefaultSelected(SelectionEvent arg0) {
			}
			public void widgetSelected(SelectionEvent arg0) {
				FileDialog fd = new FileDialog(getShell(), SWT.OPEN);
				fd.setFilterExtensions(new String[] {"*.properties" ,"*.*"});
				String file = fd.open();
				if (file != null)
					biz.loadPictoDSSettings(file);
			}
		});
		MenuItem saveItem = new MenuItem(fileMenu, SWT.PUSH);
		saveItem.setText("Save PictoDS Settings");
		saveItem.addSelectionListener(new SelectionListener() {
			public void widgetDefaultSelected(SelectionEvent arg0) {
			}
			public void widgetSelected(SelectionEvent arg0) {
				FileDialog fd = new FileDialog(getShell(), SWT.SAVE);
				fd.setFileName("NewPictods.properties");
				fd.setFilterExtensions(new String[] {"*.properties" ,"*.*"});
				String file = fd.open();
				if (file != null)
					biz.savePictoDSSettings(file);
			}
		});

		MenuItem exitItem = new MenuItem(fileMenu, SWT.PUSH);
		exitItem.setText("Exit");
		exitItem.addSelectionListener(new SelectionListener() {
			public void widgetDefaultSelected(SelectionEvent arg0) {
			}
			public void widgetSelected(SelectionEvent arg0) {
				close();
			}
		});

		MenuItem optionsItem = new MenuItem(menuBar, SWT.CASCADE);
		optionsItem.setText("Options");
		Menu optionsMenu = new Menu(optionsItem);
		optionsItem.setMenu(optionsMenu);
		MenuItem pathItem = new MenuItem(optionsMenu, SWT.PUSH);
		pathItem.setText("Configure Path");
		pathItem.addSelectionListener(new SelectionListener() {
			public void widgetDefaultSelected(SelectionEvent arg0) {
			}
			public void widgetSelected(SelectionEvent arg0) {
				PictoDSSettingsUI inst = new PictoDSSettingsUI(getShell());
				inst.settings = pictodsSettings;
				inst.open();
			}
		});
		MenuItem ndsItem = new MenuItem(optionsMenu, SWT.PUSH);
		ndsItem.setText("NDS Settings");
		ndsItem.addSelectionListener(new SelectionListener() {
			public void widgetDefaultSelected(SelectionEvent arg0) {
			}
			public void widgetSelected(SelectionEvent arg0) {
				NDSSettingsUI inst = new NDSSettingsUI(getShell());
				inst.settings = defaultNdsSettings;
				inst.title = "Default .nds settings:";
				inst.open();
			}
		});
		MenuItem userItem = new MenuItem(optionsMenu, SWT.PUSH);
		userItem.setText("User Settings");
		userItem.addSelectionListener(new SelectionListener() {
			public void widgetDefaultSelected(SelectionEvent arg0) {
			}
			public void widgetSelected(SelectionEvent arg0) {
				UserSettingsUI inst = new UserSettingsUI(getShell());
				inst.settings = defaultUserSettings;
				inst.title = "User settings:";
				inst.open();
			}
		});

		MenuItem helpItem = new MenuItem(menuBar, SWT.CASCADE);
		helpItem.setText("Help");
		Menu helpMenu = new Menu(helpItem);
		helpItem.setMenu(helpMenu);
		MenuItem getFreeCBDSItem = new MenuItem(helpMenu, SWT.PUSH);
		getFreeCBDSItem.setText("Get some free cbds !");
		getFreeCBDSItem.addSelectionListener(new SelectionListener() {
			public void widgetDefaultSelected(SelectionEvent arg0) {
			}
			public void widgetSelected(SelectionEvent arg0) {
				Program.launch("http://cbds.free.fr/");
			}
		});
		MenuItem aboutItem = new MenuItem(helpMenu, SWT.PUSH);
		aboutItem.setText("About");
		aboutItem.addSelectionListener(new SelectionListener() {
			public void widgetDefaultSelected(SelectionEvent arg0) {
			}
			public void widgetSelected(SelectionEvent arg0) {
				new AboutUI(getShell()).open();
			}
		});

		{
			listGroup = new Group(composite, SWT.NONE);
			GridLayout listGroupLayout = new GridLayout();
			listGroupLayout.makeColumnsEqualWidth = false;
			listGroupLayout.numColumns = 2;
			listGroup.setLayoutData(new GridData(GridData.FILL, GridData.FILL, true, true));
			listGroup.setLayout(listGroupLayout);
			{
				list = new Table(
						listGroup,
						SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER |SWT.MULTI | SWT.FULL_SELECTION | SWT.CHECK);
				list.setHeaderVisible(true);
				list.setLinesVisible(true);
				list.setLayoutData(new GridData(GridData.FILL, GridData.FILL, true, true));
				list.addMouseListener(new MouseAdapter() {
					public void mouseDoubleClick(MouseEvent arg0) {
						modifyMouseUp();
					}
				});
				
				int operations = DND.DROP_MOVE | DND.DROP_COPY | DND.DROP_DEFAULT;
				DropTarget target = new DropTarget(list, operations);
//				 Receive data in Text or File format
				final TextTransfer textTransfer = TextTransfer.getInstance();
				final FileTransfer fileTransfer = FileTransfer.getInstance();
				target.setTransfer(new Transfer[] {fileTransfer, textTransfer});
				target.addDropListener(new DropTargetListener() {
					public void dragEnter(DropTargetEvent event) {
						if (event.detail == DND.DROP_DEFAULT) {
							if ((event.operations & DND.DROP_COPY) != 0) {
								event.detail = DND.DROP_COPY;
							} else {
								event.detail = DND.DROP_NONE;
							}
						}
						// will accept text but prefer to have files dropped
						for (int i = 0; i < event.dataTypes.length; i++) {
							if (fileTransfer.isSupportedType(event.dataTypes[i])){
								event.currentDataType = event.dataTypes[i];
								// files should only be copied
								if (event.detail != DND.DROP_COPY) {
									event.detail = DND.DROP_NONE;
								}
								break;
							}
						}
					}
					public void dragOver(DropTargetEvent event) {
						event.feedback = DND.FEEDBACK_SELECT | DND.FEEDBACK_SCROLL;
						if (textTransfer.isSupportedType(event.currentDataType)) {
							// NOTE: on unsupported platforms this will return null
							Object o = textTransfer.nativeToJava(event.currentDataType);
							String t = (String)o;
							if (t != null)
								System.out.println(t);
						}
					}
					public void dragOperationChanged(DropTargetEvent event) {
						if (event.detail == DND.DROP_DEFAULT) {
							if ((event.operations & DND.DROP_COPY) != 0) {
								event.detail = DND.DROP_COPY;
							} else {
								event.detail = DND.DROP_NONE;
							}
						}
						// allow text to be moved but files should only be copied
						if (fileTransfer.isSupportedType(event.currentDataType)){
							if (event.detail != DND.DROP_COPY) {
								event.detail = DND.DROP_NONE;
							}
						}
					}
					public void dragLeave(DropTargetEvent event) {
					}
					public void dropAccept(DropTargetEvent event) {
					}
					public void drop(DropTargetEvent event) {
						if (textTransfer.isSupportedType(event.currentDataType)) {
							String filename = (String)event.data;
							File file = new File(filename);
							if (file.exists()) {
								if (file.isDirectory()) {
									addFolder(filename);
								}
								else if (file.isFile()) {
									addFiles(new String[]{filename});
								}
							}
							return;
						}
						if (fileTransfer.isSupportedType(event.currentDataType)){
							String[] files = (String[])event.data;
							for (int i = 0; i < files.length; i++) {
								String filename = files[i];
								File file = new File(filename);
								if (file.exists()) {
									if (file.isDirectory()) {
										addFolder(filename);
									}
									else if (file.isFile()) {
										addFiles(new String[]{filename});
									}
								}
							}
						}
					}
				});
				
				
				
				for(int i = 0; i < COLUMN_NAMES.length; i++) {
					TableColumn column = new TableColumn(list, SWT.NONE);
					column.setText(COLUMN_NAMES[i]);
					if (i == 0 || i == 1)
						column.setWidth(200);
					else 
						column.setWidth(75);
					final int columnIndex = i;
					column.addSelectionListener(new SelectionAdapter() {
						public void widgetSelected(SelectionEvent e) {
							sort(columnIndex);
						}
					});
				}
			}
			{
				buttonGroup = new Group(listGroup, SWT.NONE);
				GridLayout buttonGroupLayout = new GridLayout();
				buttonGroupLayout.makeColumnsEqualWidth = true;
				buttonGroup.setLayoutData(new GridData(GridData.FILL, GridData.FILL, false, false));
				buttonGroup.setLayout(buttonGroupLayout);
				{
					addFile = new Button(buttonGroup, SWT.PUSH | SWT.CENTER);
					addFile.setLayoutData(new GridData(GridData.FILL, GridData.FILL, false, false));
					addFile.setText("Add File");
					addFile.addMouseListener(new MouseAdapter() {
						public void mouseUp(MouseEvent evt) {
							addFileMouseUp();
						}
					});
				}
				{
					addFolder = new Button(buttonGroup, SWT.PUSH
							| SWT.CENTER);
					addFolder.setLayoutData(new GridData(GridData.FILL, GridData.FILL, false, false));
					addFolder.setText("Add Folder");
					addFolder.addMouseListener(new MouseAdapter() {
						public void mouseUp(MouseEvent evt) {
							addFolderMouseUp();
						}
					});
				}
				{
					delete = new Button(buttonGroup, SWT.PUSH | SWT.CENTER);
					delete.setLayoutData(new GridData(GridData.FILL, GridData.FILL, false, false));
					delete.setText("Delete");
					delete.addMouseListener(new MouseAdapter() {
						public void mouseUp(MouseEvent evt) {
							deleteMouseUp();
						}
					});
				}
				{
					modify = new Button(buttonGroup, SWT.PUSH | SWT.CENTER);
					modify.setLayoutData(new GridData(GridData.FILL, GridData.FILL, false, false));
					modify.setText("Modify");
					modify.addMouseListener(new MouseAdapter() {
						public void mouseUp(MouseEvent evt) {
							modifyMouseUp();
						}
					});
				}
			}
		}
		{
			GridData progressBarLData = new GridData();
			progressBarLData.horizontalAlignment = GridData.FILL;
			
			create = new Button(composite, SWT.PUSH | SWT.CENTER);
			create.setLayoutData(new GridData(GridData.FILL, GridData.FILL, true, false));
			create.setText("PROCEED");
			create.addMouseListener(new MouseAdapter() {
				public void mouseUp(MouseEvent evt) {
//					try {
////						PDFToImage.main(new String[] {
////								"-imageType jpg",
////								"-outputPrefix D:/LegendesEcossaises.pdf",
////								"-startPage 1",
////								"-endPage 2"
////								});
//						PDFToImage.main(new String[] {
//								"D:/LegendesEcossaises.pdf",
//								});
//					} catch (Exception e1) {
//						// TODO Auto-generated catch block
//						e1.printStackTrace();
//					}
					
					//biz.print(new JFrame() , "D:/faq.pdf");
					
//					try {
//						//pdf2Jpg("D:/Data/BDK/Mes test/LegendesEcossaises.pdf", "d:/tmp");
//						pdf2Jpg("D:/manara.pdf", "d:/tmp");
//					} catch (IOException e) {
//						// TODO Auto-generated catch block
//						e.printStackTrace();
//					}
					
					if (!checkPathes())
						return;
					
					if (isCancel()) {
						if (pm != null)
							pm.cancel();
					}
					else {
						if (list.getItemCount() == 0) {
							return;
						}
						int i = 0, count = list.getItems().length;
						for (i = 0; i < count; i++) {
							if (list.getItem(i).getChecked())
								break;
						}
						if (i == count)
							return;
						proceedToCancel();
						proceedMouseUp();
					}
				}
			});
			
			progressBar = new ProgressBar(composite, SWT.NONE);
			progressBar.setLayoutData(progressBarLData);
			progressBar.setVisible(false);
		}
		return composite;
	}

	/**
	 * @see Dialog#configureShell(Shell newShell)
	 */
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		dialogShell = newShell;
		newShell.setText("PictoDS");
		newShell.setImage(new Image(Display.getCurrent() , CURRENT_DIR + "resources/pictods.ico"));
		dialogShell.setMinimumSize(WIDTH, -1);
		fd = new FileDialog(newShell, SWT.MULTI | SWT.OPEN);
		fd.setFilterExtensions(new String[]{
				"*.zip;*.rar;*.cbz;*.cbr;*.pdf",
				"*.*"});
		dd = new DirectoryDialog(newShell, SWT.OPEN);
	}
	
	private void proceedToCancel() {
		create.setText("Cancel");
		progressBar.setVisible(true);
		addFile.setEnabled(false);
		addFolder.setEnabled(false);
		delete.setEnabled(false);
		modify.setEnabled(false);
		list.setEnabled(false);
	}

	private void cancelToProceed() {
		create.setText("PROCEED");
		progressBar.setVisible(false);
		setStatus("");
		progressBar.setSelection(0);
		addFile.setEnabled(true);
		addFolder.setEnabled(true);
		delete.setEnabled(true);
		modify.setEnabled(true);
		list.setEnabled(true);
	}

	private boolean isCancel() {
		return create.getText().equals("Cancel");
	}

	private void addFileMouseUp() {
		if (!pictodsSettings.inputPath.equals("")) {
			fd.setFilterPath(pictodsSettings.inputPath);
		}
		String filename = fd.open();
		if (filename == null) {
			return;
		}
		String parent = new File(filename).getParent();
		parent = parent.replace('\\', '/');
		fd.setFilterPath(parent);
		dd.setFilterPath(parent);
		String[] files = fd.getFileNames();
		for (int i = 0; i < files.length; i++) {
			files[i] = parent + "/" + files[i];
		}
		addFiles(files);
	}

	private void addFiles(String[] filenames) {
		String filename;
		String cbName;
		if (filenames != null) {
			for (int i = 0; i < filenames.length; i++) {
				filename = filenames[i];
				cbName = Pictods.getOutputName(filename);
				NDSSettings newSettings = new NDSSettings(defaultNdsSettings, cbName);
				TableItem newone = new TableItem(list, SWT.CHECK, 0);
				newone.setChecked(true);
				newone.setText(SRC_FILE_NAME, filename);
				newone.setText(MANGA, newSettings.manga == 0?"false":"true");
				newSettings.path = pictodsSettings.outputPath + "/" + Pictods.clearFileName(newSettings.name) + ".cbds";
				newone.setText(DEST_FILE_NAME, newSettings.path);
				newone.setText(NAME, cbName);
				newone.setText(AUTHOR, newSettings.author);
				newone.setText(PROVIDER, newSettings.provider);
				newone.setText(STATUS, "");
				newone.setData(newSettings);
			}
		}
	}
	
	private void addFolderMouseUp() {
		if (!pictodsSettings.inputPath.equals("")) {
			dd.setFilterPath(pictodsSettings.inputPath);
		}
		String dirname = dd.open();
		if (dirname == null)
			return;
		dirname = dirname.replace('\\', '/');
		dd.setFilterPath(dirname);
		fd.setFilterPath(dirname);
		addFolder(dirname);
	}
	
	private void addFolder(String dirname) {
		NDSSettings newSettings = new NDSSettings(defaultNdsSettings, new File(dirname).getName());
		TableItem newone = new TableItem(list, SWT.CHECK, 0);
		newone.setChecked(true);
		newone.setText(SRC_FILE_NAME, dirname);
		newone.setText(MANGA, newSettings.manga == 0?"false":"true");
		newSettings.path = pictodsSettings.outputPath + "/" + Pictods.clearFileName(newSettings.name) + ".cbds";
		newone.setText(DEST_FILE_NAME, newSettings.path);
		newone.setText(NAME, newSettings.name);
		newone.setText(AUTHOR, newSettings.author);
		newone.setText(PROVIDER, newSettings.provider);
		newone.setText(STATUS, "");
		newone.setData(newSettings);
	}

	private void deleteMouseUp() {
		int[] indices = list.getSelectionIndices();
		if (indices.length == 0)
			return;
		list.remove(indices);
		int minidx = Maths.min(indices) - 1;
		if (minidx < 0 && list.getItemCount() > 0)
			minidx = 0;
		list.setSelection(minidx);
	}

	private void modifyMouseUp() {
		int idx = list.getSelectionIndex();
		if (idx == -1)
			return;
		TableItem item = list.getItem(idx);
		NDSSettingsUI ui = new NDSSettingsUI(getShell());
		ui.settings = (NDSSettings) item.getData();
		ui.title = "Settings for " + item.getText(SRC_FILE_NAME) + ":";
		ui.open();
		refreshItem(item);
	}
	
	private void currentFileToNds() {
		if (list.getItem(currentIndex).getChecked()) {
			pm = new MyProgressMonitor();
			//list.setSelection(currentIndex);
			try {
				TableItem currentItem = list.getItem(currentIndex);
				final String src = currentItem.getText(SRC_FILE_NAME);
				final String dest = currentItem.getText(DEST_FILE_NAME);
				currentItem.setText(STATUS, "PENDING");
				final NDSSettings data = (NDSSettings) currentItem.getData();
				final IPictoDSJobListener listener = this;
				new Thread(new Runnable() {
					public void run() {
						pm.setPrefix(src + ": ");
						final Status result = biz.fileToNds(src, dest, data, defaultUserSettings, pictodsSettings, pm, listener);
						if (result.code == Status.ERROR) {
							Display.getDefault().syncExec(new Runnable() {
								public void run() {
									MessageDialog.openError(getShell(), "PictoDS error", result.message);
								}
							});
						}
					}}).start();
			}
			catch(Throwable e) {
				Log.debug(e);
				MessageDialog.openError(getShell(), "PictoDS error", "A problem has occured :(\nPlease, see log traces.");
			}
		}
		else {
			nextJob();
		}
	}
	
	private void nextJob() {
		Display.getDefault().syncExec(new Runnable() {
			public void run() {
				currentIndex++;
				if (currentIndex == list.getItemCount()) {
					cancelToProceed();
					list.setSelection(-1);
					try  {
						playAudioFile(CURRENT_DIR + "resources/smb3_1-up.wav");
					}
					catch(Exception e) {
						Log.debug(e);
					}
					return;
				}
				currentFileToNds();
			}
		});
	}
	
	public void jobFinished(final Status status) {
		Display.getDefault().syncExec(new Runnable() {
			public void run() {
				if (pm.isCanceled()) {
					cancelToProceed();
					list.setSelection(-1);
					return;
				}
				list.getItem(currentIndex).setChecked(false);
				list.getItem(currentIndex).setText(STATUS, status.message);
				nextJob();
			}
		});
	}
	
	private boolean checkPathes() {
		boolean result = true;
//		String tmp = pictodsSettings.unrarPath.trim();
//		int idx = tmp.indexOf(' ');
//		if (idx == -1) {
//			if (!new File(pictodsSettings.unrarPath).exists()) {
//				result = false;
//				MessageDialog.openError(
//						getShell(),
//						"Pictods error",
//						pictodsSettings.unrarPath + " not found.Please, check path in options.");
//			}
//		}
//		else {
//			if (!new File(pictodsSettings.unrarPath.substring(0, idx)).exists()) {
//				result = false;
//				MessageDialog.openError(
//						getShell(),
//						"Pictods error",
//						pictodsSettings.unrarPath + " not found.Please, check path in options.");
//			}
//		}
		if (!new File(pictodsSettings.outputPath).exists()) {
			result = false;
			MessageDialog.openError(
					getShell(),
					"Pictods error",
					pictodsSettings.outputPath + " not found.Please, check path in options.");
		}
		return result;
	}
	
	
	
	private void proceedMouseUp() {
		currentIndex = 0;
		currentFileToNds();
	}
	
	private void refreshItem(TableItem item) {
		NDSSettings set = (NDSSettings) item.getData();
		set.path = pictodsSettings.outputPath + "/" + Pictods.clearFileName(set.name) + ".cbds";
		item.setText(MANGA, set.manga == 0?"false":"true");
		item.setText(DEST_FILE_NAME, set.path);
		item.setText(NAME, set.name);
		item.setText(AUTHOR, set.author);
		item.setText(PROVIDER, set.provider);
	}
	
//	private void playSound(String wavFile) 
//	throws UnsupportedAudioFileException, IOException, LineUnavailableException {
//	AudioInputStream stream = AudioSystem.getAudioInputStream(new File(wavFile));
//	AudioFormat format = stream.getFormat();
//	DataLine.Info info = new DataLine.Info(
//	Clip.class,
//	stream.getFormat(),
//	((int) stream.getFrameLength() * format.getFrameSize()));
//	Clip clip = (Clip) AudioSystem.getLine(info);
//	clip.open(stream);
//	clip.start();
//	clip.close();
//	}

	public void playAudioFile( String fileName ) {
		File soundFile = new File( fileName );
		try {
			// Create a stream from the given file.
			// Throws IOException or UnsupportedAudioFileException
			AudioInputStream audioInputStream = AudioSystem.getAudioInputStream( soundFile );
			// AudioSystem.getAudioInputStream( inputStream ); // alternate audio stream from inputstream
			playAudioStream( audioInputStream );
		} catch ( Exception e ) {
			Log.debug("Problem with file " + fileName);
			Log.debug(e);
		}
	} // playAudioFile

	public static void playAudioStream(AudioInputStream audioInputStream) {
		// Audio format provides information like sample rate, size, channels.
		AudioFormat audioFormat = audioInputStream.getFormat();

		// Open a data line to play our type of sampled audio.
		// Use SourceDataLine for play and TargetDataLine for record.
		DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
		if (!AudioSystem.isLineSupported(info)) {
			Log.debug("Play.playAudioStream does not handle this type of audio on this system.");
			return;
		}
		try {
			// Create a SourceDataLine for play back (throws LineUnavailableException).  
			SourceDataLine dataLine = (SourceDataLine) AudioSystem.getLine(info);
			// The line acquires system resources (throws LineAvailableException).
			dataLine.open(audioFormat);
			// Adjust the volume on the output line.
			if( dataLine.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
				FloatControl volume = (FloatControl) dataLine.getControl(FloatControl.Type.MASTER_GAIN);
				try {
					volume.setValue(70.0F);
				}
				catch(Exception e) { }
			}
			// Allows the line to move data in and out to a port.
			dataLine.start();

			// Create a buffer for moving data from the audio stream to the line.   
			int bufferSize = (int) audioFormat.getSampleRate() * audioFormat.getFrameSize();
			byte [] buffer = new byte[ bufferSize ];

			// Move the data until done or there is an error.
			try {
				int bytesRead = 0;
				while ( bytesRead >= 0 ) {
					bytesRead = audioInputStream.read(buffer, 0, buffer.length);
					if (bytesRead >= 0) {
						// Odd sized sounds throw an exception if we don't write the same amount.
						dataLine.write(buffer, 0, bytesRead);
					}
				}
			} catch (IOException e) {
				Log.debug(e);
			}

			// Continues data line I/O until its buffer is drained.
			dataLine.drain();

			// Closes the data line, freeing any resources such as the audio device.
			dataLine.close();
		} catch (LineUnavailableException e) {
			Log.debug(e);
		}
	}
	
/*	public static void pdf2Jpg(String inputFilePath, String outputPrefix)
	throws IOException
	{
		String imageType = "jpg";
		PDDocument document = null;
		try
		{
			document = PDDocument.load( inputFilePath );

			if( document.isEncrypted() )
			{
//				Could include decryption capability with password provided.
//				Check org.pdfbox.PDFToImage.java in source.
				System.err.println("Please remove password from PDF file");
			}
			else
			{
				List pages = document.getDocumentCatalog().getAllPages();
				for( int i=0; i<pages.size(); i++ )
				{
					ImageOutputStream output = null;
					ImageWriter imageWriter = null;
					try
					{
						PDPage page = (PDPage)pages.get(i);
						BufferedImage image = page.convertToImage();
						String fileName = outputPrefix + (i+1) + "." + imageType;
						output = ImageIO.createImageOutputStream(new File(fileName));

						boolean foundWriter = false;
						Iterator writerIter=ImageIO.getImageWritersByFormatName(imageType);
						while( writerIter.hasNext() && !foundWriter )
						{
							try
							{
								imageWriter = (ImageWriter)writerIter.next();
								ImageWriteParam writerParams = imageWriter.getDefaultWriteParam();
								if(writerParams.canWriteCompressed() )
								{
									writerParams.setCompressionMode(ImageWriteParam.MODE_EXPLICIT);
									writerParams.setCompressionQuality(1.0f);
								}

								imageWriter.setOutput( output );
								imageWriter.write(null,new
										IIOImage(image,null,null),writerParams);
								foundWriter = true;
							}
							catch( IIOException io )
							{
//								ignore exception
							}
							finally
							{
								if( imageWriter != null )
								{
									imageWriter.dispose();
								}
							}
						}
						if( !foundWriter )
						{
							throw new RuntimeException( "No writer found for jpg." );
						}
					}
					finally
					{
						if( output != null )
						{
							output.flush();
							output.close();
						}
					}
				}
			}
		}
		finally
		{
			if( document != null )
			{
				document.close();
			}
		}
	}*/	

	public class MyProgressMonitor implements IProgressMonitor {
		private boolean canceled = false;
		private int selection;
		private String prefix = "";

		public MyProgressMonitor() {
			canceled = false;
		}

		public void setMaximum(final int max) {
			Display.getDefault().syncExec(new Runnable() {
				public void run() {
					progressBar.setMaximum(max);
				}
			});
		}

		public void setSelection(int sel) {
			selection = sel;
			Display.getDefault().syncExec(new Runnable() {
				public void run() {
					progressBar.setSelection(selection);
				}
			});
		}

		public int getSelection() {
			Display.getDefault().syncExec(new Runnable() {
				public void run() {
					selection = progressBar.getSelection();
				}
			});
			return selection;
		}

		public void setText(final String text) {
			Display.getDefault().syncExec(new Runnable() {
				public void run() {
					setStatus(prefix + text);
				}
			});
		}

		public void setPrefix(String prfx) {
			prefix = prfx;
		}

		public void cancel() {
			canceled = true;
		}

		public boolean isCanceled() {
			return canceled;
		}

	}

 	private void sort(int column) {
		if(list.getItemCount() <= 1)	return;

		TableItem[] items = list.getItems();
		String[][] data = new String[items.length][list.getColumnCount()];
		for(int i = 0; i < items.length; i++) {
			for(int j = 0; j < list.getColumnCount(); j++) {
				data[i][j] = items[i].getText(j);
			}
		}
		
		Arrays.sort(data, new RowComparator(column));
		
		if (lastSortColumn != column) {
			for (int i = 0; i < data.length; i++) {
				items[i].setText(data[i]);
			}
			lastSortColumn = column;
		} else {
			// reverse order if the current column is selected again
			int j = data.length -1;
			for (int i = 0; i < data.length; i++) {
				items[i].setText(data[j--]);
			}
			lastSortColumn = -1;
		}
		
	}

	/**
	 * To compare entries (rows) by the given column
	 */
	private class RowComparator implements Comparator<String[]> {
		private int column;
		
		/**
		 * Constructs a RowComparator given the column index
		 * @param col The index (starting at zero) of the column
		 */
		public RowComparator(int col) {
			column = col;
		}
		
		/**
		 * Compares two rows (type String[]) using the specified
		 * column entry.
		 * @param obj1 First row to compare
		 * @param obj2 Second row to compare
		 * @return negative if obj1 less than obj2, positive if
		 * 			obj1 greater than obj2, and zero if equal.
		 */
		public int compare(String[] row1, String[] row2) {
			return row1[column].compareTo(row2[column]);
		}
	}
}
