package org.pictods.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ExitUI extends Dialog {

	private Shell dialogShell;
	private static final int WIDTH = 350;

	public ExitUI(Shell parent) {
		super(parent);
	}
	
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		dialogShell = newShell;
		dialogShell.setText("Exit");
		dialogShell.setImage(new Image(Display.getCurrent() , "../resources/pictods.ico"));
		dialogShell.setMinimumSize(WIDTH, -1);
//		Rectangle displaySize = Display.getCurrent().getBounds();
//		dialogShell.setLocation(new Point(displaySize.width/2 - WIDTH/2, displaySize.height/2 - HEIGHT/2));
	}

	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, "Quit",
				true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	protected Control createDialogArea(Composite parent) {
		Composite composite = (Composite) super.createDialogArea(parent);
		((GridLayout) composite.getLayout()).numColumns = 1;
		
		Group panel = new Group(composite, SWT.NONE);
		panel.setLayout(new GridLayout(1, false));
		panel.setLayoutData(new GridData(GridData.FILL, GridData.FILL, true, true));
		final Label exit = new Label(panel, SWT.NONE);
		exit.setText(
				"        Check http://gnese.free.fr/NDS for a newer version\n\n" +
				"           -- If you wanna support us, click on banners ;) --\n");
		
        exit.addMouseMoveListener(new MouseMoveListener() {
			public void mouseMove(MouseEvent e) {
				if (isOnLink(e.x, e.y)) {
					exit.setCursor(new Cursor(Display.getCurrent(), SWT.CURSOR_HAND));
				}
				else {
					exit.setCursor(new Cursor(Display.getCurrent(), SWT.CURSOR_ARROW));
				}
			}
		});
		exit.addMouseListener(new MouseListener() {
			public void mouseDoubleClick(MouseEvent e) { }
			public void mouseDown(MouseEvent e) { }
			public void mouseUp(MouseEvent e) {
				if (isOnLink(e.x, e.y)) {
					Program.launch("http://gnese.free.fr/NDS");
				}
			}
		});
		
		return composite;
	}
	
	public boolean isOnLink(int x, int y) {
		return x > 55 && x < 175 && y > 2 && y < 10;
	}
	
}
