package org.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class Zip {
	
	
	public static void zipDir(File dir, String zipFileName, int level) throws IOException {
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFileName));
        out.setLevel(level);
		File[] files = dir.listFiles(); 
		byte[] tmpBuf = new byte[1024];
		File file;
		for (int i=0; i< files.length; i++) {
			file = files[i];
			if(file.isDirectory()) { 
				addDir(file, out, file.getName());
		        continue; 
		    } 
            FileInputStream in = new FileInputStream(file.getAbsolutePath()); 
            out.putNextEntry(new ZipEntry(file.getName()));
            // Transfer from the file to the ZIP file 
            int len;
            while((len = in.read(tmpBuf)) > 0) { 
            	out.write(tmpBuf, 0, len); 
            } 
            // Complete the entry 
		    out.closeEntry(); 
		    in.close(); 
		}
        out.close(); 
	}
	
	private static void addDir(File dirObj, ZipOutputStream out, String basename) throws IOException { 
		File[] files = dirObj.listFiles(); 
		byte[] tmpBuf = new byte[1024];
		File file;
		for (int i=0; i< files.length; i++) {
			file = files[i];
			if(file.isDirectory()) {
				if (basename.length() > 0)
					basename = basename + "/";
				addDir(file, out, basename + file.getName());
		        continue; 
		    } 
            FileInputStream in = new FileInputStream(file.getAbsolutePath()); 
            out.putNextEntry(new ZipEntry(basename + "/" + file.getName()));
            // Transfer from the file to the ZIP file 
            int len; 
            while((len = in.read(tmpBuf)) > 0) { 
            	out.write(tmpBuf, 0, len); 
            } 
            // Complete the entry 
		    out.closeEntry(); 
		    in.close(); 
		} 
	} 

}
