/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.carbon.OS;

public class HTMLTransfer
extends ByteArrayTransfer {
    static HTMLTransfer _instance = new HTMLTransfer();
    static final String HTML = "HTML";
    static final int HTMLID = HTMLTransfer.registerType("HTML");

    HTMLTransfer() {
    }

    public static HTMLTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkHTML(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String string = (String)object;
        int count = string.length();
        char[] chars = new char[count];
        string.getChars(0, count, chars, 0);
        byte[] buffer = new byte[chars.length * 2];
        OS.memcpy(buffer, chars, buffer.length);
        transferData.data = new byte[1][];
        transferData.data[0] = buffer;
        transferData.result = 0;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        if (transferData.data.length == 0 || transferData.data[0].length == 0) {
            return null;
        }
        byte[] buffer = transferData.data[0];
        char[] chars = new char[(buffer.length + 1) / 2];
        OS.memcpy(chars, buffer, buffer.length);
        return new String(chars);
    }

    protected int[] getTypeIds() {
        return new int[]{HTMLID};
    }

    protected String[] getTypeNames() {
        return new String[]{HTML};
    }

    boolean checkHTML(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkHTML(object);
    }
}

