/*
 * Decompiled with CFR 0.152.
 */
package org.pictods.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.pictods.Pictods;
import org.pictods.UserSettings;

public class UserSettingsUI
extends Dialog {
    private Shell dialogShell;
    public UserSettings settings;
    private static final int WIDTH = 350;
    private Text scrollIncrement;
    private Text zoomIncrement;
    public String title = "";
    private Button lefty;
    private Button landscape;
    private Button screenspace;
    private Button scrollChange;
    private Button iconLock;
    private Button waitForKeyRelease;
    private Button progressiveScroll;
    private Button transitionAnim;
    private Button iconAnim;
    private Button soundsEffect;
    private Button startupSound;
    private Button resizeFilter;

    public UserSettingsUI(Shell parent) {
        super(parent);
    }

    public void defaultPressed() {
        this.applySettingsToUI(new UserSettings());
        this.applyUIToSettings();
    }

    protected void okPressed() {
        this.applyUIToSettings();
        Pictods.SaveUserSettings(this.settings);
        super.okPressed();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 14) {
            this.defaultPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Generate", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(parent, 14, "Default", false);
    }

    public void applyUIToSettings() {
        try {
            this.settings.soundsEffect = this.soundsEffect.getSelection() ? 1 : 0;
            this.settings.startupSound = this.startupSound.getSelection() ? 1 : 0;
            this.settings.resizeFilter = this.resizeFilter.getSelection() ? 1 : 0;
            this.settings.lefty = this.lefty.getSelection() ? 1 : 0;
            this.settings.scrollChange = this.scrollChange.getSelection() ? 1 : 0;
            this.settings.landscape = this.landscape.getSelection() ? 1 : 0;
            this.settings.screenspace = this.screenspace.getSelection() ? 1 : 0;
            this.settings.iconLock = this.iconLock.getSelection() ? 1 : 0;
            this.settings.waitForKeyRelease = this.waitForKeyRelease.getSelection() ? 1 : 0;
            this.settings.progressiveScroll = this.progressiveScroll.getSelection() ? 1 : 0;
            this.settings.transitionAnim = this.transitionAnim.getSelection() ? 1 : 0;
            this.settings.iconAnim = this.iconAnim.getSelection() ? 1 : 0;
            this.settings.scrollIncrement = Integer.parseInt(this.scrollIncrement.getText());
            this.settings.zoomIncrement = Integer.parseInt(this.zoomIncrement.getText());
        }
        catch (NumberFormatException e) {
            MessageDialog.openError((Shell)this.dialogShell, (String)"Pictods error", (String)"Bad value. Please, check fields.");
        }
    }

    public void applySettingsToUI(UserSettings set) {
        this.soundsEffect.setSelection(set.soundsEffect != 0);
        this.startupSound.setSelection(set.startupSound != 0);
        this.resizeFilter.setSelection(set.resizeFilter != 0);
        this.lefty.setSelection(set.lefty != 0);
        this.scrollChange.setSelection(set.scrollChange != 0);
        this.landscape.setSelection(set.landscape != 0);
        this.screenspace.setSelection(set.screenspace != 0);
        this.iconLock.setSelection(set.iconLock != 0);
        this.waitForKeyRelease.setSelection(set.waitForKeyRelease != 0);
        this.progressiveScroll.setSelection(set.progressiveScroll != 0);
        this.transitionAnim.setSelection(set.transitionAnim != 0);
        this.iconAnim.setSelection(set.iconAnim != 0);
        this.scrollIncrement.setText("" + set.scrollIncrement);
        this.zoomIncrement.setText("" + set.zoomIncrement);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.dialogShell = newShell;
        this.dialogShell.setText("User Settings");
        this.dialogShell.setImage(new Image((Device)Display.getCurrent(), "../resources/pictods.ico"));
        this.dialogShell.setLayout((Layout)new GridLayout(1, false));
        this.dialogShell.setMinimumSize(350, -1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 1;
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText(this.title);
        Group panel = new Group(composite, 0);
        panel.setLayout((Layout)new GridLayout(1, false));
        panel.setLayoutData((Object)new GridData(4, 4, true, true));
        TabFolder ndsFolder = new TabFolder((Composite)panel, 0);
        ndsFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        Group imageGroup = new Group((Composite)ndsFolder, 0);
        imageGroup.setLayout((Layout)new GridLayout(2, false));
        imageGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        Group userGroup = new Group((Composite)ndsFolder, 0);
        userGroup.setLayout((Layout)new GridLayout(1, false));
        userGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.lefty = new Button((Composite)userGroup, 32);
        this.lefty.setText("lefty");
        this.lefty.setToolTipText("lefty, right handed otherwise");
        this.landscape = new Button((Composite)userGroup, 32);
        this.landscape.setText("landscape");
        this.landscape.setToolTipText("landscape, portrait otherwise");
        this.soundsEffect = new Button((Composite)userGroup, 32);
        this.soundsEffect.setText("sounds effect");
        this.soundsEffect.setToolTipText("sound effects will be performed on user interaction");
        this.startupSound = new Button((Composite)userGroup, 32);
        this.startupSound.setText("startup sound");
        this.startupSound.setToolTipText("plays a welcome sound (\"welcome to comicbookds\") at application startup");
        this.resizeFilter = new Button((Composite)userGroup, 32);
        this.resizeFilter.setText("resize filter");
        this.resizeFilter.setToolTipText("use filters to resize the image (nicer but require a second image display)");
        this.screenspace = new Button((Composite)userGroup, 32);
        this.screenspace.setText("screen space");
        this.screenspace.setToolTipText("reflects the screen space between the top and bottom images");
        this.scrollChange = new Button((Composite)userGroup, 32);
        this.scrollChange.setText("scroll change");
        this.scrollChange.setToolTipText("a scroll action (with key presses) while viewing the last image part triggers a page change");
        this.iconLock = new Button((Composite)userGroup, 32);
        this.iconLock.setText("icon locked");
        this.iconLock.setToolTipText("locks the icons (they remain visible on screen)");
        this.transitionAnim = new Button((Composite)userGroup, 32);
        this.transitionAnim.setText("transition animated");
        this.transitionAnim.setToolTipText("animate the transitions");
        this.iconAnim = new Button((Composite)userGroup, 32);
        this.iconAnim.setText("icon animated");
        this.iconAnim.setToolTipText("animate the icons");
        this.waitForKeyRelease = new Button((Composite)userGroup, 32);
        this.waitForKeyRelease.setText("wait key release");
        this.waitForKeyRelease.setToolTipText("In thumbnails and library modes: Wait for the key to be released before switching to next element");
        this.progressiveScroll = new Button((Composite)userGroup, 32);
        this.progressiveScroll.setText("progressive scroll");
        this.progressiveScroll.setToolTipText("One pixel scroll at the begining, then quicker until the max value (scroll incr.)");
        Label scrollLabel = new Label((Composite)userGroup, 0);
        scrollLabel.setText("scroll increment:");
        this.scrollIncrement = new Text((Composite)userGroup, 2048);
        this.scrollIncrement.setLayoutData((Object)new GridData(4, 4, true, false));
        this.scrollIncrement.setToolTipText("defines the scroll increment in pixels");
        Label zoomLabel = new Label((Composite)userGroup, 0);
        zoomLabel.setText("zoom increment:");
        this.zoomIncrement = new Text((Composite)userGroup, 2048);
        this.zoomIncrement.setLayoutData((Object)new GridData(4, 4, true, false));
        this.zoomIncrement.setToolTipText("defines the zoom increment (the higher the value is, the quicker the zoom will be)");
        TabItem userItem = new TabItem(ndsFolder, 0);
        userItem.setText("Preferences");
        userItem.setControl((Control)userGroup);
        this.applySettingsToUI(this.settings);
        return composite;
    }
}

