/*
 * Decompiled with CFR 0.152.
 */
package org.pictods.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.pictods.NDSSettings;

public class NDSSettingsUI
extends Dialog {
    private Shell dialogShell;
    public NDSSettings settings;
    private static final int WIDTH = 350;
    private Text iWidth;
    private Text iHeight;
    private Text iSize;
    private Text oWidth;
    private Text oHeight;
    private Text oSize;
    private Text thWidth;
    private Text thHeight;
    private Text thSize;
    private Text name;
    private Text author;
    private Text provider;
    private Combo iQuality;
    private Combo oQuality;
    private Combo thQuality;
    public String title = "";
    private Button manga;

    public NDSSettingsUI(Shell parent) {
        super(parent);
    }

    public void defaultPressed() {
        this.applySettingsToUI(new NDSSettings());
        this.applyUIToSettings();
    }

    protected void okPressed() {
        this.applyUIToSettings();
        super.okPressed();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 14) {
            this.defaultPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(parent, 14, "Default", false);
    }

    public void applyUIToSettings() {
        try {
            this.settings.iWidth = Integer.parseInt(this.iWidth.getText());
            this.settings.iHeight = Integer.parseInt(this.iHeight.getText());
            this.settings.iSize = Integer.parseInt(this.iSize.getText());
            this.settings.iQuality = Integer.parseInt(this.thQuality.getItem(this.iQuality.getSelectionIndex()));
            this.settings.oWidth = Integer.parseInt(this.oWidth.getText());
            this.settings.oHeight = Integer.parseInt(this.oHeight.getText());
            this.settings.oSize = Integer.parseInt(this.oSize.getText());
            this.settings.oQuality = Integer.parseInt(this.thQuality.getItem(this.oQuality.getSelectionIndex()));
            this.settings.thWidth = Integer.parseInt(this.thWidth.getText());
            this.settings.thHeight = Integer.parseInt(this.thHeight.getText());
            this.settings.thSize = Integer.parseInt(this.thSize.getText());
            this.settings.thQuality = Integer.parseInt(this.thQuality.getItem(this.thQuality.getSelectionIndex()));
            int n = this.settings.manga = this.manga.getSelection() ? 1 : 0;
            if (this.name.isEnabled()) {
                this.settings.name = this.name.getText();
            }
            if (this.author.isEnabled()) {
                this.settings.author = this.author.getText();
            }
            if (this.provider.isEnabled()) {
                this.settings.provider = this.provider.getText();
            }
        }
        catch (NumberFormatException e) {
            MessageDialog.openError((Shell)this.dialogShell, (String)"Pictods error", (String)"Bad value. Please, check fields.");
        }
    }

    public void applySettingsToUI(NDSSettings set) {
        this.iWidth.setText("" + set.iWidth);
        this.iHeight.setText("" + set.iHeight);
        this.iSize.setText("" + set.iSize);
        this.iQuality.select(set.iQuality / 10 - 1);
        this.oWidth.setText("" + set.oWidth);
        this.oHeight.setText("" + set.oHeight);
        this.oSize.setText("" + set.oSize);
        this.oQuality.select(set.oQuality / 10 - 1);
        this.thWidth.setText("" + set.thWidth);
        this.thHeight.setText("" + set.thHeight);
        this.thSize.setText("" + set.thSize);
        this.thQuality.select(set.thQuality / 10 - 1);
        this.manga.setSelection(set.manga != 0);
        if (set.name == null) {
            this.name.setEnabled(false);
        } else {
            this.name.setText(set.name);
        }
        this.author.setText(set.author);
        this.provider.setText(set.provider);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.dialogShell = newShell;
        this.dialogShell.setText("NDS Settings");
        this.dialogShell.setImage(new Image((Device)Display.getCurrent(), "../resources/pictods.ico"));
        this.dialogShell.setLayout((Layout)new GridLayout(1, false));
        this.dialogShell.setMinimumSize(350, -1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 1;
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText(this.title);
        Group panel = new Group(composite, 0);
        panel.setLayout((Layout)new GridLayout(1, false));
        panel.setLayoutData((Object)new GridData(4, 4, true, true));
        TabFolder ndsFolder = new TabFolder((Composite)panel, 0);
        ndsFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        Group imageGroup = new Group((Composite)ndsFolder, 0);
        imageGroup.setLayout((Layout)new GridLayout(2, false));
        imageGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        TabItem imageItem = new TabItem(ndsFolder, 0);
        imageItem.setText("Image");
        imageItem.setControl((Control)imageGroup);
        Label widthLabel = new Label((Composite)imageGroup, 0);
        widthLabel.setText("Width:");
        this.iWidth = new Text((Composite)imageGroup, 2048);
        this.iWidth.setLayoutData((Object)new GridData(4, 4, true, false));
        Label heightLabel = new Label((Composite)imageGroup, 0);
        heightLabel.setText("Height:");
        this.iHeight = new Text((Composite)imageGroup, 2048);
        this.iHeight.setLayoutData((Object)new GridData(4, 4, true, false));
        Label maxLabel = new Label((Composite)imageGroup, 0);
        maxLabel.setText("Max Size:");
        this.iSize = new Text((Composite)imageGroup, 2048);
        this.iSize.setLayoutData((Object)new GridData(4, 4, true, false));
        Label qualityLabel = new Label((Composite)imageGroup, 0);
        qualityLabel.setText("Quality:");
        this.iQuality = new Combo((Composite)imageGroup, 2048);
        this.iQuality.setItems(new String[]{"10", "20", "30", "40", "50", "60", "70", "80", "90"});
        Group overviewGroup = new Group((Composite)ndsFolder, 0);
        overviewGroup.setLayout((Layout)new GridLayout(2, false));
        overviewGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        TabItem overviewItem = new TabItem(ndsFolder, 0);
        overviewItem.setText("Overview");
        overviewItem.setControl((Control)overviewGroup);
        Label owidthLabel = new Label((Composite)overviewGroup, 0);
        owidthLabel.setText("Width:");
        this.oWidth = new Text((Composite)overviewGroup, 2048);
        this.oWidth.setEnabled(false);
        Label oheightLabel = new Label((Composite)overviewGroup, 0);
        oheightLabel.setText("Height:");
        this.oHeight = new Text((Composite)overviewGroup, 2048);
        this.oHeight.setEnabled(false);
        Label omaxLabel = new Label((Composite)overviewGroup, 0);
        omaxLabel.setText("Max Size:");
        this.oSize = new Text((Composite)overviewGroup, 2048);
        this.oSize.setEnabled(false);
        Label oqualityLabel = new Label((Composite)overviewGroup, 0);
        oqualityLabel.setText("Quality:");
        this.oQuality = new Combo((Composite)overviewGroup, 2048);
        this.oQuality.setItems(new String[]{"10", "20", "30", "40", "50", "60", "70", "80", "90"});
        Group thumnailGroup = new Group((Composite)ndsFolder, 0);
        thumnailGroup.setLayout((Layout)new GridLayout(2, false));
        thumnailGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        TabItem thumbnailItem = new TabItem(ndsFolder, 0);
        thumbnailItem.setText("Thumbnail");
        thumbnailItem.setControl((Control)thumnailGroup);
        Label thwidthLabel = new Label((Composite)thumnailGroup, 0);
        thwidthLabel.setText("Width:");
        this.thWidth = new Text((Composite)thumnailGroup, 2048);
        this.thWidth.setEnabled(false);
        Label thheightLabel = new Label((Composite)thumnailGroup, 0);
        thheightLabel.setText("Height:");
        this.thHeight = new Text((Composite)thumnailGroup, 2048);
        this.thHeight.setEnabled(false);
        Label thmaxLabel = new Label((Composite)thumnailGroup, 0);
        thmaxLabel.setText("Max Size:");
        this.thSize = new Text((Composite)thumnailGroup, 2048);
        this.thSize.setEnabled(false);
        Label thqualityLabel = new Label((Composite)thumnailGroup, 0);
        thqualityLabel.setText("Quality:");
        this.thQuality = new Combo((Composite)thumnailGroup, 2048);
        this.thQuality.setItems(new String[]{"10", "20", "30", "40", "50", "60", "70", "80", "90"});
        Group outputGroup = new Group((Composite)ndsFolder, 0);
        outputGroup.setLayout((Layout)new GridLayout(1, false));
        outputGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        TabItem outputItem = new TabItem(ndsFolder, 0);
        outputItem.setText("Output");
        outputItem.setControl((Control)outputGroup);
        Label nameLabel = new Label((Composite)outputGroup, 0);
        nameLabel.setText("Name:");
        this.name = new Text((Composite)outputGroup, 2048);
        this.name.setLayoutData((Object)new GridData(4, 4, true, false));
        Label authorLabel = new Label((Composite)outputGroup, 0);
        authorLabel.setText("Author:");
        this.author = new Text((Composite)outputGroup, 2048);
        this.author.setLayoutData((Object)new GridData(4, 4, true, false));
        Label providerLabel = new Label((Composite)outputGroup, 0);
        providerLabel.setText("Provider:");
        this.provider = new Text((Composite)outputGroup, 2048);
        this.provider.setLayoutData((Object)new GridData(4, 4, true, false));
        Label modeLabel = new Label((Composite)outputGroup, 0);
        modeLabel.setText("Mode:");
        this.manga = new Button((Composite)outputGroup, 32);
        this.manga.setText("manga");
        this.manga.setToolTipText("right to left mode, left to right otherwise");
        this.applySettingsToUI(this.settings);
        return composite;
    }
}

