/*
 * Decompiled with CFR 0.152.
 */
package org.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class Zip {
    public static void zipDir(File dir, String zipFileName, int level) throws IOException {
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFileName));
        out.setLevel(level);
        File[] files = dir.listFiles();
        byte[] tmpBuf = new byte[1024];
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                Zip.addDir(file, out, file.getName());
            } else {
                int len;
                FileInputStream in = new FileInputStream(file.getAbsolutePath());
                out.putNextEntry(new ZipEntry(file.getName()));
                while ((len = in.read(tmpBuf)) > 0) {
                    out.write(tmpBuf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            ++i;
        }
        out.close();
    }

    private static void addDir(File dirObj, ZipOutputStream out, String basename) throws IOException {
        File[] files = dirObj.listFiles();
        byte[] tmpBuf = new byte[1024];
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                if (basename.length() > 0) {
                    basename = String.valueOf(basename) + "/";
                }
                Zip.addDir(file, out, String.valueOf(basename) + file.getName());
            } else {
                int len;
                FileInputStream in = new FileInputStream(file.getAbsolutePath());
                out.putNextEntry(new ZipEntry(String.valueOf(basename) + "/" + file.getName()));
                while ((len = in.read(tmpBuf)) > 0) {
                    out.write(tmpBuf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            ++i;
        }
    }
}

