/*
 * Decompiled with CFR 0.152.
 */
package org.pictods.ui;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.pictods.IPictoDSJobListener;
import org.pictods.NDSSettings;
import org.pictods.Pictods;
import org.pictods.PictodsSettings;
import org.pictods.UserSettings;
import org.pictods.ui.AboutUI;
import org.pictods.ui.ExitUI;
import org.pictods.ui.NDSSettingsUI;
import org.pictods.ui.PictoDSSettingsUI;
import org.pictods.ui.UserSettingsUI;
import org.util.IProgressMonitor;
import org.util.Log;
import org.util.Maths;
import org.util.Status;

public class PictodsUI
extends ApplicationWindow
implements IPictoDSJobListener {
    private Shell dialogShell;
    private Group listGroup;
    private Group buttonGroup;
    private Table list;
    private Button addFolder;
    private Button modify;
    private Button delete;
    private Button addFile;
    private Button create;
    private FileDialog fd;
    private DirectoryDialog dd;
    private ProgressBar progressBar;
    private static Pictods biz;
    private int currentIndex;
    private static final int WIDTH = 400;
    private MyProgressMonitor pm;
    private final NDSSettings defaultNdsSettings = new NDSSettings();
    private final UserSettings defaultUserSettings = new UserSettings();
    private final PictodsSettings pictodsSettings = new PictodsSettings();
    private static final String CURRENT_DIR = "../";
    private static final String NDS_CONFIG_FILE = "ComicBookDS_book.default.ini";
    private static final String USER_CONFIG_FILE = "ComicBookDS.default.ini";
    private static final String PICTODS_CONFIG_FILE = "../pictods.properties";
    private static final int SRC_FILE_NAME = 0;
    private static final int DEST_FILE_NAME = 1;
    private static final int MANGA = 2;
    private static final int NAME = 3;
    private static final int AUTHOR = 4;
    private static final int PROVIDER = 5;
    private static final int STATUS = 6;
    private static final String[] COLUMN_NAMES;
    private int lastSortColumn = -1;

    static {
        COLUMN_NAMES = new String[]{"Input", "Output", "Manga", "Name", "Author", "Provider", "Status"};
    }

    public static void main(String[] args) {
        try {
            PictodsUI inst = new PictodsUI(args);
            inst.addStatusLine();
            inst.setBlockOnOpen(true);
            inst.open();
        }
        catch (Throwable th) {
            Log.debug(th);
        }
    }

    public int open() {
        return super.open();
    }

    public PictodsUI(String[] files) {
        super(null);
        biz = new Pictods(this.pictodsSettings);
        File configFile = new File(NDS_CONFIG_FILE);
        if (configFile.exists()) {
            biz.loadNdsSettings(NDS_CONFIG_FILE, this.defaultNdsSettings);
        }
        if ((configFile = new File(USER_CONFIG_FILE)).exists()) {
            biz.loadUserSettings(USER_CONFIG_FILE, this.defaultUserSettings);
        }
        if ((configFile = new File(PICTODS_CONFIG_FILE)).exists()) {
            biz.loadPictoDSSettings(PICTODS_CONFIG_FILE);
        }
        int i = 0;
        while (i < files.length) {
            this.addFiles(files);
            ++i;
        }
    }

    public boolean close() {
        if (new ExitUI(this.getShell()).open() == 0) {
            biz.clean();
            biz.saveNdsSettings(NDS_CONFIG_FILE, this.defaultNdsSettings);
            Pictods.SaveUserSettings(USER_CONFIG_FILE, this.defaultUserSettings);
            biz.savePictoDSSettings(PICTODS_CONFIG_FILE);
            System.exit(0);
        }
        return false;
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        Menu menuBar = new Menu((Decorations)this.dialogShell, 2);
        this.dialogShell.setMenuBar(menuBar);
        MenuItem fileItem = new MenuItem(menuBar, 64);
        fileItem.setText("File");
        Menu fileMenu = new Menu(fileItem);
        fileItem.setMenu(fileMenu);
        MenuItem openOutputItem = new MenuItem(fileMenu, 8);
        openOutputItem.setText("Open Output directory");
        openOutputItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                if (!new File(((PictodsUI)PictodsUI.this).pictodsSettings.outputPath).exists()) {
                    MessageDialog.openError((Shell)PictodsUI.this.getShell(), (String)"Pictods error", (String)(String.valueOf(((PictodsUI)PictodsUI.this).pictodsSettings.outputPath) + " not found.Please, check path in options."));
                    return;
                }
                try {
                    Runtime.getRuntime().exec("\"" + ((PictodsUI)PictodsUI.this).pictodsSettings.explorerPath + "\" \"" + ((PictodsUI)PictodsUI.this).pictodsSettings.outputPath + "\"");
                }
                catch (IOException e) {
                    Log.debug(e);
                }
            }
        });
        MenuItem loadItem = new MenuItem(fileMenu, 8);
        loadItem.setText("Load PictoDS Settings");
        loadItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                FileDialog fd = new FileDialog(PictodsUI.this.getShell(), 4096);
                fd.setFilterExtensions(new String[]{"*.properties", "*.*"});
                String file = fd.open();
                if (file != null) {
                    biz.loadPictoDSSettings(file);
                }
            }
        });
        MenuItem saveItem = new MenuItem(fileMenu, 8);
        saveItem.setText("Save PictoDS Settings");
        saveItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                FileDialog fd = new FileDialog(PictodsUI.this.getShell(), 8192);
                fd.setFileName("NewPictods.properties");
                fd.setFilterExtensions(new String[]{"*.properties", "*.*"});
                String file = fd.open();
                if (file != null) {
                    biz.savePictoDSSettings(file);
                }
            }
        });
        MenuItem exitItem = new MenuItem(fileMenu, 8);
        exitItem.setText("Exit");
        exitItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                PictodsUI.this.close();
            }
        });
        MenuItem optionsItem = new MenuItem(menuBar, 64);
        optionsItem.setText("Options");
        Menu optionsMenu = new Menu(optionsItem);
        optionsItem.setMenu(optionsMenu);
        MenuItem pathItem = new MenuItem(optionsMenu, 8);
        pathItem.setText("Configure Path");
        pathItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                PictoDSSettingsUI inst = new PictoDSSettingsUI(PictodsUI.this.getShell());
                inst.settings = PictodsUI.this.pictodsSettings;
                inst.open();
            }
        });
        MenuItem ndsItem = new MenuItem(optionsMenu, 8);
        ndsItem.setText("NDS Settings");
        ndsItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                NDSSettingsUI inst = new NDSSettingsUI(PictodsUI.this.getShell());
                inst.settings = PictodsUI.this.defaultNdsSettings;
                inst.title = "Default .nds settings:";
                inst.open();
            }
        });
        MenuItem userItem = new MenuItem(optionsMenu, 8);
        userItem.setText("User Settings");
        userItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                UserSettingsUI inst = new UserSettingsUI(PictodsUI.this.getShell());
                inst.settings = PictodsUI.this.defaultUserSettings;
                inst.title = "User settings:";
                inst.open();
            }
        });
        MenuItem helpItem = new MenuItem(menuBar, 64);
        helpItem.setText("Help");
        Menu helpMenu = new Menu(helpItem);
        helpItem.setMenu(helpMenu);
        MenuItem getFreeCBDSItem = new MenuItem(helpMenu, 8);
        getFreeCBDSItem.setText("Get some free cbds !");
        getFreeCBDSItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                Program.launch((String)"http://cbds.free.fr/");
            }
        });
        MenuItem aboutItem = new MenuItem(helpMenu, 8);
        aboutItem.setText("About");
        aboutItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                new AboutUI(PictodsUI.this.getShell()).open();
            }
        });
        this.listGroup = new Group(composite, 0);
        GridLayout listGroupLayout = new GridLayout();
        listGroupLayout.makeColumnsEqualWidth = false;
        listGroupLayout.numColumns = 2;
        this.listGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.listGroup.setLayout((Layout)listGroupLayout);
        this.list = new Table((Composite)this.listGroup, 68386);
        this.list.setHeaderVisible(true);
        this.list.setLinesVisible(true);
        this.list.setLayoutData((Object)new GridData(4, 4, true, true));
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                PictodsUI.this.modifyMouseUp();
            }
        });
        int operations = 19;
        DropTarget target = new DropTarget((Control)this.list, operations);
        final TextTransfer textTransfer = TextTransfer.getInstance();
        final FileTransfer fileTransfer = FileTransfer.getInstance();
        target.setTransfer(new Transfer[]{fileTransfer, textTransfer});
        target.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
                int i = 0;
                while (i < event.dataTypes.length) {
                    if (fileTransfer.isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        if (event.detail == 1) break;
                        event.detail = 0;
                        break;
                    }
                    ++i;
                }
            }

            public void dragOver(DropTargetEvent event) {
                Object o;
                String t;
                event.feedback = 9;
                if (textTransfer.isSupportedType(event.currentDataType) && (t = (String)(o = textTransfer.nativeToJava(event.currentDataType))) != null) {
                    System.out.println(t);
                }
            }

            public void dragOperationChanged(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
                if (fileTransfer.isSupportedType(event.currentDataType) && event.detail != 1) {
                    event.detail = 0;
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dropAccept(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                if (textTransfer.isSupportedType(event.currentDataType)) {
                    String filename = (String)event.data;
                    File file = new File(filename);
                    if (file.exists()) {
                        if (file.isDirectory()) {
                            PictodsUI.this.addFolder(filename);
                        } else if (file.isFile()) {
                            PictodsUI.this.addFiles(new String[]{filename});
                        }
                    }
                    return;
                }
                if (fileTransfer.isSupportedType(event.currentDataType)) {
                    String[] files = (String[])event.data;
                    int i = 0;
                    while (i < files.length) {
                        String filename = files[i];
                        File file = new File(filename);
                        if (file.exists()) {
                            if (file.isDirectory()) {
                                PictodsUI.this.addFolder(filename);
                            } else if (file.isFile()) {
                                PictodsUI.this.addFiles(new String[]{filename});
                            }
                        }
                        ++i;
                    }
                }
            }
        });
        int i = 0;
        while (i < COLUMN_NAMES.length) {
            TableColumn column = new TableColumn(this.list, 0);
            column.setText(COLUMN_NAMES[i]);
            if (i == 0 || i == 1) {
                column.setWidth(200);
            } else {
                column.setWidth(75);
            }
            final int columnIndex = i++;
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PictodsUI.this.sort(columnIndex);
                }
            });
        }
        this.buttonGroup = new Group((Composite)this.listGroup, 0);
        GridLayout buttonGroupLayout = new GridLayout();
        buttonGroupLayout.makeColumnsEqualWidth = true;
        this.buttonGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.buttonGroup.setLayout((Layout)buttonGroupLayout);
        this.addFile = new Button((Composite)this.buttonGroup, 0x1000008);
        this.addFile.setLayoutData((Object)new GridData(4, 4, false, false));
        this.addFile.setText("Add File");
        this.addFile.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent evt) {
                PictodsUI.this.addFileMouseUp();
            }
        });
        this.addFolder = new Button((Composite)this.buttonGroup, 0x1000008);
        this.addFolder.setLayoutData((Object)new GridData(4, 4, false, false));
        this.addFolder.setText("Add Folder");
        this.addFolder.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent evt) {
                PictodsUI.this.addFolderMouseUp();
            }
        });
        this.delete = new Button((Composite)this.buttonGroup, 0x1000008);
        this.delete.setLayoutData((Object)new GridData(4, 4, false, false));
        this.delete.setText("Delete");
        this.delete.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent evt) {
                PictodsUI.this.deleteMouseUp();
            }
        });
        this.modify = new Button((Composite)this.buttonGroup, 0x1000008);
        this.modify.setLayoutData((Object)new GridData(4, 4, false, false));
        this.modify.setText("Modify");
        this.modify.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent evt) {
                PictodsUI.this.modifyMouseUp();
            }
        });
        GridData progressBarLData = new GridData();
        progressBarLData.horizontalAlignment = 4;
        this.create = new Button(composite, 0x1000008);
        this.create.setLayoutData((Object)new GridData(4, 4, true, false));
        this.create.setText("PROCEED");
        this.create.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent evt) {
                if (!PictodsUI.this.checkPathes()) {
                    return;
                }
                if (PictodsUI.this.isCancel()) {
                    if (PictodsUI.this.pm != null) {
                        PictodsUI.this.pm.cancel();
                    }
                } else {
                    if (PictodsUI.this.list.getItemCount() == 0) {
                        return;
                    }
                    int i = 0;
                    int count = PictodsUI.this.list.getItems().length;
                    i = 0;
                    while (i < count) {
                        if (PictodsUI.this.list.getItem(i).getChecked()) break;
                        ++i;
                    }
                    if (i == count) {
                        return;
                    }
                    PictodsUI.this.proceedToCancel();
                    PictodsUI.this.proceedMouseUp();
                }
            }
        });
        this.progressBar = new ProgressBar(composite, 0);
        this.progressBar.setLayoutData((Object)progressBarLData);
        this.progressBar.setVisible(false);
        return composite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.dialogShell = newShell;
        newShell.setText("PictoDS");
        newShell.setImage(new Image((Device)Display.getCurrent(), "../resources/pictods.ico"));
        this.dialogShell.setMinimumSize(400, -1);
        this.fd = new FileDialog(newShell, 4098);
        this.fd.setFilterExtensions(new String[]{"*.zip;*.rar;*.cbz;*.cbr;*.pdf", "*.*"});
        this.dd = new DirectoryDialog(newShell, 4096);
    }

    private void proceedToCancel() {
        this.create.setText("Cancel");
        this.progressBar.setVisible(true);
        this.addFile.setEnabled(false);
        this.addFolder.setEnabled(false);
        this.delete.setEnabled(false);
        this.modify.setEnabled(false);
        this.list.setEnabled(false);
    }

    private void cancelToProceed() {
        this.create.setText("PROCEED");
        this.progressBar.setVisible(false);
        this.setStatus("");
        this.progressBar.setSelection(0);
        this.addFile.setEnabled(true);
        this.addFolder.setEnabled(true);
        this.delete.setEnabled(true);
        this.modify.setEnabled(true);
        this.list.setEnabled(true);
    }

    private boolean isCancel() {
        return this.create.getText().equals("Cancel");
    }

    private void addFileMouseUp() {
        String filename;
        if (!this.pictodsSettings.inputPath.equals("")) {
            this.fd.setFilterPath(this.pictodsSettings.inputPath);
        }
        if ((filename = this.fd.open()) == null) {
            return;
        }
        String parent = new File(filename).getParent();
        parent = parent.replace('\\', '/');
        this.fd.setFilterPath(parent);
        this.dd.setFilterPath(parent);
        String[] files = this.fd.getFileNames();
        int i = 0;
        while (i < files.length) {
            files[i] = String.valueOf(parent) + "/" + files[i];
            ++i;
        }
        this.addFiles(files);
    }

    private void addFiles(String[] filenames) {
        if (filenames != null) {
            int i = 0;
            while (i < filenames.length) {
                String filename = filenames[i];
                String cbName = Pictods.getOutputName(filename);
                NDSSettings newSettings = new NDSSettings(this.defaultNdsSettings, cbName);
                TableItem newone = new TableItem(this.list, 32, 0);
                newone.setChecked(true);
                newone.setText(0, filename);
                newone.setText(2, newSettings.manga == 0 ? "false" : "true");
                newSettings.path = String.valueOf(this.pictodsSettings.outputPath) + "/" + Pictods.clearFileName(newSettings.name) + ".cbds";
                newone.setText(1, newSettings.path);
                newone.setText(3, cbName);
                newone.setText(4, newSettings.author);
                newone.setText(5, newSettings.provider);
                newone.setText(6, "");
                newone.setData((Object)newSettings);
                ++i;
            }
        }
    }

    private void addFolderMouseUp() {
        String dirname;
        if (!this.pictodsSettings.inputPath.equals("")) {
            this.dd.setFilterPath(this.pictodsSettings.inputPath);
        }
        if ((dirname = this.dd.open()) == null) {
            return;
        }
        dirname = dirname.replace('\\', '/');
        this.dd.setFilterPath(dirname);
        this.fd.setFilterPath(dirname);
        this.addFolder(dirname);
    }

    private void addFolder(String dirname) {
        NDSSettings newSettings = new NDSSettings(this.defaultNdsSettings, new File(dirname).getName());
        TableItem newone = new TableItem(this.list, 32, 0);
        newone.setChecked(true);
        newone.setText(0, dirname);
        newone.setText(2, newSettings.manga == 0 ? "false" : "true");
        newSettings.path = String.valueOf(this.pictodsSettings.outputPath) + "/" + Pictods.clearFileName(newSettings.name) + ".cbds";
        newone.setText(1, newSettings.path);
        newone.setText(3, newSettings.name);
        newone.setText(4, newSettings.author);
        newone.setText(5, newSettings.provider);
        newone.setText(6, "");
        newone.setData((Object)newSettings);
    }

    private void deleteMouseUp() {
        int[] indices = this.list.getSelectionIndices();
        if (indices.length == 0) {
            return;
        }
        this.list.remove(indices);
        int minidx = Maths.min(indices) - 1;
        if (minidx < 0 && this.list.getItemCount() > 0) {
            minidx = 0;
        }
        this.list.setSelection(minidx);
    }

    private void modifyMouseUp() {
        int idx = this.list.getSelectionIndex();
        if (idx == -1) {
            return;
        }
        TableItem item = this.list.getItem(idx);
        NDSSettingsUI ui = new NDSSettingsUI(this.getShell());
        ui.settings = (NDSSettings)item.getData();
        ui.title = "Settings for " + item.getText(0) + ":";
        ui.open();
        this.refreshItem(item);
    }

    private void currentFileToNds() {
        if (this.list.getItem(this.currentIndex).getChecked()) {
            this.pm = new MyProgressMonitor();
            try {
                TableItem currentItem = this.list.getItem(this.currentIndex);
                final String src = currentItem.getText(0);
                final String dest = currentItem.getText(1);
                currentItem.setText(6, "PENDING");
                final NDSSettings data = (NDSSettings)currentItem.getData();
                final PictodsUI listener = this;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        PictodsUI.this.pm.setPrefix(String.valueOf(src) + ": ");
                        final Status result = biz.fileToNds(src, dest, data, PictodsUI.this.defaultUserSettings, PictodsUI.this.pictodsSettings, PictodsUI.this.pm, listener);
                        if (result.code == 1) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.openError((Shell)PictodsUI.this.getShell(), (String)"PictoDS error", (String)result.message);
                                }
                            });
                        }
                    }
                }).start();
            }
            catch (Throwable e) {
                Log.debug(e);
                MessageDialog.openError((Shell)this.getShell(), (String)"PictoDS error", (String)"A problem has occured :(\nPlease, see log traces.");
            }
        } else {
            this.nextJob();
        }
    }

    private void nextJob() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                PictodsUI pictodsUI = PictodsUI.this;
                pictodsUI.currentIndex = pictodsUI.currentIndex + 1;
                if (PictodsUI.this.currentIndex == PictodsUI.this.list.getItemCount()) {
                    PictodsUI.this.cancelToProceed();
                    PictodsUI.this.list.setSelection(-1);
                    try {
                        PictodsUI.this.playAudioFile("../resources/smb3_1-up.wav");
                    }
                    catch (Exception e) {
                        Log.debug(e);
                    }
                    return;
                }
                PictodsUI.this.currentFileToNds();
            }
        });
    }

    @Override
    public void jobFinished(final Status status) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (PictodsUI.this.pm.isCanceled()) {
                    PictodsUI.this.cancelToProceed();
                    PictodsUI.this.list.setSelection(-1);
                    return;
                }
                PictodsUI.this.list.getItem(PictodsUI.this.currentIndex).setChecked(false);
                PictodsUI.this.list.getItem(PictodsUI.this.currentIndex).setText(6, status.message);
                PictodsUI.this.nextJob();
            }
        });
    }

    private boolean checkPathes() {
        boolean result = true;
        if (!new File(this.pictodsSettings.outputPath).exists()) {
            result = false;
            MessageDialog.openError((Shell)this.getShell(), (String)"Pictods error", (String)(String.valueOf(this.pictodsSettings.outputPath) + " not found.Please, check path in options."));
        }
        return result;
    }

    private void proceedMouseUp() {
        this.currentIndex = 0;
        this.currentFileToNds();
    }

    private void refreshItem(TableItem item) {
        NDSSettings set = (NDSSettings)item.getData();
        set.path = String.valueOf(this.pictodsSettings.outputPath) + "/" + Pictods.clearFileName(set.name) + ".cbds";
        item.setText(2, set.manga == 0 ? "false" : "true");
        item.setText(1, set.path);
        item.setText(3, set.name);
        item.setText(4, set.author);
        item.setText(5, set.provider);
    }

    public void playAudioFile(String fileName) {
        File soundFile = new File(fileName);
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(soundFile);
            PictodsUI.playAudioStream(audioInputStream);
        }
        catch (Exception e) {
            Log.debug("Problem with file " + fileName);
            Log.debug(e);
        }
    }

    public static void playAudioStream(AudioInputStream audioInputStream) {
        AudioFormat audioFormat = audioInputStream.getFormat();
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        if (!AudioSystem.isLineSupported(info)) {
            Log.debug("Play.playAudioStream does not handle this type of audio on this system.");
            return;
        }
        try {
            SourceDataLine dataLine = (SourceDataLine)AudioSystem.getLine(info);
            dataLine.open(audioFormat);
            if (dataLine.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                FloatControl volume = (FloatControl)dataLine.getControl(FloatControl.Type.MASTER_GAIN);
                try {
                    volume.setValue(70.0f);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            dataLine.start();
            int bufferSize = (int)audioFormat.getSampleRate() * audioFormat.getFrameSize();
            byte[] buffer = new byte[bufferSize];
            try {
                int bytesRead = 0;
                while (bytesRead >= 0) {
                    bytesRead = audioInputStream.read(buffer, 0, buffer.length);
                    if (bytesRead < 0) continue;
                    dataLine.write(buffer, 0, bytesRead);
                }
            }
            catch (IOException e) {
                Log.debug(e);
            }
            dataLine.drain();
            dataLine.close();
        }
        catch (LineUnavailableException e) {
            Log.debug(e);
        }
    }

    private void sort(int column) {
        if (this.list.getItemCount() <= 1) {
            return;
        }
        TableItem[] items = this.list.getItems();
        String[][] data = new String[items.length][this.list.getColumnCount()];
        int i = 0;
        while (i < items.length) {
            int j = 0;
            while (j < this.list.getColumnCount()) {
                data[i][j] = items[i].getText(j);
                ++j;
            }
            ++i;
        }
        Arrays.sort(data, new RowComparator(column));
        if (this.lastSortColumn != column) {
            i = 0;
            while (i < data.length) {
                items[i].setText(data[i]);
                ++i;
            }
            this.lastSortColumn = column;
        } else {
            int j = data.length - 1;
            int i2 = 0;
            while (i2 < data.length) {
                items[i2].setText(data[j--]);
                ++i2;
            }
            this.lastSortColumn = -1;
        }
    }

    public class MyProgressMonitor
    implements IProgressMonitor {
        private boolean canceled = false;
        private int selection;
        private String prefix = "";

        @Override
        public void setMaximum(final int max) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    PictodsUI.this.progressBar.setMaximum(max);
                }
            });
        }

        @Override
        public void setSelection(int sel) {
            this.selection = sel;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    PictodsUI.this.progressBar.setSelection(MyProgressMonitor.this.selection);
                }
            });
        }

        @Override
        public int getSelection() {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MyProgressMonitor.this.selection = PictodsUI.this.progressBar.getSelection();
                }
            });
            return this.selection;
        }

        @Override
        public void setText(final String text) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    PictodsUI.this.setStatus(String.valueOf(MyProgressMonitor.this.prefix) + text);
                }
            });
        }

        public void setPrefix(String prfx) {
            this.prefix = prfx;
        }

        @Override
        public void cancel() {
            this.canceled = true;
        }

        @Override
        public boolean isCanceled() {
            return this.canceled;
        }
    }

    private class RowComparator
    implements Comparator<String[]> {
        private int column;

        public RowComparator(int col) {
            this.column = col;
        }

        @Override
        public int compare(String[] row1, String[] row2) {
            return row1[this.column].compareTo(row2[this.column]);
        }
    }
}

