/*
 * Decompiled with CFR 0.152.
 */
package org.pictods;

import com.sun.imageio.plugins.jpeg.JPEGImageWriter;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.pictods.IPictoDSJobListener;
import org.pictods.NDSSettings;
import org.pictods.PictodsSettings;
import org.pictods.UserSettings;
import org.util.FileComparator;
import org.util.IProgressMonitor;
import org.util.Log;
import org.util.Status;
import org.util.StreamGobbler;
import org.util.Zip;

public class Pictods {
    private File tmpDir = new File("../bin/pictodstmp");
    private static final int BUFFER = 256;
    private static PictodsSettings pictodsSettings;
    private static final String VERSION = "210";
    private static final String EOL = "\r\n";
    private static final String COMMENT_NDSINI_INTRO = "; ComicBookDS ini file\r\n";
    private static final String COMMENT_NDSINI_VERSION = "; The compatibility version of this comic book\r\n";
    private static final String COMMENT_NDSINI_NBPAGES = "; The number of pages contained in this comic book\r\n";
    private static final String COMMENT_NDSINI_LEFTTORIGHT = "; Left To Right reading mode [RightToLeft=0,LeftToRight=1]\r\n";
    private static final String COMMENT_NDSINI_CBCREDITS1 = "; 1st line displayed in the credits (usually the ComicBook name)\r\n";
    private static final String COMMENT_NDSINI_CBCREDITS2 = "; 2nd line displayed in the credits (usually the ComicBook author)\r\n";
    private static final String COMMENT_NDSINI_CBCREDITS3 = "; 3rd line displayed in the credits (usually the ComicBook provider)\r\n";
    private static final String COMMENT_USERINI_INTRO = "\r\n";
    private static final String COMMENT_USERINI_LANDSCAPE = "; Set the initial Orientation to Landscape Mode [No=0,Yes=1]\r\n";
    private static final String COMMENT_USERINI_LEFTY = "; Use the Left Handed configuration [RightHanded=0,LeftHanded=1]\r\n";
    private static final String COMMENT_USERINI_SCREENSPACE = "; Reflects the screen space between the top and bottom images [Yes=1,No=0]\r\n";
    private static final String COMMENT_USERINI_RESIZEFILTER = "; Use filters to resize the image (nicer but require a second image display)\r\n";
    private static final String COMMENT_USERINI_SCROLLCHANGE = "; A scroll action (with key presses) while viewing the last image part triggers a page change [Yes=1,No=0]\r\n";
    private static final String COMMENT_USERINI_LOCKICONS = "; Locks the icons (they remain visible on screen) [Yes=1,No=0]\r\n";
    private static final String COMMENT_USERINI_TRANSITIONANIM = "; Animate the transitions [Yes=1,No=0]\r\n";
    private static final String COMMENT_USERINI_ICONSANIM = "; Animate the icons [Yes=1,No=0]\r\n";
    private static final String COMMENT_USERINI_SCROLLINCR = "; Defines the Scroll Increment in pixels\r\n";
    private static final String COMMENT_USERINI_ZOOMINCR = "; Defines the Zoom Increment (The higher the value is, the quicker the zoom will be)\r\n";
    private static final String COMMENT_USERINI_SOUNDSFX = "; Sound effects will be performed on user interaction [No=0,Yes=1]\r\n";
    private static final String COMMENT_USERINI_STARTUPSOUND = "; Plays a welcome sound (\"welcome to comicbookds\") at application startup [No=0,Yes=1]\r\n";
    private static final String COMMENT_USERINI_WAITFORKEYRELEASE = "; In thumbnails and library modes: Wait for the key to be released before switching to next element [No=0,Yes=1]\r\n";
    private static final String COMMENT_USERINI_PROGRESSIVESCROLL = "; One pixel scroll at the begining, then quicker until the max value (ScrollIncrement) [No=0,Yes=1]\r\n";
    private static final String COMMENT_USERINI_KEYS = ";----------------------------------------------------------------------------------\r\n; Here are the different actions to be assigned to a keypress :\r\n;    ScrollRight\r\n;    ScrollLeft\r\n;    ScrollUp\r\n;    ScrollDown\r\n;    ZoomIn\r\n;    ZoomOut\r\n;    NoZoom\r\n;    ZoomPrev\r\n;    RightPage\r\n;    LeftPage\r\n;    UpPage\r\n;    DownPage\r\n;    RightThmbPage\r\n;    LeftThmbPage\r\n;    ChangeMode // Thmbs->Overview->Dual->\r\n;    ChangeViewMode\r\n;    ChangeThmbMode\r\n;    SetModeLibrary  // Library->prevmode->\r\n;    SetModeThumbnails\r\n;    SetModeOverview\r\n;    SetModeDualScreen\r\n;    ChangeOrientation\r\n;    ChangeHand\r\n;    ChangeReading\r\n;    ChangeScreenSpace\r\n;    ChangeLight\r\n;    SetDefaultConf\r\n;    Save\r\n;----------------------------------------------------------------------------------\r\n;RightHanded_Landscape_View\r\nRightHanded_Landscape_View.KEY_Right  = ScrollRight\r\nRightHanded_Landscape_View.KEY_Down   = ScrollDown\r\nRightHanded_Landscape_View.KEY_Up     = ScrollUp\r\nRightHanded_Landscape_View.KEY_Left   = ScrollLeft\r\nRightHanded_Landscape_View.KEY_A      = ChangeViewMode\r\nRightHanded_Landscape_View.KEY_B      = ChangeThmbMode\r\nRightHanded_Landscape_View.KEY_X      = ZoomIn\r\nRightHanded_Landscape_View.KEY_Y      = ZoomOut\r\nRightHanded_Landscape_View.KEY_R      = ChangeOrientation\r\nRightHanded_Landscape_View.KEY_L      = ChangeMode\r\nRightHanded_Landscape_View.KEY_Select = ChangeLight\r\n;RightHanded_Portrait_View\r\nRightHanded_Portrait_View.KEY_Right  = ScrollUp\r\nRightHanded_Portrait_View.KEY_Down   = ScrollRight\r\nRightHanded_Portrait_View.KEY_Up     = ScrollLeft\r\nRightHanded_Portrait_View.KEY_Left   = ScrollDown\r\nRightHanded_Portrait_View.KEY_A      = ChangeViewMode\r\nRightHanded_Portrait_View.KEY_B      = ChangeThmbMode\r\nRightHanded_Portrait_View.KEY_X      = ZoomIn\r\nRightHanded_Portrait_View.KEY_Y      = ZoomOut\r\nRightHanded_Portrait_View.KEY_R      = ChangeOrientation\r\nRightHanded_Portrait_View.KEY_L      = ChangeMode\r\nRightHanded_Portrait_View.KEY_Select = ChangeLight\r\n;RightHanded_Landscape_Thmb\r\nRightHanded_Landscape_Thmb.KEY_Right  = RightPage\r\nRightHanded_Landscape_Thmb.KEY_Down   = DownPage\r\nRightHanded_Landscape_Thmb.KEY_Up     = UpPage\r\nRightHanded_Landscape_Thmb.KEY_Left   = LeftPage\r\nRightHanded_Landscape_Thmb.KEY_A      = ChangeViewMode\r\nRightHanded_Landscape_Thmb.KEY_B      = ChangeThmbMode\r\nRightHanded_Landscape_Thmb.KEY_X      = RightThmbPage\r\nRightHanded_Landscape_Thmb.KEY_Y      = LeftThmbPage\r\nRightHanded_Landscape_Thmb.KEY_R      = ChangeOrientation\r\nRightHanded_Landscape_Thmb.KEY_L      = ChangeMode\r\nRightHanded_Landscape_Thmb.KEY_Select = ChangeLight\r\n;RightHanded_Portrait_Thmb\r\nRightHanded_Portrait_Thmb.KEY_Right  = UpPage\r\nRightHanded_Portrait_Thmb.KEY_Down   = RightPage\r\nRightHanded_Portrait_Thmb.KEY_Up     = LeftPage\r\nRightHanded_Portrait_Thmb.KEY_Left   = DownPage\r\nRightHanded_Portrait_Thmb.KEY_A      = ChangeViewMode\r\nRightHanded_Portrait_Thmb.KEY_B      = ChangeThmbMode\r\nRightHanded_Portrait_Thmb.KEY_X      = LeftThmbPage\r\nRightHanded_Portrait_Thmb.KEY_Y      = RightThmbPage\r\nRightHanded_Portrait_Thmb.KEY_R      = ChangeOrientation\r\nRightHanded_Portrait_Thmb.KEY_L      = ChangeMode\r\nRightHanded_Portrait_Thmb.KEY_Select = ChangeLight\r\n;LeftHanded_Landscape_View\r\nLeftHanded_Landscape_View.KEY_Right  = ZoomOut\r\nLeftHanded_Landscape_View.KEY_Down   = ChangeThmbMode\r\nLeftHanded_Landscape_View.KEY_Up     = ZoomIn\r\nLeftHanded_Landscape_View.KEY_Left   = ChangeViewMode\r\nLeftHanded_Landscape_View.KEY_A      = ScrollRight\r\nLeftHanded_Landscape_View.KEY_B      = ScrollDown\r\nLeftHanded_Landscape_View.KEY_X      = ScrollUp\r\nLeftHanded_Landscape_View.KEY_Y      = ScrollLeft\r\nLeftHanded_Landscape_View.KEY_R      = ChangeMode\r\nLeftHanded_Landscape_View.KEY_L      = ChangeOrientation\r\nLeftHanded_Landscape_View.KEY_Select = ChangeLight\r\n;LeftHanded_Portrait_View\r\nLeftHanded_Portrait_View.KEY_Right  = ZoomOut\r\nLeftHanded_Portrait_View.KEY_Down   = ChangeThmbMode\r\nLeftHanded_Portrait_View.KEY_Up     = ZoomIn\r\nLeftHanded_Portrait_View.KEY_Left   = ChangeViewMode\r\nLeftHanded_Portrait_View.KEY_A      = ScrollDown\r\nLeftHanded_Portrait_View.KEY_B      = ScrollLeft\r\nLeftHanded_Portrait_View.KEY_X      = ScrollRight\r\nLeftHanded_Portrait_View.KEY_Y      = ScrollUp\r\nLeftHanded_Portrait_View.KEY_R      = ChangeMode\r\nLeftHanded_Portrait_View.KEY_L      = ChangeOrientation\r\nLeftHanded_Portrait_View.KEY_Select = ChangeLight\r\n;LeftHanded_Landscape_Thmb\r\nLeftHanded_Landscape_Thmb.KEY_Right  = RightThmbPage\r\nLeftHanded_Landscape_Thmb.KEY_Down   = ChangeThmbMode\r\nLeftHanded_Landscape_Thmb.KEY_Up     = LeftThmbPage\r\nLeftHanded_Landscape_Thmb.KEY_Left   = ChangeViewMode\r\nLeftHanded_Landscape_Thmb.KEY_A      = RightPage\r\nLeftHanded_Landscape_Thmb.KEY_B      = DownPage\r\nLeftHanded_Landscape_Thmb.KEY_X      = UpPage\r\nLeftHanded_Landscape_Thmb.KEY_Y      = LeftPage\r\nLeftHanded_Landscape_Thmb.KEY_R      = ChangeMode\r\nLeftHanded_Landscape_Thmb.KEY_L      = ChangeOrientation\r\nLeftHanded_Landscape_Thmb.KEY_Select = ChangeLight\r\n;LeftHanded_Portrait_Thmb\r\nLeftHanded_Portrait_Thmb.KEY_Right  = LeftThmbPage\r\nLeftHanded_Portrait_Thmb.KEY_Down   = ChangeThmbMode\r\nLeftHanded_Portrait_Thmb.KEY_Up     = RightThmbPage\r\nLeftHanded_Portrait_Thmb.KEY_Left   = ChangeViewMode\r\nLeftHanded_Portrait_Thmb.KEY_A      = DownPage\r\nLeftHanded_Portrait_Thmb.KEY_B      = LeftPage\r\nLeftHanded_Portrait_Thmb.KEY_X      = RightPage\r\nLeftHanded_Portrait_Thmb.KEY_Y      = UpPage\r\nLeftHanded_Portrait_Thmb.KEY_R      = ChangeMode\r\nLeftHanded_Portrait_Thmb.KEY_L      = ChangeOrientation\r\nLeftHanded_Portrait_Thmb.KEY_Select = ChangeLight\r\n";

    public Pictods() {
        this(new PictodsSettings());
    }

    public Pictods(PictodsSettings pathSet) {
        pictodsSettings = pathSet;
        try {
            Log.setOutputStream(new FileOutputStream("pictodslog.txt"));
        }
        catch (FileNotFoundException e) {
            Log.debug(e);
        }
        Log.debug = true;
    }

    public static void main(String[] args) {
        NDSSettings ndsSettings = new NDSSettings();
        UserSettings userSettings = new UserSettings();
        PictodsSettings tmpPictodsSettings = new PictodsSettings();
        Pictods instance = new Pictods();
        if (args.length == 0) {
            System.out.println("\nWelcome to PictoDS command line !\n\nexample of command line:\n\na simple one:\njava -cp org.pictods.jar org.pictods.Pictods c:\\test\\test.cbz\nIn this case the conf and properties files will be the default ones.\n\na litle bit more complex:\njava -cp org.pictods.jar org.pictods.Pictods -userconf:c:\\ComicBookDS.default.ini -pictodsconf:c:\\pictods.properties -ndsconf:c:\\ComicBookDS_book.test1.ini c:\\test\\test1.cbz -ndsconf:c:\\ComicBookDS_book.test2.ini c:\\test\\test2.cbz");
            return;
        }
        int i = 0;
        while (i < args.length) {
            File configFile;
            String param;
            if (args[i].toLowerCase().startsWith("-ndsconf:")) {
                param = args[i].substring("-ndsconf:".length());
                configFile = new File(param);
                if (configFile.exists()) {
                    instance.loadNdsSettings(param, ndsSettings);
                } else {
                    System.out.println(configFile + " not found. Using default one.");
                }
            } else if (args[i].toLowerCase().startsWith("-userconf:")) {
                param = args[i].substring("-userconf:".length());
                configFile = new File(param);
                if (configFile.exists()) {
                    instance.loadUserSettings(param, userSettings);
                } else {
                    System.out.println(configFile + " not found. Using default one.");
                }
            } else if (args[i].toLowerCase().startsWith("-pictodsconf:")) {
                param = args[i].substring("-pictodsconf:".length());
                configFile = new File(param);
                if (configFile.exists()) {
                    tmpPictodsSettings = instance.loadPictoDSSettings(param);
                } else {
                    System.out.println(configFile + " not found. Using default one.");
                }
            } else {
                ndsSettings = new NDSSettings(ndsSettings, Pictods.getOutputName(args[i]));
                ndsSettings.path = String.valueOf(tmpPictodsSettings.outputPath) + "/" + Pictods.clearFileName(ndsSettings.name) + ".cbds";
                instance.fileToNds(args[i], ndsSettings.path, ndsSettings, userSettings, tmpPictodsSettings, new StubProgressMonitor(), null);
            }
            ++i;
        }
    }

    public static final String getOutputName(String filename) {
        int end = (filename = filename.replace('\\', '/')).lastIndexOf(47);
        if (end != -1) {
            filename = filename.substring(end + 1);
        }
        if ((end = filename.lastIndexOf(46)) != -1) {
            filename = filename.substring(0, end);
        }
        return filename;
    }

    public static final String clearFileName(String str) {
        str = str.replace('/', ' ');
        str = str.replace('\\', ' ');
        str = str.replace('<', ' ');
        str = str.replace('>', ' ');
        str = str.replace('*', ' ');
        str = str.replace('?', ' ');
        str = str.replace(':', ' ');
        str = str.replace('|', ' ');
        str = str.replace('\"', ' ');
        return str;
    }

    public Status imagesToNds(File dir, NDSSettings set, IProgressMonitor monitor, boolean recursive) {
        Log.debug("enter imagesToNds with: " + dir.getAbsolutePath());
        monitor.setSelection(33);
        Status result = this.createResizedImages(dir, set, monitor, recursive);
        if (result.code == 1) {
            return result;
        }
        if (monitor.isCanceled()) {
            return Status.OK_STATUS;
        }
        monitor.setSelection(66);
        try {
            this.packageCBDS(set);
        }
        catch (IOException e) {
            Log.debug(e);
            result = new Status(e, e.getMessage(), 1);
        }
        monitor.setSelection(100);
        return result;
    }

    private void packageCBDS(NDSSettings set) throws IOException {
        this.saveNdsSettings(String.valueOf(this.tmpDir.getAbsolutePath()) + "/ComicBookDS_book.ini", set);
        this.zipTmpDir(set.path);
    }

    private void zipTmpDir(String zipFileName) throws IOException {
        Zip.zipDir(this.tmpDir, zipFileName, 0);
    }

    private Status imageDirToNds(String dirname, NDSSettings set, IProgressMonitor monitor) {
        File file = new File(dirname);
        if (set.name == null || set.name.length() == 0) {
            set.name = file.getName();
        }
        return this.imagesToNds(file, set, monitor, false);
    }

    private Status zipToNds(String zipname, NDSSettings set, IProgressMonitor monitor) {
        File[] files = this.extractZipToTmpDirectory(zipname, monitor);
        if (files != null && files.length > 0) {
            if (set.name == null || set.name.length() == 0) {
                set.name = new File(zipname).getName();
                int end = set.name.lastIndexOf(46);
                set.name = set.name.substring(0, end);
            }
            return this.imagesToNds(this.tmpDir, set, monitor, true);
        }
        return Status.OK_STATUS;
    }

    private Status rarToNds(String rarname, NDSSettings set, IProgressMonitor monitor) {
        Status result = this.extractRarToTmpDirectory(rarname, monitor);
        if (result.code == 0) {
            Log.debug("extraction seems ok");
            if (set.name == null || set.name.length() == 0) {
                set.name = new File(rarname).getName();
                int end = set.name.lastIndexOf(46);
                set.name = set.name.substring(0, end);
            }
            return this.imagesToNds(this.tmpDir, set, monitor, true);
        }
        return result;
    }

    private Status pdfToNds(String pdfname, NDSSettings set, IProgressMonitor monitor) {
        Status result = this.extractPdfToTmpDirectory(pdfname, monitor);
        if (result.code == 0) {
            Log.debug("extraction seems ok");
            if (set.name == null || set.name.length() == 0) {
                set.name = new File(pdfname).getName();
                int end = set.name.lastIndexOf(46);
                set.name = set.name.substring(0, end);
            }
            return this.imagesToNds(this.tmpDir, set, monitor, true);
        }
        return result;
    }

    public Status fileToNds(String filename, String destname, NDSSettings settings, UserSettings usettings, PictodsSettings psettings, IProgressMonitor monitor, IPictoDSJobListener listener) {
        Status result;
        File file = new File(filename);
        if (file.exists()) {
            String tmp = filename.toLowerCase();
            monitor.setMaximum(100);
            monitor.setSelection(0);
            this.createTmpDirectory();
            result = file.isDirectory() ? this.imageDirToNds(filename, settings, monitor) : (this.isZipFile(tmp) ? this.zipToNds(filename, settings, monitor) : (this.isRarFile(tmp) ? this.rarToNds(filename, settings, monitor) : (this.isPdfFile(tmp) ? this.pdfToNds(filename, settings, monitor) : new Status(null, "'" + filename + "' format not supported", 1))));
            this.clean();
        } else {
            result = new Status(null, "'" + filename + "' does not exist", 1);
        }
        if (listener != null) {
            listener.jobFinished(result);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File[] extractZipToTmpDirectory(String zipfilename, IProgressMonitor monitor) {
        Vector<File> result = new Vector<File>(10);
        byte[] data = new byte[256];
        try {
            BufferedOutputStream dest = null;
            ZipFile zis = new ZipFile(zipfilename);
            Enumeration enu = zis.getEntries();
            float i = 0.0f;
            float nbFiles = 0.0f;
            while (enu.hasMoreElements()) {
                enu.nextElement();
                nbFiles += 1.0f;
            }
            enu = zis.getEntries();
            while (enu.hasMoreElements()) {
                int count;
                ZipEntry entry = (ZipEntry)enu.nextElement();
                if (entry.isDirectory()) continue;
                InputStream stream = zis.getInputStream(entry);
                String filename = entry.getName();
                File file = this.createFile(filename);
                if (file == null) continue;
                result.add(file);
                dest = new BufferedOutputStream(new FileOutputStream(file), 256);
                if (monitor.isCanceled()) {
                    return null;
                }
                monitor.setSelection((int)(i / nbFiles * 33.0f));
                monitor.setText("Extracting " + filename);
                while ((count = stream.read(data, 0, 256)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
                stream.close();
                i += 1.0f;
            }
            return result.toArray(new File[result.size()]);
        }
        catch (IOException e) {
            Log.debug(e);
            return null;
        }
    }

    private Status extractRarToTmpDirectory(String rarfilename, IProgressMonitor monitor) {
        try {
            Log.debug("enter extractRarToTmpDirectory with: " + rarfilename);
            if (Pictods.pictodsSettings.unrarPath.equals("")) {
                return new Status(null, "Can't UNRAR file: " + rarfilename + ".\nPlease, define a command line in pictods path option to enable RAR functions.", 1);
            }
            monitor.setText("Extracting " + rarfilename);
            String cmd = this.replaceAll(Pictods.pictodsSettings.unrarPath, "%filename", rarfilename);
            cmd = this.replaceAll(cmd, "%outputdirectoryname", this.tmpDir.getName());
            Process pr = Runtime.getRuntime().exec(cmd, null, this.tmpDir.getParentFile());
            Log.debug("exec: " + cmd + " from " + this.tmpDir.getParentFile());
            StreamGobbler errorGobbler = new StreamGobbler(pr.getErrorStream(), "ERROR");
            StreamGobbler inputGobbler = new StreamGobbler(pr.getInputStream(), "INPUT");
            errorGobbler.start();
            inputGobbler.start();
            Log.debug("exit extractRarToTmpDirectory");
            return pr.waitFor() == 0 ? Status.OK_STATUS : new Status(null, "Unrar could not extract: " + rarfilename, 1);
        }
        catch (Exception e) {
            Log.debug(e);
            return new Status(e, e.getMessage(), 1);
        }
    }

    private Status extractPdfToTmpDirectory(String pdffilename, IProgressMonitor monitor) {
        try {
            Log.debug("enter extractPdfToTmpDirectory with: " + pdffilename);
            if (Pictods.pictodsSettings.pdf2jpgPath.equals("")) {
                return new Status(null, "Can't extract pdf file: " + pdffilename + ".\nPlease, define a command line in pictods path option to enable PDF functions.", 1);
            }
            monitor.setText("Extracting " + pdffilename);
            String cmd = this.replaceAll(Pictods.pictodsSettings.pdf2jpgPath, "%filename", pdffilename);
            cmd = this.replaceAll(cmd, "%outputdirectoryname", this.tmpDir.getName());
            Process pr = Runtime.getRuntime().exec(cmd, null, this.tmpDir.getParentFile());
            Log.debug("exec: " + cmd + " from " + this.tmpDir.getParentFile());
            StreamGobbler errorGobbler = new StreamGobbler(pr.getErrorStream(), "ERROR");
            StreamGobbler inputGobbler = new StreamGobbler(pr.getInputStream(), "INPUT");
            errorGobbler.start();
            inputGobbler.start();
            Log.debug("exit extractPdfToTmpDirectory");
            return pr.waitFor() == 0 ? Status.OK_STATUS : new Status(null, "PDF could not extract: " + pdffilename, 1);
        }
        catch (Exception e) {
            Log.debug(e);
            return new Status(e, e.getMessage(), 1);
        }
    }

    private String replaceAll(String original, String token, String replace) {
        int i = 0;
        while (true) {
            int idx;
            i = idx = original.indexOf(token, i);
            if (idx == -1) {
                return original;
            }
            original = String.valueOf(original.substring(0, idx)) + replace + original.substring(idx + token.length());
        }
    }

    private File createFile(String filename) throws IOException {
        int idx = filename.lastIndexOf(47);
        File result = idx == -1 ? new File(String.valueOf(this.tmpDir.getCanonicalPath()) + '/' + filename) : (idx + 1 == filename.length() ? null : new File(String.valueOf(this.tmpDir.getCanonicalPath()) + filename.substring(idx)));
        return result;
    }

    private BufferedImage createResizedImage(BufferedImage src, int width, int height, int maxsize, boolean keepratio) {
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        if (srcWidth > width || srcHeight > height) {
            if (keepratio) {
                double ratioW = (double)srcWidth / (double)width;
                double ratioH = (double)srcHeight / (double)height;
                if (ratioW > ratioH) {
                    width = (int)((double)srcWidth / ratioW);
                    height = (int)((double)srcHeight / ratioW);
                } else {
                    width = (int)((double)srcWidth / ratioH);
                    height = (int)((double)srcHeight / ratioH);
                }
            }
        } else {
            width = srcWidth;
            height = srcHeight;
        }
        if (maxsize != 0 && width * height > maxsize) {
            double sqrt = Math.sqrt((double)maxsize / (double)(srcWidth * srcHeight));
            width = (int)((double)width * sqrt);
            height = (int)((double)height * sqrt);
        }
        Image img = width != srcWidth || height != srcHeight ? src.getScaledInstance(width, height, 16) : src.getSubimage(0, 0, width, height);
        BufferedImage dest = new BufferedImage(width, height, 1);
        Graphics2D g = (Graphics2D)dest.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.drawImage(img, 0, 0, width, height, null);
        g.dispose();
        return dest;
    }

    private void createFile(String path, String content) throws IOException {
        File out = new File(path);
        out.createNewFile();
        FileOutputStream fout = new FileOutputStream(out);
        fout.write(content.getBytes());
        fout.write("\r\n".getBytes());
        fout.close();
    }

    private Status createResizedImages(File dir, NDSSettings ndsSettings, IProgressMonitor monitor, boolean recursive) {
        File outputN;
        File outputTR;
        File outputTN;
        File outputOR;
        File outputON;
        File outputI;
        File[] children = dir.listFiles();
        Log.debug("enter createResizedImages");
        Arrays.sort(children, new FileComparator());
        File child = null;
        try {
            outputI = new File(String.valueOf(this.tmpDir.getCanonicalPath()) + "/IMAGE");
            outputI.mkdir();
            outputON = new File(String.valueOf(this.tmpDir.getCanonicalPath()) + "/SMALL_N");
            outputON.mkdir();
            outputOR = new File(String.valueOf(this.tmpDir.getCanonicalPath()) + "/SMALL_R");
            outputOR.mkdir();
            outputTN = new File(String.valueOf(this.tmpDir.getCanonicalPath()) + "/THMB_N");
            outputTN.mkdir();
            outputTR = new File(String.valueOf(this.tmpDir.getCanonicalPath()) + "/THMB_R");
            outputTR.mkdir();
            outputN = new File(String.valueOf(this.tmpDir.getCanonicalPath()) + "/NAME");
            outputN.mkdir();
        }
        catch (IOException e) {
            Log.debug(e);
            return new Status(e, e.getMessage(), 1);
        }
        int nbFiles = children.length;
        Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName("jpeg");
        JPEGImageWriter iw = null;
        ImageWriteParam param = null;
        while (it.hasNext()) {
            ImageWriter element = it.next();
            if (!(element instanceof JPEGImageWriter)) continue;
            iw = (JPEGImageWriter)element;
            param = iw.getDefaultWriteParam();
            param.setCompressionMode(2);
        }
        if (iw == null) {
            Log.debug("no jpeg writer found");
            return new Status(null, "No jpeg writer found", 1);
        }
        int pagenumber = 1;
        int i = 0;
        while (i < nbFiles) {
            block26: {
                child = children[i];
                String filename = child.getName();
                Log.debug("loop on " + filename);
                if (monitor.isCanceled()) {
                    return Status.OK_STATUS;
                }
                String outfile = String.valueOf(pagenumber) + ".jpg";
                if (!child.isDirectory()) {
                    BufferedImage originalBuffer;
                    try {
                        originalBuffer = ImageIO.read(child);
                    }
                    catch (Exception e) {
                        if (dir.equals(this.tmpDir)) {
                            child.delete();
                        }
                        Log.debug("Could not read: " + child);
                        Log.debug(e);
                        break block26;
                    }
                    if (dir.equals(this.tmpDir)) {
                        child.delete();
                    }
                    if (originalBuffer == null) {
                        Log.debug("Could not read: " + child);
                    } else {
                        ImageOutputStream stream;
                        try {
                            String name = filename;
                            int idx = filename.lastIndexOf(46);
                            if (idx != -1 && filename.length() - idx <= 5) {
                                name = filename.substring(0, idx);
                            }
                            this.createFile(String.valueOf(outputN.getAbsolutePath()) + "/" + pagenumber + ".txt", name);
                        }
                        catch (IOException e) {
                            Log.debug("Can't create " + outputN.getAbsolutePath() + "/" + pagenumber);
                        }
                        ++pagenumber;
                        monitor.setText("Resizing " + filename);
                        monitor.setSelection((int)(33.0f + (float)i / (float)nbFiles * 33.0f));
                        int originalWidth = originalBuffer.getWidth();
                        int originalHeight = originalBuffer.getHeight();
                        BufferedImage src = new BufferedImage(originalWidth, originalHeight, 1);
                        Graphics2D g = (Graphics2D)src.getGraphics();
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                        g.drawImage(originalBuffer, 0, 0, originalWidth, originalHeight, null);
                        g.dispose();
                        BufferedImage originalRotatedBuffer = new BufferedImage(originalHeight, originalWidth, 1);
                        AffineTransformOp affineTransOp = new AffineTransformOp(AffineTransform.getRotateInstance(Math.toRadians(90.0), (double)originalHeight / 2.0, (double)originalHeight / 2.0), 2);
                        affineTransOp.filter(src, originalRotatedBuffer);
                        param.setCompressionQuality((float)ndsSettings.iQuality / 100.0f);
                        BufferedImage baseI = this.createResizedImage(originalBuffer, ndsSettings.iWidth, ndsSettings.iHeight, ndsSettings.iSize, true);
                        try {
                            stream = ImageIO.createImageOutputStream(new File(String.valueOf(outputI.getAbsolutePath()) + "/" + outfile));
                            iw.setOutput(stream);
                            iw.write(null, new IIOImage(baseI, null, null), param);
                            stream.close();
                        }
                        catch (IOException e) {
                            Log.debug(e);
                            break block26;
                        }
                        param.setCompressionQuality((float)ndsSettings.oQuality / 100.0f);
                        BufferedImage on = this.createResizedImage(baseI, ndsSettings.oWidth, ndsSettings.oHeight, ndsSettings.oSize, true);
                        try {
                            stream = ImageIO.createImageOutputStream(new File(String.valueOf(outputON.getAbsolutePath()) + "/" + outfile));
                            iw.setOutput(stream);
                            iw.write(null, new IIOImage(on, null, null), param);
                            stream.close();
                        }
                        catch (IOException e) {
                            Log.debug(e);
                            break block26;
                        }
                        BufferedImage or = this.createResizedImage(originalRotatedBuffer, ndsSettings.oWidth, ndsSettings.oHeight, ndsSettings.oSize, true);
                        try {
                            stream = ImageIO.createImageOutputStream(new File(String.valueOf(outputOR.getAbsolutePath()) + "/" + outfile));
                            iw.setOutput(stream);
                            iw.write(null, new IIOImage(or, null, null), param);
                            stream.close();
                        }
                        catch (IOException e) {
                            Log.debug(e);
                            break block26;
                        }
                        param.setCompressionQuality((float)ndsSettings.thQuality / 100.0f);
                        BufferedImage tn = this.createResizedImage(on, ndsSettings.thWidth, ndsSettings.thHeight, ndsSettings.thSize, true);
                        try {
                            stream = ImageIO.createImageOutputStream(new File(String.valueOf(outputTN.getAbsolutePath()) + "/" + outfile));
                            iw.setOutput(stream);
                            iw.write(null, new IIOImage(tn, null, null), param);
                            stream.close();
                        }
                        catch (IOException e) {
                            Log.debug(e);
                            break block26;
                        }
                        BufferedImage tr = this.createResizedImage(or, ndsSettings.thWidth, ndsSettings.thHeight, ndsSettings.thSize, true);
                        try {
                            stream = ImageIO.createImageOutputStream(new File(String.valueOf(outputTR.getAbsolutePath()) + "/" + outfile));
                            iw.setOutput(stream);
                            iw.write(null, new IIOImage(tr, null, null), param);
                            stream.close();
                        }
                        catch (IOException e) {
                            Log.debug(e);
                        }
                    }
                }
            }
            ++i;
        }
        ndsSettings.nbPages = pagenumber - 1;
        return Status.OK_STATUS;
    }

    private void createTmpDirectory() {
        if (this.tmpDir.exists()) {
            this.clean();
        }
        this.tmpDir.mkdir();
    }

    private boolean isZipFile(String filename) {
        return filename.endsWith(".zip") || filename.endsWith(".cbz");
    }

    private boolean isRarFile(String filename) {
        return filename.endsWith(".rar") || filename.endsWith(".cbr");
    }

    private boolean isPdfFile(String filename) {
        return filename.endsWith(".pdf");
    }

    private void deleteDir(File dir) {
        File[] children = dir.listFiles();
        if (children == null) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            File child = children[i];
            if (child.isDirectory()) {
                this.deleteDir(child);
            }
            child.delete();
            ++i;
        }
    }

    public void clean() {
        this.deleteDir(this.tmpDir);
        this.tmpDir.delete();
    }

    public void loadNdsSettings(String file, NDSSettings ndsSettings) {
        Properties props;
        FileInputStream fis;
        try {
            fis = new FileInputStream(file);
            props = new Properties();
            props.load(fis);
        }
        catch (IOException e) {
            Log.debug(e);
            return;
        }
        try {
            ndsSettings.name = (String)props.get("CbCredits1");
            ndsSettings.author = (String)props.get("CbCredits2");
            ndsSettings.provider = (String)props.get("CbCredits3");
            ndsSettings.manga = Integer.parseInt((String)props.get("LeftToRight")) == 0 ? 1 : 0;
            ndsSettings.nbPages = Integer.parseInt((String)props.get("NbPages"));
            ndsSettings.iHeight = Integer.parseInt((String)props.get("iHeight"));
            ndsSettings.iQuality = Integer.parseInt((String)props.get("iQuality"));
            ndsSettings.iWidth = Integer.parseInt((String)props.get("iWidth"));
            ndsSettings.iSize = Integer.parseInt((String)props.get("iSize"));
            ndsSettings.oHeight = Integer.parseInt((String)props.get("oHeight"));
            ndsSettings.oQuality = Integer.parseInt((String)props.get("oQuality"));
            ndsSettings.oWidth = Integer.parseInt((String)props.get("oWidth"));
            ndsSettings.oSize = Integer.parseInt((String)props.get("oSize"));
            ndsSettings.thHeight = Integer.parseInt((String)props.get("thHeight"));
            ndsSettings.thQuality = Integer.parseInt((String)props.get("thQuality"));
            ndsSettings.thWidth = Integer.parseInt((String)props.get("thWidth"));
            ndsSettings.thSize = Integer.parseInt((String)props.get("thSize"));
        }
        catch (Exception e) {
            Log.debug(e);
        }
        try {
            fis.close();
        }
        catch (IOException e) {
            Log.debug(e);
        }
    }

    public void saveNdsSettings(String file, NDSSettings ndsSettings) {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            Log.debug(e);
            return;
        }
        try {
            fos.write(COMMENT_NDSINI_INTRO.getBytes());
            if (ndsSettings.name != null) {
                fos.write(COMMENT_NDSINI_CBCREDITS1.getBytes());
                fos.write(("CbCredits1 = " + ndsSettings.name + "\r\n").getBytes());
            }
            fos.write(COMMENT_NDSINI_CBCREDITS2.getBytes());
            fos.write(("CbCredits2 = " + ndsSettings.author + "\r\n").getBytes());
            fos.write(COMMENT_NDSINI_CBCREDITS3.getBytes());
            fos.write(("CbCredits3 = " + ndsSettings.provider + "\r\n").getBytes());
            fos.write(COMMENT_NDSINI_LEFTTORIGHT.getBytes());
            fos.write(("LeftToRight = " + (ndsSettings.manga == 0 ? "1" : "0") + "\r\n").getBytes());
            fos.write(COMMENT_NDSINI_NBPAGES.getBytes());
            fos.write(("NbPages = " + ndsSettings.nbPages + "\r\n").getBytes());
            fos.write(COMMENT_NDSINI_VERSION.getBytes());
            fos.write("Version = 200\r\n".getBytes());
            fos.write(("iHeight = " + ndsSettings.iHeight + "\r\n").getBytes());
            fos.write(("iQuality = " + ndsSettings.iQuality + "\r\n").getBytes());
            fos.write(("iSize = " + ndsSettings.iSize + "\r\n").getBytes());
            fos.write(("iWidth = " + ndsSettings.iWidth + "\r\n").getBytes());
            fos.write(("oHeight = " + ndsSettings.oHeight + "\r\n").getBytes());
            fos.write(("oQuality = " + ndsSettings.oQuality + "\r\n").getBytes());
            fos.write(("oSize = " + ndsSettings.oSize + "\r\n").getBytes());
            fos.write(("oWidth = " + ndsSettings.oWidth + "\r\n").getBytes());
            fos.write(("thHeight = " + ndsSettings.thHeight + "\r\n").getBytes());
            fos.write(("thQuality = " + ndsSettings.thQuality + "\r\n").getBytes());
            fos.write(("thSize = " + ndsSettings.thSize + "\r\n").getBytes());
            fos.write(("thWidth = " + ndsSettings.thWidth + "\r\n").getBytes());
        }
        catch (IOException e) {
            Log.debug(e);
        }
        try {
            fos.close();
        }
        catch (IOException e) {
            Log.debug(e);
        }
    }

    public void loadUserSettings(String file, UserSettings userSettings) {
        Properties props;
        FileInputStream fis;
        try {
            fis = new FileInputStream(file);
            props = new Properties();
            props.load(fis);
        }
        catch (IOException e) {
            Log.debug(e);
            return;
        }
        try {
            userSettings.scrollIncrement = Integer.parseInt((String)props.get("ScrollIncrement"));
            userSettings.zoomIncrement = Integer.parseInt((String)props.get("ZoomIncrement"));
            userSettings.iconAnim = Integer.parseInt((String)props.get("IconsAnimation"));
            userSettings.iconLock = Integer.parseInt((String)props.get("LockIcons"));
            userSettings.landscape = Integer.parseInt((String)props.get("LandscapeMode"));
            userSettings.lefty = Integer.parseInt((String)props.get("LeftHandedMode"));
            userSettings.screenspace = Integer.parseInt((String)props.get("ReflectScreenSpace"));
            userSettings.scrollChange = Integer.parseInt((String)props.get("ScrollCanChangePage"));
            userSettings.transitionAnim = Integer.parseInt((String)props.get("TransitionsAnimation"));
            userSettings.soundsEffect = Integer.parseInt((String)props.get("SoundEffects"));
            userSettings.startupSound = Integer.parseInt((String)props.get("StartupSound"));
            userSettings.resizeFilter = Integer.parseInt((String)props.get("UseResizeFilter"));
            userSettings.waitForKeyRelease = Integer.parseInt((String)props.get("WaitForKeyRelease"));
            userSettings.progressiveScroll = Integer.parseInt((String)props.get("ProgressiveScroll"));
        }
        catch (Exception e) {
            Log.debug(e);
        }
        try {
            fis.close();
        }
        catch (IOException e) {
            Log.debug(e);
        }
    }

    public static void SaveUserSettings(String path, UserSettings userSettings) {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(path);
        }
        catch (FileNotFoundException e) {
            Log.debug(e);
            return;
        }
        try {
            fos.write("\r\n".getBytes());
            fos.write(COMMENT_USERINI_SCROLLINCR.getBytes());
            fos.write(("ScrollIncrement = " + userSettings.scrollIncrement + "\r\n").getBytes());
            fos.write(COMMENT_USERINI_ZOOMINCR.getBytes());
            fos.write(("ZoomIncrement = " + userSettings.zoomIncrement + "\r\n").getBytes());
            fos.write(COMMENT_USERINI_ICONSANIM.getBytes());
            fos.write(("IconsAnimation = " + userSettings.iconAnim + "\r\n").getBytes());
            fos.write(COMMENT_USERINI_LOCKICONS.getBytes());
            fos.write(("LockIcons = " + userSettings.iconLock + "\r\n").getBytes());
            fos.write(COMMENT_USERINI_LANDSCAPE.getBytes());
            fos.write(("LandscapeMode = " + userSettings.landscape + "\r\n").getBytes());
            fos.write(COMMENT_USERINI_LEFTY.getBytes());
            fos.write(("LeftHandedMode = " + userSettings.lefty + "\r\n").getBytes());
            fos.write(COMMENT_USERINI_SCREENSPACE.getBytes());
            fos.write(("ReflectScreenSpace = " + userSettings.screenspace + "\r\n").getBytes());
            fos.write(COMMENT_USERINI_SCROLLCHANGE.getBytes());
            fos.write(("ScrollCanChangePage = " + userSettings.scrollChange + "\r\n").getBytes());
            fos.write(COMMENT_USERINI_TRANSITIONANIM.getBytes());
            fos.write(("TransitionsAnimation = " + userSettings.transitionAnim + "\r\n").getBytes());
            fos.write(COMMENT_USERINI_SOUNDSFX.getBytes());
            fos.write(("SoundEffects = " + userSettings.soundsEffect + "\r\n").getBytes());
            fos.write(COMMENT_USERINI_STARTUPSOUND.getBytes());
            fos.write(("StartupSound = " + userSettings.startupSound + "\r\n").getBytes());
            fos.write(COMMENT_USERINI_RESIZEFILTER.getBytes());
            fos.write(("UseResizeFilter = " + userSettings.resizeFilter + "\r\n").getBytes());
            fos.write(COMMENT_USERINI_WAITFORKEYRELEASE.getBytes());
            fos.write(("WaitForKeyRelease = " + userSettings.waitForKeyRelease + "\r\n").getBytes());
            fos.write(COMMENT_USERINI_PROGRESSIVESCROLL.getBytes());
            fos.write(("ProgressiveScroll = " + userSettings.progressiveScroll + "\r\n").getBytes());
            fos.write(COMMENT_USERINI_KEYS.getBytes());
        }
        catch (IOException e) {
            Log.debug(e);
        }
        try {
            fos.close();
        }
        catch (IOException e) {
            Log.debug(e);
        }
    }

    public static void SaveUserSettings(UserSettings userSettings) {
        Pictods.SaveUserSettings(String.valueOf(Pictods.pictodsSettings.outputPath) + "/ComicBookDS.ini", userSettings);
    }

    public PictodsSettings loadPictoDSSettings(String file) {
        Properties props;
        FileInputStream fis;
        try {
            fis = new FileInputStream(file);
            props = new Properties();
            props.load(fis);
        }
        catch (IOException e) {
            Log.debug(e);
            return pictodsSettings;
        }
        try {
            Pictods.pictodsSettings.inputPath = (String)props.get("pictodsSettings.inputPath");
            if (Pictods.pictodsSettings.inputPath == null) {
                Pictods.pictodsSettings.inputPath = "";
            }
            Pictods.pictodsSettings.outputPath = (String)props.get("pictodsSettings.outputPath");
            if (Pictods.pictodsSettings.outputPath == null || Pictods.pictodsSettings.outputPath.trim().equals("")) {
                Pictods.pictodsSettings.outputPath = new File("../cbds").getCanonicalPath();
            }
            Pictods.pictodsSettings.unrarPath = (String)props.get("pictodsSettings.unrarPath");
            Pictods.pictodsSettings.explorerPath = (String)props.get("pictodsSettings.explorerPath");
            Pictods.pictodsSettings.pdf2jpgPath = (String)props.get("pictodsSettings.pdf2jpgPath");
        }
        catch (Exception e) {
            Log.debug(e);
        }
        try {
            fis.close();
        }
        catch (IOException e) {
            Log.debug(e);
        }
        return pictodsSettings;
    }

    public void savePictoDSSettings(String file) {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            Log.debug(e);
            return;
        }
        Properties props = new Properties();
        props.put("pictodsSettings.inputPath", Pictods.pictodsSettings.inputPath);
        props.put("pictodsSettings.outputPath", Pictods.pictodsSettings.outputPath);
        props.put("pictodsSettings.unrarPath", Pictods.pictodsSettings.unrarPath);
        props.put("pictodsSettings.pdf2jpgPath", Pictods.pictodsSettings.pdf2jpgPath);
        props.put("pictodsSettings.explorerPath", Pictods.pictodsSettings.explorerPath);
        props.put("VERSION", VERSION);
        try {
            props.store(fos, null);
        }
        catch (IOException e) {
            Log.debug(e);
        }
        try {
            fos.close();
        }
        catch (IOException e) {
            Log.debug(e);
        }
    }

    private static final class StubProgressMonitor
    implements IProgressMonitor {
        private StubProgressMonitor() {
        }

        @Override
        public void cancel() {
        }

        @Override
        public int getSelection() {
            return 0;
        }

        @Override
        public boolean isCanceled() {
            return false;
        }

        @Override
        public void setMaximum(int max) {
        }

        @Override
        public void setSelection(int sel) {
        }

        @Override
        public void setText(String text) {
        }
    }
}

