/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.viewers;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.IObservable;
import org.eclipse.jface.internal.databinding.provisional.observable.IStaleListener;
import org.eclipse.jface.internal.databinding.provisional.observable.set.IObservableSet;
import org.eclipse.jface.internal.databinding.provisional.observable.set.ISetChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.set.ObservableSet;
import org.eclipse.jface.internal.databinding.provisional.observable.set.SetDiff;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public final class ObservableSetContentProvider
implements IStructuredContentProvider {
    private IObservableSet readableSet;
    private Viewer viewer;
    private KnownElementsSet knownElements;
    private ISetChangeListener listener;
    private IStaleListener staleListener;
    static /* synthetic */ Class class$0;

    public ObservableSetContentProvider() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.readableSet = new ObservableSet(Collections.EMPTY_SET, clazz){};
        this.knownElements = new KnownElementsSet(this, this.readableSet);
        this.listener = new ISetChangeListener(){

            public void handleSetChange(IObservableSet source, SetDiff diff) {
                boolean wasStale = ObservableSetContentProvider.this.knownElements.isStale();
                if (ObservableSetContentProvider.this.isDisposed()) {
                    return;
                }
                ObservableSetContentProvider.this.doDiff(diff.getAdditions(), diff.getRemovals(), true);
                if (!wasStale && source.isStale()) {
                    ObservableSetContentProvider.this.knownElements.doFireStale(true);
                }
            }
        };
        this.staleListener = new IStaleListener(){

            public void handleStale(IObservable source) {
                ObservableSetContentProvider.this.knownElements.doFireStale(source.isStale());
            }
        };
    }

    public void dispose() {
        this.setInput(null);
    }

    private void doDiff(Set added, Set removed, boolean updateViewer) {
        this.knownElements.doFireDiff(added, Collections.EMPTY_SET);
        if (updateViewer) {
            Object[] toAdd = added.toArray();
            if (this.viewer instanceof TableViewer) {
                TableViewer tv = (TableViewer)this.viewer;
                tv.add(toAdd);
            } else if (this.viewer instanceof AbstractListViewer) {
                AbstractListViewer lv = (AbstractListViewer)this.viewer;
                lv.add(toAdd);
            }
            Object[] toRemove = removed.toArray();
            if (this.viewer instanceof TableViewer) {
                TableViewer tv = (TableViewer)this.viewer;
                tv.remove(toRemove);
            } else if (this.viewer instanceof AbstractListViewer) {
                AbstractListViewer lv = (AbstractListViewer)this.viewer;
                lv.remove(toRemove);
            }
        }
        this.knownElements.doFireDiff(Collections.EMPTY_SET, removed);
    }

    public Object[] getElements(Object inputElement) {
        return this.readableSet.toArray();
    }

    public IObservableSet getKnownElements() {
        return this.knownElements;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (!(viewer instanceof TableViewer) && !(viewer instanceof AbstractListViewer)) {
            throw new IllegalArgumentException("This content provider only works with TableViewer or AbstractListViewer");
        }
        if (newInput != null && !(newInput instanceof IObservableSet)) {
            throw new IllegalArgumentException("This content provider only works with input of type IReadableSet");
        }
        this.setInput((IObservableSet)newInput);
    }

    private boolean isDisposed() {
        return this.viewer.getControl() == null || this.viewer.getControl().isDisposed();
    }

    private void setInput(IObservableSet newSet) {
        boolean isStale;
        boolean updateViewer = true;
        if (newSet == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            newSet = new ObservableSet(Collections.EMPTY_SET, clazz){};
            updateViewer = false;
        }
        boolean wasStale = false;
        if (this.readableSet != null) {
            wasStale = this.readableSet.isStale();
            this.readableSet.removeSetChangeListener(this.listener);
            this.readableSet.removeStaleListener(this.staleListener);
        }
        HashSet additions = new HashSet();
        HashSet removals = new HashSet();
        additions.addAll(newSet);
        additions.removeAll(this.readableSet);
        removals.addAll(this.readableSet);
        removals.removeAll(newSet);
        this.readableSet = newSet;
        this.doDiff(additions, removals, updateViewer);
        if (this.readableSet != null) {
            this.readableSet.addSetChangeListener(this.listener);
            this.readableSet.addStaleListener(this.staleListener);
        }
        boolean bl = isStale = this.readableSet != null && this.readableSet.isStale();
        if (isStale != wasStale) {
            this.knownElements.doFireStale(isStale);
        }
    }

    private class KnownElementsSet
    extends ObservableSet {
        final /* synthetic */ ObservableSetContentProvider this$0;
        static /* synthetic */ Class class$0;

        KnownElementsSet(ObservableSetContentProvider observableSetContentProvider, Set wrappedSet) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            super(wrappedSet, clazz);
            this.this$0 = observableSetContentProvider;
        }

        void doFireDiff(Set added, Set removed) {
            this.fireSetChange(Diffs.createSetDiff(added, removed));
        }

        void doFireStale(boolean isStale) {
            if (isStale) {
                this.fireStale();
            } else {
                this.fireChange();
            }
        }
    }
}

