/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal.viewers;

import java.util.Collection;
import org.eclipse.jface.internal.databinding.provisional.BindSpec;
import org.eclipse.jface.internal.databinding.provisional.Binding;
import org.eclipse.jface.internal.databinding.provisional.BindingEvent;
import org.eclipse.jface.internal.databinding.provisional.DataBindingContext;
import org.eclipse.jface.internal.databinding.provisional.observable.IObservable;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.IMappingChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.IMultiMapping;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.IObservableMultiMappingWithDomain;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.MappingDiff;
import org.eclipse.jface.internal.databinding.provisional.observable.set.IObservableSet;
import org.eclipse.jface.internal.databinding.provisional.observable.set.ISetChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.set.SetDiff;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IObservableValue;
import org.eclipse.jface.internal.databinding.provisional.observable.value.WritableValue;
import org.eclipse.jface.internal.databinding.provisional.validation.ValidationError;
import org.eclipse.jface.internal.databinding.provisional.viewers.IObservableCollectionWithLabels;

public class MultiMappingAndSetBinding
extends Binding {
    private boolean updating = false;
    private IObservableCollectionWithLabels target;
    private IObservableMultiMappingWithDomain model;
    private IObservableSet modelSet;
    private final IObservableSet targetSet;
    private final ISetChangeListener targetChangeListener = new ISetChangeListener(){

        public void handleSetChange(IObservableSet source, SetDiff diff) {
        }
    };
    private IMappingChangeListener cellsChangeListener = new IMappingChangeListener(){

        public void handleMappingValueChange(IObservable source, MappingDiff diff) {
            MultiMappingAndSetBinding.this.target.updateElements(diff.getElements().toArray());
        }
    };
    private ISetChangeListener modelChangeListener = new ISetChangeListener(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleSetChange(IObservableSet source, SetDiff diff) {
            block5: {
                if (MultiMappingAndSetBinding.this.updating) {
                    return;
                }
                BindingEvent e = new BindingEvent(MultiMappingAndSetBinding.this.model, MultiMappingAndSetBinding.this.targetSet, diff, 0, 0);
                if (MultiMappingAndSetBinding.this.failure(MultiMappingAndSetBinding.this.errMsg(MultiMappingAndSetBinding.this.fireBindingEvent(e)))) {
                    return;
                }
                try {
                    SetDiff setDiff = (SetDiff)e.diff;
                    MultiMappingAndSetBinding.this.targetSet.addAll((Collection)setDiff.getAdditions());
                    MultiMappingAndSetBinding.this.targetSet.removeAll((Collection)setDiff.getRemovals());
                    e.pipelinePosition = 4;
                    if (!MultiMappingAndSetBinding.this.failure(MultiMappingAndSetBinding.this.errMsg(MultiMappingAndSetBinding.this.fireBindingEvent(e)))) break block5;
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    MultiMappingAndSetBinding.this.updating = false;
                    throw throwable;
                }
                MultiMappingAndSetBinding.this.updating = false;
                return;
            }
            Object var5_7 = null;
            MultiMappingAndSetBinding.this.updating = false;
        }
    };
    private WritableValue partialValidationErrorObservable = new WritableValue(null);
    private WritableValue validationErrorObservable = new WritableValue(null);

    public MultiMappingAndSetBinding(DataBindingContext context, IObservableSet targetSet, IObservableCollectionWithLabels target, IObservableSet modelSet, IObservableMultiMappingWithDomain model, BindSpec bindSpec) {
        super(context);
        this.targetSet = targetSet;
        this.target = target;
        this.model = model;
        this.modelSet = modelSet;
        targetSet.addSetChangeListener(this.targetChangeListener);
        model.addMappingChangeListener(this.cellsChangeListener);
        modelSet.addSetChangeListener(this.modelChangeListener);
        this.updateTargetFromModel();
    }

    private ValidationError errMsg(ValidationError validationError) {
        this.partialValidationErrorObservable.setValue(null);
        this.validationErrorObservable.setValue(validationError);
        return validationError;
    }

    private boolean failure(ValidationError errorMessage) {
        return errorMessage != null && errorMessage.status == 2;
    }

    public void updateTargetFromModel() {
        this.targetSet.clear();
        this.targetSet.addAll((Collection)this.modelSet);
        this.target.init(new IMultiMapping(){

            public Object[] getMappingValues(Object element, int[] columnIndices) {
                return MultiMappingAndSetBinding.this.model.getMappingValues(element, columnIndices);
            }

            public void setMappingValues(Object element, int[] columnIndices, Object[] values) {
                MultiMappingAndSetBinding.this.model.setMappingValues(element, columnIndices, values);
            }
        });
    }

    public IObservableValue getValidationError() {
        return this.validationErrorObservable;
    }

    public IObservableValue getPartialValidationError() {
        return this.partialValidationErrorObservable;
    }

    public void updateModelFromTarget() {
    }
}

