/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Control;

public class Accessible {
    static final String[] requiredAttributes = new String[]{"AXRole", "AXSubrole", "AXRoleDescription", "AXHelp", "AXTitle", "AXValue", "AXEnabled", "AXFocused", "AXParent", "AXChildren", "AXSelectedChildren", "AXVisibleChildren", "AXWindow", "AXTopLevelUIElement", "AXPosition", "AXSize", "AXDescription"};
    static final String[] textAttributes = new String[]{"AXNumberOfCharacters", "AXSelectedText", "AXSelectedTextRange", "AXInsertionPointLineNumber"};
    Vector accessibleListeners = new Vector();
    Vector accessibleControlListeners = new Vector();
    Vector accessibleTextListeners = new Vector();
    Control control;
    int axuielementref = 0;
    int[] osChildIDCache = new int[0];

    Accessible(Control control) {
        this.control = control;
        this.axuielementref = OS.AXUIElementCreateWithHIObjectAndIdentifier(control.handle, 0L);
    }

    public static Accessible internal_new_Accessible(Control control) {
        return new Accessible(control);
    }

    public void addAccessibleListener(AccessibleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.addElement(listener);
    }

    public void addAccessibleControlListener(AccessibleControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.accessibleControlListeners.addElement(listener);
    }

    public void addAccessibleTextListener(AccessibleTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.accessibleTextListeners.addElement(listener);
    }

    public Control getControl() {
        return this.control;
    }

    public void internal_dispose_Accessible() {
        if (this.axuielementref != 0) {
            OS.CFRelease(this.axuielementref);
            this.axuielementref = 0;
            int index = 1;
            while (index < this.osChildIDCache.length) {
                OS.CFRelease(this.osChildIDCache[index]);
                index += 2;
            }
            this.osChildIDCache = new int[0];
        }
    }

    public int internal_kEventAccessibleGetChildAtPoint(int nextHandler, int theEvent, int userData) {
        if (this.axuielementref != 0) {
            int childID = this.getChildIDFromEvent(theEvent);
            CGPoint pt = new CGPoint();
            OS.GetEventParameter(theEvent, 1835822947, 1751740532, null, 8, null, pt);
            AccessibleControlEvent event = new AccessibleControlEvent(this);
            event.x = (int)pt.x;
            event.y = (int)pt.y;
            event.childID = -1;
            int i = 0;
            while (i < this.accessibleControlListeners.size()) {
                AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
                listener.getChildAtPoint(event);
                ++i;
            }
            if (event.accessible != null) {
                OS.SetEventParameter(theEvent, 1633904748, 1667658873, 4, new int[]{event.accessible.axuielementref});
                return 0;
            }
            if (event.childID == -1 || event.childID == -2 || event.childID == childID) {
                return 0;
            }
            OS.SetEventParameter(theEvent, 1633904748, 1667658873, 4, new int[]{this.childIDToOs(event.childID)});
            return 0;
        }
        return -9874;
    }

    public int internal_kEventAccessibleGetNamedAttribute(int nextHandler, int theEvent, int userData) {
        if (this.axuielementref != 0) {
            int[] stringRef = new int[1];
            OS.GetEventParameter(theEvent, 1635020397, 1667658612, null, 4, null, stringRef);
            int length = OS.CFStringGetLength(stringRef[0]);
            char[] buffer = new char[length];
            CFRange range = new CFRange();
            range.length = length;
            OS.CFStringGetCharacters(stringRef[0], range, buffer);
            String attributeName = new String(buffer);
            if (attributeName.equals("AXRole")) {
                return this.getRoleAttribute(nextHandler, theEvent, userData);
            }
            if (attributeName.equals("AXSubrole")) {
                return this.getSubroleAttribute(nextHandler, theEvent, userData);
            }
            if (attributeName.equals("AXRoleDescription")) {
                return this.getRoleDescriptionAttribute(nextHandler, theEvent, userData);
            }
            if (attributeName.equals("AXHelp")) {
                return this.getHelpAttribute(nextHandler, theEvent, userData);
            }
            if (attributeName.equals("AXTitle")) {
                return this.getTitleAttribute(nextHandler, theEvent, userData);
            }
            if (attributeName.equals("AXValue")) {
                return this.getValueAttribute(nextHandler, theEvent, userData);
            }
            if (attributeName.equals("AXEnabled")) {
                return this.getEnabledAttribute(nextHandler, theEvent, userData);
            }
            if (attributeName.equals("AXFocused")) {
                return this.getFocusedAttribute(nextHandler, theEvent, userData);
            }
            if (attributeName.equals("AXParent")) {
                return this.getParentAttribute(nextHandler, theEvent, userData);
            }
            if (attributeName.equals("AXChildren")) {
                return this.getChildrenAttribute(nextHandler, theEvent, userData);
            }
            if (attributeName.equals("AXSelectedChildren")) {
                return this.getSelectedChildrenAttribute(nextHandler, theEvent, userData);
            }
            if (attributeName.equals("AXVisibleChildren")) {
                return this.getVisibleChildrenAttribute(nextHandler, theEvent, userData);
            }
            if (attributeName.equals("AXWindow")) {
                return this.getWindowAttribute(nextHandler, theEvent, userData);
            }
            if (attributeName.equals("AXTopLevelUIElement")) {
                return this.getTopLevelUIElementAttribute(nextHandler, theEvent, userData);
            }
            if (attributeName.equals("AXPosition")) {
                return this.getPositionAttribute(nextHandler, theEvent, userData);
            }
            if (attributeName.equals("AXSize")) {
                return this.getSizeAttribute(nextHandler, theEvent, userData);
            }
            if (attributeName.equals("AXDescription")) {
                return this.getDescriptionAttribute(nextHandler, theEvent, userData);
            }
            if (attributeName.equals("AXNumberOfCharacters")) {
                return this.getNumberOfCharactersAttribute(nextHandler, theEvent, userData);
            }
            if (attributeName.equals("AXSelectedText")) {
                return this.getSelectedTextAttribute(nextHandler, theEvent, userData);
            }
            if (attributeName.equals("AXSelectedTextRange")) {
                return this.getSelectedTextRangeAttribute(nextHandler, theEvent, userData);
            }
            if (attributeName.equals("AXInsertionPointLineNumber")) {
                return this.getInsertionPointLineNumberAttribute(nextHandler, theEvent, userData);
            }
            return this.getAttribute(nextHandler, theEvent, userData);
        }
        return -9874;
    }

    public int internal_kEventAccessibleGetAllAttributeNames(int nextHandler, int theEvent, int userData) {
        if (this.axuielementref != 0) {
            int stringRef;
            int[] arrayRef = new int[1];
            OS.GetEventParameter(theEvent, 1635020403, 1667657057, null, 4, null, arrayRef);
            int stringArrayRef = arrayRef[0];
            int i = 0;
            while (i < requiredAttributes.length) {
                stringRef = this.stringToStringRef(requiredAttributes[i]);
                OS.CFArrayAppendValue(stringArrayRef, stringRef);
                OS.CFRelease(stringRef);
                ++i;
            }
            if (this.accessibleTextListeners.size() > 0) {
                i = 0;
                while (i < textAttributes.length) {
                    stringRef = this.stringToStringRef(textAttributes[i]);
                    OS.CFArrayAppendValue(stringArrayRef, stringRef);
                    OS.CFRelease(stringRef);
                    ++i;
                }
            }
            return 0;
        }
        return -9874;
    }

    int getAttribute(int nextHandler, int theEvent, int userData) {
        int code = OS.CallNextEventHandler(nextHandler, theEvent);
        if (code == -9874) {
            OS.SetEventParameter(theEvent, 1634689642, 1667658873, 4, new int[]{this.axuielementref});
            code = OS.CallNextEventHandler(nextHandler, theEvent);
        }
        return code;
    }

    int getHelpAttribute(int nextHandler, int theEvent, int userData) {
        int code = OS.CallNextEventHandler(nextHandler, theEvent);
        String osHelpAttribute = null;
        int[] stringRef = new int[1];
        if (code == 0) {
            OS.GetEventParameter(theEvent, 1635022444, 1667658612, null, 4, null, stringRef);
            osHelpAttribute = this.stringRefToString(stringRef[0]);
        }
        AccessibleEvent event = new AccessibleEvent(this);
        event.childID = this.getChildIDFromEvent(theEvent);
        event.result = osHelpAttribute;
        int i = 0;
        while (i < this.accessibleListeners.size()) {
            AccessibleListener listener = (AccessibleListener)this.accessibleListeners.elementAt(i);
            listener.getHelp(event);
            ++i;
        }
        if (event.result != null) {
            stringRef[0] = this.stringToStringRef(event.result);
            if (stringRef[0] != 0) {
                OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, stringRef);
                OS.CFRelease(stringRef[0]);
                return 0;
            }
        }
        return code;
    }

    int getRoleAttribute(int nextHandler, int theEvent, int userData) {
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = this.getChildIDFromEvent(theEvent);
        event.detail = -1;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getRole(event);
            ++i;
        }
        if (event.detail != -1) {
            int stringRef;
            String appRole = this.roleToOs(event.detail);
            int index = appRole.indexOf(58);
            if (index != -1) {
                appRole = appRole.substring(0, index);
            }
            if ((stringRef = this.stringToStringRef(appRole)) != 0) {
                OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, new int[]{stringRef});
                OS.CFRelease(stringRef);
                return 0;
            }
        }
        return OS.CallNextEventHandler(nextHandler, theEvent);
    }

    int getSubroleAttribute(int nextHandler, int theEvent, int userData) {
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = this.getChildIDFromEvent(theEvent);
        event.detail = -1;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getRole(event);
            ++i;
        }
        if (event.detail != -1) {
            int stringRef;
            String appRole = this.roleToOs(event.detail);
            int index = appRole.indexOf(58);
            if (index != -1 && (stringRef = this.stringToStringRef(appRole = appRole.substring(index + 1))) != 0) {
                OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, new int[]{stringRef});
                OS.CFRelease(stringRef);
            }
            return 0;
        }
        return OS.CallNextEventHandler(nextHandler, theEvent);
    }

    int getRoleDescriptionAttribute(int nextHandler, int theEvent, int userData) {
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = this.getChildIDFromEvent(theEvent);
        event.detail = -1;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getRole(event);
            ++i;
        }
        if (event.detail != -1) {
            int stringRef1;
            String appRole = this.roleToOs(event.detail);
            String appSubrole = null;
            int index = appRole.indexOf(58);
            if (index != -1) {
                appSubrole = appRole.substring(index + 1);
                appRole = appRole.substring(0, index);
            }
            if ((stringRef1 = this.stringToStringRef(appRole)) != 0) {
                int stringRef2 = 0;
                if (appSubrole != null) {
                    stringRef2 = this.stringToStringRef(appSubrole);
                }
                int stringRef3 = OS.HICopyAccessibilityRoleDescription(stringRef1, stringRef2);
                OS.CFRelease(stringRef1);
                if (stringRef2 != 0) {
                    OS.CFRelease(stringRef2);
                }
                if (stringRef3 != 0) {
                    OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, new int[]{stringRef3});
                    OS.CFRelease(stringRef3);
                    return 0;
                }
            }
        }
        return OS.CallNextEventHandler(nextHandler, theEvent);
    }

    int getTitleAttribute(int nextHandler, int theEvent, int userData) {
        int status;
        int code = OS.CallNextEventHandler(nextHandler, theEvent);
        String osTitleAttribute = null;
        int[] stringRef = new int[1];
        if (code == 0 && (status = OS.GetEventParameter(theEvent, 1635022444, 1667658612, null, 4, null, stringRef)) == 0) {
            osTitleAttribute = this.stringRefToString(stringRef[0]);
        }
        AccessibleEvent event = new AccessibleEvent(this);
        event.childID = this.getChildIDFromEvent(theEvent);
        event.result = osTitleAttribute;
        int i = 0;
        while (i < this.accessibleListeners.size()) {
            AccessibleListener listener = (AccessibleListener)this.accessibleListeners.elementAt(i);
            listener.getName(event);
            ++i;
        }
        if (event.result != null) {
            stringRef[0] = this.stringToStringRef(event.result);
            if (stringRef[0] != 0) {
                OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, stringRef);
                OS.CFRelease(stringRef[0]);
                return 0;
            }
        }
        return code;
    }

    int getValueAttribute(int nextHandler, int theEvent, int userData) {
        int code = OS.CallNextEventHandler(nextHandler, theEvent);
        int childID = this.getChildIDFromEvent(theEvent);
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = childID;
        event.detail = -1;
        event.result = null;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getRole(event);
            listener.getValue(event);
            ++i;
        }
        int role = event.detail;
        String value = event.result;
        if (value != null || role == 41) {
            int stringRef = 0;
            switch (role) {
                case 3: 
                case 37: 
                case 44: 
                case 45: 
                case 48: 
                case 51: {
                    try {
                        int number = Integer.parseInt(value);
                        OS.SetEventParameter(theEvent, 1635022444, 1819242087, 4, new int[]{number});
                        return 0;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (value.equalsIgnoreCase("true")) {
                            OS.SetEventParameter(theEvent, 1635022444, 1651470188, 4, new boolean[]{true});
                            return 0;
                        }
                        if (!value.equalsIgnoreCase("false")) break;
                        OS.SetEventParameter(theEvent, 1635022444, 1651470188, 4, new boolean[1]);
                        return 0;
                    }
                }
                case 42: 
                case 46: 
                case 60: {
                    stringRef = this.stringToStringRef(value);
                    break;
                }
                case 41: {
                    AccessibleEvent e = new AccessibleEvent(this);
                    e.childID = childID;
                    e.result = null;
                    int i2 = 0;
                    while (i2 < this.accessibleListeners.size()) {
                        AccessibleListener listener = (AccessibleListener)this.accessibleListeners.elementAt(i2);
                        listener.getName(e);
                        ++i2;
                    }
                    if (e.result != null) {
                        stringRef = this.stringToStringRef(e.result);
                        break;
                    }
                    if (value == null) break;
                    stringRef = this.stringToStringRef(value);
                }
            }
            if (stringRef != 0) {
                OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, new int[]{stringRef});
                OS.CFRelease(stringRef);
                return 0;
            }
        }
        return code;
    }

    int getEnabledAttribute(int nextHandler, int theEvent, int userData) {
        return this.getAttribute(nextHandler, theEvent, userData);
    }

    int getFocusedAttribute(int nextHandler, int theEvent, int userData) {
        int osChildID = this.getChildIDFromEvent(theEvent);
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = -3;
        event.accessible = null;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getFocus(event);
            ++i;
        }
        if (event.accessible != null && OS.CFEqual(event.accessible.axuielementref, osChildID)) {
            OS.SetEventParameter(theEvent, 1635022444, 1651470188, 4, new boolean[]{true});
            return 0;
        }
        if (event.childID == -2) {
            OS.SetEventParameter(theEvent, 1635022444, 1651470188, 4, new boolean[1]);
            return 0;
        }
        if (event.childID != -3) {
            boolean hasFocus = OS.CFEqual(this.childIDToOs(event.childID), osChildID);
            OS.SetEventParameter(theEvent, 1635022444, 1651470188, 4, new boolean[]{hasFocus});
            return 0;
        }
        return OS.CallNextEventHandler(nextHandler, theEvent);
    }

    int getParentAttribute(int nextHandler, int theEvent, int userData) {
        int code = OS.CallNextEventHandler(nextHandler, theEvent);
        if (code == -9874) {
            OS.SetEventParameter(theEvent, 1635022444, 1667658873, 4, new int[]{this.axuielementref});
            return 0;
        }
        return code;
    }

    int getChildrenAttribute(int nextHandler, int theEvent, int userData) {
        int children;
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getChildren(event);
            ++i;
        }
        Object[] appChildren = event.children;
        if (appChildren != null && appChildren.length > 0 && (children = OS.CFArrayCreateMutable(0, 0, 0)) != 0) {
            int i2 = 0;
            while (i2 < appChildren.length) {
                Object child = appChildren[i2];
                if (child instanceof Integer) {
                    OS.CFArrayAppendValue(children, this.childIDToOs((Integer)child));
                } else {
                    OS.CFArrayAppendValue(children, ((Accessible)child).axuielementref);
                }
                ++i2;
            }
            OS.SetEventParameter(theEvent, 1635022444, 1667657057, 4, new int[]{children});
            OS.CFRelease(children);
            return 0;
        }
        return OS.CallNextEventHandler(nextHandler, theEvent);
    }

    int getSelectedChildrenAttribute(int nextHandler, int theEvent, int userData) {
        return this.getAttribute(nextHandler, theEvent, userData);
    }

    int getVisibleChildrenAttribute(int nextHandler, int theEvent, int userData) {
        return this.getAttribute(nextHandler, theEvent, userData);
    }

    int getWindowAttribute(int nextHandler, int theEvent, int userData) {
        return this.getAttribute(nextHandler, theEvent, userData);
    }

    int getTopLevelUIElementAttribute(int nextHandler, int theEvent, int userData) {
        return this.getAttribute(nextHandler, theEvent, userData);
    }

    int getPositionAttribute(int nextHandler, int theEvent, int userData) {
        int code = OS.CallNextEventHandler(nextHandler, theEvent);
        CGPoint osPositionAttribute = new CGPoint();
        if (code == 0) {
            OS.GetEventParameter(theEvent, 1835822947, 1751740532, null, 8, null, osPositionAttribute);
        }
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = this.getChildIDFromEvent(theEvent);
        event.x = (int)osPositionAttribute.x;
        event.y = (int)osPositionAttribute.y;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getLocation(event);
            ++i;
        }
        osPositionAttribute.x = event.x;
        osPositionAttribute.y = event.y;
        OS.SetEventParameter(theEvent, 1635022444, 1751740532, 8, osPositionAttribute);
        return 0;
    }

    int getSizeAttribute(int nextHandler, int theEvent, int userData) {
        int code = OS.CallNextEventHandler(nextHandler, theEvent);
        CGPoint osSizeAttribute = new CGPoint();
        if (code == 0) {
            OS.GetEventParameter(theEvent, 1835822947, 1751740532, null, 8, null, osSizeAttribute);
        }
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = this.getChildIDFromEvent(theEvent);
        event.width = (int)osSizeAttribute.x;
        event.height = (int)osSizeAttribute.y;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getLocation(event);
            ++i;
        }
        osSizeAttribute.x = event.width;
        osSizeAttribute.y = event.height;
        OS.SetEventParameter(theEvent, 1635022444, 1751740532, 8, osSizeAttribute);
        return 0;
    }

    int getDescriptionAttribute(int nextHandler, int theEvent, int userData) {
        return this.getAttribute(nextHandler, theEvent, userData);
    }

    int getNumberOfCharactersAttribute(int nextHandler, int theEvent, int userData) {
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = this.getChildIDFromEvent(theEvent);
        event.result = null;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getValue(event);
            ++i;
        }
        String appValue = event.result;
        if (appValue != null) {
            OS.SetEventParameter(theEvent, 1635022444, 1819242087, 4, new int[]{appValue.length()});
            return 0;
        }
        return OS.CallNextEventHandler(nextHandler, theEvent);
    }

    int getSelectedTextAttribute(int nextHandler, int theEvent, int userData) {
        AccessibleTextEvent event = new AccessibleTextEvent(this);
        event.childID = this.getChildIDFromEvent(theEvent);
        event.offset = -1;
        event.length = -1;
        int i = 0;
        while (i < this.accessibleTextListeners.size()) {
            AccessibleTextListener listener = (AccessibleTextListener)this.accessibleTextListeners.elementAt(i);
            listener.getSelectionRange(event);
            ++i;
        }
        int offset = event.offset;
        int length = event.length;
        if (offset != -1 && length != -1 && length != 0) {
            int stringRef;
            AccessibleControlEvent event2 = new AccessibleControlEvent(this);
            event2.childID = event.childID;
            event2.result = null;
            int i2 = 0;
            while (i2 < this.accessibleControlListeners.size()) {
                AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i2);
                listener.getValue(event2);
                ++i2;
            }
            String appValue = event2.result;
            if (appValue != null && (stringRef = this.stringToStringRef(appValue.substring(offset, offset + length))) != 0) {
                OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, new int[]{stringRef});
                OS.CFRelease(stringRef);
                return 0;
            }
        }
        return OS.CallNextEventHandler(nextHandler, theEvent);
    }

    int getSelectedTextRangeAttribute(int nextHandler, int theEvent, int userData) {
        AccessibleTextEvent event = new AccessibleTextEvent(this);
        event.childID = this.getChildIDFromEvent(theEvent);
        event.offset = -1;
        event.length = -1;
        int i = 0;
        while (i < this.accessibleTextListeners.size()) {
            AccessibleTextListener listener = (AccessibleTextListener)this.accessibleTextListeners.elementAt(i);
            listener.getSelectionRange(event);
            ++i;
        }
        if (event.offset != -1) {
            CFRange range = new CFRange();
            range.location = event.offset;
            range.length = event.length;
            int valueRef = OS.AXValueCreate(4, range);
            OS.SetEventParameter(theEvent, 1635022444, 1667658873, 4, new int[]{valueRef});
            OS.CFRelease(valueRef);
            return 0;
        }
        return OS.CallNextEventHandler(nextHandler, theEvent);
    }

    int getInsertionPointLineNumberAttribute(int nextHandler, int theEvent, int userData) {
        AccessibleTextEvent event = new AccessibleTextEvent(this);
        event.childID = this.getChildIDFromEvent(theEvent);
        event.offset = -1;
        int i = 0;
        while (i < this.accessibleTextListeners.size()) {
            AccessibleTextListener listener = (AccessibleTextListener)this.accessibleTextListeners.elementAt(i);
            listener.getCaretOffset(event);
            ++i;
        }
        if (event.offset != -1) {
            OS.SetEventParameter(theEvent, 1635022444, 1819242087, 4, new int[]{event.offset});
            return 0;
        }
        return OS.CallNextEventHandler(nextHandler, theEvent);
    }

    public void removeAccessibleListener(AccessibleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.removeElement(listener);
    }

    public void removeAccessibleControlListener(AccessibleControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.accessibleControlListeners.removeElement(listener);
    }

    public void removeAccessibleTextListener(AccessibleTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.accessibleTextListeners.removeElement(listener);
    }

    public void selectionChanged() {
        this.checkWidget();
        int stringRef = this.stringToStringRef("AXSelectedChildrenChanged");
        OS.AXNotificationHIObjectNotify(stringRef, this.control.handle, 0L);
        OS.CFRelease(stringRef);
    }

    public void setFocus(int childID) {
        this.checkWidget();
        this.childIDToOs(childID);
        int stringRef = this.stringToStringRef("AXFocusedWindowChanged");
        OS.AXNotificationHIObjectNotify(stringRef, this.control.handle, childID + 1);
        OS.CFRelease(stringRef);
    }

    public void textCaretMoved(int index) {
        this.checkWidget();
        int stringRef = this.stringToStringRef("AXValueChanged");
        OS.AXNotificationHIObjectNotify(stringRef, this.control.handle, 0L);
        OS.CFRelease(stringRef);
    }

    public void textChanged(int type, int startIndex, int length) {
        this.checkWidget();
        int stringRef = this.stringToStringRef("AXValueChanged");
        OS.AXNotificationHIObjectNotify(stringRef, this.control.handle, 0L);
        OS.CFRelease(stringRef);
    }

    public void textSelectionChanged() {
        this.checkWidget();
        int stringRef = this.stringToStringRef("AXSelectedChildrenChanged");
        OS.AXNotificationHIObjectNotify(stringRef, this.control.handle, 0L);
        OS.CFRelease(stringRef);
    }

    int getChildIDFromEvent(int theEvent) {
        int[] ref = new int[1];
        OS.GetEventParameter(theEvent, 1634689642, 1667658873, null, 4, null, ref);
        return this.osToChildID(ref[0]);
    }

    int childIDToOs(int childID) {
        if (childID == -1) {
            return this.axuielementref;
        }
        int index = 0;
        while (index < this.osChildIDCache.length) {
            if (childID == this.osChildIDCache[index]) {
                return this.osChildIDCache[index + 1];
            }
            index += 2;
        }
        int osChildID = OS.AXUIElementCreateWithHIObjectAndIdentifier(this.control.handle, childID + 1);
        int[] newCache = new int[this.osChildIDCache.length + 2];
        System.arraycopy(this.osChildIDCache, 0, newCache, 0, this.osChildIDCache.length);
        this.osChildIDCache = newCache;
        this.osChildIDCache[index] = childID;
        this.osChildIDCache[index + 1] = osChildID;
        return osChildID;
    }

    int osToChildID(int osChildID) {
        if (OS.CFEqual(osChildID, this.axuielementref)) {
            return -1;
        }
        long[] childID = new long[1];
        OS.AXUIElementGetIdentifier(osChildID, childID);
        if (childID[0] == 0L) {
            return -1;
        }
        return (int)childID[0] - 1;
    }

    int stateToOs(int state) {
        return state;
    }

    int osToState(int osState) {
        return osState;
    }

    String roleToOs(int role) {
        switch (role) {
            case 10: {
                return "AXWindow";
            }
            case 9: {
                return "AXWindow";
            }
            case 2: {
                return "AXMenuBar";
            }
            case 11: {
                return "AXMenu";
            }
            case 12: {
                return "AXMenuItem";
            }
            case 21: {
                return "AXSplitter";
            }
            case 13: {
                return "AXHelpTag";
            }
            case 3: {
                return "AXScrollBar";
            }
            case 18: {
                return "AXWindow:AXDialog";
            }
            case 41: {
                return "AXStaticText";
            }
            case 43: {
                return "AXButton";
            }
            case 44: {
                return "AXCheckBox";
            }
            case 45: {
                return "AXRadioButton";
            }
            case 46: {
                return "AXComboBox";
            }
            case 42: {
                return "AXTextField";
            }
            case 22: {
                return "AXToolbar";
            }
            case 33: {
                return "AXOutline";
            }
            case 34: {
                return "AXStaticText";
            }
            case 24: {
                return "AXTable";
            }
            case 29: {
                return "AXRow:AXTableRow";
            }
            case 25: {
                return "AXButton:AXSortButton";
            }
            case 26: {
                return "AXRow:AXTableRow";
            }
            case 35: {
                return "AXOutline";
            }
            case 36: {
                return "AXOutline:AXOutlineRow";
            }
            case 60: {
                return "AXTabGroup";
            }
            case 37: {
                return "AXRadioButton";
            }
            case 48: {
                return "AXProgressIndicator";
            }
            case 51: {
                return "AXSlider";
            }
            case 30: {
                return "AXLink";
            }
        }
        return "AXUnknown";
    }

    int osToRole(String osRole) {
        if (osRole == null) {
            return 0;
        }
        if (osRole.equals("AXWindow")) {
            return 9;
        }
        if (osRole.equals("AXMenuBar")) {
            return 2;
        }
        if (osRole.equals("AXMenu")) {
            return 11;
        }
        if (osRole.equals("AXMenuItem")) {
            return 12;
        }
        if (osRole.equals("AXSplitter")) {
            return 21;
        }
        if (osRole.equals("AXHelpTag")) {
            return 13;
        }
        if (osRole.equals("AXScrollBar")) {
            return 3;
        }
        if (osRole.equals("AXScrollArea")) {
            return 33;
        }
        if (osRole.equals("AXWindow:AXDialog")) {
            return 18;
        }
        if (osRole.equals("AXWindow:AXSystemDialog")) {
            return 18;
        }
        if (osRole.equals("AXStaticText")) {
            return 41;
        }
        if (osRole.equals("AXButton")) {
            return 43;
        }
        if (osRole.equals("AXCheckBox")) {
            return 44;
        }
        if (osRole.equals("AXRadioButton")) {
            return 45;
        }
        if (osRole.equals("AXComboBox")) {
            return 46;
        }
        if (osRole.equals("AXTextField")) {
            return 42;
        }
        if (osRole.equals("AXTextArea")) {
            return 42;
        }
        if (osRole.equals("AXToolbar")) {
            return 22;
        }
        if (osRole.equals("AXList")) {
            return 33;
        }
        if (osRole.equals("AXTable")) {
            return 24;
        }
        if (osRole.equals("AXColumn")) {
            return 25;
        }
        if (osRole.equals("AXButton:AXSortButton")) {
            return 25;
        }
        if (osRole.equals("AXRow:AXTableRow")) {
            return 26;
        }
        if (osRole.equals("AXOutline")) {
            return 35;
        }
        if (osRole.equals("AXOutline:AXOutlineRow")) {
            return 36;
        }
        if (osRole.equals("AXTabGroup")) {
            return 60;
        }
        if (osRole.equals("AXProgressIndicator")) {
            return 48;
        }
        if (osRole.equals("AXSlider")) {
            return 51;
        }
        if (osRole.equals("AXLink")) {
            return 30;
        }
        return 10;
    }

    int stringToStringRef(String string) {
        char[] buffer = new char[string.length()];
        string.getChars(0, buffer.length, buffer, 0);
        return OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
    }

    String stringRefToString(int stringRef) {
        int length = OS.CFStringGetLength(stringRef);
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(stringRef, range, buffer);
        return new String(buffer);
    }

    void checkWidget() {
        if (!this.isValidThread()) {
            SWT.error(22);
        }
        if (this.control.isDisposed()) {
            SWT.error(24);
        }
    }

    boolean isValidThread() {
        return this.control.getDisplay().getThread() == Thread.currentThread();
    }
}

