unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, FileCtrl,GLDPNG, _PicTools;

type
  TMain = class(TForm)
    cimg: TImage;
    aimg: TImage;
    Timer1: TTimer;
    GLDPNGMemo: TMemo;
    picOpenDlg: TOpenDialog;
    procedure FormCreate(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Main: TMain;

implementation

{$R *.dfm}

var
  sw,sh:integer;

procedure LoadPNG(fn:string;var bm,abm:TBitmap);
var
  png:TGLDPNG;
begin
  png:=TGLDPNG.Create;

  png.Image:=bm;
  png.AlphaBitmap:=abm;
  png.LoadFromFile(fn);

  png.Free;
end;

procedure SaveTGF(fn:string;var cbm,abm:TBitmap;alphaflag:boolean);
var
  wfs:TFileStream;
  x,y:integer;
  len:integer;
  pcbm,pabm:PByteArray;
  alpha:byte;
  cnt:integer;
  procedure Write8(d:byte);
  begin
    wfs.WriteBuffer(d,1);
  end;
  procedure Write16(d:word);
  begin
    wfs.WriteBuffer(d,2);
  end;
  procedure Write32(d:dword);
  begin
    wfs.WriteBuffer(d,4);
  end;
  procedure Write15(pbm:PByteArray;alpha:byte;x:integer);
  var
    r,g,b:integer;
  begin
    alpha:=31-alpha;
    r:=pbm[x*3+2];
    r:=(r*alpha) div 31;
    g:=pbm[x*3+1];
    g:=(g*alpha) div 31;
    b:=pbm[x*3+0];
    b:=(b*alpha) div 31;
    Write16((b shl 10)+(g shl 5)+(r shl 0)+(1 shl 15));
  end;
  function getlength(pbm:PByteArray;alpha:byte;x:integer):integer;
  begin
    if alphaflag=True then begin
      Result:=0;
      while(alpha=pbm[x]) do begin
        inc(Result);
        inc(x);
        if x=sw then exit;
        if Result=$ff then exit;
      end;
      end else begin
      Result:=0;
      while(True) do begin
        inc(Result);
        inc(x);
        if x=sw then exit;
        if Result=$ff then exit;
      end;
    end;
  end;
begin
  wfs:=TFileStream.Create(fn,fmCreate);

  Write16(sw);
  Write16(sh);

  pabm:=nil;

  for y:=0 to sh-1 do begin
    pcbm:=cbm.ScanLine[y];
    if alphaflag=True then pabm:=abm.ScanLine[y];
    x:=0;
    while(x<sw) do begin
      if alphaflag=True then begin
        alpha:=pabm[x];
        end else begin
        alpha:=31;
      end;
      len:=getlength(pabm,alpha,x);
      Write8(alpha);
      Write8(len);
      if alpha<>31 then begin
        for cnt:=x to x+len-1 do begin
          Write15(pcbm,alpha,cnt);
        end;
      end;
      inc(x,len);
    end;
  end;

  wfs.Free;
end;

procedure conv8to5(var bm:TBitmap);
var
  x,y,w:integer;
  pbm:PByteArray;
begin
  w:=bm.Width;
  if bm.PixelFormat=pf24bit then w:=w*3;

  for y:=0 to bm.Height-1 do begin
    pbm:=bm.ScanLine[y];
    for x:=0 to w-1 do begin
      pbm[x]:=pbm[x] shr 3;
    end;
  end;
end;

procedure png2tgf(pngfn:string);
var
  pngcbm,pngabm:TBitmap;
  alpha:boolean;
begin
  pngcbm:=TBitmap.Create;
  pngabm:=TBitmap.Create;

  LoadPNG(pngfn,pngcbm,pngabm);

  sw:=pngcbm.Width;
  sh:=pngcbm.Height;

  alpha:=True;
  if (assigned(pngabm)=False) or (pngabm.Width<>sw) or (pngabm.Height<>sh) then begin
    alpha:=False;
{
    ShowMessage('not found AlphaChannel.');
    Application.Terminate;
    exit;
}
  end;

  Main.ClientWidth:=sw;
  Main.ClientHeight:=sh*2;

  with Main.cimg do begin
    Left:=0;
    Top:=0;
    Width:=sw;
    Height:=sh;
    bitblt(Canvas.Handle,0,0,sw,sh,pngcbm.Canvas.Handle,0,0,SRCCOPY);
  end;

  if alpha=True then begin
    with Main.aimg do begin
      Left:=0;
      Top:=sh;
      Width:=sw;
      Height:=sh;
      bitblt(Canvas.Handle,0,0,sw,sh,pngabm.Canvas.Handle,0,0,SRCCOPY);
    end;
  end;

  Main.cimg.Refresh;
  Main.aimg.Refresh;

  conv8to5(pngcbm);
  if alpha=True then conv8to5(pngabm);

  SaveTGF(changefileext(pngfn,'.tgf.bin'),pngcbm,pngabm,alpha);

  pngcbm.Free;
  pngabm.Free;
end;

procedure TMain.FormCreate(Sender: TObject);
var
  picfn:string;
begin
  Show;

  if 1<=ParamCount then begin
    picfn:=ParamStr(1);
    end else begin
    if picOpenDlg.Execute=False then begin
      Application.Terminate;
      exit;
    end;
    picfn:=picOpenDlg.FileName;
  end;
  caption:=picfn;

  GLDPNGMemo.Visible:=False;
  png2tgf(picfn);

  Application.Terminate;
end;

end.
