unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, FileCtrl,GLDPNG, _PicTools;

type
  TMain = class(TForm)
    cimg: TImage;
    aimg: TImage;
    Timer1: TTimer;
    GLDPNGMemo: TMemo;
    picOpenDlg: TOpenDialog;
    procedure FormCreate(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Main: TMain;

implementation

{$R *.dfm}

var
  sw,sh:integer;

procedure LoadPNG(fn:string;var bm,abm:TBitmap);
var
  png:TGLDPNG;
begin
  png:=TGLDPNG.Create;

  png.Image:=bm;
  png.AlphaBitmap:=abm;
  png.LoadFromFile(fn);

  png.Free;
end;

procedure Saveb32(fn:string;var cbm,abm:TBitmap;alphaflag:boolean);
var
  wfs:TFileStream;
  x,y:integer;
  pcbm,pabm:PByteArray;
  alpha:integer;
  procedure Write8(d:byte);
  begin
    wfs.WriteBuffer(d,1);
  end;
  procedure Write16(d:word);
  begin
    wfs.WriteBuffer(d,2);
  end;
  procedure Write32(d:dword);
  begin
    wfs.WriteBuffer(d,4);
  end;
  procedure Write20(pbm:PByteArray;alpha:integer;x:integer);
  var
    r,g,b:integer;
    ialpha:integer;
  begin
    ialpha:=255-alpha;
    r:=(pbm[x*3+2]*ialpha) div 255;
    g:=(pbm[x*3+1]*ialpha) div 255;
    b:=(pbm[x*3+0]*ialpha) div 255;
    Write32((alpha shl 24)+(b shl 16)+(g shl 8)+(r shl 0));
  end;
begin
  wfs:=TFileStream.Create(fn,fmCreate);

  Write16(sw);
  Write16(sh);

  pabm:=nil;

  for y:=0 to sh-1 do begin
    pcbm:=cbm.ScanLine[y];
    if alphaflag=True then pabm:=abm.ScanLine[y];
    for x:=0 to sw-1 do begin
      if alphaflag=True then begin
        alpha:=pabm[x];
        end else begin
        alpha:=0;
      end;
      Write20(pcbm,alpha,x);
    end;
  end;

  wfs.Free;
end;

procedure png2b32(pngfn:string);
var
  pngcbm,pngabm:TBitmap;
  alpha:boolean;
begin
  pngcbm:=TBitmap.Create;
  pngabm:=TBitmap.Create;

  LoadPNG(pngfn,pngcbm,pngabm);

  sw:=pngcbm.Width;
  sh:=pngcbm.Height;

  alpha:=True;
  if (assigned(pngabm)=False) or (pngabm.Width<>sw) or (pngabm.Height<>sh) then begin
    alpha:=False;
{
    ShowMessage('not found AlphaChannel.');
    Application.Terminate;
    exit;
}
  end;

  Main.ClientWidth:=sw;
  Main.ClientHeight:=sh*2;

  with Main.cimg do begin
    Left:=0;
    Top:=0;
    Width:=sw;
    Height:=sh;
    bitblt(Canvas.Handle,0,0,sw,sh,pngcbm.Canvas.Handle,0,0,SRCCOPY);
  end;

  if alpha=True then begin
    with Main.aimg do begin
      Left:=0;
      Top:=sh;
      Width:=sw;
      Height:=sh;
      bitblt(Canvas.Handle,0,0,sw,sh,pngabm.Canvas.Handle,0,0,SRCCOPY);
    end;
  end;

  Main.cimg.Refresh;
  Main.aimg.Refresh;

  Saveb32(changefileext(pngfn,'.b32.bin'),pngcbm,pngabm,alpha);

  pngcbm.Free;
  pngabm.Free;
end;

procedure TMain.FormCreate(Sender: TObject);
var
  picfn:string;
begin
  Show;

  if 1<=ParamCount then begin
    picfn:=ParamStr(1);
    end else begin
    if picOpenDlg.Execute=False then begin
      Application.Terminate;
      exit;
    end;
    picfn:=picOpenDlg.FileName;
  end;
  caption:=picfn;

  GLDPNGMemo.Visible:=False;
  png2b32(picfn);

  Application.Terminate;
end;

end.
