unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs,GLDPNG, ExtCtrls,_PicTools, StdCtrls, FileCtrl, Buttons;

type
  TMain = class(TForm)
    picOpenDlg: TOpenDialog;
    PrevImg: TImage;
    GroupBox1: TGroupBox;
    ckNoneChk: TRadioButton;
    ckManualChk: TRadioButton;
    ckUpLeftChk: TRadioButton;
    ckDownLeftChk: TRadioButton;
    ckUpRightChk: TRadioButton;
    ckDownRightChk: TRadioButton;
    ConvertBtn: TBitBtn;
    CancelBtn: TBitBtn;
    GLDPNGMemo: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure ckNoneChkClick(Sender: TObject);
    procedure PrevImgMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ConvertBtnClick(Sender: TObject);
    procedure ckUpLeftChkClick(Sender: TObject);
    procedure ckDownLeftChkClick(Sender: TObject);
    procedure ckUpRightChkClick(Sender: TObject);
    procedure ckDownRightChkClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
    procedure proc(picfn:string);
  end;

var
  Main: TMain;

implementation

{$R *.dfm}

const DitherTable4:array[0..(4*4)-1] of integer=(0,4,1,5, 6,2,7,3, 1,5,0,4, 7,3,6,2);

var
  picfn:string;
  srcbm:TBitmap;
  TransR,TransG,TransB:integer;

var
  B15TransFlag:boolean;
  B15Data:array of word;
  B15DataCount:integer;

procedure dither(srcbm:TBitmap);
var
  x,y,w,h:integer;
  psbm:PByteArray;
  r,g,b:integer;
  dr,dg,db:integer;
  function d(c:integer):integer;
  var
    sx,sy,a:integer;
  begin
    sx:=x and 3;
    sy:=y and 3;
    a:=DitherTable4[sx*4+sy];
    Result:=(c+a) shr 3;
    if Result>31 then Result:=31;
  end;
  function d2(c:integer;var dc:integer):integer;
  var
    a:integer;
  begin
    a:=c+dc;
    dc:=a and 7;
    Result:=a shr 3;
    if Result>31 then Result:=31;
  end;
  function RGB15(r,g,b:integer):word;
  begin
    Result:=(b shl 10)+(g shl 5)+(r shl 0)+(1 shl 15);
  end;
begin
  w:=srcbm.Width;
  h:=srcbm.Height;

  dr:=0;
  dg:=0;
  db:=0;

  B15DataCount:=w*h;
  setlength(B15Data,B15DataCount);
  B15TransFlag:=False;

  for y:=0 to h-1 do begin
    psbm:=srcbm.ScanLine[y];
    for x:=0 to w-1 do begin
      b:=psbm[x*3+0];
      g:=psbm[x*3+1];
      r:=psbm[x*3+2];
      if (TransR<>r) or (TransG<>g) or (TransB<>b) then begin
//        psbm[x*3+0]:=d2(b,db) shl 3;
//        psbm[x*3+1]:=d2(g,dg) shl 3;
//        psbm[x*3+2]:=d2(r,dr) shl 3;
        B15Data[x+(y*w)]:=RGB15(d(r),d(g),d(b));
        end else begin
        B15Data[x+(y*w)]:=0;
        B15TransFlag:=True;
      end;
    end;
  end;
end;

procedure saveb15(fn:string;w,h:integer);
var
  wfs:TFileStream;
  procedure write16(d:word);
  begin
    wfs.WriteBuffer(d,2);
  end;
  procedure writebool(d:Boolean);
  begin
    if d=False then begin
      write16(0);
      end else begin
      write16(1);
    end;
  end;
begin
  wfs:=TFileStream.Create(fn,fmCreate);

  write16(w);
  write16(h);
  writebool(B15TransFlag);

  wfs.WriteBuffer(B15Data[0],B15DataCount*2);

  wfs.Free;
end;

procedure TMain.proc(picfn:string);
begin
  dither(srcbm);
  saveb15(changefileext(picfn,'.b15.bin'),srcbm.Width,srcbm.Height);
end;

procedure TMain.FormCreate(Sender: TObject);
var
  ext:string;
  png:TGLDPNG;
begin
  with ConvertBtn do begin
    if Main.ClientWidth<(Left+Width+8) then Main.ClientWidth:=Left+Width+8;
  end;
  Show;

  if 1<=ParamCount then begin
    picfn:=ParamStr(1);
    end else begin
    if picOpenDlg.Execute=False then begin
      Application.Terminate;
      exit;
    end;
    picfn:=picOpenDlg.FileName;
  end;
  caption:=picfn;

  srcbm:=TBitmap.Create;

  ext:=lowercase(ExtractFileExt(picfn));

  if ext='.bmp' then begin
    srcbm.LoadFromFile(picfn);
    end else begin
    if ext='.png' then begin
      png:=TGLDPNG.Create;
      png.Image:=srcbm;
      png.LoadFromFile(picfn);
      png.Free;
      end else begin
      ShowMessage('not support file format');
      Application.Terminate;
      exit;
    end;
  end;
  srcbm.PixelFormat:=pf24bit;
//  dither(srcbm);

  PrevImg.Width:=srcbm.Width;
  PrevImg.Height:=srcbm.Height;
  MakeBlankImg(PrevImg,pf24bit);

  ckNoneChk.Checked:=True;
  ckNoneChkClick(Sender);

  with PrevImg do begin
    if Main.ClientWidth<(Left+Width+8) then Main.ClientWidth:=Left+Width+8;
    Main.ClientHeight:=Top+Height+8;
  end;

  GLDPNGMemo.Visible:=False;
end;

procedure TMain.CancelBtnClick(Sender: TObject);
begin
  Main.Close;
end;

procedure TMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  srcbm.Free;
end;

procedure SetColorKey(x,y:integer);
var
  w,h:integer;
  px,py:integer;
  psbm,pdbm:PByteArray;
  r,g,b:integer;
begin
  psbm:=srcbm.ScanLine[y];
  TransB:=psbm[x*3+0];
  TransG:=psbm[x*3+1];
  TransR:=psbm[x*3+2];

  w:=srcbm.Width;
  h:=srcbm.Height;

  bitblt(Main.PrevImg.Canvas.Handle,0,0,w,h,srcbm.Canvas.Handle,0,0,SRCCOPY);

  for py:=0 to h-1 do begin
    psbm:=srcbm.ScanLine[py];
    pdbm:=Main.PrevImg.Picture.Bitmap.ScanLine[py];
    for px:=0 to w-1 do begin
      b:=psbm[px*3+0];
      g:=psbm[px*3+1];
      r:=psbm[px*3+2];
      if (TransR=r) and (TransG=g) and (TransB=b) then begin
        pdbm[px*3+0]:=$00;
        pdbm[px*3+1]:=$ff;
        pdbm[px*3+2]:=$00;
      end;
    end;
  end;

  Main.PrevImg.Refresh;
end;

procedure TMain.ckNoneChkClick(Sender: TObject);
begin
  bitblt(PrevImg.Canvas.Handle,0,0,srcbm.Width,srcbm.Height,srcbm.Canvas.Handle,0,0,SRCCOPY);
  PrevImg.Refresh;

  TransR:=-1;
  TransG:=-1;
  TransB:=-1;
end;

procedure TMain.PrevImgMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  ckManualChk.Checked:=True;
  SetColorKey(x,y);
end;

procedure TMain.ConvertBtnClick(Sender: TObject);
begin
  proc(picfn);
  Main.Close;
end;

procedure TMain.ckUpLeftChkClick(Sender: TObject);
begin
  SetColorKey(0,0);
end;

procedure TMain.ckDownLeftChkClick(Sender: TObject);
begin
  SetColorKey(0,srcbm.Height-1);
end;

procedure TMain.ckUpRightChkClick(Sender: TObject);
begin
  SetColorKey(srcbm.Width-1,0);
end;

procedure TMain.ckDownRightChkClick(Sender: TObject);
begin
  SetColorKey(srcbm.Width-1,srcbm.Height-1);
end;

end.
