
#include <nds.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "_console.h"
#include "_consolewritelog.h"
#include "maindef.h"
#include "memtool.h"
#include "_const.h"
#include "lang.h"
#include "datetime.h"
#include "inifile.h"

#include "glib.h"
#include "skin.h"
#include "skinpack.h"
#include "strtool.h"

#include "fat2.h"
#include "shell.h"
#include "sndeff.h"
#include "procstate.h"
#include "strpcm.h"
#include "cfont.h"

static const float PI=3.14159;

extern CglB32* SkinPack_LoadB32(ESkinFiles ESF);

#include "RotDraw.h"

static CglB32 *pBG,*pBody,*pSecBar,*pMinBar,*pHourBar;
static CglB32 *pNumFont[12];

static u32 *pViewCanvas32;
static u32 *pBaseCanvas32;

static bool JustMinitusAnimation;
static float JustMinitusAnimation_Rot;

static u32 TimeVSync;

// ------------------------------------------------------

static const char* GetLangMsg(const char *pstr)
{
  if(Shell_isJPNmode()==true){
    const char *pjpn=pstr;
    while(1){
      const char ch=*pjpn++;
      if(ch==0) break;
      if(ch=='|'){
        pstr=pjpn;
        break;
      }
    }
  }
  return(pstr);
}

// ------------------------------------------------------

static bool mf;

void CB_MouseDown(s32 x,s32 y)
{
  mf=true;
}

void CB_MouseMove(s32 x,s32 y)
{
  if(mf==false) return;
}

void CB_MouseUp(s32 x,s32 y)
{
  if(mf==false) return;
  
  mf=false;
}

// ------------------------------------------------------

static void DrawBaseCanvas(u32 *pcan32)
{
  MemCopy32CPU(pBG->GetData(),pcan32,ScreenWidth*ScreenHeight*4);
  
  const u32 CX=ScreenWidth/2,CY=ScreenHeight/2;
  DrawRotation(pcan32,CX,CY,pHourBar,(float)TimeVSync/12/60/60/60*PI*2);
  DrawRotation(pcan32,CX,CY,pMinBar,(float)TimeVSync/60/60/60*PI*2);
  DrawRotation(pcan32,CX,CY,pBody,0);
}

// ------------------------------------------------------

static void CB_KeyPress(u32 VsyncCount,u32 Keys,bool FirstFlag)
{
  if(Keys&KEY_R) Keys|=KEY_L;
  if(Keys&KEY_X) Keys|=KEY_UP;
  if(Keys&KEY_B) Keys|=KEY_DOWN;
  if(Keys&KEY_Y) Keys|=KEY_LEFT;
  if(Keys&KEY_A) Keys|=KEY_RIGHT;
  
  if((Keys&KEY_L)!=0){
    if((Keys&(KEY_X|KEY_Y))!=0){
      if((Keys&KEY_X)!=0) ChangeNextBacklightLevel();
      if((Keys&KEY_Y)!=0) ChangePrevBacklightLevel();
      return;
    }
    return;
  }
}

static void CB_Start(void)
{
  pBG=SkinPack_LoadB32(ESF_BG_b32);
  pBody=SkinPack_LoadB32(ESF_Body_b32);
  pSecBar=SkinPack_LoadB32(ESF_SecBar_b32);
  pMinBar=SkinPack_LoadB32(ESF_MinBar_b32);
  pHourBar=SkinPack_LoadB32(ESF_HourBar_b32);
  
  pNumFont[0]=SkinPack_LoadB32(ESF_NumC_b32);
  pNumFont[1]=SkinPack_LoadB32(ESF_Num1_b32);
  pNumFont[2]=SkinPack_LoadB32(ESF_Num2_b32);
  pNumFont[3]=SkinPack_LoadB32(ESF_Num3_b32);
  pNumFont[4]=SkinPack_LoadB32(ESF_Num4_b32);
  pNumFont[5]=SkinPack_LoadB32(ESF_Num5_b32);
  pNumFont[6]=SkinPack_LoadB32(ESF_Num6_b32);
  pNumFont[7]=SkinPack_LoadB32(ESF_Num7_b32);
  pNumFont[8]=SkinPack_LoadB32(ESF_Num8_b32);
  pNumFont[9]=SkinPack_LoadB32(ESF_Num9_b32);
  pNumFont[10]=SkinPack_LoadB32(ESF_NumA_b32);
  pNumFont[11]=SkinPack_LoadB32(ESF_NumB_b32);
  
  pViewCanvas32=(u32*)safemalloc(&MM_Process,ScreenWidth*ScreenHeight*4);
  MemSet32CPU(0,pViewCanvas32,ScreenWidth*ScreenHeight*4);
  
  pBaseCanvas32=(u32*)safemalloc(&MM_Process,ScreenWidth*ScreenHeight*4);
  MemSet32CPU(0,pViewCanvas32,ScreenWidth*ScreenHeight*4);
  
  pScreenSub->pCanvas->FillFull(0);
  
  JustMinitusAnimation=false;
  JustMinitusAnimation_Rot=0;
  
  mf=false;
  
  DateTime_ResetNow();
  TTime time=DateTime_GetNow().Time;
  TimeVSync=time.Hour;
  TimeVSync=(TimeVSync*60)+time.Min;
  TimeVSync=(TimeVSync*60)+time.Sec;
  TimeVSync*=60;
  
  DrawBaseCanvas(pBaseCanvas32);
}

static void BitBlt32Full(const u32 *pcan32,CglCanvas *pcan)
{
  const u32 *psrcbuf=pcan32;
  u16 *pdstbuf=pcan->GetVRAMBuf();
  u32 gr=0,gg=0,gb=0;
  for(u32 idx=0;idx<ScreenWidth*ScreenHeight;idx++){
    u32 col32=*psrcbuf++;
    u32 b=((col32>>16)&0xff)+gb;
    u32 g=((col32>>8)&0xff)+gg;
    u32 r=((col32>>0)&0xff)+gr;
    if(0xff<b) b=0xff;
    gb=b&7;
    if(0xff<g) g=0xff;
    gg=g&7;
    if(0xff<r) r=0xff;
    gr=r&7;
    *pdstbuf++=RGB15(r>>3,g>>3,b>>3)|BIT15;
  }
}

static void BitBlt32(const u32 *pcan32,int x,int y,int w,int h,CglCanvas *pcan)
{
  if(x<0){
    w+=x;
    x=0;
  }
  if(y<0){
    h+=y;
    y=0;
  }
  if(ScreenWidth<(x+w)) w=ScreenWidth-x;
  if(ScreenHeight<(y+h)) h=ScreenHeight-y;
  
  const u32 *psrcbuf=pcan32;
  u16 *pdstbuf=pcan->GetVRAMBuf();
  for(s32 py=y;py<(y+h);py++){
    const u32 *psrc=&psrcbuf[(py*ScreenWidth)+x];
    u16 *pdst=&pdstbuf[(py*ScreenWidth)+x];
    for(s32 px=x;px<(x+w);px++){
      u32 col32=*psrc++;
      u32 b=(col32>>16)&0xff;
      u32 g=(col32>>8)&0xff;
      u32 r=(col32>>0)&0xff;
      *pdst++=RGB15(r>>3,g>>3,b>>3)|BIT15;
    }
  }
}

static bool DrawNums(u32 *pcan32,bool UseDirect,float BaseRot)
{
  bool used=false;
  
  const u32 CX=ScreenWidth/2,CY=ScreenHeight/2;
  const float Len=(ScreenHeight/2);
  
  for(u32 idx=0;idx<12;idx++){
    const float r=(float)idx/12*PI*2+PI;
    float x=CX+sin(-r)*Len;
    float y=CY+cos(-r)*Len*0.9;
    
    float rot=0;
    if(BaseRot!=0){
      rot=JustMinitusAnimation_Rot-(float)idx/2;
      if(rot<0) rot=0;
      if((PI*2)<rot){
        rot=0;
        }else{
        used=true;
      }
    }
    
    DrawRotation(pcan32,x,y,pNumFont[idx],rot);
    
    u32 w=pNumFont[idx]->GetWidth(),h=pNumFont[idx]->GetHeight();
    u32 size;
    if(w<h){
      size=h;
      }else{
      size=w;
    }
    size=size*1.5;
    
    if(UseDirect==true) BitBlt32(pcan32,x-size/2,y-size/2,size,size,pScreenMain->pViewCanvas);
  }
  
  return(used);
}

static void CB_VsyncUpdate(u32 VsyncCount)
{
//  if(8<VsyncCount) VsyncCount=8;
  
  PrfStart();
  
  const u32 CX=ScreenWidth/2,CY=ScreenHeight/2;
  
  u32 last=TimeVSync;
  TimeVSync+=VsyncCount;
  if((TimeVSync%(60*60))<(last%(60*60))){
    JustMinitusAnimation=true;
    JustMinitusAnimation_Rot=0;
    DrawBaseCanvas(pBaseCanvas32);
    DrawRotation(pBaseCanvas32,CX,CY,pSecBar,0);
    }else{
    if((TimeVSync%(15*60))<(last%(15*60))){
      DrawBaseCanvas(pBaseCanvas32);
    }
  }
  
  if(JustMinitusAnimation==false){
    MemCopy32CPU(pBaseCanvas32,pViewCanvas32,ScreenWidth*ScreenHeight*4);
    
    DrawRotation(pViewCanvas32,CX,CY,pSecBar,(float)TimeVSync/60/60*PI*2);
    
    DrawNums(pViewCanvas32,false,0);
    
    BitBlt32Full(pViewCanvas32,pScreenMain->pBackCanvas);
    
    ScreenMain_Flip_ProcFadeEffect();
    }else{
    MemCopy32CPU(pBaseCanvas32,pViewCanvas32,ScreenWidth*ScreenHeight*4);
    JustMinitusAnimation_Rot+=(float)VsyncCount/10;
    bool used=DrawNums(pViewCanvas32,true,JustMinitusAnimation_Rot);
    if(used==false){
      JustMinitusAnimation=false;
      DrawBaseCanvas(pBaseCanvas32);
    }
  }
  
  static u32 a=0;
  a+=VsyncCount;
  PrfEnd(a);
}

static void CB_End(void)
{
  ProcState_Save();
  
  SoundSE_Stop();
  SoundBGM_Stop();
}

void ProcSettings_SetCallBack(TCallBack *pCallBack)
{
  pCallBack->Start=CB_Start;
  pCallBack->VsyncUpdate=CB_VsyncUpdate;
  pCallBack->End=CB_End;
  pCallBack->KeyPress=CB_KeyPress;
  pCallBack->MouseDown=CB_MouseDown;
  pCallBack->MouseMove=CB_MouseMove;
  pCallBack->MouseUp=CB_MouseUp;
}

