
#define FIX (1024)

static inline void LinearInterpolation1D(u32 *pdst,const u32 col)
{
#define ParseRGB(col,A,R,G,B) \
  const u32 A=(col>>24)&0xff; \
  u32 B=(col>>16)&0xff; \
  u32 G=(col>>8)&0xff; \
  u32 R=(col>>0)&0xff;
  
  ParseRGB(col,A,R,G,B);
  
  const u32 SumA=A;
  if(SumA==(0xff*1)) return;
  
  if(SumA==(0x00*1)){
    *pdst=(B<<16)|(G<<8)|(R<<0);
    }else{
    ParseRGB(*pdst,basecolA,basecolR,basecolG,basecolB);
    R+=(basecolR*A)/0x100;
    G+=(basecolG*A)/0x100;
    B+=(basecolB*A)/0x100;
    
    *pdst=(B<<16)|(G<<8)|(R<<0);
  }
  
#undef ParseRGB
}

static inline void LinearInterpolation2D(u32 *pdst,const int vx,const int vy,const u32 col00,const u32 col01,const u32 col10,const u32 col11)
{
#define ParseRGB(col,A,R,G,B) \
  const u32 A=(col>>24)&0xff; \
  const u32 B=(col>>16)&0xff; \
  const u32 G=(col>>8)&0xff; \
  const u32 R=(col>>0)&0xff;
  
  ParseRGB(col00,A00,R00,G00,B00);
  ParseRGB(col01,A01,R01,G01,B01);
  ParseRGB(col10,A10,R10,G10,B10);
  ParseRGB(col11,A11,R11,G11,B11);
  
  const u32 SumA=A00+A01+A10+A11;
  if(SumA==(0xff*4)) return;
  
  if(SumA==(0x00*4)){
    const int vxi=FIX-vx;
    const int vyi=FIX-vy;
    
    const u32 R0=((R00*vxi)+(R01*vx));
    const u32 G0=((G00*vxi)+(G01*vx));
    const u32 B0=((B00*vxi)+(B01*vx));
    const u32 R1=((R10*vxi)+(R11*vx));
    const u32 G1=((G10*vxi)+(G11*vx));
    const u32 B1=((B10*vxi)+(B11*vx));
    u32 R=((R0*vyi)+(R1*vy))/FIX/FIX;
    u32 G=((G0*vyi)+(G1*vy))/FIX/FIX;
    u32 B=((B0*vyi)+(B1*vy))/FIX/FIX;
    
    *pdst=(B<<16)|(G<<8)|(R<<0);
    }else{
    const int vxi=FIX-vx;
    const int vyi=FIX-vy;
    
    const u32 A0=((A00*vxi)+(A01*vx));
    const u32 R0=((R00*vxi)+(R01*vx));
    const u32 G0=((G00*vxi)+(G01*vx));
    const u32 B0=((B00*vxi)+(B01*vx));
    const u32 A1=((A10*vxi)+(A11*vx));
    const u32 R1=((R10*vxi)+(R11*vx));
    const u32 G1=((G10*vxi)+(G11*vx));
    const u32 B1=((B10*vxi)+(B11*vx));
    const u32 A=((A0*vyi)+(A1*vy))/FIX/FIX;
    u32 R=((R0*vyi)+(R1*vy))/FIX/FIX;
    u32 G=((G0*vyi)+(G1*vy))/FIX/FIX;
    u32 B=((B0*vyi)+(B1*vy))/FIX/FIX;
    
    ParseRGB(*pdst,basecolA,basecolR,basecolG,basecolB);
    R+=(basecolR*A)/0x100;
    G+=(basecolG*A)/0x100;
    B+=(basecolB*A)/0x100;
    
    *pdst=(B<<16)|(G<<8)|(R<<0);
  }
  
#undef ParseRGB
}

static void DrawRotationFix(u32 *pdst,const int DstCX,const int DstCY,CglB32 *psrc)
{
  const int SrcWidth=psrc->GetWidth(),SrcHeight=psrc->GetHeight();
//  const int SrcCX=SrcWidth/2,SrcCY=SrcHeight/2;
  const u32 *psrcbuf=psrc->GetData();
  
  const int DstWidth=ScreenWidth,DstHeight=ScreenHeight;
  u32 *pdstbuf=pdst;
  
  const int BoxWidth=SrcWidth;
  const int BoxHeight=SrcHeight;
  
  int ofsx=0,ofsy=0;
  int sx=DstCX-BoxWidth/2,ex=DstCX+BoxWidth/2;
  int sy=DstCY-BoxHeight/2,ey=DstCY+BoxHeight/2;
  if(sx<0){
    ofsx=-sx;
    sx=0;
  }
  if((DstWidth-1)<ex) ex=DstWidth-1;
  if(sy<0){
    ofsy=-sy;
    sy=0;
  }
  if((DstHeight-1)<ey) ey=DstHeight-1;
  
  for(int y2=sy;y2<ey;y2++){
    const u32 *psrc=&psrcbuf[((ofsy+y2-sy)*SrcWidth)+ofsx];
    u32 *pdst=&pdstbuf[(y2*DstWidth)+sx];
    
    //pϐX[v̑lZ
    for(int x2=sx;x2<ex;x2++){
      LinearInterpolation1D(pdst,*psrc);
      psrc++;
      pdst++;
    }
  }
}

static void DrawRotation(u32 *pdst,const int DstCX,const int DstCY,CglB32 *psrc,float A)
{
  if(A==0){
    DrawRotationFix(pdst,DstCX,DstCY,psrc);
    return;
  }
  A=-A;
  
  const int SrcWidth=psrc->GetWidth(),SrcHeight=psrc->GetHeight();
  const int SrcCX=SrcWidth/2,SrcCY=SrcHeight/2;
  const u32 *psrcbuf=psrc->GetData();
  
  const int DstWidth=ScreenWidth,DstHeight=ScreenHeight;
  u32 *pdstbuf=pdst;
  
  const int int_sin=(int)(sin(A)*FIX);          //SINlFIX|Đɂl
  const int int_cos=(int)(cos(A)*FIX);          //COSlFIX|Đɂl
  
  //͉摜̑Jn_W
  const int StX=int_cos*(-DstCX)-int_sin*(-DstCY)+(SrcCX*FIX);
  const int StY=int_sin*(-DstCX)+int_cos*(-DstCY)+(SrcCY*FIX);
  
  const int DXX=int_cos,DXY=int_sin;         //͉摜X[v̑
  const int DYX=-int_sin,DYY=int_cos;         //͉摜Y[v̑(s)
  
  const int BoxWidth=fabs(SrcWidth*cos(A))+fabs(SrcHeight*sin(A))+1;
  const int BoxHeight=fabs(SrcWidth*sin(A))+fabs(SrcHeight*cos(A))+1;
  
  int sx=DstCX-BoxWidth/2,ex=DstCX+BoxWidth/2;
  int sy=DstCY-BoxHeight/2,ey=DstCY+BoxHeight/2;
  if(sx<0) sx=0;
  if((DstWidth-1)<ex) ex=DstWidth-1;
  if(sy<0) sy=0;
  if((DstHeight-1)<ey) ey=DstHeight-1;
  
  //]C[`
  //o͉摜̍WŃ[vs
  for(int y2=sy;y2<ey;y2++){
    //pϐ̏
    //͉摜pϐiFIX|lj
    int x1_mult=StX+y2*DYX;
    int y1_mult=StY+y2*DYY;
    
    x1_mult+=sx*DXX;
    y1_mult+=sx*DXY;
    
    //pϐX[v̑lZ
    for(int x2=sx;x2<ex;x2++){

      //pϐ͉摜̍W擾
      const int x1=x1_mult/FIX;
      const int y1=y1_mult/FIX;

      const u32 *psrc00=&psrcbuf[(y1*SrcWidth)+x1];
      u32 *pdst=&pdstbuf[(y2*DstWidth)+x2];
      
      //͉摜̍WLȒlȂRs[s
      if((0<=x1)&&(x1<(SrcWidth-1))&&(0<=y1)&&(y1<(SrcHeight-1))){
        u32 col00=psrc00[(0*SrcWidth)+0];
        u32 col01=psrc00[(0*SrcWidth)+1];
        u32 col10=psrc00[(1*SrcWidth)+0];
        u32 col11=psrc00[(1*SrcWidth)+1];
        LinearInterpolation2D(pdst,x1_mult&(FIX-1),y1_mult&(FIX-1),col00,col01,col10,col11);
      }
      
      x1_mult+=DXX;
      y1_mult+=DXY;
    }
  }
}

#undef FIX
