#pragma once


extern void DCache_FlushRangeOverrun(const void *v,u32 size);
extern void DCache_CleanRangeOverrun(const void *v,u32 size);

extern void MemCopy8CPU(const void *src,void *dst,u32 len);
extern void MemCopy16CPU(const void *src,void *dst,u32 len);
extern void MemCopy32CPU(const void *src,void *dst,u32 len);
extern void MemSet8CPU(u8 v,void *dst,u32 len);
extern void MemSet16CPU(u16 v,void *dst,u32 len);
extern void MemSet32CPU(u32 v,void *dst,u32 len);

// ---------------------------------------------------------------------

typedef struct {
  u32 adr,size;
  const char *filename;
  const char *funcname;
  u16 linenum;
  u8 Offset;
  bool locked;
} TMM_List;
  
typedef struct {
  const char *pName;
  u32 ListCount;
  TMM_List *pLists;
} TMM;

extern TMM MM_Temp,MM_System,MM_SystemAfter,MM_Skin,MM_Process;

extern void MM_Init(void);
extern void MM_ShowAllocated(TMM *pMM);
extern void MM_Compact(void);
extern void MM_CheckMemoryLeak(TMM *pMM);
extern void MM_CheckOverRange(void);

// mۂꂽIɑSĉB
// ȂǁAmikmod[N̂ŎdȂB
extern void MM_ExecuteForceAllFree(TMM *pMM);

extern bool (*safemalloc_CallBack_RequestFreeMemory_PlugSound)(void);
extern bool (*safemalloc_CallBack_RequestFreeMemory_PlugImage)(void);
extern bool (*safemalloc_CallBack_RequestFreeMemory_NDSFiles)(void);

extern void *__safemalloc__(TMM *pMM,const char *filename,int linenum,const char *funcname,int size,int align);
extern void *__safemalloc_chkmem__(TMM *pMM,const char *filename,int linenum,const char *funcname,int size,int align);
extern void __safefree__(TMM *pMM,const char *filename,int linenum,const char *funcname,const void *ptr);
extern void *__safecalloc__(TMM *pMM,const char *filename,int linenum,const char *funcname,int nmemb, int size);
extern void *__saferealloc__(TMM *pMM,const char *filename,int linenum,const char *funcname,void *ptr, int size);

#define safemalloc(pMM,size) __safemalloc__(pMM,__MODULE__,__LINE__,__FUNCTION__,size,0)
#define safemalloc32(pMM,size) __safemalloc__(pMM,__MODULE__,__LINE__,__FUNCTION__,size,32)
#define safemalloc_chkmem(pMM,size) __safemalloc_chkmem__(pMM,__MODULE__,__LINE__,__FUNCTION__,size,0)
#define safemalloc32_chkmem(pMM,size) __safemalloc_chkmem__(pMM,__MODULE__,__LINE__,__FUNCTION__,size,32)
#define safefree(pMM,ptr) __safefree__(pMM,__MODULE__,__LINE__,__FUNCTION__,ptr)
#define safecalloc(pMM,nmemb,size) __safecalloc__(pMM,__MODULE__,__LINE__,__FUNCTION__,nmemb,size)
#define saferealloc(pMM,ptr,size) __saferealloc__(pMM,__MODULE__,__LINE__,__FUNCTION__,ptr,size)

// ---------------------------------------------------------------------

extern void PrintFreeMem_Simple(void);
extern void PrintFreeMem_Accuracy(void);
extern void PrintFreeMem_Accuracy_Already(void);
extern void PrintFreeMem(void);

extern u32 GetMaxMemoryBlockSize(void);

